/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.client;

import edu.uiuc.ncsa.security.servlet.ServiceClient;
import java.net.URI;
import java.util.Map;
import org.oa4mp.delegation.client.DelegationService;
import org.oa4mp.delegation.client.request.AGResponse;
import org.oa4mp.delegation.client.request.DelegationRequest;
import org.oa4mp.delegation.client.request.DelegationResponse;
import org.oa4mp.delegation.client.request.RFC6749_4_4Request;
import org.oa4mp.delegation.client.request.RFC6749_4_4_Response;
import org.oa4mp.delegation.client.request.RFC7009Request;
import org.oa4mp.delegation.client.request.RFC7009Response;
import org.oa4mp.delegation.client.request.RFC7523Request;
import org.oa4mp.delegation.client.request.RFC7523Response;
import org.oa4mp.delegation.client.request.RFC7662Request;
import org.oa4mp.delegation.client.request.RFC7662Response;
import org.oa4mp.delegation.client.request.RTRequest;
import org.oa4mp.delegation.client.request.RTResponse;
import org.oa4mp.delegation.client.request.UIRequest;
import org.oa4mp.delegation.client.request.UIResponse;
import org.oa4mp.delegation.client.server.AGServer;
import org.oa4mp.delegation.client.server.ATServer;
import org.oa4mp.delegation.client.server.PAServer;
import org.oa4mp.delegation.client.server.RFC7009Server;
import org.oa4mp.delegation.client.server.RFC7662Server;
import org.oa4mp.delegation.client.server.RTServer;
import org.oa4mp.delegation.common.services.Request;
import org.oa4mp.delegation.server.client.AGServer2;
import org.oa4mp.delegation.server.client.RFC6749_4_4Server;
import org.oa4mp.delegation.server.client.RFC7523Server;
import org.oa4mp.delegation.server.client.RFC8623Server;
import org.oa4mp.delegation.server.client.UIServer2;

public class DS2
extends DelegationService {
    UIServer2 uiServer;
    RFC6749_4_4Server rfc6749_4_4Server;
    RFC8623Server rfc8623Server;
    RFC7523Server rfc7523Server;
    RTServer rtServer;
    RFC7662Server rfc7662Server;
    RFC7009Server rfc7009Server;

    public DS2(AGServer agServer, ATServer atServer, PAServer paServer, UIServer2 uiServer, RTServer rtServer, RFC6749_4_4Server rfc6749_4_4Server, RFC7009Server rfc7009Server, RFC7662Server rfc7662Server, RFC7523Server rfc7523Server, RFC8623Server rfc8623Server) {
        super(agServer, atServer, paServer);
        this.uiServer = uiServer;
        this.rtServer = rtServer;
        this.rfc6749_4_4Server = rfc6749_4_4Server;
        this.rfc7009Server = rfc7009Server;
        this.rfc7662Server = rfc7662Server;
        this.rfc7523Server = rfc7523Server;
        this.rfc8623Server = rfc8623Server;
    }

    public RFC8623Server getRfc8623Server() {
        return this.rfc8623Server;
    }

    public void setRfc8623Server(RFC8623Server rfc8623Server) {
        this.rfc8623Server = rfc8623Server;
    }

    public UIServer2 getUiServer() {
        return this.uiServer;
    }

    public UIResponse getUserInfo(UIRequest uiRequest) {
        return (UIResponse)this.getUiServer().process((Request)uiRequest);
    }

    public RTServer getRtServer() {
        return this.rtServer;
    }

    public void setRtServer(RTServer rtServer) {
        this.rtServer = rtServer;
    }

    public RTResponse refresh(RTRequest refreshTokenRequest) {
        return (RTResponse)this.getRtServer().process((Request)refreshTokenRequest);
    }

    public RFC7009Response rfc7009(RFC7009Request request) {
        return this.getRfc7009Server().processRFC7009Request(request);
    }

    public RFC7662Response rfc7662(RFC7662Request request) {
        return this.getRfc7662Server().processRFC7662Request(request);
    }

    public RFC6749_4_4_Response rfc6749_4_4(RFC6749_4_4Request request) {
        return this.rfc6749_4_4Server.processRFC6749_4_4Request(request);
    }

    public RFC7523Response rfc7523(RFC7523Request request) {
        return this.rfc7523Server.processRFC7523Request(request);
    }

    public DelegationResponse processDelegationRequest(DelegationRequest delegationRequest) {
        DelegationResponse delResp = new DelegationResponse(null);
        Map m = delegationRequest.getParameters();
        m.put("client_id", delegationRequest.getClient().getIdentifierString());
        m.put("redirect_uri", delegationRequest.getParameters().get("redirect_uri"));
        URI authZUri = ((AGServer2)this.getAgServer()).getServiceClient().host(new URI[0]);
        URI redirectURI = URI.create(ServiceClient.convertToStringRequest((String)authZUri.toString(), (Map)m));
        delResp.setParameters(m);
        delResp.setRedirectUri(redirectURI);
        return delResp;
    }

    public URI createRedirectURL(DelegationRequest delegationAssetRequest, AGResponse agResp) {
        String rc = delegationAssetRequest.getBaseUri().toString() + "?code=" + agResp.getAuthorizationGrant().getToken();
        Object state = agResp.getParameters().get("state");
        if (state != null) {
            rc = rc + "&state=" + String.valueOf(state);
        }
        return URI.create(rc);
    }

    public RFC7662Server getRfc7662Server() {
        return this.rfc7662Server;
    }

    public RFC7009Server getRfc7009Server() {
        return this.rfc7009Server;
    }
}

