/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.client;

import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.util.pkcs.MyCertUtil;
import java.net.URI;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import org.oa4mp.delegation.client.request.PARequest;
import org.oa4mp.delegation.client.request.PAResponse;
import org.oa4mp.delegation.client.server.PAServer;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.MyX509Certificates;
import org.oa4mp.delegation.common.token.ProtectedAsset;
import org.oa4mp.delegation.server.client.ASImpl;

public class PAServer2
extends ASImpl
implements PAServer {
    ServiceClient serviceClient;

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public PAServer2(ServiceClient serviceClient) {
        super(serviceClient.host(new URI[0]));
        this.serviceClient = serviceClient;
    }

    public PAResponse processPARequest(PARequest request) {
        return this.getAsset(request.getClient(), request.getParameters(), request.getAccessToken());
    }

    protected PAResponse getAsset(Client client, Map props, AccessToken accessToken) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("access_token", accessToken.getToken().toString());
        m.put("client_id", client.getIdentifierString());
        m.put("client_secret", client.getSecret());
        m.put("redirect_uri", (String)props.get("redirect_uri"));
        m.put("certreq", String.valueOf(props.get("certreq")));
        m.put("certlifetime", String.valueOf(props.get("certlifetime")));
        String response = this.getServiceClient().doGet(m);
        MyX509Certificates myX509Certificate = null;
        try {
            myX509Certificate = new MyX509Certificates(MyCertUtil.fromX509PEM((String)response));
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        PAResponse par = new PAResponse((ProtectedAsset)myX509Certificate);
        return par;
    }
}

