/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.client;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.IdentifierProvider;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import java.net.URI;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.client.request.BasicRequest;
import org.oa4mp.delegation.client.request.RFC7523Request;
import org.oa4mp.delegation.client.request.RFC7523Response;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.BaseClientConverter;
import org.oa4mp.delegation.common.storage.clients.BaseClientKeys;
import org.oa4mp.delegation.common.storage.clients.ClientProvider;
import org.oa4mp.delegation.server.client.RFC7523Utils;
import org.oa4mp.delegation.server.client.TokenAwareServer;
import org.oa4mp.delegation.server.server.RFC7523Constants;

public class RFC7523Server
extends TokenAwareServer
implements RFC7523Constants {
    public RFC7523Server(ServiceClient serviceClient, URI issuer, String wellKnown, boolean oidcEnabled) {
        super(serviceClient, issuer, wellKnown, oidcEnabled);
    }

    public RFC7523Response processRFC7523Request(RFC7523Request request) {
        String response;
        if (request.getParameters().containsKey("admin_client")) {
            JSONWebKey key;
            IdentifierProvider<Identifier> idp = new IdentifierProvider<Identifier>("admins"){};
            ClientProvider clientProvider = new ClientProvider((IdentifierProvider)idp);
            BaseClientKeys baseClientKeys = new BaseClientKeys();
            baseClientKeys.identifier(new String[]{"admin_id"});
            baseClientKeys.secret(new String[]{"secret"});
            BaseClientConverter bcc = new BaseClientConverter(baseClientKeys, (IdentifiableProvider)clientProvider);
            JSONObject wrapper = new JSONObject();
            wrapper.put((Object)bcc.getJSONComponentName(), request.getParameters().get("admin_client"));
            BaseClient adminClient = bcc.fromJSON(wrapper);
            String adminKID = (String)request.getParameters().get("admin_kid");
            request.getParameters().remove("admin_client");
            request.getParameters().remove("admin_kid");
            if (adminClient.hasJWKSURI()) {
                String rawKeys = this.serviceClient.doGet(adminClient.getJwksURI().toString(), null);
                JSONWebKeys keys = null;
                try {
                    JWKUtil2 jwkUtil21 = new JWKUtil2();
                    keys = jwkUtil21.fromJSON(rawKeys);
                    key = (JSONWebKey)keys.get((Object)adminKID);
                }
                catch (Throwable e) {
                    throw new GeneralException("could not get keys", e);
                }
            } else {
                key = (JSONWebKey)adminClient.getJWKS().get((Object)adminKID);
            }
            response = RFC7523Utils.doInitFlowTokenRequest(this.getServiceClient(), adminClient, key, (BaseClient)request.getClient(), this.getTokenEndpoint(), request.getParameters());
        } else {
            response = RFC7523Utils.doTokenRequest(this.getServiceClient(), (BaseClient)request.getClient(), this.getTokenEndpoint(), request.getKeyID(), request.getParameters());
        }
        RFC7523Response rfc7523Response = new RFC7523Response();
        rfc7523Response.setResponse(JSONObject.fromObject((Object)response));
        if (rfc7523Response.getResponse().containsKey((Object)"id_token")) {
            rfc7523Response.setIdToken(this.getAndCheckIDToken(rfc7523Response.getResponse(), (BasicRequest)request));
        }
        return rfc7523Response;
    }
}

