/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.client;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.NonceHerder;
import org.oa4mp.delegation.server.jwt.MyOtherJWTUtil2;
import org.oa4mp.delegation.server.server.RFC7523Constants;

public class RFC7523Utils
implements RFC7523Constants {
    public static String doPost(ServiceClient serviceClient, BaseClient baseClient, URI accessTokenEndpoint, String keyID, Map parameters) {
        return RFC7523Utils.doPost(serviceClient, baseClient, accessTokenEndpoint, RFC7523Utils.findKey(baseClient, keyID), parameters);
    }

    public static String doPost(ServiceClient serviceClient, BaseClient baseClient, URI accessTokenEndpoint, JSONWebKey key, Map parameters) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.putAll(parameters);
            if (key == null) {
                throw new IllegalStateException("Client \"" + baseClient.getIdentifierString() + "\" key not found.");
            }
            JSONObject authNRequest = RFC7523Utils.createBasicJWT(baseClient);
            authNRequest.put((Object)"aud", (Object)accessTokenEndpoint.toString());
            String payload = MyOtherJWTUtil2.createJWT(authNRequest, key);
            map.put("client_assertion", payload);
            map.put("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
            return serviceClient.doPost(map);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new GeneralException("POST error for client \"" + baseClient.getIdentifierString() + "\"", t);
        }
    }

    protected static JSONObject createBasicJWT(BaseClient client) {
        JSONObject json = new JSONObject();
        String clientid = client.getIdentifierString();
        json.put((Object)"iss", (Object)clientid);
        json.put((Object)"sub", (Object)clientid);
        json.put((Object)"jti", (Object)(clientid + (clientid.endsWith("/") ? "" : "/") + "rfc7523/" + NonceHerder.createNonce()));
        json.put((Object)"exp", (Object)((System.currentTimeMillis() + 900000L) / 1000L));
        json.put((Object)"iat", (Object)(System.currentTimeMillis() / 1000L));
        return json;
    }

    protected static JSONWebKey findKey(BaseClient client, String kid) {
        if (!client.hasJWKS()) {
            throw new IllegalStateException("Client \"" + client.getIdentifierString() + "\" is missing JSON Web Keys.");
        }
        JSONWebKeys jwks = client.getJWKS();
        JSONWebKey key = null;
        if (jwks.size() == 1) {
            key = jwks.getDefault();
        } else {
            if (StringUtils.isTrivial((String)kid)) {
                throw new IllegalStateException("client \"" + client.getIdentifierString() + "\" has multiple keys, but no key id (kid). Cannot encode token.");
            }
            key = (JSONWebKey)jwks.get((Object)kid);
        }
        return key;
    }

    public static String doTokenRequest(ServiceClient serviceClient, BaseClient client, URI tokenEndpoint, String kid, Map parameters) {
        JSONObject authGrant = RFC7523Utils.createBasicJWT(client);
        if (parameters.containsKey("scope")) {
            RFC7523Utils.setupScopes(parameters);
        }
        authGrant.putAll(parameters);
        JSONWebKey key = RFC7523Utils.findKey(client, kid);
        if (key == null) {
            throw new IllegalStateException("Client \"" + client.getIdentifierString() + "\" key not found.");
        }
        JSONObject tokenRequest = RFC7523Utils.createBasicJWT(client);
        tokenRequest.putAll(parameters);
        tokenRequest.put((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:jwt-bearer");
        try {
            tokenRequest.put((Object)"assertion", (Object)MyOtherJWTUtil2.createJWT(authGrant, key));
        }
        catch (Throwable t) {
            if (DebugUtil.isEnabled()) {
                t.printStackTrace();
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new GeneralException("Token request error for client \"" + client.getIdentifierString() + "\"", t);
        }
        return RFC7523Utils.doPost(serviceClient, client, tokenEndpoint, kid, (Map)tokenRequest);
    }

    public static String doInitFlowTokenRequest(ServiceClient serviceClient, BaseClient adminClient, JSONWebKey adminKey, BaseClient client, URI tokenEndpoint, Map parameters) {
        if (adminKey == null) {
            throw new IllegalStateException("Client \"" + client.getIdentifierString() + "\" key not found.");
        }
        JSONObject tokenRequest = RFC7523Utils.createBasicJWT(client);
        if (parameters.containsKey("scope")) {
            RFC7523Utils.setupScopes(parameters);
        }
        tokenRequest.putAll(parameters);
        tokenRequest.put((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:jwt-bearer");
        try {
            tokenRequest.put((Object)"assertion", (Object)MyOtherJWTUtil2.createJWT(tokenRequest));
        }
        catch (Throwable t) {
            if (DebugUtil.isEnabled()) {
                t.printStackTrace();
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new GeneralException("Token request error for client \"" + client.getIdentifierString() + "\"", t);
        }
        return RFC7523Utils.doPost(serviceClient, adminClient, tokenEndpoint, adminKey, (Map)tokenRequest);
    }

    private static void setupScopes(Map parameters) {
        JSONArray array;
        Object obj = parameters.get("scope");
        parameters.remove("scope");
        if (obj instanceof JSONArray) {
            array = (JSONArray)obj;
        } else if (obj instanceof String) {
            array = new JSONArray();
            StringTokenizer stringTokenizer = new StringTokenizer((String)obj, " ");
            while (stringTokenizer.hasMoreTokens()) {
                array.add((Object)stringTokenizer.nextToken());
            }
        } else {
            throw new IllegalArgumentException("unknown scope type of " + String.valueOf(obj.getClass()) + ": \"" + String.valueOf(obj) + "\"");
        }
        parameters.put("scope", array);
    }
}

