/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.client;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import java.net.URI;
import java.util.HashMap;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.client.request.RFC7662Request;
import org.oa4mp.delegation.client.request.RFC7662Response;
import org.oa4mp.delegation.client.server.RFC7662Server;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.client.RFC7523Utils;
import org.oa4mp.delegation.server.client.TokenAwareServer;
import org.oa4mp.delegation.server.server.RFC7662Constants;

public class RFC7662Server2
extends TokenAwareServer
implements RFC7662Server,
RFC7662Constants {
    public RFC7662Server2(ServiceClient serviceClient, URI issuer, String wellKnown, boolean oidcEnabled) {
        super(serviceClient, issuer, wellKnown, oidcEnabled);
    }

    public RFC7662Response processRFC7662Request(RFC7662Request request) {
        String out;
        HashMap<String, String> parameters = new HashMap<String, String>();
        Client client = request.getClient();
        if (request.hasAccessToken()) {
            parameters.put("token_type_hint", "access_token");
            String token = request.getAccessToken().getToken();
            parameters.put("token", token);
            out = this.getServiceClient().doPost(parameters, token);
        } else {
            parameters.put("token_type_hint", "refresh_token");
            String token = request.getRefreshToken().getToken();
            parameters.put("token", token);
            out = client.hasJWKS() ? RFC7523Utils.doPost(this.getServiceClient(), (BaseClient)request.getClient(), request.getTokenEndpoint(), request.getKeyID(), parameters) : this.getServiceClient().doPost(parameters, request.getClient().getIdentifierString(), request.getClient().getSecret());
        }
        try {
            JSONObject jsonObject = JSONObject.fromObject((Object)out);
            RFC7662Response response = new RFC7662Response();
            response.setResponse(jsonObject);
            return response;
        }
        catch (JSONException jsonException) {
            throw new GeneralException("Error parsing JSON from \"" + out + "\"");
        }
    }
}

