/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.client;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import java.net.URI;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.client.request.BasicRequest;
import org.oa4mp.delegation.client.request.RTRequest;
import org.oa4mp.delegation.client.request.RTResponse;
import org.oa4mp.delegation.client.server.RTServer;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.client.RFC7523Utils;
import org.oa4mp.delegation.server.client.TokenAwareServer;

public class RTServer2
extends TokenAwareServer
implements RTServer {
    public RTServer2(ServiceClient serviceClient, URI issuer, String wellknown, boolean oidcEnabled) {
        super(serviceClient, issuer, wellknown, oidcEnabled);
    }

    public RTResponse processRTRequest(RTRequest rtRequest) {
        AccessToken accessToken = rtRequest.getAccessToken();
        RefreshToken refreshToken = rtRequest.getRefreshToken();
        if (refreshToken == null) {
            throw new GeneralException("there is no refresh token, so it is not possible to refresh it.");
        }
        String raw = this.getRTResponse(this.getAddress(), rtRequest);
        JSONObject json = this.getAndCheckResponse(raw);
        String returnedAT = json.getString("access_token");
        if (accessToken.getToken().equals(returnedAT)) {
            throw new IllegalArgumentException("the returned access token from the server should not match the one in the request.");
        }
        String exp = json.getString("expires_in");
        if (exp == null || exp.length() == 0) {
            throw new IllegalArgumentException("missing expires_in field from server");
        }
        RefreshTokenImpl refreshTokenImpl2 = TokenFactory.createRT((String)json.getString("refresh_token"));
        AccessTokenImpl newAT = TokenFactory.createAT((String)returnedAT);
        IDTokenImpl idToken = null;
        if (this.serverOIDCEnabled && rtRequest.getClient().getScopes().contains("openid")) {
            idToken = this.getAndCheckIDToken(json, (BasicRequest)rtRequest);
        }
        RTResponse rtResponse = this.createResponse(newAT, refreshTokenImpl2, idToken);
        return rtResponse;
    }

    protected String getRTResponse(URI uri, RTRequest rtRequest) {
        String response;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("grant_type", "refresh_token");
        map.put("refresh_token", rtRequest.getRefreshToken().getToken());
        map.putAll(rtRequest.getParameters());
        Client client = rtRequest.getClient();
        if (client.hasJWKS()) {
            response = RFC7523Utils.doPost(this.getServiceClient(), (BaseClient)client, this.getTokenEndpoint(), rtRequest.getKeyID(), map);
        } else {
            map.put("client_id", client.getIdentifierString());
            map.put("client_secret", client.getSecret());
            response = this.getServiceClient().doGet(map);
        }
        return response;
    }

    public RTResponse createResponse(AccessTokenImpl at, RefreshTokenImpl rt, IDTokenImpl idToken) {
        return new RTResponse(at, rt, idToken);
    }
}

