/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.client;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.client.request.BasicRequest;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.JWTUtil;
import org.oa4mp.delegation.server.client.ASImpl;

public abstract class TokenAwareServer
extends ASImpl {
    boolean serverOIDCEnabled = true;
    boolean clientOIDCEnabled = false;
    ServiceClient serviceClient;
    URI issuer;
    String wellKnown = null;
    URI tokenEndpoint;

    URI getIssuer() {
        return this.issuer;
    }

    public ServiceClient getServiceClient() {
        return this.serviceClient;
    }

    public TokenAwareServer(ServiceClient serviceClient, URI issuer, String wellKnown, boolean serverOIDCEnabled) {
        super(serviceClient.host(new URI[0]));
        this.serviceClient = serviceClient;
        this.wellKnown = wellKnown;
        this.serverOIDCEnabled = serverOIDCEnabled;
        this.tokenEndpoint = serviceClient.host(new URI[0]);
        this.issuer = issuer;
    }

    public JSONWebKeys getJsonWebKeys() {
        if (this.wellKnown == null) {
            throw new NFWException("no well-known URI has been configured. Please add this to the configuration file.");
        }
        return JWTUtil.getJsonWebKeys(this.getServiceClient(), this.wellKnown);
    }

    protected JSONObject getAndCheckResponse(String response) {
        if (response == null || response.length() == 0) {
            return new JSONObject();
        }
        if (response.startsWith("<") || response.startsWith("\n")) {
            throw new GeneralException("response from server was html: " + response);
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.fromObject((Object)response);
        }
        catch (Throwable t) {
            DebugUtil.trace((Object)this, (String)("Response from server was not a JSON Object: " + response));
            throw new GeneralException("the server encountered an error and the response was not JSON:\n\"" + response + "\"", t);
        }
        if (!jsonObject.getString("token_type").equals("Bearer")) {
            throw new GeneralException("incorrect token type");
        }
        return jsonObject;
    }

    protected IDTokenImpl getAndCheckIDToken(JSONObject jsonObject, BasicRequest atRequest) {
        JSONObject claims;
        block11: {
            if (!this.serverOIDCEnabled) {
                return null;
            }
            JSONWebKeys keys = this.getJsonWebKeys();
            if (!jsonObject.containsKey((Object)"id_token")) {
                throw new GeneralException("ID Token not found.");
            }
            claims = JWTUtil.verifyAndReadJWT(jsonObject.getString("id_token"), keys);
            if (claims.isNullObject()) {
                return null;
            }
            if (!claims.containsKey((Object)"aud")) {
                throw new GeneralException(" ID Token missing aud claim for \"" + atRequest.getClient().getIdentifierString() + "\"");
            }
            if (!claims.getString("aud").equals(atRequest.getClient().getIdentifierString())) {
                throw new GeneralException(" ID Token audience is incorrect. Expected \"" + claims.getString("aud") + "\", got \"" + atRequest.getClient().getIdentifierString() + "\"");
            }
            if (!claims.containsKey((Object)"iss")) {
                throw new GeneralException(" ID Token missing iss claim for \"" + atRequest.getClient().getIdentifierString() + "\"");
            }
            URL host = null;
            URL remoteHost = null;
            try {
                host = this.getAddress().toURL();
                remoteHost = new URL(claims.getString("iss"));
                if (!(remoteHost.equals(this.getIssuer().toURL()) || host.getProtocol().equals(remoteHost.getProtocol()) && host.getHost().equals(remoteHost.getHost()) && remoteHost.equals(this.getIssuer().toURL()) && host.getPort() == remoteHost.getPort())) {
                    throw new GeneralException(" ID Token issuer is incorrect. Got \"" + String.valueOf(remoteHost) + "\", expected \"" + String.valueOf(host) + "\"");
                }
            }
            catch (MalformedURLException e) {
                if (!DebugUtil.isEnabled()) break block11;
                System.err.println(this.getClass().getSimpleName() + " ID Token:\n" + claims.toString(2));
                System.err.println("host= " + String.valueOf(host) + " remoteHost = " + String.valueOf(remoteHost));
                System.err.println("got " + claims.getString("iss") + " expected " + String.valueOf(this.getIssuer()));
                e.printStackTrace();
            }
        }
        if (!claims.containsKey((Object)"exp")) {
            throw new GeneralException(" ID Token claims failed to have required expiration");
        }
        long exp = Long.parseLong(claims.getString("exp")) * 1000L;
        if (exp <= System.currentTimeMillis()) {
            throw new GeneralException(" ID Token expired claims.");
        }
        return TokenFactory.createIDT((String)jsonObject.getString("id_token"));
    }

    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(URI tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }
}

