/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.jwt;

import edu.uiuc.ncsa.security.core.exceptions.IllegalAccessException;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunRequest;
import edu.uiuc.ncsa.security.util.scripting.ScriptRunResponse;
import edu.uiuc.ncsa.security.util.scripting.ScriptRuntimeEngine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.jwt.AccessTokenHandlerInterface;
import org.oa4mp.delegation.server.jwt.FlowStates;
import org.oa4mp.delegation.server.jwt.IDTokenHandlerInterface;
import org.oa4mp.delegation.server.jwt.PayloadHandler;
import org.oa4mp.delegation.server.jwt.RefreshTokenHandlerInterface;
import org.oa4mp.delegation.server.server.OIDCServiceTransactionInterface;
import org.oa4mp.delegation.server.server.claims.ClaimSource;

public class HandlerRunner {
    OIDCServiceTransactionInterface transaction;
    AccessTokenHandlerInterface accessTokenHandler = null;
    IDTokenHandlerInterface idTokenHandlerInterface = null;
    RefreshTokenHandlerInterface refreshTokenHandler = null;
    List<PayloadHandler> handlers = new ArrayList<PayloadHandler>();
    ScriptRuntimeEngine scriptRuntimeEngine = null;

    public AccessTokenHandlerInterface getAccessTokenHandler() {
        return this.accessTokenHandler;
    }

    public void setAccessTokenHandler(AccessTokenHandlerInterface accessTokenHandler) {
        this.accessTokenHandler = accessTokenHandler;
        this.addHandler(accessTokenHandler);
    }

    public IDTokenHandlerInterface getIdTokenHandlerInterface() {
        return this.idTokenHandlerInterface;
    }

    public void setIdTokenHandlerInterface(IDTokenHandlerInterface idTokenHandlerInterface) {
        this.idTokenHandlerInterface = idTokenHandlerInterface;
        if (idTokenHandlerInterface instanceof PayloadHandler) {
            this.addHandler((PayloadHandler)((Object)idTokenHandlerInterface));
        }
    }

    public boolean hasIDTokenHandler() {
        return this.idTokenHandlerInterface != null;
    }

    public boolean hasATHandler() {
        return this.accessTokenHandler != null;
    }

    public void setRefreshTokenHandler(RefreshTokenHandlerInterface refreshTokenHandler) {
        this.refreshTokenHandler = refreshTokenHandler;
        this.addHandler(refreshTokenHandler);
    }

    public RefreshTokenHandlerInterface getRefreshTokenHandler() {
        return this.refreshTokenHandler;
    }

    public boolean hasRTHandler() {
        return this.refreshTokenHandler != null;
    }

    public HandlerRunner(OIDCServiceTransactionInterface transaction, ScriptRuntimeEngine scriptRuntimeEngine) {
        this.transaction = transaction;
        this.scriptRuntimeEngine = scriptRuntimeEngine;
    }

    public void addHandler(PayloadHandler handler) {
        this.handlers.add(handler);
    }

    public void initializeHandlers() throws Throwable {
        for (PayloadHandler h : this.handlers) {
            DebugUtil.trace((Object)this, (String)("Running init for handler " + String.valueOf(h)));
            h.init();
        }
    }

    public void doAuthClaims() throws Throwable {
        DebugUtil.trace((Object)this, (String)"Starting Auth claims");
        this.transaction.setFlowStates(new FlowStates());
        this.initializeHandlers();
        this.doScript("init");
        this.doScript("pre_auth");
        this.doScript("post_auth");
        this.getFromSources(this.transaction.getFlowStates(), "pre_auth", true);
        for (PayloadHandler h : this.handlers) {
            h.saveState("post_auth");
        }
    }

    public void doRefreshClaims() throws Throwable {
        this.doTokenClaims(true);
    }

    public void doTokenExchange() throws Throwable {
        for (PayloadHandler h : this.handlers) {
            h.setAccountingInformation();
        }
        this.doScript("pre_exchange");
        this.doScript("post_exchange");
        for (PayloadHandler h : this.handlers) {
            h.checkClaims();
        }
        for (PayloadHandler h : this.handlers) {
            h.saveState("post_exchange");
        }
        for (PayloadHandler h : this.handlers) {
            h.finish("post_exchange");
        }
    }

    public void doUserInfo() throws Throwable {
        for (PayloadHandler h : this.handlers) {
            h.setAccountingInformation();
        }
        this.doScript("pre_user_info");
        this.getFromSources(this.transaction.getFlowStates(), "pre_auth", false);
        this.doScript("post_user_info");
        for (PayloadHandler h : this.handlers) {
            h.checkClaims();
        }
        for (PayloadHandler h : this.handlers) {
            h.saveState("post_user_info");
        }
        for (PayloadHandler h : this.handlers) {
            h.finish("post_user_info");
        }
    }

    public void doTokenClaims() throws Throwable {
        this.doTokenClaims(false);
    }

    protected void doTokenClaims(boolean isRefresh) throws Throwable {
        this.doScript(isRefresh ? "pre_refresh" : "pre_token");
        this.getFromSources(this.transaction.getFlowStates(), isRefresh ? "pre_refresh" : "pre_token", false);
        if (isRefresh) {
            for (PayloadHandler h : this.handlers) {
                h.setAccountingInformation();
            }
        }
        this.doScript(isRefresh ? "post_refresh" : "post_token");
        for (PayloadHandler h : this.handlers) {
            h.checkClaims();
        }
        for (PayloadHandler h : this.handlers) {
            h.saveState(isRefresh ? "post_refresh" : "post_token");
        }
        for (PayloadHandler h : this.handlers) {
            h.finish(isRefresh ? "post_refresh" : "post_token");
        }
    }

    protected void getFromSources(FlowStates flowStates, String execPhase, boolean checkAuthClaims) throws Throwable {
        JSONObject claims = this.getIdTokenHandlerInterface().getUserMetaData();
        for (PayloadHandler h : this.handlers) {
            if (h.getSources().isEmpty()) continue;
            for (int i = 0; i < h.getSources().size(); ++i) {
                boolean isRunAtAuthz;
                ClaimSource claimSource = h.getSources().get(i);
                boolean bl = isRunAtAuthz = h instanceof IDTokenHandlerInterface && !(h instanceof AccessTokenHandlerInterface);
                if (isRunAtAuthz) {
                    DebugUtil.trace((Object)this, (String)"executing get claims");
                    if (claimSource.isRunOnlyAtAuthorization()) {
                        if (execPhase.endsWith("_auth")) {
                            claims = h.execute(claimSource, claims);
                        }
                    } else {
                        claims = h.execute(claimSource, claims);
                    }
                    if (!flowStates.acceptRequests) {
                        throw new IllegalAccessException();
                    }
                    h.finish(execPhase);
                }
                DebugUtil.trace((Object)this, (String)("user info for claim source #" + String.valueOf(claimSource) + " = " + claims.toString(1)));
            }
        }
        for (PayloadHandler h : this.handlers) {
            if (!(h instanceof IDTokenHandlerInterface)) continue;
            ((IDTokenHandlerInterface)((Object)h)).setUserMetaData(claims);
        }
    }

    public ScriptRuntimeEngine getScriptRuntimeEngine() {
        if (this.scriptRuntimeEngine == null) {
            // empty if block
        }
        return this.scriptRuntimeEngine;
    }

    protected ScriptRunRequest newSRR(final OIDCServiceTransactionInterface transaction, final String phase) {
        ScriptRunRequest initReq = new ScriptRunRequest(){
            HashMap<String, Object> map = new HashMap();
            boolean isPopulated = false;
            String p = phase;

            void populate() {
                if (this.isPopulated) {
                    return;
                }
                if (transaction.getProxyState().containsKey((Object)"asset")) {
                    JSONObject idt = transaction.getProxyState().getJSONObject("asset").getJSONObject("id_token");
                    if (idt != null) {
                        IDTokenImpl idToken = TokenFactory.createIDT((JSONObject)idt);
                        this.map.put("proxy_claims", idToken.getPayload());
                    } else {
                        this.map.put("proxy_claims", new JSONObject());
                    }
                } else {
                    this.map.put("proxy_claims", new JSONObject());
                }
                if (!transaction.getUserMetaData().isEmpty()) {
                    this.map.put("claims", transaction.getUserMetaData());
                }
                if (!transaction.getATData().isEmpty()) {
                    this.map.put("access_token", transaction.getATData());
                }
                if (!transaction.getRTData().isEmpty()) {
                    this.map.put("refresh_token", transaction.getRTData());
                }
                this.map.put("scopes", transaction.getScopes());
                this.map.put("audience", transaction.getAudience());
                this.map.put("resource", transaction.getResource());
                this.map.put("eas", transaction.getExtendedAttributes());
                this.map.put("flow_states", transaction.getFlowStates());
                this.isPopulated = true;
            }

            public Map<String, Object> getArgs() {
                if (!this.isPopulated) {
                    this.populate();
                }
                return this.map;
            }

            public String getAction() {
                return this.p;
            }

            public boolean returnArgs() {
                return true;
            }

            public String getResponseArgName() {
                return "";
            }

            public boolean hasReturnedValue() {
                return false;
            }
        };
        return initReq;
    }

    protected void handleSREResponse(OIDCServiceTransactionInterface transaction, ScriptRunResponse scriptRunResponse) throws IOException {
        switch (scriptRunResponse.getReturnCode()) {
            case 1: {
                transaction.setFlowStates((FlowStates)scriptRunResponse.getReturnedValues().get("flow_states"));
                return;
            }
            case 0: {
                return;
            }
        }
        throw new NotImplementedException(" other script runtime reponses not implemented yet.");
    }

    protected void doScript(String phase) throws Throwable {
        this.newDoScript(phase);
    }

    protected void newDoScript(String phase) throws Throwable {
        if (this.getScriptRuntimeEngine() == null) {
            return;
        }
        if (this.handlers.isEmpty()) {
            ScriptRunRequest req = this.newSRR(this.transaction, phase);
            ScriptRunResponse resp = this.getScriptRuntimeEngine().run(req);
            this.handleSREResponse(this.transaction, resp);
        } else {
            PayloadHandler previousHandler = null;
            block13: for (PayloadHandler h : this.handlers) {
                if (h.getPhCfg().isLegacyHandler() || h.hasScript() && h.getPhCfg().getScriptSet().get("exec_phase", phase) != null) {
                    ScriptRunRequest req = this.newSRR(this.transaction, phase);
                    if (previousHandler != null && previousHandler instanceof IDTokenHandlerInterface && h instanceof IDTokenHandlerInterface) {
                        IDTokenHandlerInterface h2 = (IDTokenHandlerInterface)((Object)h);
                        h2.setUserMetaData(((IDTokenHandlerInterface)((Object)previousHandler)).getUserMetaData());
                    }
                    h.addRequestState(req);
                    this.getScriptRuntimeEngine().clearScriptSet();
                    this.getScriptRuntimeEngine().setScriptSet(h.getPhCfg().getScriptSet());
                    ScriptRunResponse resp = this.getScriptRuntimeEngine().run(req);
                    this.handleSREResponse(this.transaction, resp);
                    h.handleResponse(resp);
                    previousHandler = h;
                    continue;
                }
                switch (phase) {
                    case "pre_auth": 
                    case "pre_user_info": {
                        if (!(h instanceof IDTokenHandlerInterface)) break;
                        IDTokenHandlerInterface hhh = (IDTokenHandlerInterface)((Object)h);
                        JSONObject currentUMD = hhh.getUserMetaData();
                        for (ClaimSource claimSource : h.getSources()) {
                            currentUMD = h.execute(claimSource, currentUMD);
                            hhh.setUserMetaData(currentUMD);
                        }
                        continue block13;
                    }
                    case "post_auth": {
                        if (!(h instanceof IDTokenHandlerInterface)) break;
                        h.setResponseCode(2);
                        h.finish(phase);
                        h.saveState("post_auth");
                        break;
                    }
                    case "post_token": 
                    case "post_refresh": 
                    case "post_exchange": {
                        if (!(h instanceof AccessTokenHandlerInterface) && !(h instanceof RefreshTokenHandlerInterface)) break;
                        h.setResponseCode(2);
                        h.finish(phase);
                        h.saveState("post_exchange");
                    }
                }
            }
        }
    }
}

