/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidAlgorithmException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidSignatureException;
import edu.uiuc.ncsa.security.core.exceptions.UnsupportedJWTTypeException;
import edu.uiuc.ncsa.security.core.exceptions.UnsupportedProtocolException;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.server.JWTUtil;

public class MyOtherJWTUtil2 {
    public static String TYPE = "typ";
    public static String KEY_ID = "kid";
    public static String ALGORITHM = "alg";
    public static String DEFAULT_TYPE = "JWT";
    JWKUtil2 jwkUtil2;
    public static final String NONE_JWT = "none";
    public static final int NONE_KEY = 100;
    public static final String RS256_JWT = "RS256";
    public static final String RS256_JAVA = "SHA256withRSA";
    public static final int RS256_KEY = 101;
    public static final String RS384_JWT = "RS384";
    public static final String RS384_JAVA = "SHA384withRSA";
    public static final int RS384_KEY = 102;
    public static final String RS512_JWT = "RS512";
    public static final String RS512_JAVA = "SHA512withRSA";
    public static final int RS512_KEY = 103;
    public static final int HEADER_INDEX = 0;
    public static final int PAYLOAD_INDEX = 1;
    public static final int SIGNATURE_INDEX = 2;

    public JWKUtil2 getJwkUtil2() {
        if (this.jwkUtil2 == null) {
            this.jwkUtil2 = new JWKUtil2();
        }
        return this.jwkUtil2;
    }

    public void setJwkUtil2(JWKUtil2 jwkUtil2) {
        this.jwkUtil2 = jwkUtil2;
    }

    public static String createJWT(JSONObject payload) {
        return MyOtherJWTUtil2.createJWT(payload, DEFAULT_TYPE);
    }

    public static String createJWT(JSONObject payload, String type) {
        JSONObject header = new JSONObject();
        header.put((Object)TYPE, (Object)type);
        header.put((Object)ALGORITHM, (Object)NONE_JWT);
        return MyOtherJWTUtil2.concat(header, payload) + ".";
    }

    public static String createJWT(JSONObject payload, JSONWebKey jsonWebKey) throws ParseException, JOSEException {
        return MyOtherJWTUtil2.createJWT(payload, jsonWebKey, DEFAULT_TYPE);
    }

    public static String createJWT(JSONObject payload, JSONWebKey jsonWebKey, String type) throws ParseException, JOSEException {
        JSONObject header = new JSONObject();
        header.put((Object)TYPE, (Object)type);
        if (jsonWebKey.id != null && jsonWebKey.id.length() != 0) {
            header.put((Object)KEY_ID, (Object)jsonWebKey.id);
        }
        Object token = null;
        header.put((Object)ALGORITHM, (Object)jsonWebKey.algorithm);
        token = jsonWebKey.algorithm.equals(NONE_JWT) ? MyOtherJWTUtil2.concat(header, payload) + "." : MyOtherJWTUtil2.sign(header, payload, jsonWebKey);
        return token;
    }

    protected static String concat(JSONObject header, JSONObject payload) {
        return Base64.encodeBase64URLSafeString((byte[])header.toString().getBytes()) + "." + Base64.encodeBase64URLSafeString((byte[])payload.toString().getBytes());
    }

    protected static String sign(JSONObject header, JSONObject payload, JSONWebKey webkey) throws JOSEException, ParseException {
        JWSAlgorithm jwsAlgorithm = new JWSAlgorithm(header.getString(ALGORITHM));
        JWSHeader jwsHeader = JWSHeader.parse((Map)header);
        JWTClaimsSet jwsPayload = JWTClaimsSet.parse((Map)payload);
        SignedJWT signedJWT = new SignedJWT(jwsHeader, jwsPayload);
        RSASSASigner signer = null;
        boolean unsupportedSigner = true;
        if (webkey.isRSAKey()) {
            signer = new RSASSASigner(webkey.privateKey);
            unsupportedSigner = false;
        }
        if (webkey.isECKey()) {
            signer = new ECDSASigner((ECPrivateKey)webkey.privateKey);
            unsupportedSigner = false;
        }
        if (unsupportedSigner) {
            throw new UnsupportedProtocolException("unsupported key type for signature verification");
        }
        signedJWT.sign((JWSSigner)signer);
        return signedJWT.serialize();
    }

    protected static String sign(String x, JSONWebKey webkey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(webkey.privateKey.getEncoded());
        RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance(MyOtherJWTUtil2.getJavaSignatureName(webkey.algorithm));
        signature.initSign(privateKey);
        byte[] content = x.getBytes();
        signature.update(content);
        byte[] signatureBytes = signature.sign();
        return Base64.encodeBase64URLSafeString((byte[])signatureBytes);
    }

    protected static String getJavaSignatureName(String algorithm) {
        if (algorithm.equals(NONE_JWT)) {
            return NONE_JWT;
        }
        if (algorithm.equals(RS256_JWT)) {
            return RS256_JAVA;
        }
        if (algorithm.equals(RS384_JWT)) {
            return RS384_JAVA;
        }
        if (algorithm.equals(RS512_JWT)) {
            return RS512_JAVA;
        }
        throw new IllegalArgumentException("unknown algorithm \"" + algorithm + "\"");
    }

    public static boolean verify(Base64URL header, Base64URL payload, Base64URL signature, JSONWebKey webKey) throws ParseException, JOSEException {
        if (signature == null) {
            JSONObject json = JSONObject.fromObject((Object)header.decodeToString());
            Object alg = json.get(ALGORITHM);
            if (alg == null || !(alg instanceof String)) {
                throw new IllegalStateException("Unknown algorithm");
            }
            String algorithm = (String)alg;
            return algorithm.equals(NONE_JWT);
        }
        SignedJWT signedJWT = new SignedJWT(header, payload, signature);
        RSASSAVerifier verifier = null;
        boolean unsupportedProtocol = true;
        if (webKey.isRSAKey()) {
            verifier = new RSASSAVerifier((RSAPublicKey)webKey.publicKey);
            unsupportedProtocol = false;
        }
        if (webKey.isECKey()) {
            verifier = new ECDSAVerifier((ECPublicKey)webKey.publicKey);
            unsupportedProtocol = false;
        }
        if (unsupportedProtocol) {
            throw new UnsupportedProtocolException("unsupported protocol");
        }
        try {
            return signedJWT.verify((JWSVerifier)verifier);
        }
        catch (JOSEException t) {
            return false;
        }
    }

    public static String[] decat(String jwt) {
        StringTokenizer st = new StringTokenizer(jwt, ".");
        String[] output = new String[3];
        switch (st.countTokens()) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("no JWT components found.");
            }
            case 2: {
                output[0] = st.nextToken();
                output[1] = st.nextToken();
                output[2] = "";
                break;
            }
            default: {
                output[0] = st.nextToken();
                output[1] = st.nextToken();
                output[2] = st.nextToken();
            }
        }
        return output;
    }

    public static JSONObject[] readJWT(String jwt) {
        String[] x = MyOtherJWTUtil2.decat(jwt);
        JSONObject h = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)x[0])));
        JSONObject p = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)x[1])));
        JSONObject[] rc = new JSONObject[]{h, p};
        return rc;
    }

    public static JSONObject verifyAndReadJWT(String jwt) {
        return MyOtherJWTUtil2.verifyAndReadJWT(jwt, (JSONWebKeys)null);
    }

    public static JSONObject verifyAndReadJWT(String jwt, JSONWebKeys webKeys) {
        String[] x = MyOtherJWTUtil2.decat(jwt);
        JSONObject h = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)x[0])));
        Base64URL h64 = new Base64URL(x[0]);
        Base64URL p64 = new Base64URL(x[1]);
        Base64URL s64 = null;
        if (x.length == 3) {
            s64 = new Base64URL(x[2]);
        }
        JSONObject p = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)x[1])));
        if (h.get(ALGORITHM) == null) {
            throw new InvalidAlgorithmException("no algorithm.");
        }
        if (h.get(ALGORITHM).equals(NONE_JWT)) {
            DebugUtil.trace(JWTUtil.class, (String)"unsigned id token. Returning payload");
            return p;
        }
        if (!h.get(TYPE).equals(DEFAULT_TYPE) && !h.get(TYPE).equals("at+jwt")) {
            throw new UnsupportedJWTTypeException("Unsupported token type.");
        }
        Object keyID = h.get(KEY_ID);
        if (webKeys == null) {
            throw new IllegalStateException("Missing web keys");
        }
        if (keyID == null || !(keyID instanceof String)) {
            throw new InvalidAlgorithmException("Unknown algorithm");
        }
        boolean isOK = false;
        try {
            JSONWebKey wk = (JSONWebKey)webKeys.get((Object)h.getString(KEY_ID));
            if (wk == null) {
                throw new IllegalArgumentException("Web key with id " + KEY_ID + " not found. Allowed keys are " + String.valueOf(webKeys.keySet()));
            }
            if (wk.publicKey == null) {
                throw new IllegalStateException("Web key with id " + KEY_ID + " does not have a public key");
            }
            isOK = MyOtherJWTUtil2.verify(h64, p64, s64, wk);
        }
        catch (Throwable t) {
            throw new InvalidSignatureException("could not verify signature", t);
        }
        if (!isOK) {
            throw new InvalidSignatureException("could not verify signature");
        }
        return p;
    }

    public static JSONWebKeys getJsonWebKeys(String wellKnown) {
        if (wellKnown == null || wellKnown.isEmpty()) {
            throw new GeneralException("missing well known URI. Cannot get keys");
        }
        ServiceClient serviceClient = new ServiceClient(URI.create(wellKnown));
        return MyOtherJWTUtil2.getJsonWebKeys(serviceClient, wellKnown);
    }

    public static JSONWebKeys getJsonWebKeys(URI wellKnown) {
        if (wellKnown == null) {
            throw new GeneralException("missing well known uri. Cannot resolve the keys");
        }
        return MyOtherJWTUtil2.getJsonWebKeys(wellKnown.toString());
    }

    public static JSONObject verifyAndReadJWT(String jwt, URI wellKnown) {
        if (wellKnown == null) {
            throw new GeneralException("missing well known uri. Cannot resolve the keys");
        }
        if (jwt == null || jwt.isEmpty()) {
            throw new GeneralException("missing or empty token.");
        }
        return MyOtherJWTUtil2.verifyAndReadJWT(jwt, JWTUtil.getJsonWebKeys(wellKnown.toString()));
    }

    public static JSONWebKeys getJsonWebKeys(ServiceClient serviceClient, String wellKnown) {
        JWKUtil2 jwkUtil21 = new JWKUtil2();
        if (serviceClient == null) {
            throw new GeneralException("missing service client.");
        }
        if (wellKnown == null || wellKnown.isEmpty()) {
            throw new GeneralException("missing well known URI. Cannot get keys");
        }
        String rawResponse = serviceClient.doGet(wellKnown, null);
        JSON rawJSON = JSONSerializer.toJSON((Object)rawResponse);
        if (!(rawJSON instanceof JSONObject)) {
            throw new IllegalStateException("Attempted to get JSON Object but returned result is not JSON");
        }
        JSONObject json = (JSONObject)rawJSON;
        String rawKeys = serviceClient.doGet(json.getString("jwks_uri"), null);
        JSONWebKeys keys = null;
        Object claims = null;
        try {
            keys = jwkUtil21.fromJSON(rawKeys);
        }
        catch (Throwable e) {
            throw new GeneralException("could not get keys", e);
        }
        return keys;
    }
}

