/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.server;

import edu.uiuc.ncsa.security.servlet.ServletDebugUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.request.AGResponse;
import org.oa4mp.delegation.server.server.IResponse2;
import org.oa4mp.delegation.server.server.OA2ClientScopes;
import org.oa4mp.delegation.server.server.OA2TransactionScopes;

public class AGIResponse2
extends IResponse2
implements AGResponse {
    boolean encodeToken = false;
    ServiceTransaction serviceTransaction;
    AuthorizationGrant grant;

    public AGIResponse2(boolean isOIDC) {
        super(isOIDC);
    }

    public boolean isEncodeToken() {
        return this.encodeToken;
    }

    public void setEncodeToken(boolean encodeToken) {
        this.encodeToken = encodeToken;
    }

    public Client getClient() {
        return this.getServiceTransaction().getClient();
    }

    public ServiceTransaction getServiceTransaction() {
        return this.serviceTransaction;
    }

    public void setServiceTransaction(ServiceTransaction serviceTransaction) {
        this.serviceTransaction = serviceTransaction;
    }

    public AuthorizationGrant getGrant() {
        return this.grant;
    }

    public void setGrant(AuthorizationGrant grant) {
        this.grant = grant;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void write(HttpServletResponse response) throws IOException {
        JSONObject m = new JSONObject();
        if (this.isEncodeToken()) {
            m.put((Object)"code", (Object)this.grant.encodeToken());
        } else {
            m.put((Object)"code", (Object)this.grant.getToken());
        }
        if (this.parameters.get("state") != null && 0 < ((String)this.parameters.get("state")).length()) {
            m.put((Object)"state", this.parameters.get("state"));
        }
        OA2ClientScopes clientScopes = (OA2ClientScopes)this.getClient();
        OA2TransactionScopes transactionScopes = (OA2TransactionScopes)this.getServiceTransaction();
        if (clientScopes.getScopes() == null || clientScopes.getScopes().isEmpty()) {
            ServletDebugUtil.trace((Object)this, (String)("Client scopes null or empty:" + String.valueOf(clientScopes)));
        }
        if (transactionScopes.getScopes() == null || transactionScopes.getScopes().isEmpty()) {
            ServletDebugUtil.trace((Object)this, (String)("Transaction scopes null or empty = " + String.valueOf(transactionScopes)));
        } else if (clientScopes.getScopes().size() != transactionScopes.getScopes().size()) {
            ServletDebugUtil.trace((Object)this, (String)("returning reduced set of scopes. Stored =" + String.valueOf(clientScopes.getScopes()) + ", returned =" + String.valueOf(transactionScopes.getScopes())));
            JSONArray scopeArray = new JSONArray();
            scopeArray.addAll(transactionScopes.getScopes());
            m.put((Object)"scope", (Object)scopeArray);
            ServletDebugUtil.trace((Object)this, (String)("returned scopes = " + String.valueOf(scopeArray)));
        } else {
            ServletDebugUtil.trace((Object)this, (String)"Full set of requested scopes requested.");
        }
        PrintWriter osw = response.getWriter();
        ServletDebugUtil.trace((Object)this, (String)("Returning JSON object " + m.toString(2)));
        m.write((Writer)osw);
        ((Writer)osw).flush();
        ((Writer)osw).close();
    }
}

