/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.server;

import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.server.OA2Scopes;
import org.oa4mp.delegation.server.ServiceTransaction;
import org.oa4mp.delegation.server.server.IResponse2;
import org.oa4mp.delegation.server.server.OIDCServiceTransactionInterface;

public abstract class IDTokenResponse
extends IResponse2 {
    AccessToken accessToken;
    RefreshTokenImpl refreshToken;
    IDTokenImpl idToken;
    ServiceTransaction serviceTransaction;
    JSONWebKey jsonWebKey;
    boolean signToken = false;
    JSONObject userMetadata;
    Collection<String> supportedScopes = new ArrayList<String>();

    public IDTokenResponse(AccessTokenImpl accessToken, RefreshTokenImpl refreshToken, boolean isOIDC) {
        super(isOIDC);
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public IDTokenImpl getIdToken() {
        return this.idToken;
    }

    public void setIdToken(IDTokenImpl idToken) {
        this.idToken = idToken;
    }

    public boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    public RefreshTokenImpl getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(RefreshTokenImpl refreshToken) {
        this.refreshToken = refreshToken;
    }

    public ServiceTransaction getServiceTransaction() {
        return this.serviceTransaction;
    }

    public void setServiceTransaction(ServiceTransaction serviceTransaction) {
        this.serviceTransaction = serviceTransaction;
    }

    public JSONWebKey getJsonWebKey() {
        return this.jsonWebKey;
    }

    public void setJsonWebKey(JSONWebKey jsonWebKey) {
        this.jsonWebKey = jsonWebKey;
    }

    public boolean isSignToken() {
        return this.signToken;
    }

    public void setSignToken(boolean signToken) {
        this.signToken = signToken;
    }

    public JSONObject getUserMetadata() {
        if (this.userMetadata == null) {
            this.userMetadata = new JSONObject();
        }
        return this.userMetadata;
    }

    public void setUserMetadata(JSONObject userMetadata) {
        this.userMetadata = userMetadata;
    }

    public Collection<String> getSupportedScopes() {
        return this.supportedScopes;
    }

    public void setSupportedScopes(Collection<String> supportedScopes) {
        this.supportedScopes = supportedScopes;
    }

    public void write(HttpServletResponse response) throws IOException {
        String ss;
        DebugUtil.trace((Object)this, (String)"starting ID token response write");
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (this.accessToken.getToken().contains("?")) {
            m.put("access_token", this.accessToken.encodeToken());
        } else {
            m.put("access_token", this.accessToken.getToken());
        }
        m.put("expires_in", this.accessToken.getLifetime() / 1000L);
        m.put("token_type", "Bearer");
        if (this.getRefreshToken() != null && this.getRefreshToken().getToken() != null) {
            if (this.getRefreshToken().getToken().contains("?")) {
                m.put("refresh_token", this.getRefreshToken().encodeToken());
            } else {
                m.put("refresh_token", this.getRefreshToken().getToken());
            }
            m.put("refresh_token_lifetime", this.refreshToken.getLifetime() / 1000L);
            m.put("refresh_token_iat", this.refreshToken.getIssuedAt() / 1000L);
        }
        TreeSet<String> allScopes = new TreeSet<String>();
        OIDCServiceTransactionInterface st = (OIDCServiceTransactionInterface)this.getServiceTransaction();
        if (st.getATData().containsKey((Object)"scope")) {
            allScopes.addAll(OA2Scopes.ScopeUtil.toScopes(st.getATData().getString("scope")));
        }
        if (!this.getSupportedScopes().isEmpty()) {
            for (String s : this.getSupportedScopes()) {
                allScopes.add(s);
            }
        }
        if (!StringUtils.isTrivial((String)(ss = OA2Scopes.ScopeUtil.toString(allScopes)))) {
            m.put("scope", ss);
        }
        if ((this.isOIDC() || this.serviceTransaction.getResponseTypes().contains("id_token")) && st.getScopes().contains("openid")) {
            DebugUtil.trace((Object)this, (String)"writing ID token response");
            m.put("id_token", this.getIdToken().getToken());
        }
        JSONObject json = JSONObject.fromObject(m);
        response.setContentType("application/json;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        PrintWriter osw = response.getWriter();
        json.write((Writer)osw);
        ((Writer)osw).flush();
        ((Writer)osw).close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{accessToken=" + String.valueOf(this.accessToken) + ", refreshToken=" + String.valueOf(this.refreshToken) + ", signToken=" + this.signToken + ", claims=" + String.valueOf(this.userMetadata) + ", supportedScopes=" + String.valueOf(this.supportedScopes) + "}";
    }
}

