/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.server;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.MyX509Certificates;
import org.oa4mp.delegation.common.token.ProtectedAsset;
import org.oa4mp.delegation.server.request.PAResponse;
import org.oa4mp.delegation.server.server.IResponse2;

public class PAIResponse2
extends IResponse2
implements PAResponse {
    ProtectedAsset protectedAsset;
    AccessToken accessToken;
    Map<String, String> additionalInformation;

    public PAIResponse2(boolean isOIDC) {
        super(isOIDC);
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public ProtectedAsset getProtectedAsset() {
        return this.protectedAsset;
    }

    public void setProtectedAsset(ProtectedAsset protectedAsset) {
        this.protectedAsset = protectedAsset;
    }

    public Map<String, String> getAdditionalInformation() {
        if (this.additionalInformation == null) {
            this.additionalInformation = new HashMap<String, String>();
        }
        return this.additionalInformation;
    }

    public void setAdditionalInformation(Map<String, String> additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public void write(HttpServletResponse response) throws IOException {
        if (this.protectedAsset == null) {
            throw new GeneralException("Error, no protected asset =");
        }
        if (!(this.getProtectedAsset() instanceof MyX509Certificates)) {
            throw new NotImplementedException("Error, this implementation can only serialize MyX509Certificates and a protected asset of type \"" + this.getProtectedAsset().getClass().getName() + "\" was found instead");
        }
        try {
            MyX509Certificates certs = (MyX509Certificates)this.getProtectedAsset();
            if (certs == null || certs.getX509CertificatesPEM() == null) {
                throw new GeneralException(" No certificate found.");
            }
            response.setContentType("text/plain");
            ServletOutputStream out = response.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out);
            out.write(certs.getX509CertificatesPEM().getBytes());
            out.flush();
            out.close();
        }
        catch (Exception x) {
            throw new GeneralException((Throwable)x);
        }
    }
}

