/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.server;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class RFC7636Util {
    public static final String CODE_VERIFIER = "code_verifier";
    public static final String CODE_CHALLENGE = "code_challenge";
    public static final String CODE_CHALLENGE_METHOD = "code_challenge_method";
    public static final String METHOD_PLAIN = "plain";
    public static final String METHOD_S256 = "S256";
    static SecureRandom secureRandom = new SecureRandom();
    public static int byteCount = 48;

    public static String createChallenge(String verifier, String method) {
        switch (method) {
            case "S256": {
                return Base64.encodeBase64URLSafeString((byte[])DigestUtils.sha256((byte[])verifier.getBytes(StandardCharsets.UTF_8)));
            }
            case "plain": {
                return verifier;
            }
        }
        throw new IllegalArgumentException("unknown method type");
    }

    public static String createVerifier() {
        byte[] ba = new byte[byteCount];
        secureRandom.nextBytes(ba);
        return Base64.encodeBase64URLSafeString((byte[])ba);
    }

    public static void main(String[] args) {
        String v = RFC7636Util.createVerifier();
        System.out.println("verifier: " + v);
        System.out.println("challenge: " + RFC7636Util.createChallenge(v, METHOD_S256));
        int[] rawInts = new int[]{116, 24, 223, 180, 151, 153, 224, 37, 79, 250, 96, 125, 216, 173, 187, 186, 22, 212, 37, 77, 105, 214, 191, 240, 91, 88, 5, 88, 83, 132, 141, 121};
        byte[] testBytes = new byte[rawInts.length];
        for (int i = 0; i < rawInts.length; ++i) {
            testBytes[i] = (byte)rawInts[i];
        }
        String testV = Base64.encodeBase64URLSafeString((byte[])testBytes);
        System.out.println("testV: " + testV);
        System.out.println("verifier ok? " + testV.equals("dBjftJeZ4CVP-mB92K27uhbUJU1p1r_wW1gFWFOEjXk"));
        String testCC = RFC7636Util.createChallenge(testV, METHOD_S256);
        System.out.println("testCC:" + testCC);
        System.out.println("challenge ok? " + testCC.equals("E9Melhoa2OwvFrEMTJguCHaoeK1t8URWbuGJSstw-cM"));
    }
}

