/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.server.claims;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.delegation.common.storage.JSONUtil;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;

public class ClaimSourceConfigurationUtil {
    public static final String ID_TAG = "id";
    public static final String NAME_TAG = "name";
    public static final String ENABLED_TAG = "enabled";
    public static final String FAIL_ON_ERROR_TAG = "failOnError";
    public static final String NOTIFY_ON_FAIL_TAG = "notifyOnFail";
    public static final String OMIT_CLAIMS_LIST_TAG = "omitClaimsList";
    JSONUtil jsonUtil = null;

    public String getComponentName() {
        return "default";
    }

    public boolean isInstanceOf(JSONObject jsonObject) {
        return jsonObject.containsKey((Object)this.getComponentName());
    }

    public ClaimSourceConfiguration createConfiguration() {
        return new ClaimSourceConfiguration();
    }

    public ClaimSourceConfiguration getConfiguration(MyLoggingFacade logger, ConfigurationNode node) {
        String omitList;
        ClaimSourceConfiguration config = this.createConfiguration();
        if (node == null) {
            logger.info("No claim source configuration found.");
            config.setEnabled(false);
            return config;
        }
        config.setEnabled(true);
        String x = Configurations.getFirstAttribute((ConfigurationNode)node, (String)ENABLED_TAG);
        if (x != null) {
            try {
                config.setEnabled(Boolean.parseBoolean(x));
            }
            catch (Throwable t) {
                logger.warn("Could not parsed enabled flag value of \"" + x + "\". Assuming configuration is enabled.");
            }
        }
        String name = Configurations.getNodeValue((ConfigurationNode)node, (String)NAME_TAG);
        String id = Configurations.getNodeValue((ConfigurationNode)node, (String)ID_TAG);
        config.setName(name);
        config.setId(id);
        String errs = Configurations.getNodeValue((ConfigurationNode)node, (String)FAIL_ON_ERROR_TAG);
        if (errs != null && errs.length() != 0) {
            config.setFailOnError(Boolean.getBoolean(errs));
        }
        if ((errs = Configurations.getNodeValue((ConfigurationNode)node, (String)NOTIFY_ON_FAIL_TAG)) != null && errs.length() != 0) {
            config.setNotifyOnFail(Boolean.getBoolean(errs));
        }
        if ((omitList = Configurations.getNodeValue((ConfigurationNode)node, (String)OMIT_CLAIMS_LIST_TAG)) != null && !omitList.isEmpty()) {
            JSONArray array = JSONArray.fromObject((Object)omitList);
            config.setOmitList((List<String>)array);
        }
        return config;
    }

    public JSONObject toJSON(ClaimSourceConfiguration config) {
        JSONUtil jsonUtil = this.getJSONUtil();
        JSONObject jsonConfig = new JSONObject();
        JSONObject content = new JSONObject();
        jsonConfig.put((Object)this.getComponentName(), (Object)content);
        jsonUtil.setJSONValue(jsonConfig, ID_TAG, (Object)config.getId());
        jsonUtil.setJSONValue(jsonConfig, NAME_TAG, (Object)config.getName());
        jsonUtil.setJSONValue(jsonConfig, ENABLED_TAG, (Object)config.isEnabled());
        jsonUtil.setJSONValue(jsonConfig, FAIL_ON_ERROR_TAG, (Object)config.isFailOnError());
        jsonUtil.setJSONValue(jsonConfig, NOTIFY_ON_FAIL_TAG, (Object)config.isNotifyOnFail());
        if (config.getOmitList() != null && !config.getOmitList().isEmpty()) {
            JSONArray omitList = null;
            if (config.getOmitList() instanceof JSONArray) {
                jsonUtil.setJSONValue(jsonConfig, OMIT_CLAIMS_LIST_TAG, config.getOmitList());
            } else {
                omitList = new JSONArray();
                omitList.addAll(config.getOmitList());
                jsonUtil.setJSONValue(jsonConfig, OMIT_CLAIMS_LIST_TAG, (Object)omitList);
            }
        }
        return jsonConfig;
    }

    public ClaimSourceConfiguration fromJSON(ClaimSourceConfiguration config, JSONObject json) {
        Object rawOmitList;
        JSONUtil jsonUtil = this.getJSONUtil();
        if (config == null) {
            config = this.createConfiguration();
        }
        config.setId(jsonUtil.getJSONValueString(json, ID_TAG));
        config.setName(jsonUtil.getJSONValueString(json, NAME_TAG));
        config.setEnabled(jsonUtil.getJSONValueBoolean(json, ENABLED_TAG));
        if (jsonUtil.hasKey(json, FAIL_ON_ERROR_TAG)) {
            config.setFailOnError(jsonUtil.getJSONValueBoolean(json, FAIL_ON_ERROR_TAG));
        }
        if (jsonUtil.hasKey(json, NOTIFY_ON_FAIL_TAG)) {
            config.setNotifyOnFail(jsonUtil.getJSONValueBoolean(json, NOTIFY_ON_FAIL_TAG));
        }
        if ((rawOmitList = jsonUtil.getJSONValue(json, OMIT_CLAIMS_LIST_TAG)) == null) {
            config.setOmitList((List<String>)new JSONArray());
        } else {
            JSONArray array = null;
            array = rawOmitList instanceof JSONArray ? (JSONArray)rawOmitList : JSONArray.fromObject((Object)rawOmitList);
            config.setOmitList((List<String>)array);
        }
        config.setProperties((Map<String, Object>)json.getJSONObject(this.getComponentName()));
        return config;
    }

    protected JSONUtil getJSONUtil() {
        if (this.jsonUtil == null) {
            this.jsonUtil = new JSONUtil(this.getComponentName());
        }
        return this.jsonUtil;
    }
}

