/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.server.config;

import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.server.config.JSONClaimSourceConfig;
import org.oa4mp.delegation.server.server.config.LDAPConfigurationUtil;

public class LDAPConfiguration
extends JSONClaimSourceConfig {
    String server;
    int port = -1;
    SSLConfiguration sslConfiguration;
    String searchNameKey;
    String securityPrincipal;
    String searchBase;
    Map<String, LDAPConfigurationUtil.AttributeEntry> searchAttributes = new HashMap<String, LDAPConfigurationUtil.AttributeEntry>();
    String searchFilterAttribute = "uid";
    String password;
    int authType = 0;
    String contextName;
    String searchScope;
    String additionalFilter;

    public LDAPConfiguration() {
        super(null);
    }

    public String getSearchNameKey() {
        return this.searchNameKey;
    }

    public void setSearchNameKey(String searchNameKey) {
        this.searchNameKey = searchNameKey;
    }

    public String getSecurityPrincipal() {
        return this.securityPrincipal;
    }

    public void setSecurityPrincipal(String securityPrincipal) {
        this.securityPrincipal = securityPrincipal;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public Map<String, LDAPConfigurationUtil.AttributeEntry> getSearchAttributes() {
        return this.searchAttributes;
    }

    public void setSearchAttributes(Map<String, LDAPConfigurationUtil.AttributeEntry> searchAttributes) {
        this.searchAttributes = searchAttributes;
    }

    public String getSearchFilterAttribute() {
        return this.searchFilterAttribute;
    }

    public void setSearchFilterAttribute(String searchFilterAttribute) {
        this.searchFilterAttribute = searchFilterAttribute;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public SSLConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public void setSslConfiguration(SSLConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    public int getAuthType() {
        return this.authType;
    }

    public void setAuthType(int authType) {
        this.authType = authType;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LDAPConfiguration)) {
            return false;
        }
        LDAPConfiguration ldap = (LDAPConfiguration)obj;
        if (!BeanUtils.checkEquals((Object)ldap.getContextName(), (Object)this.getContextName())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)ldap.getPassword(), (Object)this.getPassword())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)ldap.getSecurityPrincipal(), (Object)this.getSecurityPrincipal())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)ldap.getSearchBase(), (Object)this.getSearchBase())) {
            return false;
        }
        if (!BeanUtils.checkEquals((Object)ldap.getServer(), (Object)this.getServer())) {
            return false;
        }
        if (ldap.getPort() != this.getPort()) {
            return false;
        }
        if (ldap.getAuthType() != this.getAuthType()) {
            return false;
        }
        return ldap.getSslConfiguration().equals((Object)this.getSslConfiguration());
    }

    public LDAPConfiguration clone() throws CloneNotSupportedException {
        LDAPConfiguration ldap2 = new LDAPConfiguration();
        ldap2.setAuthType(this.getAuthType());
        ldap2.setContextName(this.getContextName());
        ldap2.setEnabled(this.isEnabled());
        ldap2.setFailOnError(this.isFailOnError());
        ldap2.setNotifyOnFail(this.isNotifyOnFail());
        ldap2.setPassword(this.getPassword());
        ldap2.setPort(this.getPort());
        ldap2.setSearchAttributes(this.getSearchAttributes());
        ldap2.setSearchNameKey(this.getSearchNameKey());
        ldap2.setSecurityPrincipal(this.getSecurityPrincipal());
        ldap2.setServer(this.getServer());
        ldap2.setSslConfiguration(this.getSslConfiguration());
        ldap2.setSearchBase(this.getSearchBase());
        ldap2.setSearchFilterAttribute(this.getSearchFilterAttribute());
        ldap2.setAdditionalFilter(this.getAdditionalFilter());
        return ldap2;
    }

    @Override
    public String toString() {
        return "LDAPConfiguration{authType=" + this.authType + ", server='" + this.server + "', port=" + this.port + ", sslConfiguration=" + String.valueOf(this.sslConfiguration) + ", searchNameKey='" + this.searchNameKey + "', securityPrincipal='" + this.securityPrincipal + "', searchBase='" + this.searchBase + "', searchAttributes=" + String.valueOf(this.searchAttributes) + ", enabled=" + this.enabled + ", password='" + this.password + "', contextName='" + this.contextName + "', failOnError=" + this.failOnError + ", notifyOnFail=" + this.notifyOnFail + ", additionalFilter=" + this.additionalFilter + "}";
    }

    public String getSearchScope() {
        return this.searchScope;
    }

    public void setSearchScope(String searchScope) {
        this.searchScope = searchScope;
    }

    public boolean hasSearchScope() {
        return this.searchScope != null && this.searchScope.trim().length() != 0;
    }

    public String getAdditionalFilter() {
        return this.additionalFilter;
    }

    public void setAdditionalFilter(String additionalFilter) {
        this.additionalFilter = additionalFilter;
    }

    @Override
    public void fromJSON(JSONObject json) {
        LDAPConfigurationUtil x = new LDAPConfigurationUtil();
        x.fromJSON(this, json);
    }

    @Override
    public JSONObject toJSON() {
        LDAPConfigurationUtil x = new LDAPConfigurationUtil();
        return x.toJSON(this);
    }

    @Override
    public boolean hasJSONObject() {
        return true;
    }
}

