/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.server.config;

import edu.uiuc.ncsa.security.core.configuration.Configurations;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import edu.uiuc.ncsa.security.util.ssl.SSLConfigurationUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.delegation.common.storage.JSONUtil;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfiguration;
import org.oa4mp.delegation.server.server.claims.ClaimSourceConfigurationUtil;
import org.oa4mp.delegation.server.server.config.LDAPConfiguration;
import org.oa4mp.delegation.server.server.config.SSLConfigurationUtil2;

public class LDAPConfigurationUtil
extends ClaimSourceConfigurationUtil {
    public static final String LDAP_TAG = "ldap";
    public static final String LDAP_PASSWORD_TAG = "password";
    public static final String LDAP_ADDRESS_TAG = "address";
    public static final String LDAP_SEARCH_BASE_TAG = "searchBase";
    public static final String SEARCH_NAME_USERNAME = "username";
    public static final String SEARCH_NAME_KEY = "searchName";
    public static final String SEARCH_FILTER_ATTRIBUTE_KEY = "searchFilterAttribute";
    public static final String SEARCH_FILTER_ATTRIBUTE_DEFAULT = "uid";
    public static final String SEARCH_SCOPE = "searchScope";
    public static final String SEARCH_SCOPE_SUBTREE = "subtree";
    public static final String SEARCH_SCOPE_OBJECT = "object";
    public static final String SEARCH_SCOPE_ONE_LEVEL = "one_level";
    public static final String LDAP_SEARCH_ATTRIBUTES_TAG = "searchAttributes";
    public static final String LDAP_SEARCH_ATTRIBUTE_TAG = "attribute";
    public static final String LDAP_SECURITY_PRINCIPAL_TAG = "principal";
    public static final String LDAP_PORT_TAG = "port";
    public static final String LDAP_CONTEXT_NAME_TAG = "contextName";
    public static final int DEFAULT_PORT = 636;
    public static final String LDAP_AUTH_TYPE = "authorizationType";
    public static final String LDAP_AUTH_NONE = "none";
    public static final int LDAP_AUTH_UNSPECIFIED_KEY = 0;
    public static final int LDAP_AUTH_NONE_KEY = 1;
    public static final String LDAP_AUTH_SIMPLE = "simple";
    public static final int LDAP_AUTH_SIMPLE_KEY = 10;
    public static final String LDAP_AUTH_STRONG = "strong";
    public static final int LDAP_AUTH_STRONG_KEY = 100;
    public static final String RETURN_NAME = "returnName";
    public static final String RETURN_AS_LIST = "returnAsList";
    public static final String IS_GROUP = "isGroup";

    @Override
    public ClaimSourceConfiguration createConfiguration() {
        return new LDAPConfiguration();
    }

    @Override
    public String getComponentName() {
        return LDAP_TAG;
    }

    public LDAPConfiguration getLdapConfiguration(MyLoggingFacade logger, ConfigurationNode node) {
        ConfigurationNode ldapNode = Configurations.getFirstNode((ConfigurationNode)node, (String)LDAP_TAG);
        LDAPConfiguration ldapConfiguration = (LDAPConfiguration)this.getConfiguration(logger, ldapNode);
        logger.info("Starting to load LDAP configuration.");
        if (!ldapConfiguration.isEnabled()) {
            return ldapConfiguration;
        }
        SSLConfiguration sslConfiguration = SSLConfigurationUtil.getSSLConfiguration((MyLoggingFacade)logger, (ConfigurationNode)ldapNode);
        ldapConfiguration.setSslConfiguration(sslConfiguration);
        String tempServer = Configurations.getNodeValue((ConfigurationNode)ldapNode, (String)LDAP_ADDRESS_TAG);
        ldapConfiguration.setServer(Configurations.getNodeValue((ConfigurationNode)ldapNode, (String)LDAP_ADDRESS_TAG));
        String x = Configurations.getNodeValue((ConfigurationNode)ldapNode, (String)LDAP_CONTEXT_NAME_TAG);
        ldapConfiguration.setContextName(x == null ? "" : x);
        String searchNameKey = Configurations.getNodeValue((ConfigurationNode)ldapNode, (String)SEARCH_NAME_KEY);
        if (searchNameKey != null) {
            ldapConfiguration.setSearchNameKey(searchNameKey);
        } else {
            ldapConfiguration.setSearchNameKey(SEARCH_NAME_USERNAME);
        }
        ldapConfiguration.setSecurityPrincipal(Configurations.getNodeValue((ConfigurationNode)ldapNode, (String)LDAP_SECURITY_PRINCIPAL_TAG));
        ConfigurationNode attributeNode = Configurations.getFirstNode((ConfigurationNode)ldapNode, (String)LDAP_SEARCH_ATTRIBUTES_TAG);
        if (attributeNode == null) {
            ldapConfiguration.setSearchAttributes(null);
        } else {
            for (int i = 0; i < attributeNode.getChildrenCount(); ++i) {
                Object kid;
                if (!LDAP_SEARCH_ATTRIBUTE_TAG.equals(attributeNode.getChild(i).getName()) || (kid = attributeNode.getChild(i).getValue()) == null) continue;
                String returnName = Configurations.getFirstAttribute((ConfigurationNode)attributeNode.getChild(i), (String)RETURN_NAME);
                if (returnName == null) {
                    returnName = kid.toString();
                }
                x = Configurations.getFirstAttribute((ConfigurationNode)attributeNode.getChild(i), (String)RETURN_AS_LIST);
                boolean returnAsList = false;
                if (x != null) {
                    try {
                        returnAsList = Boolean.parseBoolean(x);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                x = Configurations.getFirstAttribute((ConfigurationNode)attributeNode.getChild(i), (String)IS_GROUP);
                boolean isGroup = false;
                if (x != null) {
                    try {
                        isGroup = Boolean.parseBoolean(x);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                AttributeEntry attributeEntry = new AttributeEntry(kid.toString(), returnName, returnAsList, isGroup);
                ldapConfiguration.getSearchAttributes().put(attributeEntry.sourceName, attributeEntry);
            }
        }
        ldapConfiguration.setSearchBase(Configurations.getNodeValue((ConfigurationNode)ldapNode, (String)LDAP_SEARCH_BASE_TAG));
        String port = Configurations.getNodeValue((ConfigurationNode)ldapNode, (String)LDAP_PORT_TAG);
        try {
            if (port != null) {
                ldapConfiguration.setPort(Integer.parseInt(port));
            }
        }
        catch (Throwable t) {
            logger.warn("Could not parse port \"" + port + "\" for the LDAP handler. Using default of no port.");
        }
        String searchScope = Configurations.getNodeValue((ConfigurationNode)ldapNode, (String)SEARCH_SCOPE);
        if (!StringUtils.isTrivial((String)searchScope)) {
            ldapConfiguration.setSearchScope(searchScope);
        }
        ldapConfiguration.setPassword(Configurations.getNodeValue((ConfigurationNode)ldapNode, (String)LDAP_PASSWORD_TAG));
        x = Configurations.getFirstAttribute((ConfigurationNode)ldapNode, (String)LDAP_AUTH_TYPE);
        ldapConfiguration.setAuthType(this.getAuthType(x));
        logger.info("LDAP configuration loaded.");
        return ldapConfiguration;
    }

    public String getAuthName(int authType) {
        switch (authType) {
            case 1: {
                return LDAP_AUTH_NONE;
            }
            case 10: {
                return LDAP_AUTH_SIMPLE;
            }
            case 100: {
                return LDAP_AUTH_STRONG;
            }
        }
        return "";
    }

    public int getAuthType(String x) {
        int rc = 0;
        if (x != null) {
            if (x.equals(LDAP_AUTH_NONE)) {
                rc = 1;
            }
            if (x.equals(LDAP_AUTH_SIMPLE)) {
                rc = 10;
            }
            if (x.equals(LDAP_AUTH_STRONG)) {
                rc = 100;
            }
        }
        return rc;
    }

    public JSONArray toJSON(Collection<LDAPConfiguration> configurations) {
        JSONArray ldaps = new JSONArray();
        for (LDAPConfiguration ldap : configurations) {
            ldaps.add((Object)this.toJSON(ldap));
        }
        return ldaps;
    }

    public JSONObject toJSON(LDAPConfiguration configuration) {
        JSONObject ldap = super.toJSON(configuration);
        this.getJSONUtil().setJSONValue(ldap, LDAP_ADDRESS_TAG, (Object)configuration.getServer());
        this.getJSONUtil().setJSONValue(ldap, LDAP_PORT_TAG, (Object)configuration.getPort());
        this.getJSONUtil().setJSONValue(ldap, LDAP_AUTH_TYPE, (Object)configuration.getAuthType());
        if (configuration.getAuthType() == 1) {
            this.getJSONUtil().setJSONValue(ldap, LDAP_AUTH_TYPE, (Object)LDAP_AUTH_NONE);
        }
        if (configuration.getAuthType() == 10) {
            this.getJSONUtil().setJSONValue(ldap, LDAP_AUTH_TYPE, (Object)LDAP_AUTH_SIMPLE);
            this.getJSONUtil().setJSONValue(ldap, LDAP_PASSWORD_TAG, (Object)configuration.getPassword());
            this.getJSONUtil().setJSONValue(ldap, LDAP_SECURITY_PRINCIPAL_TAG, (Object)configuration.getSecurityPrincipal());
        }
        if (configuration.hasSearchScope()) {
            this.getJSONUtil().setJSONValue(ldap, SEARCH_SCOPE, (Object)configuration.getSearchScope());
        }
        JSONArray searchAttributes = new JSONArray();
        for (String key : configuration.getSearchAttributes().keySet()) {
            AttributeEntry ae = configuration.getSearchAttributes().get(key);
            JSONObject entry = new JSONObject();
            entry.put((Object)"name", (Object)ae.sourceName);
            entry.put((Object)RETURN_AS_LIST, (Object)ae.isList);
            entry.put((Object)RETURN_NAME, (Object)ae.targetName);
            if (ae.isGroup) {
                entry.put((Object)IS_GROUP, (Object)ae.isGroup);
            }
            searchAttributes.add((Object)entry);
        }
        this.getJSONUtil().setJSONValue(ldap, LDAP_SEARCH_ATTRIBUTES_TAG, (Object)searchAttributes);
        this.getJSONUtil().setJSONValue(ldap, LDAP_SEARCH_BASE_TAG, (Object)configuration.getSearchBase());
        if (configuration.getSearchNameKey() != null) {
            this.getJSONUtil().setJSONValue(ldap, SEARCH_NAME_KEY, (Object)configuration.getSearchNameKey());
        }
        if (configuration.getSearchFilterAttribute() != null) {
            this.getJSONUtil().setJSONValue(ldap, SEARCH_FILTER_ATTRIBUTE_KEY, (Object)configuration.getSearchFilterAttribute());
        }
        if (configuration.getContextName() == null) {
            this.getJSONUtil().setJSONValue(ldap, LDAP_CONTEXT_NAME_TAG, (Object)"");
        } else {
            this.getJSONUtil().setJSONValue(ldap, LDAP_CONTEXT_NAME_TAG, (Object)configuration.getContextName());
        }
        if (configuration.getSslConfiguration() != null) {
            JSONObject jsonSSL = SSLConfigurationUtil2.toJSON(configuration.getSslConfiguration());
            this.getJSONUtil().setJSONValue(ldap, "ssl", (Object)jsonSSL.getJSONObject("ssl"));
        }
        return ldap;
    }

    public Collection<LDAPConfiguration> fromJSON(JSON json) {
        if (json instanceof JSONArray) {
            return this.fromJSON((JSONArray)json);
        }
        LinkedList<LDAPConfiguration> ldaps = new LinkedList<LDAPConfiguration>();
        if (json instanceof JSONNull) {
            return ldaps;
        }
        ldaps.add(this.fromJSON((JSONObject)json));
        return ldaps;
    }

    public Collection<LDAPConfiguration> fromJSON(JSONArray json) {
        LinkedList<LDAPConfiguration> ldaps = new LinkedList<LDAPConfiguration>();
        for (int i = 0; i < json.size(); ++i) {
            ldaps.add(this.fromJSON(json.getJSONObject(i)));
        }
        return ldaps;
    }

    public boolean isLDAPCOnfig(JSONObject json) {
        return this.isInstanceOf(json);
    }

    @Override
    public LDAPConfiguration fromJSON(ClaimSourceConfiguration claimSourceConfiguration, JSONObject json) {
        super.fromJSON(claimSourceConfiguration, json);
        LDAPConfiguration config = (LDAPConfiguration)claimSourceConfiguration;
        JSONUtil jsonUtil = this.getJSONUtil();
        String contextName = jsonUtil.getJSONValueString(json, LDAP_CONTEXT_NAME_TAG);
        if (contextName == null) {
            config.setContextName("");
        } else {
            config.setContextName(contextName);
        }
        if (json.containsKey((Object)SEARCH_SCOPE)) {
            config.setSearchScope(json.getString(SEARCH_SCOPE));
        }
        String x = jsonUtil.getJSONValueString(json, LDAP_AUTH_TYPE);
        config.setAuthType(this.getAuthType(x));
        config.setServer(jsonUtil.getJSONValueString(json, LDAP_ADDRESS_TAG));
        config.setPort(jsonUtil.getJSONValueInt(json, LDAP_PORT_TAG));
        Object se = jsonUtil.getJSONValue(json, LDAP_SEARCH_ATTRIBUTES_TAG);
        if (se instanceof JSONArray) {
            JSONArray searchAttributes = (JSONArray)se;
            for (int i = 0; i < searchAttributes.size(); ++i) {
                JSONObject current = searchAttributes.getJSONObject(i);
                String name = current.getString("name");
                String targetName = current.getString(RETURN_NAME);
                boolean isList = current.getBoolean(RETURN_AS_LIST);
                boolean isGroup = false;
                if (current.containsKey((Object)IS_GROUP)) {
                    isGroup = current.getBoolean(IS_GROUP);
                }
                AttributeEntry attributeEntry = new AttributeEntry(name, targetName, isList, isGroup);
                config.getSearchAttributes().put(attributeEntry.sourceName, attributeEntry);
            }
            config.setSearchBase(jsonUtil.getJSONValueString(json, LDAP_SEARCH_BASE_TAG));
            config.setSearchNameKey(jsonUtil.getJSONValueString(json, SEARCH_NAME_KEY));
            config.setSecurityPrincipal(jsonUtil.getJSONValueString(json, LDAP_SECURITY_PRINCIPAL_TAG));
            config.setPassword(jsonUtil.getJSONValueString(json, LDAP_PASSWORD_TAG));
            x = jsonUtil.getJSONValueString(json, SEARCH_FILTER_ATTRIBUTE_KEY);
            if (x != null && 0 < x.length()) {
                config.setSearchFilterAttribute(x);
            } else {
                config.setSearchFilterAttribute(SEARCH_FILTER_ATTRIBUTE_DEFAULT);
            }
            JSONObject jsonSSL = new JSONObject();
            jsonSSL.put((Object)"ssl", jsonUtil.getJSONValue(json, "ssl"));
            SSLConfiguration sslConfiguration = SSLConfigurationUtil2.fromJSON(jsonSSL);
            config.setSslConfiguration(sslConfiguration);
        }
        return config;
    }

    public LDAPConfiguration fromJSON(JSONObject json) {
        LDAPConfiguration config = new LDAPConfiguration();
        return this.fromJSON(config, json);
    }

    public static class AttributeEntry
    implements Serializable {
        public String sourceName;
        public String targetName;
        public boolean isList = false;
        public boolean isGroup = false;

        public AttributeEntry(String sourceName, String targetName, boolean isList, boolean isGroup) {
            this.isList = isList;
            this.sourceName = sourceName;
            this.targetName = targetName;
            this.isGroup = isGroup;
        }

        public String toString() {
            return "AttributeEntry[isList=" + this.isList + "isGroup=" + this.isGroup + ", sourceName='" + this.sourceName + "', targetName='" + this.targetName + "']";
        }
    }
}

