/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.delegation.server.server.config;

import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import edu.uiuc.ncsa.security.util.ssl.SSLConfigurationUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.common.storage.JSONUtil;

public class SSLConfigurationUtil2
extends SSLConfigurationUtil {
    static JSONUtil jsonUtil = null;

    public static JSONObject toJSON(SSLConfiguration sslConfiguration) {
        try {
            return SSLConfigurationUtil2.toJSONNEW(sslConfiguration);
        }
        catch (Throwable t) {
            return SSLConfigurationUtil2.toJSONOLD(sslConfiguration);
        }
    }

    protected static JSONObject toJSONNEW(SSLConfiguration sslConfiguration) {
        JSONObject output = new JSONObject();
        JSONObject trustStore = new JSONObject();
        JSONObject keyStore = new JSONObject();
        output.put((Object)"tlsVersion", (Object)sslConfiguration.getTlsVersion());
        if (sslConfiguration.getKeystore() != null) {
            keyStore.put((Object)"path", (Object)sslConfiguration.getKeystore());
        }
        if (sslConfiguration.getKeystoreType() != null) {
            keyStore.put((Object)"type", (Object)sslConfiguration.getKeystoreType());
        }
        if (sslConfiguration.getKeystorePassword() != null) {
            keyStore.put((Object)"password", (Object)sslConfiguration.getKeystorePassword());
        }
        if (!keyStore.isEmpty()) {
            output.put((Object)"keystore", (Object)keyStore);
        }
        trustStore.put((Object)"useJavaTrustStore", (Object)sslConfiguration.isUseDefaultJavaTrustStore());
        trustStore.put((Object)"useStrictHostnames", (Object)sslConfiguration.isStrictHostnames());
        trustStore.put((Object)"useDefaultTrustManager", (Object)sslConfiguration.isUseDefaultTrustManager());
        if (sslConfiguration.getTrustRootPassword() != null) {
            trustStore.put((Object)"password", (Object)sslConfiguration.getTrustRootPassword());
        }
        if (sslConfiguration.getKeystoreType() != null) {
            trustStore.put((Object)"type", (Object)sslConfiguration.getTrustRootType());
        }
        if (sslConfiguration.getTrustrootPath() != null) {
            trustStore.put((Object)"path", (Object)sslConfiguration.getTrustrootPath());
        }
        if (sslConfiguration.getTrustRootCertDN() != null) {
            trustStore.put((Object)"certDN", (Object)sslConfiguration.getTrustRootCertDN());
        }
        output.put((Object)"trustStore", (Object)trustStore);
        return output;
    }

    protected static JSONObject toJSONOLD(SSLConfiguration sslConfiguration) {
        JSONObject ssl = new JSONObject();
        JSONUtil jsonUtil = SSLConfigurationUtil2.getJSONUtil();
        JSONObject content = new JSONObject();
        JSONObject keyStore = new JSONObject();
        content.put((Object)"keystore", (Object)keyStore);
        ssl.put((Object)"ssl", (Object)content);
        jsonUtil.setJSONValue(ssl, "tlsVersion", (Object)sslConfiguration.getTlsVersion());
        jsonUtil.setJSONValue(ssl, "useJavaTrustStore", (Object)sslConfiguration.isUseDefaultJavaTrustStore());
        jsonUtil.setJSONValue(ssl, "password", (Object)sslConfiguration.getKeystorePassword());
        jsonUtil.setJSONValue(ssl, "type", (Object)sslConfiguration.getKeystoreType());
        if (!sslConfiguration.isUseDefaultJavaTrustStore()) {
            byte[] keystore = null;
            try {
                InputStream is = sslConfiguration.getKeystoreIS();
                if (is != null) {
                    int nRead;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] data = new byte[16384];
                    while ((nRead = is.read(data, 0, data.length)) != -1) {
                        baos.write(data, 0, nRead);
                    }
                    baos.flush();
                    keystore = baos.toByteArray();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (keystore != null) {
                jsonUtil.setJSONValue(ssl, "keystore", (Object)Base64.encodeBase64URLSafeString(keystore));
            }
        }
        return ssl;
    }

    public static SSLConfiguration fromJSON(JSONObject json) {
        try {
            return SSLConfigurationUtil2.fromJSONNEW(json);
        }
        catch (Throwable t) {
            return SSLConfigurationUtil2.fromJSONOLD(json);
        }
    }

    public static SSLConfiguration fromJSONNEW(JSONObject json) {
        SSLConfiguration ssl = new SSLConfiguration();
        JSONObject trustStore = json.getJSONObject("trustStore");
        if (!trustStore.isEmpty()) {
            if (trustStore.containsKey((Object)"type")) {
                ssl.setTrustRootType(trustStore.getString("type"));
            }
            if (trustStore.containsKey((Object)"password")) {
                ssl.setTrustRootPassword(trustStore.getString("password"));
            }
            if (trustStore.containsKey((Object)"certDN")) {
                ssl.setTrustRootCertDN(trustStore.getString("certDN"));
            }
            if (trustStore.containsKey((Object)"path")) {
                ssl.setTrustRootPath(trustStore.getString("path"));
            }
            if (trustStore.containsKey((Object)"useJavaTrustStore")) {
                ssl.setUseDefaultJavaTrustStore(trustStore.getBoolean("useJavaTrustStore"));
            }
            if (trustStore.containsKey((Object)"useDefaultTrustManager")) {
                ssl.setUseDefaultTrustManager(trustStore.getBoolean("useDefaultTrustManager"));
            }
            if (trustStore.containsKey((Object)"useStrictHostnames")) {
                ssl.setStrictHostnames(trustStore.getBoolean("useStrictHostnames"));
            }
        }
        if (json.containsKey((Object)"keystore")) {
            JSONObject keystore = json.getJSONObject("keystore");
            if (keystore.containsKey((Object)"type")) {
                ssl.setKeystoreType(keystore.getString("type"));
            }
            if (keystore.containsKey((Object)"password")) {
                ssl.setKeystorePassword(keystore.getString("password"));
            }
            if (keystore.containsKey((Object)"path")) {
                ssl.setKeystore(keystore.getString("path"));
            }
        }
        return ssl;
    }

    public static SSLConfiguration fromJSONOLD(JSONObject json) {
        SSLConfiguration ssl = new SSLConfiguration();
        JSONUtil jsonUtil = SSLConfigurationUtil2.getJSONUtil();
        ssl.setTlsVersion(jsonUtil.getJSONValueString(json, "tlsVersion"));
        ssl.setKeystoreType(jsonUtil.getJSONValueString(json, "type"));
        ssl.setKeystorePassword(jsonUtil.getJSONValueString(json, "password"));
        if (jsonUtil.hasKey(json, "useJavaTrustStore")) {
            ssl.setUseDefaultJavaTrustStore(jsonUtil.getJSONValueBoolean(json, "useJavaTrustStore"));
        } else {
            ssl.setUseDefaultJavaTrustStore(true);
        }
        ssl.setKeystoreBytes(Base64.decodeBase64((String)jsonUtil.getJSONValueString(json, "keystore")));
        if (!ssl.isUseDefaultJavaTrustStore()) {
            ssl.setKeystore(null);
        }
        return ssl;
    }

    public static JSONUtil getJSONUtil() {
        if (jsonUtil == null) {
            jsonUtil = new JSONUtil("ssl");
        }
        return jsonUtil;
    }

    public static void main(String[] args) {
        SSLConfiguration ssl = new SSLConfiguration();
        ssl.setTlsVersion("1.2");
        ssl.setStrictHostnames(true);
        ssl.setKeystore("/path/to/keystore");
        ssl.setKeystorePassword("woof");
        ssl.setKeystoreType("JKS");
        ssl.setTrustRootCertDN("CN=localhost");
        ssl.setTrustRootPassword("arf");
        ssl.setTrustRootPath("/path/to/trustroots");
        ssl.setTrustRootType("JKS");
        ssl.setUseDefaultTrustManager(false);
        ssl.setUseDefaultJavaTrustStore(true);
        System.out.println(SSLConfigurationUtil2.toJSON(ssl).toString(2));
    }
}

