/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.client.loader.OA2ClientEnvironment;
import org.oa4mp.delegation.common.token.Token;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.common.token.impl.TokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenUtils;
import org.oa4mp.server.admin.oauth2.tools.OA2CLCCommands;
import org.oa4mp.server.admin.oauth2.tools.OA2CommandLineClient;
import org.oa4mp.server.qdl.clc.QDLCLC;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.exceptions.MissingArgException;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.extensions.QDLMetaModule;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLList;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.BooleanValue;
import org.qdl_lang.variables.values.QDLKey;
import org.qdl_lang.variables.values.QDLNullValue;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StringValue;

public class CLC
implements QDLMetaModule {
    OA2CLCCommands clcCommands;
    boolean initCalled = false;
    protected String DUMMY_ARG = "dummy";
    protected String INIT_NAME = "init";
    protected String checkInitMessage = "Be sure you have called the " + this.INIT_NAME + " function first or this will fail.";
    protected String CLAIMS_NAME = "claims";
    protected String GRANT_NAME = "grant";
    protected String ACCESS_NAME = "access";
    protected String GET_CERT_NAME = "get_cert";
    protected String CURRENT_URI = "current_uri";
    protected String URI_NAME = "uri";
    protected String REFRESH_NAME = "refresh";
    protected String ECHO_HTTP_RESPONSE = "echo_http_response";
    protected String ECHO_HTTP_REQUEST = "echo_http_request";
    protected String EXCHANGE_NAME = "exchange";
    protected String EXCHANGE_RAW_RESPONSE = "raw_response";
    protected String REVOKE_NAME = "revoke";
    protected String DEVICE_FLOW_NAME = "df";
    protected String INTROSPECT_NAME = "introspect";
    protected String USER_INFO_NAME = "user_info";
    protected String TOKENS_NAME = "tokens";
    protected String WRITE_NAME = "write";
    protected String READ_NAME = "read";
    protected String CLEAR_NAME = "clear_param";
    protected String LOAD_NAME = "load";
    protected String GET_PARAM = "get_param";
    protected String SET_PARAM = "set_param";
    protected String CLEAR_PARAMS = "clear_params";
    protected static final String PARAM_FLAG_AUTHZ = "authz";
    protected static final String PARAM_FLAG_AUTHZ_SHORT = "a";
    protected static final String PARAM_FLAG_TOKEN = "token";
    protected static final String PARAM_FLAG_TOKEN_SHORT = "t";
    protected static final String PARAM_FLAG_REFRESH = "refresh";
    protected static final String PARAM_FLAG_REFRESH_SHORT = "r";
    protected static final String PARAM_FLAG_EXCHANGE = "exchange";
    protected static final String PARAM_FLAG_EXCHANGE_SHORT = "x";
    public static String ACCESS_TOKEN_ACCESSOR = "at";
    public static String REFRESH_TOKEN_ACCESSOR = "rt";
    public static String RFC7523_NAME = "rfc7523";
    public static String VERBOSE_ON = "verbose_on";
    public static String JAVA_TRACE = "java_trace";
    public static String CLIENT_CREDENTIALS_FLOW = "ccf";
    public static String CLIENT_CREDENTIALS_RFC7523 = "rfc7523";

    protected void checkInit() {
        if (this.clcCommands == null || !this.initCalled) {
            throw new IllegalStateException("you must call " + this.INIT_NAME + " before calling this function");
        }
    }

    protected QDLStem getTokens() {
        QDLStem result = new QDLStem();
        StemUtility.put((QDLStem)result, (Object)"access_token", (Object)this.tokenToStem((TokenImpl)this.clcCommands.getDummyAsset().getAccessToken()));
        if (this.clcCommands.getDummyAsset().hasRefreshToken()) {
            StemUtility.put((QDLStem)result, (Object)"refresh_token", (Object)this.tokenToStem((TokenImpl)this.clcCommands.getDummyAsset().getRefreshToken()));
        }
        return result;
    }

    protected void setTokens(QDLStem newTokens) {
        QDLStem at;
        if (newTokens.containsKey((Object)"access_token")) {
            at = newTokens.getStem("access_token");
            this.clcCommands.getDummyAsset().setAccessToken(this.stemToAT(at));
        }
        if (newTokens.containsKey((Object)"refresh_token")) {
            at = newTokens.getStem("refresh_token");
            this.clcCommands.getDummyAsset().setRefreshToken(this.stemToRT(at));
        }
    }

    protected InputLine argsToInputLine(String name, QDLValue[] qdlValues) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(name);
        for (QDLValue ooo : qdlValues) {
            if (!ooo.isString()) continue;
            args.add(ooo.asString().trim());
        }
        String[] strings = new String[]{};
        strings = args.toArray(strings);
        InputLine inputLine = new InputLine(strings);
        return inputLine;
    }

    protected void handleException(Throwable t) {
        if (DebugUtil.isEnabled()) {
            t.printStackTrace();
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new GeneralException(t.getMessage(), t);
    }

    protected QDLStem tokenToStem(TokenImpl token) {
        QDLStem stem = new QDLStem();
        JSONObject json = this.clcCommands.resolveFromToken((Token)token, false);
        StemUtility.put((QDLStem)stem, (Object)"raw_token", (Object)token.getToken());
        if (json == null) {
            if (TokenUtils.isBase32((String)token.getToken())) {
                TokenImpl accessToken2 = new TokenImpl(null);
                accessToken2.decodeToken(token.getToken());
                token = accessToken2;
                StemUtility.put((QDLStem)stem, (Object)"jti", (Object)token.getToken());
            }
            Date expirationDate = token.hasJTI() ? DateUtils.getDate((URI)token.getJti()) : DateUtils.getDate((String)token.getToken());
            expirationDate.setTime(expirationDate.getTime() + token.getLifetime());
            Boolean isExpired = expirationDate.getTime() < System.currentTimeMillis();
            StemUtility.put((QDLStem)stem, (Object)"expired", (Object)isExpired);
            if (!isExpired.booleanValue()) {
                StemUtility.put((QDLStem)stem, (Object)"lifetime", (Object)token.getLifetime());
                StemUtility.put((QDLStem)stem, (Object)"ts", (Object)token.getIssuedAt());
                StemUtility.put((QDLStem)stem, (Object)"expires", (Object)(token.getIssuedAt() + token.getLifetime()));
            }
        } else {
            QDLStem jwt = new QDLStem();
            jwt.fromJSON(json);
            StemUtility.put((QDLStem)stem, (Object)"jwt", (Object)jwt);
            StemUtility.put((QDLStem)stem, (Object)"jti", (Object)jwt.getString("jti"));
            Long expiration = -1L;
            Long timestamp = -1L;
            if (json.containsKey((Object)"iat")) {
                timestamp = json.getLong("iat") * 1000L;
                StemUtility.put((QDLStem)stem, (Object)"ts", (Object)timestamp);
            }
            if (json.containsKey((Object)"exp")) {
                expiration = json.getLong("exp") * 1000L;
                StemUtility.put((QDLStem)stem, (Object)"expires", (Object)expiration);
                StemUtility.put((QDLStem)stem, (Object)"lifetime", (Object)(expiration - timestamp));
            }
            if (0L < expiration && 0L < timestamp) {
                if (System.currentTimeMillis() < expiration) {
                    StemUtility.put((QDLStem)stem, (Object)"expired", (Object)Boolean.FALSE);
                } else {
                    StemUtility.put((QDLStem)stem, (Object)"expired", (Object)Boolean.TRUE);
                }
            }
        }
        return stem;
    }

    protected AccessTokenImpl stemToAT(QDLStem stem) {
        if (stem.containsKey((Object)"raw_token")) {
            return TokenFactory.createAT((String)stem.getString("raw_token"));
        }
        if (stem.containsKey((Object)"jti")) {
            return TokenFactory.createAT((String)stem.getString("jti"));
        }
        throw new IllegalArgumentException("Incorrect access token stem. Cannot create access token");
    }

    protected RefreshTokenImpl stemToRT(QDLStem stem) {
        if (stem.containsKey((Object)"raw_token")) {
            return TokenFactory.createRT((String)stem.getString("raw_token"));
        }
        if (stem.containsKey((Object)"jti")) {
            return TokenFactory.createRT((String)stem.getString("jti"));
        }
        throw new IllegalArgumentException("Incorrect refresh token stem. Cannot create refresh token");
    }

    private static Map argToMap(QDLValue[] objects, String name) {
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        if (objects.length == 1) {
            if (objects[0].isString()) {
                parameters.put("sub", objects[0]);
            } else if (objects[0].isStem()) {
                QDLStem stem = objects[0].asStem();
                for (QDLKey key : stem.keySet()) {
                    QDLValue value = stem.get(key);
                    if (value.isStem()) {
                        QDLStem qdlStem = value.asStem();
                        if (qdlStem.isList()) {
                            JSONArray array = new JSONArray();
                            array.addAll((Collection)QDLValue.castToJavaValues((List)qdlStem.getQDLList()));
                            parameters.put(key.getValue(), array);
                            continue;
                        }
                        parameters.put(key.getValue(), qdlStem.toJSON());
                        continue;
                    }
                    parameters.put(key.getValue(), value.getValue());
                }
            } else {
                throw new IllegalArgumentException("unknown argument type for " + name);
            }
        }
        return parameters;
    }

    public JSONObject serializeToJSON() {
        if (this.clcCommands == null) {
            return new JSONObject();
        }
        try {
            return this.clcCommands.toJSON();
        }
        catch (Exception e) {
            throw new GeneralException((Throwable)e);
        }
    }

    public void deserializeFromJSON(JSONObject jsonObject) {
        try {
            this.clcCommands.fromJSON(jsonObject);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("error loading stored CLC state", t);
        }
    }

    public class ClientCredentialsFlow
    implements QDLFunction {
        public String getName() {
            return CLIENT_CREDENTIALS_FLOW;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            QDLStem inStem;
            CLC.this.checkInit();
            Boolean useRFC7523 = Boolean.FALSE;
            if (0 < objects.length && objects[0].isStem() && (useRFC7523 = Boolean.valueOf((inStem = objects[0].asStem()).containsKey((Object)CLIENT_CREDENTIALS_RFC7523))).booleanValue()) {
                useRFC7523 = inStem.getBoolean(CLIENT_CREDENTIALS_RFC7523);
                inStem.remove(CLIENT_CREDENTIALS_RFC7523);
            }
            Map parameters = CLC.argToMap(objects, this.getName());
            CLC.this.clcCommands.ccf(parameters, useRFC7523.booleanValue());
            QDLStem QDLStem2 = new QDLStem();
            if (CLC.this.clcCommands.getCcfResponse() != null) {
                QDLStem2.fromJSON(CLC.this.clcCommands.getCcfResponse());
            }
            return QDLValue.asQDLValue((Object)QDLStem2);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doxx.add(this.getName() + "() - initiate basic client credentials flow.");
                    break;
                }
                case 1: {
                    String bb = StringUtils.getBlanks((int)this.getName().length());
                    doxx.add(this.getName() + "(username | arg.) - initiate basic client credentials flow, using a subject or arguments.");
                    doxx.add(bb + "If the subject is supplied, it will be used as the subject of the");
                    doxx.add(bb + "ID token.");
                    doxx.add(bb + "If you supply the key " + CLIENT_CREDENTIALS_RFC7523 + " with a true value, then");
                    doxx.add(bb + "RFC7523 credentials are used. If false (default) or omitted, then the standard  id + secret is used.");
                    doxx.add("\nTo send headers, include a stem that has the key __headers");
                }
            }
            doxx.add("This returns the raw response as a JSON object. To get the tokens or claims, use the");
            doxx.add("API calls, e.g. clc#tokens()");
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class JavaTrace
    implements QDLFunction {
        public String getName() {
            return JAVA_TRACE;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            boolean oldValue;
            CLC.this.checkInit();
            boolean bl = oldValue = DebugUtil.isEnabled() && DebugUtil.getDebugLevel() == 1;
            if (objects.length == 0) {
                return QDLValue.asQDLValue((Object)oldValue);
            }
            if (objects[0].isBoolean()) {
                if (objects[0].asBoolean().booleanValue()) {
                    DebugUtil.setEnabled((boolean)true);
                    DebugUtil.setDebugLevel((int)1);
                } else {
                    DebugUtil.setEnabled((boolean)false);
                    DebugUtil.setDebugLevel((int)10);
                }
                return QDLValue.asQDLValue((Object)oldValue);
            }
            throw new BadArgException("unknown argument for " + this.getName() + " of type " + objects[0].getClass().getSimpleName(), 0);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> dd = new ArrayList<String>();
            if (argCount == 0) {
                dd.add(this.getName() + "() = query if java stack trace is on or not");
            }
            if (argCount == 1) {
                dd.add(this.getName() + "(true|false) = toggle java stack traces");
            }
            dd.add("This is used for low-level debugging of Java, such as module development.");
            dd.add("Unless you are a Java developer enabling it might result in out that does not make a lot of sense");
            return dd;
        }
    }

    public class VerboseOn
    implements QDLFunction {
        public String getName() {
            return VERBOSE_ON;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            if (objects.length == 0) {
                return QDLValue.asQDLValue((Object)CLC.this.clcCommands.isVerbose());
            }
            boolean oldValue = CLC.this.clcCommands.isVerbose();
            if (objects[0].isBoolean()) {
                CLC.this.clcCommands.set_verbose_on(new InputLine(objects[0].asBoolean() != false ? "true" : "false"));
                return QDLValue.asQDLValue((Object)oldValue);
            }
            throw new BadArgException("unknown argument for " + this.getName() + " of type " + objects[0].getClass().getSimpleName(), 0);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> dd = new ArrayList<String>();
            if (argCount == 0) {
                dd.add(this.getName() + "() = query if verbose is on or not");
            }
            if (argCount == 1) {
                dd.add(this.getName() + "(true|false) = toggle if verbose is on or not");
            }
            dd.add("verbose refers to printing a great deal of internal information of the workings ");
            dd.add("of the CLC. Use it only if there is an issue that requires it");
            return dd;
        }
    }

    public class RFC7523
    implements QDLFunction {
        public String getName() {
            return RFC7523_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            Map parameters = CLC.argToMap(objects, this.getName());
            CLC.this.clcCommands.rfc7523(parameters);
            return QDLValue.asQDLValue((Object)CLC.this.getTokens());
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> dd = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    dd.add(this.getName() + "() - issue grant request using default, 'username' is the client ID");
                    dd.add("E.g.");
                    dd.add(this.getName() + "()");
                    dd.add("Sends a basic request with no additional parameters. Returns the tokens and claims");
                    break;
                }
                case 1: {
                    dd.add(this.getName() + "(username | arg.) - issue grant request using the username or the entries of arg.");
                    dd.add("   The keys and values of arg. are sent as parameters, so be sure that values are strings.");
                    dd.add("\nE.g. with parameters");
                    dd.add(this.getName() + "('igwn-robot@bigstate.edu')");
                    dd.add("Sends request with the user name (as the subject of the request token). This is used on the");
                    dd.add("service as if the user logged in with the given name, so all e.g. QDL scripts will run against that name.");
                    dd.add("\nE.g. with configuration stem");
                    dd.add(this.getName() + "({'sub':'bob@bigstate.edu','lifetime':1000000})");
                    dd.add("sends the request with the given user name and the parameter (in this case, requesting a certificate lifetime).");
                    dd.add("\nTo send headers, include a stem that has the key __headers");
                    dd.add("E.g. using an admin client to initiate the flow");
                    dd.add("This sets some custom scopes, then starts the flow");
                    dd.add("(load the client whose flow you initiate, get the admin_client. and the kid for the key first)");
                    dd.add("param.'a' := {'scope':'read: write: x.y'};");
                    dd.add("clc#set_param(param.);");
                    dd.add("tokens. := clc#rfc7523({'sub':'jeff','admin_client':admin_client., 'admin_kid':admin_kid});");
                    dd.add("The result is the tokens that you pass back to a client. ");
                    dd.add("In this case, you supply the admin client (as a stem) and the admin's key you want to use");
                    dd.add("for signing. This starts a flow for the current client. Mostly this is to test");
                    dd.add("how this works.");
                    dd.add("In addition to any client-specific parameters (such as the sub, scopes) you need to pass");
                    dd.add("admin_client - the entire admin client as a stem");
                    dd.add("admin_kidthe key id to use");
                }
            }
            return dd;
        }
    }

    public class AccessRT
    implements QDLFunction {
        List<String> dd = null;

        public String getName() {
            return REFRESH_TOKEN_ACCESSOR;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (objects.length == 0) {
                return QDLValue.asQDLValue((Object)CLC.this.tokenToStem((TokenImpl)CLC.this.clcCommands.getDummyAsset().getRefreshToken()));
            }
            if (!objects[0].isStem()) {
                throw new BadArgException("The argument to " + this.getName() + " must be a stem.", 0);
            }
            QDLStem newRT = objects[0].asStem();
            QDLStem oldRT = CLC.this.tokenToStem((TokenImpl)CLC.this.clcCommands.getDummyAsset().getRefreshToken());
            CLC.this.clcCommands.getDummyAsset().setRefreshToken(CLC.this.stemToRT(newRT));
            return QDLValue.asQDLValue((Object)oldRT);
        }

        public List<String> getDocumentation(int argCount) {
            if (this.dd == null) {
                this.dd = new ArrayList<String>();
                this.dd.add(this.getName() + "({new_refresh_token.}) - get or set the current refresh token");
                this.dd.add("If no argument, return the current token or null of none.");
                this.dd.add("Otherwise, the argument is the new refresh token, which is used hencforth. ");
                this.dd.add("if you set the token, the previous one is returned.");
            }
            return this.dd;
        }
    }

    public class AccessAT
    implements QDLFunction {
        List<String> dd = null;

        public String getName() {
            return ACCESS_TOKEN_ACCESSOR;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (objects.length == 0) {
                return QDLValue.asQDLValue((Object)CLC.this.tokenToStem((TokenImpl)CLC.this.clcCommands.getDummyAsset().getAccessToken()));
            }
            if (!objects[0].isStem()) {
                throw new BadArgException("The argument to " + this.getName() + " must be a stem.", 0);
            }
            QDLStem newAT = objects[0].asStem();
            QDLStem oldAT = CLC.this.tokenToStem((TokenImpl)CLC.this.clcCommands.getDummyAsset().getAccessToken());
            CLC.this.clcCommands.getDummyAsset().setAccessToken(CLC.this.stemToAT(newAT));
            return QDLValue.asQDLValue((Object)oldAT);
        }

        public List<String> getDocumentation(int argCount) {
            if (this.dd == null) {
                this.dd = new ArrayList<String>();
                this.dd.add(this.getName() + "({new_access_token.}) - get or set the current access token");
                this.dd.add("If no argument, return the current token or null of none.");
                this.dd.add("Otherwise, the argument is the new access token, which is used hencforth. ");
                this.dd.add("if you set the token, the previous one is returned.");
            }
            return this.dd;
        }
    }

    public class SetParam
    implements QDLFunction {
        List<String> doc = new ArrayList<String>();

        public String getName() {
            return CLC.this.SET_PARAM;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (objects.length != 1) {
                throw new MissingArgException(this.getName() + " requires an argument", null);
            }
            if (!objects[0].isStem()) {
                throw new BadArgException(this.getName() + " requires a stem as its argument", null);
            }
            QDLStem stem = objects[0].asStem();
            for (QDLKey key : stem.keySet()) {
                QDLValue obj;
                HashMap params = null;
                switch (key.toString()) {
                    case "authz": 
                    case "a": {
                        params = CLC.this.clcCommands.getRequestParameters();
                        break;
                    }
                    case "token": 
                    case "t": {
                        params = CLC.this.clcCommands.getTokenParameters();
                        break;
                    }
                    case "refresh": 
                    case "r": {
                        params = CLC.this.clcCommands.getRefreshParameters();
                        break;
                    }
                    case "exchange": 
                    case "x": {
                        params = CLC.this.clcCommands.getExchangeParameters();
                        break;
                    }
                }
                if (params == null || !(obj = stem.get(key)).isStem()) continue;
                QDLStem args = obj.asStem();
                for (QDLKey keyArg : args.keySet()) {
                    params.put(keyArg.asString(), args.get(keyArg).getValue());
                }
            }
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            if (this.doc.isEmpty()) {
                this.doc.add(this.getName() + "(arg.) - set the parameters for this client.");
                this.doc.add("keys are a | authz, e | exchange, t | token, r | refresh");
                this.doc.add("a | authz = authorization");
                this.doc.add("t | token = (access) token)");
                this.doc.add("r | refresh = refresh");
                this.doc.add("x | exchange = exchange");
                this.doc.add("and each consists of a stem of key-value pairs");
                this.doc.add("E.g. set scope and code_challenge_method for the authz leg:");
                this.doc.add("param.'a' := {'scope':'read: write:','code_challenge_method':'256'};");
                this.doc.add(this.getName() + "(param.);");
                this.doc.add("You could also use 'authz' for the key rather than 'a'");
                this.doc.add("See also:" + CLC.this.GET_PARAM);
            }
            return this.doc;
        }
    }

    public class GetParam
    implements QDLFunction {
        List<String> doxx = new ArrayList<String>();

        public String getName() {
            return CLC.this.GET_PARAM;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            QDLStem stem = new QDLStem();
            QDLList qdlList = null;
            boolean isScalar = false;
            if (objects.length == 0) {
                qdlList = new QDLList();
                qdlList.appendAll(QDLValue.castToQDLValueList((Object[])new Object[]{CLC.PARAM_FLAG_AUTHZ_SHORT, CLC.PARAM_FLAG_TOKEN, CLC.PARAM_FLAG_REFRESH, CLC.PARAM_FLAG_EXCHANGE}));
            }
            if (objects.length == 1) {
                if (objects[0].isString()) {
                    isScalar = true;
                    qdlList = new QDLList();
                    qdlList.add(objects[0]);
                } else {
                    if (!objects[0].isStem()) {
                        throw new BadArgException(this.getName() + " requires a stem or list as its argument", null);
                    }
                    qdlList = objects[0].asStem().getQDLList();
                }
            }
            for (QDLValue key : qdlList.values()) {
                HashMap params = null;
                switch (key.toString()) {
                    case "authz": 
                    case "a": {
                        params = CLC.this.clcCommands.getRequestParameters();
                        break;
                    }
                    case "token": 
                    case "t": {
                        params = CLC.this.clcCommands.getTokenParameters();
                        break;
                    }
                    case "refresh": 
                    case "r": {
                        params = CLC.this.clcCommands.getRefreshParameters();
                        break;
                    }
                    case "exchange": 
                    case "x": {
                        params = CLC.this.clcCommands.getExchangeParameters();
                        break;
                    }
                }
                if (params == null) continue;
                QDLStem v = new QDLStem();
                for (String key2 : params.keySet()) {
                    StemUtility.put((QDLStem)v, (Object)key2, params.get(key2));
                }
                if (isScalar) {
                    return QDLValue.asQDLValue((Object)v);
                }
                StemUtility.put((QDLStem)stem, (Object)key.toString(), (Object)v);
            }
            return QDLValue.asQDLValue((Object)stem);
        }

        public List<String> getDocumentation(int argCount) {
            if (this.doxx.isEmpty()) {
                this.doxx.add(this.getName() + "([flag | flags.]) = return the parameters. If no argument, return all parameters as a stem");
                this.doxx.add("Otherwise, the flag or list of flags is");
                this.doxx.add("a | authz = authorization");
                this.doxx.add("t | token = (access) token)");
                this.doxx.add("r | refresh = refresh");
                this.doxx.add("x | exchange = exchange");
                this.doxx.add("");
                this.doxx.add("");
                this.doxx.add("E.g.");
                this.doxx.add(this.getName() + "(authz)");
            }
            return this.doxx;
        }
    }

    public class ClearParam
    implements QDLFunction {
        List<String> doxx = new ArrayList<String>();

        public String getName() {
            return CLC.this.CLEAR_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            if (objects.length == 0) {
                CLC.this.clcCommands.clear(new InputLine(new String[0]), true);
            }
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            if (this.doxx.isEmpty()) {
                this.doxx.add(this.getName() + "() = clear all the state inluding any parameters. ");
                this.doxx.add("You can also recall " + CLC.this.INIT_NAME);
            }
            return this.doxx;
        }
    }

    public class Read
    implements QDLFunction {
        public String getName() {
            return CLC.this.READ_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            if (CLC.this.clcCommands == null) {
                CLIDriver driver = new CLIDriver();
                CLC.this.clcCommands = new OA2CLCCommands(true, driver, (OA2CommandLineClient)new QDLCLC(driver));
            }
            CLC.this.clcCommands.read(CLC.this.argsToInputLine(this.getName(), objects));
            CLC.this.initCalled = true;
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 1: {
                    doxx.add(this.getName() + "(file) - read state previously saved by this client.");
                    break;
                }
                case 2: {
                    doxx.add(this.getName() + "(file, '-p') - provision current client from this saved state (used by ersatz clients).");
                }
            }
            doxx.add("NOTE: If you are going to read a configuration, make sure you initialize it first so that");
            doxx.add("the asset store etc. are all found.");
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class Write
    implements QDLFunction {
        public String getName() {
            return CLC.this.WRITE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            String args = CLC.this.DUMMY_ARG + " " + String.valueOf(objects[0]);
            if (objects.length == 2) {
                args = args + " -m " + String.valueOf(objects[1]);
            }
            CLC.this.checkInit();
            CLC.this.clcCommands.write(new InputLine(args));
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(file [,message]) - write the current state to the file");
            switch (argCount) {
                case 1: {
                    doxx.add(this.getName() + "(file) writes to the file");
                    break;
                }
                case 2: {
                    doxx.add(this.getName() + "(file, message) write to the file and includes the given message");
                }
            }
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class Tokens
    implements QDLFunction {
        public String getName() {
            return CLC.this.TOKENS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            CLC.this.checkInit();
            if (objects.length == 0) {
                return QDLValue.asQDLValue((Object)CLC.this.getTokens());
            }
            if (!objects[0].isStem()) {
                throw new BadArgException("the argument to " + this.getName() + " must be a stem", 0);
            }
            CLC.this.setTokens(objects[0].asStem());
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 0) {
                doxx.add(this.getName() + "() - return the current tokens.");
            }
            if (argCount == 1) {
                doxx.add(this.getName() + "(new_tokens.) - set the current access and refresh tokens");
                doxx.add("Note that the stem has keys access_token and refresh_token and these entries");
                doxx.add("are identical to the values returned by various calls. The output is true if successful.");
            }
            doxx.add("note that " + this.getName() + "(" + this.getName() + ") will set the tokens to the current tokens.");
            doxx.add("so this shows what the argument can be. A common construct is along the lines of");
            doxx.add("E.g.");
            doxx.add("old. := " + this.getName() + "();");
            doxx.add("//// Do a bunch of other stuff, like refreshes, exchanges and invalidate tokens");
            doxx.add(this.getName() + "(old.)");
            doxx.add("Sets the tokens to the value so you can resume your flow with them.");
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class UserInfo
    implements QDLFunction {
        public String getName() {
            return CLC.this.USER_INFO_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            QDLStem out = new QDLStem();
            org.oa4mp.delegation.server.UserInfo userInfo = CLC.this.clcCommands.user_info2(CLC.this.argsToInputLine(this.getName(), objects));
            JSONObject json = new JSONObject();
            json.putAll(userInfo.getMap());
            out.fromJSON(json);
            return QDLValue.asQDLValue((Object)out);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + " return the user info.");
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class Introspect
    implements QDLFunction {
        public String getName() {
            return CLC.this.INTROSPECT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            QDLStem QDLStem2 = new QDLStem();
            CLC.this.clcCommands.introspect(CLC.this.argsToInputLine(this.getName(), objects));
            QDLStem2.fromJSON(CLC.this.clcCommands.getIntrospectResponse());
            return QDLValue.asQDLValue((Object)QDLStem2);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + " introspect on the current token.");
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class DeviceFlow
    implements QDLFunction {
        public String getName() {
            return CLC.this.DEVICE_FLOW_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            QDLStem outStem = new QDLStem();
            QDLStem inStem = new QDLStem();
            if (objects.length == 1) {
                if (!objects[0].isStem()) {
                    throw new BadArgException("If there is an argument, it must be a stem of headers", 0);
                }
                inStem.put("__headers", objects[0]);
            }
            JSONObject json = CLC.this.clcCommands.df((Map)inStem);
            outStem.fromJSON(json);
            return QDLValue.asQDLValue((Object)outStem);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doxx.add(this.getName() + "() - initiate the device flow. If possible, the user code is copied to the clipboard.");
                    break;
                }
                case 1: {
                    doxx.add(this.getName() + "(headers.) - initiate the device flow, setting the headers. If possible, the user code is copied to the clipboard.");
                }
            }
            doxx.add("This returns the raw response from the server");
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class Revoke
    implements QDLFunction {
        public String getName() {
            return CLC.this.REVOKE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            CLC.this.clcCommands.revoke(CLC.this.argsToInputLine(this.getName(), objects));
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            return null;
        }
    }

    public class Exchange
    implements QDLFunction {
        public String getName() {
            return CLC.this.EXCHANGE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            InputLine inputLine;
            CLC.this.checkInit();
            QDLStem inStem = null;
            boolean hasHeaders = false;
            boolean rawResponse = false;
            if (objects.length == 1 && objects[0].isStem()) {
                inStem = objects[0].asStem();
            }
            if (inStem == null) {
                inputLine = CLC.this.argsToInputLine(this.getName(), objects);
                rawResponse = inputLine.hasArg(CLC.this.EXCHANGE_RAW_RESPONSE);
                inputLine.removeSwitch(CLC.this.EXCHANGE_RAW_RESPONSE);
            } else {
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(CLC.PARAM_FLAG_EXCHANGE);
                if (inStem.containsKey((Object)"type")) {
                    args.add("-" + inStem.getString("type"));
                }
                if (inStem.containsKey((Object)"subject")) {
                    args.add("-subject");
                    args.add(inStem.getString("subject"));
                }
                if (inStem.containsKey((Object)CLC.this.EXCHANGE_RAW_RESPONSE)) {
                    rawResponse = inStem.getBoolean(CLC.this.EXCHANGE_RAW_RESPONSE);
                }
                if (inStem.containsKey((Object)"__headers")) {
                    hasHeaders = true;
                    CLC.this.clcCommands.getExchangeParameters().put("__headers", inStem.getStem("__headers"));
                }
                inputLine = new InputLine(args);
            }
            boolean isIDToken = inputLine.hasArg("-id");
            boolean isRefreshToken = inputLine.hasArg("-rt");
            CLC.this.clcCommands.exchange(inputLine);
            if (hasHeaders) {
                CLC.this.clcCommands.getExchangeParameters().remove("__headers");
            }
            if (isIDToken) {
                QDLStem x = new QDLStem();
                x.fromJSON(CLC.this.clcCommands.getIdToken().getPayload());
                return QDLValue.asQDLValue((Object)x);
            }
            if (isRefreshToken) {
                QDLStem x = new QDLStem();
                StemUtility.put((QDLStem)x, (Object)"refresh_token", (Object)CLC.this.tokenToStem((TokenImpl)CLC.this.clcCommands.getDummyAsset().getRefreshToken()));
                return QDLValue.asQDLValue((Object)x);
            }
            if (rawResponse) {
                QDLStem out = new QDLStem();
                out.fromJSON(CLC.this.clcCommands.getExchangeResponse());
                return QDLValue.asQDLValue((Object)out);
            }
            return QDLValue.asQDLValue((Object)CLC.this.getTokens());
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doxx.add(this.getName() + "() - Do the token exchange using the access token as the bearer token.");
                    break;
                }
                case 1: {
                    int width = 15;
                    doxx.add(this.getName() + "(['-rt' | '-at' | 'id'| '-none'] | arg.) - Do the token exchange using the access token as the bearer token and getting back the indicated type.");
                    doxx.add("arg. - a stem for the types, the possible entries are");
                    doxx.add(StringUtils.pad((String)"Key", (int)width) + "Value");
                    doxx.add(StringUtils.pad((String)"subject", (int)width) + "The subject type, at, rt, id");
                    doxx.add(StringUtils.pad((String)"type", (int)width) + "The type of token to return at, rt or id");
                    doxx.add(StringUtils.pad((String)CLC.this.EXCHANGE_RAW_RESPONSE, (int)width) + "returns the raw response from the server, not the tokens");
                    doxx.add(StringUtils.pad((String)"__headers", (int)width) + "a stem of header values.");
                    doxx.add("\nE.g.");
                    doxx.add("exchange({'subject':'at','type','rt')");
                    doxx.add("would do the exchange using the access token as a bearer token to get a refresh token");
                    break;
                }
                default: {
                    doxx.add(this.getName() + "([-rt | -at | '-id' | -none] [-subject at|rt|id] [" + CLC.this.EXCHANGE_RAW_RESPONSE + "] Do the token exchange.");
                    doxx.add("returns: Both tokens, but the requested token is updated.");
                    doxx.add("Arguments:");
                    doxx.add("(None) = exchange the access token using the access token as the bearer token. Make sure it has not expired.");
                    doxx.add(CLC.this.EXCHANGE_RAW_RESPONSE + " = return the raw response from the server, not just the tokens.");
                    doxx.add("-at = explicitly request an access token");
                    doxx.add("-rt = exchange refresh token, using the refresh token as the bearer token");
                    doxx.add("-none = do not request the return type, let the server use its default");
                    doxx.add("-subject = Use the indicated token as the subject. The default is to use the requested type.");
                    doxx.add("\nE.g.");
                    doxx.add("exchange('-at', '-subject', 'rt');");
                    doxx.add("would exchange the access token (possibly expired) using the (valid) refresh token.");
                }
            }
            doxx.add(CLC.this.checkInitMessage);
            doxx.add("\nE.g.");
            return doxx;
        }
    }

    public class EchoHTTPRequest
    implements QDLFunction {
        public String getName() {
            return CLC.this.ECHO_HTTP_REQUEST;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            if (objects.length == 0) {
                return QDLValue.asQDLValue((Object)ServiceClient.ECHO_REQUEST);
            }
            if (!objects[0].isBoolean()) {
                throw new BadArgException(this.getName() + " requires a boolean argument", 0);
            }
            Boolean oldValue = ServiceClient.ECHO_REQUEST;
            ServiceClient.ECHO_REQUEST = objects[0].asBoolean();
            return QDLValue.asQDLValue((Object)oldValue);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doxx.add(this.getName() + "() - query current state of request echoing.");
                    doxx.add("Returns true is enabled, false otherwise.");
                }
                case 1: {
                    doxx.add(this.getName() + "( true | false) - set current state of request echoing.");
                    doxx.add("Returns previous state.");
                }
            }
            doxx.add("Request echoing means that *every* HTTP request to the server is echoed to the command");
            doxx.add("console (not to the GUI output). This is intended to allow very low-level");
            doxx.add("observation of this module. Crafting OAuth requests can be enormously difficult,");
            doxx.add("so if you need to see the traffic, this is invaluable.");
            doxx.add("See also:" + CLC.this.ECHO_HTTP_RESPONSE);
            return doxx;
        }
    }

    public class EchoHttpResponse
    implements QDLFunction {
        public String getName() {
            return CLC.this.ECHO_HTTP_RESPONSE;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            if (objects.length == 0) {
                return QDLValue.asQDLValue((Object)ServiceClient.ECHO_RESPONSE);
            }
            if (!objects[0].isBoolean()) {
                throw new BadArgException(this.getName() + " requires a boolean argument", 0);
            }
            Boolean oldValue = ServiceClient.ECHO_RESPONSE;
            ServiceClient.ECHO_RESPONSE = objects[0].asBoolean();
            return QDLValue.asQDLValue((Object)oldValue);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doxx.add(this.getName() + "() - query current state of response echoing.");
                    doxx.add("Returns true is enabled, false otherwise.");
                }
                case 1: {
                    doxx.add(this.getName() + "( true | false) - set current state of response echoing.");
                    doxx.add("Returns previous state.");
                }
            }
            doxx.add("HTTP response echoing means that *every* HTTP response to the server is echoed to the command");
            doxx.add("console (not to the GUI output). This is intended to allow very low-level");
            doxx.add("observation of this module.");
            doxx.add("See also:" + CLC.this.ECHO_HTTP_REQUEST);
            return doxx;
        }
    }

    public class Refresh
    implements QDLFunction {
        public String getName() {
            return CLC.this.REFRESH_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            CLC.this.clcCommands.refresh();
            return QDLValue.asQDLValue((Object)CLC.this.getTokens());
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + " refresh the tokens.");
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class CreateURI
    implements QDLFunction {
        public String getName() {
            return CLC.this.URI_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            CLC.this.clcCommands.uri(CLC.this.argsToInputLine(this.getName(), objects));
            return QDLValue.asQDLValue((Object)CLC.this.clcCommands.getCurrentURI().toString());
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + " create the uri. This is returned and, if possible, copied to the clipboard.");
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class GetCurrentURI
    implements QDLFunction {
        public String getName() {
            return CLC.this.CURRENT_URI;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            URI c = CLC.this.clcCommands.getCurrentURI();
            if (c == null) {
                return QDLNullValue.getNullValue();
            }
            return QDLValue.asQDLValue((Object)c.toString());
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> d = new ArrayList<String>();
            d.add(this.getName() + "() - get the current URI or null if there is none");
            d.add("You should call " + CLC.this.URI_NAME + " first.");
            return d;
        }
    }

    public class GetCert
    implements QDLFunction {
        List<String> dd = new ArrayList<String>();

        public String getName() {
            return CLC.this.GET_CERT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.clcCommands.get_cert(CLC.this.argsToInputLine(this.getName(), objects));
            if (CLC.this.clcCommands.hasX509Certificates()) {
                return QDLValue.asQDLValue((Object)CLC.this.clcCommands.getX509CertificateString());
            }
            return new StringValue();
        }

        public List<String> getDocumentation(int argCount) {
            if (this.dd.isEmpty()) {
                this.dd.add(this.getName() + "() - get a certificate (chain).");
                this.dd.add("Note that the client must be configured with the correct getcert scope and the");
                this.dd.add("server must support MyProxy.");
            }
            return this.dd;
        }
    }

    public class Access
    implements QDLFunction {
        public String getName() {
            return CLC.this.ACCESS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            CLC.this.checkInit();
            Object args = CLC.this.DUMMY_ARG;
            boolean verify = false;
            boolean rawResponse = false;
            boolean hasHeaders = false;
            if (objects.length == 1 && objects[0].isStem()) {
                QDLStem input = objects[0].asStem();
                if (input.containsKey((Object)"verify")) {
                    verify = input.getBoolean("verify");
                }
                if (input.containsKey((Object)"raw_response")) {
                    rawResponse = input.getBoolean("raw_response");
                }
                if (input.containsKey((Object)"__headers")) {
                    CLC.this.clcCommands.getTokenParameters().put("__headers", input.get("__headers"));
                    hasHeaders = true;
                }
            }
            if (!verify) {
                OA2CLCCommands cfr_ignored_0 = CLC.this.clcCommands;
                args = (String)args + " " + "-no_verify";
            }
            CLC.this.clcCommands.access(new InputLine((String)args));
            if (hasHeaders) {
                CLC.this.clcCommands.getTokenParameters().remove("__headers");
            }
            if (rawResponse) {
                QDLStem out = new QDLStem();
                try {
                    JSONObject jsonObject = JSONObject.fromObject((Object)CLC.this.clcCommands.getCurrentATResponse().getRawResponse());
                    out.fromJSON(jsonObject);
                    return QDLValue.asQDLValue((Object)out);
                }
                catch (Throwable throwable) {
                    return QDLValue.asQDLValue((Object)CLC.this.clcCommands.getCurrentATResponse().getRawResponse());
                }
            }
            return QDLValue.asQDLValue((Object)CLC.this.getTokens());
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doxx.add(this.getName() + "() get the access token, verifying the response. This returns the tokens.");
                    break;
                }
                case 1: {
                    doxx.add(this.getName() + "(arg.) get the access token, using the stem entries to construct the response.");
                    String bb = StringUtils.getBlanks((int)(this.getName().length() + 1));
                    doxx.add("\nThe elements of the arg. stem are:\n");
                    doxx.add("      verify (boolean) - if true (default, verify the tokens");
                    doxx.add("raw_response (boolean) - if false, return the raw response. If true (default) return the actual tokens.");
                    doxx.add("\nTo send headers, include a stem that has the key __headers");
                }
            }
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class Grant
    implements QDLFunction {
        public String getName() {
            return CLC.this.GRANT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            QDLStem g = new QDLStem();
            CLC.this.clcCommands.grant(CLC.this.argsToInputLine(this.getName(), objects));
            if (CLC.this.clcCommands.getGrant() == null) {
                throw new GeneralException("unable to get grant");
            }
            g.fromJSON(CLC.this.clcCommands.getGrant().toJSON());
            return QDLValue.asQDLValue((Object)g);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "([grant]) - set the current grant.");
            if (argCount == 0) {
                doxx.add(this.getName() + "() - set the grant from the clipboard");
            }
            if (argCount == 1) {
                doxx.add(this.getName() + "(grant) - set the grant");
            }
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class GetClaim
    implements QDLFunction {
        public String getName() {
            return CLC.this.CLAIMS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            QDLStem claims = new QDLStem();
            if (CLC.this.clcCommands.getIdToken() == null || CLC.this.clcCommands.getIdToken().getPayload() == null) {
                return QDLValue.asQDLValue((Object)claims);
            }
            JSONObject jsonObject = CLC.this.clcCommands.getIdToken().getPayload();
            claims.fromJSON(jsonObject);
            return QDLValue.asQDLValue((Object)claims);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "() - set the current set of user claims.");
            doxx.add("This is the same information as returned by the " + CLC.this.USER_INFO_NAME + " function.");
            doxx.add(CLC.this.checkInitMessage);
            return doxx;
        }
    }

    public class InitMethod
    implements QDLFunction {
        public String getName() {
            return CLC.this.INIT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            try {
                if (!CLC.this.initCalled) {
                    QDLCLC qdlclc = new QDLCLC(null);
                    OA2CommandLineClient.setInstance((OA2CommandLineClient)qdlclc);
                }
                DebugUtil.setEnabled((boolean)true);
                CLIDriver driver = new CLIDriver();
                CLC.this.clcCommands = new OA2CLCCommands(true, driver, (OA2CommandLineClient)new QDLCLC(driver));
                CLC.this.clcCommands.setThrowExceptions(true);
                InputLine inputLine = new InputLine(CLC.this.DUMMY_ARG + " " + objects[1].toString() + "  " + objects[0].toString());
                CLC.this.clcCommands.load(inputLine);
                CLC.this.initCalled = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
                state.getLogger().error("error initializing client for name=" + String.valueOf(objects[1]) + ", config=" + String.valueOf(objects[0]), e);
                CLC.this.initCalled = false;
                CLC.this.clcCommands = null;
                if (DebugUtil.isEnabled()) {
                    e.printStackTrace();
                }
                throw e;
            }
            return BooleanValue.True;
        }

        protected OA2ClientEnvironment createEnvironment(QDLStem ini, String name) {
            OA2ClientEnvironment ce = new OA2ClientEnvironment();
            JSONArray jsonArray = ini.getStem("scopes").getQDLList().toJSON();
            ce.setScopes((Collection)QDLValue.castToQDLValues((List)jsonArray));
            return ce;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(file, name) - reads the configuration file and then loads the configuration with the given name. ");
            doxx.add("This sets the configuration and name and resets the state completely.");
            doxx.add("This must be called before any other function.");
            return doxx;
        }
    }
}

