/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientConverter;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.extensions.QDLMetaModule;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.BooleanValue;
import org.qdl_lang.variables.values.QDLValue;

public class ClientManagementCommands
implements QDLMetaModule {
    transient MyLoggingFacade logger = null;
    transient ConfigurationNode configurationNode;
    transient OA2SE environment = null;
    boolean initCalled = false;
    protected String INIT_NAME = "init";
    protected String checkInitMessage = "Be sure you have called the " + this.INIT_NAME + " function first or this will fail.";
    protected String READ_NAME = "read";
    protected String SAVE_NAME = "save";
    protected String SEARCH_NAME = "search";
    protected String SIZE_NAME = "size";
    protected String REMOVE_NAME = "remove";
    protected String KEYS_NAME = "keys";
    protected String APPROVE_NAME = "approve";

    public MyLoggingFacade getLogger() {
        return this.logger;
    }

    public void setLogger(MyLoggingFacade logger) {
        this.logger = logger;
    }

    public ConfigurationLoader<? extends AbstractEnvironment> getLoader() {
        return new OA2ConfigurationLoader(this.getConfigurationNode(), this.getLogger());
    }

    public ConfigurationNode getConfigurationNode() {
        return this.configurationNode;
    }

    public void setConfigurationNode(ConfigurationNode configurationNode) {
        this.configurationNode = configurationNode;
    }

    public OA2SE getEnvironment() throws Exception {
        if (this.environment == null) {
            this.environment = (OA2SE)this.getLoader().load();
        }
        return this.environment;
    }

    protected void checkInit() {
        if (!this.initCalled) {
            throw new IllegalStateException(" You must call init before calling this function");
        }
    }

    protected void init(String configFile, String cfgName) throws Throwable {
        this.setConfigurationNode(XMLConfigUtil.findConfiguration((String)configFile, (String)cfgName, (String)"service"));
        this.initCalled = true;
    }

    protected QDLStem toStem(OA2Client client) throws Exception {
        if (client == null) {
            return new QDLStem();
        }
        OA2ClientConverter converter = (OA2ClientConverter)this.getEnvironment().getClientStore().getMapConverter();
        JSONObject jsonObject = new JSONObject();
        converter.toJSON(client, jsonObject);
        QDLStem output = new QDLStem();
        if (jsonObject.isEmpty()) {
            return output;
        }
        JSONObject j2 = jsonObject.getJSONObject("client");
        output.fromJSON(j2);
        return output;
    }

    public JSONObject serializeToJSON() {
        return null;
    }

    public void deserializeFromJSON(JSONObject jsonObject) {
    }

    public class Approve
    implements QDLFunction {
        public String getName() {
            return ClientManagementCommands.this.APPROVE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            ClientManagementCommands.this.checkInit();
            Identifier id = BasicIdentifier.newID((String)objects[0].toString());
            Boolean toApprove = null;
            if (objects.length == 2) {
                if (!objects[1].isBoolean()) {
                    throw new BadArgException("The second argument must be a boolean.", 1);
                }
                toApprove = objects[1].asBoolean();
            }
            Boolean isApproved = ClientManagementCommands.this.getEnvironment().getClientApprovalStore().isApproved(id);
            if (objects.length == 1) {
                return QDLValue.asQDLValue((Object)isApproved);
            }
            ClientApproval approval = new ClientApproval(id);
            approval.setApproved(toApprove.booleanValue());
            if (toApprove.booleanValue()) {
                approval.setStatus(ClientApproval.Status.APPROVED);
            } else if (!isApproved.booleanValue()) {
                approval.setStatus(ClientApproval.Status.REVOKED);
            }
            ClientManagementCommands.this.getEnvironment().getClientApprovalStore().save((Identifiable)approval);
            return QDLValue.asQDLValue((Object)isApproved);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 1: {
                    doxx.add(this.getName() + "(id) -  This will return if the client is approved. ");
                    break;
                }
                case 2: {
                    doxx.add(this.getName() + "(id,true|false) -   Whether to approve or disapprove a client.");
                    doxx.add("NOTE: This returns the *previous* state before the change.");
                }
            }
            doxx.add(ClientManagementCommands.this.checkInitMessage);
            return doxx;
        }
    }

    public class Keys
    implements QDLFunction {
        public String getName() {
            return ClientManagementCommands.this.KEYS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            ClientManagementCommands.this.checkInit();
            OA2ClientConverter cc = null;
            cc = (OA2ClientConverter)ClientManagementCommands.this.getEnvironment().getClientStore().getMapConverter();
            ArrayList x = new ArrayList();
            x.addAll(cc.getKeys().allKeys());
            QDLStem QDLStem2 = new QDLStem();
            QDLStem2.addList(x);
            return QDLValue.asQDLValue((Object)QDLStem2);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "() - list the keys (names of properties) for clients.");
            doxx.add(ClientManagementCommands.this.checkInitMessage);
            return doxx;
        }
    }

    public class Remove
    implements QDLFunction {
        public String getName() {
            return ClientManagementCommands.this.REMOVE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            ClientManagementCommands.this.checkInit();
            Identifier id = BasicIdentifier.newID((String)objects[0].toString());
            ClientManagementCommands.this.getEnvironment().getClientStore().remove((Object)id);
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(id) - remove the client with the given identifier. Returns true if this worked.");
            doxx.add(ClientManagementCommands.this.checkInitMessage);
            return doxx;
        }
    }

    public class Size
    implements QDLFunction {
        public String getName() {
            return ClientManagementCommands.this.SIZE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            ClientManagementCommands.this.checkInit();
            return QDLValue.asQDLValue((Object)ClientManagementCommands.this.getEnvironment().getClientStore().size());
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "() - returns a count of how many clients there are in this store.");
            doxx.add(ClientManagementCommands.this.checkInitMessage);
            return doxx;
        }
    }

    public class Search
    implements QDLFunction {
        public String getName() {
            return ClientManagementCommands.this.SEARCH_NAME;
        }

        public int[] getArgCount() {
            return new int[]{2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            ClientManagementCommands.this.checkInit();
            String key = objects[0].asString();
            String regex = objects[1].asString();
            int index = 0;
            QDLStem output = new QDLStem();
            List clients = ClientManagementCommands.this.getEnvironment().getClientStore().search(key, regex, true);
            for (OA2Client c : clients) {
                StemUtility.put((QDLStem)output, (Object)(index++ + "."), (Object)ClientManagementCommands.this.toStem(c));
            }
            return QDLValue.asQDLValue((Object)output);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(key, regex) -  search for all clients with the given key whose values satisfy the regex.");
            doxx.add("Note especially this returns a bunch of stems, one for each client that is found, so it is equivalent to a multi-read");
            doxx.add(ClientManagementCommands.this.checkInitMessage);
            return doxx;
        }
    }

    public class SaveClient
    implements QDLFunction {
        public String getName() {
            return ClientManagementCommands.this.SAVE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            ClientManagementCommands.this.checkInit();
            if (!objects[0].isStem()) {
                throw new BadArgException("The argument must be a stem variable", 0);
            }
            QDLStem QDLStem2 = objects[0].asStem();
            JSON jj = QDLStem2.toJSON();
            if (jj.isArray()) {
                throw new BadArgException("The client is not in the expected format.", 0);
            }
            JSONObject json = (JSONObject)jj;
            JSONObject output = new JSONObject();
            output.put((Object)"client", (Object)json);
            OA2ClientConverter converter = (OA2ClientConverter)ClientManagementCommands.this.getEnvironment().getClientStore().getMapConverter();
            OA2Client client = converter.fromJSON(output);
            ClientManagementCommands.this.getEnvironment().getClientStore().save((Identifiable)client);
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(client.) - save the client. This returns true if the operation succeeds.");
            doxx.add(ClientManagementCommands.this.checkInitMessage);
            return doxx;
        }
    }

    public class ReadClient
    implements QDLFunction {
        public String getName() {
            return ClientManagementCommands.this.READ_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            ClientManagementCommands.this.checkInit();
            OA2Client client = (OA2Client)ClientManagementCommands.this.getEnvironment().getClientStore().get((Object)BasicIdentifier.newID((String)objects[0].toString()));
            return QDLValue.asQDLValue((Object)ClientManagementCommands.this.toStem(client));
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(id) - read the client with the given identifier. This will return a stem representation of the client. ");
            doxx.add("You may have several active clients at once.");
            doxx.add(ClientManagementCommands.this.checkInitMessage);
            return doxx;
        }
    }

    public class InitMethod
    implements QDLFunction {
        public String getName() {
            return ClientManagementCommands.this.INIT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            ClientManagementCommands.this.init(objects[0].toString(), objects[1].toString());
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(file, name) - reads the configuration file and then loads the configuration with the given name. ");
            doxx.add("This sets the configuration and name. " + ClientManagementCommands.this.READ_NAME + " is used to read a specific client by id and returns a client.");
            doxx.add("This must be called before any other function.");
            return doxx;
        }
    }
}

