/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl;

import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.util.cli.IOInterface;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.qdl.OA2LibLoader2;
import org.qdl_lang.config.QDLEnvironment;
import org.qdl_lang.state.LibLoader;
import org.qdl_lang.workspace.WorkspaceCommands;

public class OA4MPQDLWorkspaceCommands
extends WorkspaceCommands {
    protected List<LibLoader> loaders;

    public OA4MPQDLWorkspaceCommands() {
    }

    public OA4MPQDLWorkspaceCommands(IOInterface ioInterface) {
        super(ioInterface);
    }

    public void loadQE(InputLine inputLine, String cfgName) throws Throwable {
        try {
            super.loadQE(inputLine, cfgName);
        }
        catch (MyConfigurationException mcx) {
            ConfigurationNode node = XMLConfigUtil.findConfiguration((String)inputLine.getNextArgFor("-cfg"), (String)cfgName, (String)"service");
            OA2ConfigurationLoader sourceLoader = new OA2ConfigurationLoader(node);
            OA2SE sourceSE = (OA2SE)sourceLoader.load();
            this.setQdlEnvironment((QDLEnvironment)sourceSE.getQDLEnvironment());
        }
    }

    public WorkspaceCommands newInstance() {
        return new OA4MPQDLWorkspaceCommands();
    }

    public WorkspaceCommands newInstance(IOInterface ioInterface) {
        return new OA4MPQDLWorkspaceCommands(ioInterface);
    }

    public List<LibLoader> getLibLoaders() {
        if (this.loaders == null) {
            this.loaders = new ArrayList<LibLoader>();
            this.loaders.add((LibLoader)new OA2LibLoader2());
        }
        return this.loaders;
    }
}

