/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.clc;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.LoggerProvider;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.inject.Provider;
import net.sf.json.JSONObject;
import org.oa4mp.client.api.storage.AssetStore;
import org.oa4mp.client.api.storage.FSAssetStore;
import org.oa4mp.client.api.storage.MemoryAssetStore;
import org.oa4mp.client.loader.OA2ClientEnvironment;
import org.oa4mp.client.loader.OA2ClientLoaderImpl;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.server.server.config.SSLConfigurationUtil2;
import org.oa4mp.server.qdl.clc.QDLConfigTags;
import org.qdl_lang.exceptions.IndexError;
import org.qdl_lang.parsing.IniParserDriver;
import org.qdl_lang.variables.Constant;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.LongValue;
import org.qdl_lang.variables.values.QDLKey;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StemValue;

public class QDLConfigLoader<T extends OA2ClientEnvironment>
extends OA2ClientLoaderImpl<T>
implements QDLConfigTags {
    QDLStem fullConfig;
    QDLStem config;
    String configName;
    Collection<String> scopes;
    JSONWebKeys jsonWebKeys = null;
    Map<String, List<String>> extendedAttributes = null;
    Provider<AssetStore> assetStoreProvider = null;
    SSLConfiguration sslConfiguration = null;
    String identifier = null;
    String kid = null;
    String secret = null;
    String serviceURI = null;
    String skin = null;
    String wellKnownURI = null;
    URI tokenURI = null;
    URI assetURI = null;
    URI authorizeURI = null;
    URI callback = null;
    URI deviceAuthorizationURI = null;
    URI revocationURI = null;
    URI userInfoURI = null;
    Boolean enableAssetCleanup = null;
    Boolean isOIDC = null;
    Long certLifetime = null;
    URI issuer = null;
    Long maxAssetLiftime = null;
    URI introspectionURI = null;
    HashMap<String, String> constants = null;
    LoggerProvider loggerProvider = null;
    MetaDebugUtil debugger = null;

    public QDLStem getConfig() {
        return this.config;
    }

    public QDLStem getFullConfig() {
        return this.fullConfig;
    }

    public void setFullConfig(QDLStem fullConfig) {
        this.fullConfig = fullConfig;
    }

    protected QDLStem resolveExtends(QDLStem all, QDLStem target) {
        QDLStem ext;
        if (!target.containsKey((Object)"extends")) {
            return target;
        }
        StemValue sValue = new StemValue();
        sValue.fromPath("extends");
        QDLValue obj = target.get((QDLKey)sValue);
        if (obj.isStem()) {
            ext = obj.asStem();
        } else if (obj.isString()) {
            ext = new QDLStem();
            ext.put((QDLKey)LongValue.Zero, obj);
        } else {
            throw new IllegalArgumentException("The extends list must contain only strings");
        }
        if (!ext.isList()) {
            throw new IllegalArgumentException("The extends object must be a list ");
        }
        for (QDLValue value : ext.getQDLList().values()) {
            String name = value.asString();
            sValue = new StemValue();
            sValue.fromPath(name);
            QDLStem y = this.resolveExtends(all, all.get((QDLKey)sValue).asStem());
            target = target.union(new QDLStem[]{y});
        }
        target.remove("extends");
        return target;
    }

    protected QDLStem initialize(QDLStem s, String configName) {
        return this.NEWinitialize(s, configName);
    }

    protected QDLStem NEWinitialize(QDLStem s, String configName) {
        QDLValue obj = null;
        try {
            StemValue sValue = new StemValue();
            sValue.fromPath(configName);
            obj = s.get((QDLKey)sValue);
        }
        catch (IndexError indexError) {
            throw new IllegalArgumentException(configName + " is not an entry");
        }
        if (obj == null) {
            throw new IllegalArgumentException(configName + " is not an entry");
        }
        if (!obj.isStem()) {
            throw new IllegalArgumentException(configName + " must be a stem, but was a " + obj.getClass().getSimpleName());
        }
        return this.resolveExtends(s, obj.asStem());
    }

    public QDLConfigLoader(QDLStem stem, String configName) {
        this.fullConfig = stem;
        this.config = this.initialize(stem, configName);
        this.setConfigName(configName);
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public Collection<String> getScopes() {
        QDLValue qdlValue;
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        if ((qdlValue = this.getConfig().get("scopes")) == null) {
            return this.scopes;
        }
        if (qdlValue.isString()) {
            this.scopes.add(qdlValue.asString());
        } else if (!(this.scopes instanceof QDLStem)) {
            QDLStem ss = qdlValue.asStem();
            for (QDLKey key : ss.keySet()) {
                QDLValue value = ss.get(key);
                if (!value.isString()) continue;
                this.scopes.add(value.asString());
            }
        }
        return this.scopes;
    }

    public JSONWebKeys getKeys() {
        String path;
        if (this.jsonWebKeys == null && (path = this.getConfig().getString("jwks")) != null) {
            JWKUtil2 jwkUtil2 = new JWKUtil2();
            try {
                this.jsonWebKeys = jwkUtil2.fromJSON(new File(path));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("the file '" + path + "' could not be loaded:" + e.getMessage());
            }
        }
        return this.jsonWebKeys;
    }

    public Map<String, List<String>> getAdditionalParameters() {
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new HashMap<String, List<String>>();
            if (this.getConfig().containsKey((Object)"extended_attributes")) {
                QDLStem eas = this.getConfig().getStem("extended_attributes");
                for (QDLKey k : eas.keySet()) {
                    if (!Constant.isString((Object)k)) continue;
                    String key = k.asString();
                    QDLValue obj = eas.get(key);
                    if (obj.isString()) {
                        ArrayList<String> ll = new ArrayList<String>();
                        ll.add(obj.asString());
                        this.extendedAttributes.put(key, ll);
                        continue;
                    }
                    if (!obj.isStem()) continue;
                    QDLStem ea = obj.asStem();
                    this.extendedAttributes.put(key, ea.getQDLList().toStringList());
                }
            }
        }
        return this.extendedAttributes;
    }

    public Provider<AssetStore> getAssetStoreProvider() {
        if (this.assetStoreProvider == null) {
            if (!this.getConfig().containsKey((Object)"assetStore")) {
                MemoryAssetStore memoryAssetStore = new MemoryAssetStore((IdentifiableProvider)this.getAssetProvider());
                this.assetStoreProvider = new StupidAssetStoreProvider<AssetStore>((AssetStore)memoryAssetStore);
            } else {
                QDLStem a = this.getConfig().getStem("assetStore");
                switch (a.getString("type")) {
                    case "fileStore": {
                        this.assetStoreProvider = this.setupFSAssetStore(a);
                        break;
                    }
                    case "memoryStore": {
                        MemoryAssetStore memoryAssetStore = new MemoryAssetStore((IdentifiableProvider)this.getAssetProvider());
                        this.assetStoreProvider = new StupidAssetStoreProvider<AssetStore>((AssetStore)memoryAssetStore);
                    }
                }
            }
        }
        return this.assetStoreProvider;
    }

    protected Provider<AssetStore> setupFSAssetStore(QDLStem conf) {
        boolean removeFailedFiles = false;
        boolean removeEmptyFiles = false;
        if (conf.containsKey((Object)"remove_empty_files")) {
            removeEmptyFiles = conf.getBoolean("remove_empty_files");
        }
        if (conf.containsKey((Object)"remove_failed_files")) {
            removeFailedFiles = conf.getBoolean("remove_failed_files");
        }
        if (!conf.containsKey((Object)"path")) {
            throw new IllegalArgumentException("Missing math for the asset file store");
        }
        String path = conf.getString("path");
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String dataPath = path + "/dataPath";
        String indexPath = path + "/indexPath";
        FSAssetStore store = new FSAssetStore(new File(dataPath), new File(indexPath), (IdentifiableProvider)this.assetProvider, (MapConverter)this.assetConverter, removeEmptyFiles, removeFailedFiles);
        return new StupidAssetStoreProvider<AssetStore>((AssetStore)store);
    }

    public SSLConfiguration getSSLConfiguration() {
        if (this.sslConfiguration == null && this.getConfig().containsKey((Object)"ssl")) {
            QDLStem ssl = this.getConfig().getStem("ssl");
            if (ssl.containsKey((Object)"trust_store")) {
                StemUtility.put((QDLStem)ssl.getStem("trust_store"), (Object)"use_default_trust_manager", (Object)false);
            }
            this.renameSSLkeys(ssl);
            this.sslConfiguration = SSLConfigurationUtil2.fromJSON((JSONObject)((JSONObject)ssl.toJSON()));
        }
        return this.sslConfiguration;
    }

    protected void renameSSLkeys(QDLStem ssl) {
        if (ssl.containsKey((Object)"trust_store")) {
            QDLStem trustStore = ssl.getStem("trust_store");
            QDLStem renameKeys = new QDLStem();
            StemUtility.put((QDLStem)renameKeys, (Object)"type", (Object)"type");
            StemUtility.put((QDLStem)renameKeys, (Object)"path", (Object)"path");
            StemUtility.put((QDLStem)renameKeys, (Object)"cert_dn", (Object)"certDN");
            StemUtility.put((QDLStem)renameKeys, (Object)"password", (Object)"password");
            StemUtility.put((QDLStem)renameKeys, (Object)"use_java", (Object)"useJavaTrustStore");
            StemUtility.put((QDLStem)renameKeys, (Object)"strict_hostnames", (Object)"useStrictHostnames");
            StemUtility.put((QDLStem)renameKeys, (Object)"use_default_trust_manager", (Object)"useDefaultTrustManager");
            trustStore.renameKeys(renameKeys, true);
            renameKeys = new QDLStem();
            StemUtility.put((QDLStem)renameKeys, (Object)"trust_store", (Object)"trustStore");
            ssl.renameKeys(renameKeys, true);
        }
    }

    public String getId() {
        if (this.identifier == null) {
            this.identifier = this.getConfig().getString("id");
        }
        return this.identifier;
    }

    public String getKID() {
        if (this.kid == null) {
            this.kid = this.getConfig().getString("kid");
        }
        return this.kid;
    }

    public String getSecret() {
        if (this.secret == null) {
            this.secret = this.getConfig().getString("secret");
        }
        return this.secret;
    }

    public String getServiceURI() {
        if (this.serviceURI == null) {
            this.serviceURI = this.getEndpoint("service_uri");
            if (this.serviceURI == null) {
                this.serviceURI = this.getWellKnownString("issuer");
                if (this.serviceURI.endsWith("/")) {
                    this.serviceURI = this.serviceURI.substring(0, this.serviceURI.length() - 1);
                }
            }
        }
        return this.serviceURI;
    }

    public String getSkin() {
        if (this.skin == null) {
            this.skin = this.getConfig().getString("skin");
        }
        return this.skin;
    }

    public String getWellKnownURI() {
        if (this.wellKnownURI == null) {
            this.wellKnownURI = this.getEndpoint("well_known");
            if (this.wellKnownURI == null && this.getServiceURI() != null) {
                this.wellKnownURI = this.getServiceURI() + "/.well-known/openid-configuration";
            }
        }
        return this.wellKnownURI;
    }

    public URI getAccessTokenURI() {
        if (this.tokenURI == null) {
            this.tokenURI = this.createServiceURI(this.getEndpoint("token"), "token", "token_endpoint");
        }
        return this.tokenURI;
    }

    public URI getAssetURI() {
        if (this.assetURI == null) {
            this.assetURI = URI.create(this.getServiceURI() + "/getcert");
        }
        return this.assetURI;
    }

    public URI getAuthorizeURI() {
        if (this.authorizeURI == null) {
            this.authorizeURI = this.createServiceURI(this.getEndpoint("authorization"), "authorize", "authorization_endpoint");
        }
        return this.authorizeURI;
    }

    public URI getCallback() {
        String x;
        if (this.callback == null && (x = this.getConfig().getString("callback")) != null) {
            this.callback = URI.create(x);
        }
        return this.callback;
    }

    protected String getEndpoint(String name) {
        if (!this.getConfig().containsKey((Object)"endpoints")) {
            return null;
        }
        return this.getConfig().getStem("endpoints").getString(name);
    }

    public URI getDeviceAuthorizationURI() {
        if (this.deviceAuthorizationURI == null) {
            try {
                this.deviceAuthorizationURI = this.createServiceURI(this.getEndpoint("device"), "device_authorization", "device_authorization_endpoint");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.deviceAuthorizationURI;
    }

    public URI getRFC7009Endpoint() {
        if (this.revocationURI == null) {
            this.revocationURI = this.createServiceURI(this.getEndpoint("revocation"), "revoke", "revocation_endpoint");
        }
        return this.revocationURI;
    }

    public URI getUIURI() {
        if (this.userInfoURI == null) {
            this.userInfoURI = this.createServiceURI(this.getEndpoint("user_info"), "userinfo", "userinfo_endpoint");
        }
        return this.userInfoURI;
    }

    public boolean isEnableAssetCleanup() {
        if (this.enableAssetCleanup == null) {
            this.enableAssetCleanup = this.getConfig().getBoolean("enable_asset_cleanup");
            if (this.enableAssetCleanup == null) {
                this.enableAssetCleanup = false;
            }
        }
        return this.enableAssetCleanup;
    }

    public boolean isOIDCEnabled() {
        if (this.isOIDC == null) {
            this.isOIDC = this.getConfig().getBoolean("enable_oidc");
            if (this.isOIDC == null) {
                this.isOIDC = true;
            }
        }
        return this.isOIDC;
    }

    public long getCertLifetime() {
        if (this.certLifetime == null) {
            this.certLifetime = this.getConfig().getLong("lifetime");
            if (this.certLifetime == null) {
                this.certLifetime = 43200L;
            }
        }
        return this.certLifetime;
    }

    public long getKeypairLifetime() {
        return 0L;
    }

    public URI getIssuer() {
        if (this.issuer == null) {
            this.issuer = this.createServiceURI(this.getEndpoint("issuerUri"), "issuer", "issuer");
        }
        return this.issuer;
    }

    public long getMaxAssetLifetime() {
        if (this.maxAssetLiftime == null) {
            this.maxAssetLiftime = this.getConfig().getLong("asset_lifetime");
            if (this.maxAssetLiftime == null) {
                this.maxAssetLiftime = 2592000000L;
            }
        }
        return this.maxAssetLiftime;
    }

    public URI getRFC7662Endpoint() {
        if (this.introspectionURI == null) {
            this.introspectionURI = this.createServiceURI(this.getEndpoint("introspection"), "introspect", "introspection_endpoint");
        }
        return this.introspectionURI;
    }

    public T load() {
        return this.createInstance();
    }

    public T createInstance() {
        Provider<Client> clientProvider = new Provider<Client>(){

            public Client get() {
                return new Client(BasicIdentifier.newID((String)QDLConfigLoader.this.getId()));
            }
        };
        return (T)new OA2ClientEnvironment(this.getLoggerProvider().get(), this.getConstants(), this.getAccessTokenURI(), this.getAuthorizeURI(), this.getCallback(), this.getAssetURI(), this.getCertLifetime(), this.getId(), this.getSkin(), this.isEnableAssetCleanup(), this.getMaxAssetLifetime(), this.getKeypairLifetime(), this.getAssetProvider(), (Provider)clientProvider, this.tokenForgeProvider, this.getDSP(), this.getAssetStoreProvider(), false, null, null, null, this.getSecret(), this.getKID(), this.getKeys(), this.getScopes(), this.getWellKnownURI(), this.isOIDCEnabled(), false, false, this.getAdditionalParameters(), this.getDeviceAuthorizationURI(), this.getIssuer(), this.getDebugger());
    }

    public HashMap<String, String> getConstants() {
        if (this.constants == null) {
            this.constants = new HashMap();
            this.constants.put("oa4mp:callback_uri", "redirect_uri");
            this.constants.put("oa4mp:token", "code");
            this.constants.put("oa4mp:form_encoding", "application/x-www-form-urlencoded");
            this.constants.put("oa4mp:certreq", "certreq");
            this.constants.put("oa4mp:certlifetime", "certlifetime");
            this.constants.put("oa4mp:client_id", "client_id");
        }
        return this.constants;
    }

    public LoggerProvider getLoggerProvider() {
        if (this.loggerProvider == null) {
            String logFile = null;
            String logName = "oa4mp-clc";
            int fileCount = 2;
            int maxFileSize = 100000;
            boolean disableLog4J = true;
            boolean appendOn = false;
            Level level = Level.WARNING;
            QDLStem cfg = this.getConfig().getStem("logging");
            if (cfg != null) {
                if (cfg.containsKey((Object)"file")) {
                    logFile = cfg.getString("file");
                }
                if (cfg.containsKey((Object)"name")) {
                    logName = cfg.getString("name");
                }
                if (cfg.containsKey((Object)"max_size")) {
                    maxFileSize = cfg.getLong("max_size").intValue();
                }
                if (cfg.containsKey((Object)"count")) {
                    fileCount = cfg.getLong("count").intValue();
                }
                if (cfg.containsKey((Object)"disable_log4j")) {
                    disableLog4J = cfg.getBoolean("disable_log4j");
                }
                if (cfg.containsKey((Object)"append_on")) {
                    appendOn = cfg.getBoolean("append_on");
                }
            }
            this.loggerProvider = new LoggerProvider(logFile, logName, fileCount, maxFileSize, disableLog4J, appendOn, level);
        }
        return this.loggerProvider;
    }

    public MetaDebugUtil getDebugger() {
        if (this.debugger == null) {
            this.debugger = this.getDebugger(this.getConfig().getString("debug_level"));
        }
        return this.debugger;
    }

    public static void main(String[] args) throws Throwable {
        String clientFile = "/home/ncsa/dev/csd/config/auto-test/clients.ini";
        String cfgName = "oauth.conf.basic";
        IniParserDriver iniParserDriver = new IniParserDriver();
        FileReader fileReader = new FileReader(clientFile);
        QDLStem out = iniParserDriver.parse((Reader)fileReader, true);
        QDLConfigLoader loader = new QDLConfigLoader(out, cfgName);
        Object ce = loader.load();
    }

    public static class StupidAssetStoreProvider<T extends AssetStore>
    implements Provider<T>,
    Serializable {
        AssetStore assetStore;

        public StupidAssetStoreProvider(AssetStore assetStore) {
            this.assetStore = assetStore;
        }

        public T get() {
            return (T)this.assetStore;
        }
    }
}

