/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.net.URI;
import java.util.Collection;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientKeys;
import org.oa4mp.server.qdl.storage.StemConverter;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;

public class AdminClientStemMC<V extends AdminClient>
extends StemConverter<V> {
    public AdminClientStemMC(MapConverter<V> mapConverter) {
        super(mapConverter);
    }

    AdminClientKeys kk() {
        return (AdminClientKeys)this.keys;
    }

    @Override
    public V fromMap(QDLStem stem, V v) {
        v = (AdminClient)super.fromMap(stem, v);
        if (stem.containsKey((Object)this.kk().creationTS(new String[0]))) {
            v.setCreationTS(this.toDate(stem, this.kk().creationTS(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().initializeFlows(new String[0]))) {
            v.setInitializeFlows(stem.getBoolean(this.kk().initializeFlows(new String[0])).booleanValue());
        }
        if (this.isStringKeyOK(stem, this.kk().email(new String[0]))) {
            v.setEmail(stem.getString(this.kk().email(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().debugOn(new String[0]))) {
            v.setDebugOn(stem.getBoolean(this.kk().debugOn(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().lastModifiedTS(new String[0]))) {
            v.setLastModifiedTS(this.toDate(stem, this.kk().lastModifiedTS(new String[0])));
        }
        if (this.isStringKeyOK(stem, this.kk().name(new String[0]))) {
            v.setName(stem.getString(this.kk().name(new String[0])));
        }
        if (this.isStringKeyOK(stem, this.kk().secret(new String[0]))) {
            v.setSecret(stem.getString(this.kk().secret(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().rfc7523Client(new String[0]))) {
            v.setServiceClient(stem.getBoolean(this.kk().rfc7523Client(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().rfc7523ClientUsers(new String[0]))) {
            v.setServiceClientUsers((Collection)this.toList(stem, this.kk().rfc7523ClientUsers(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().jwksURI(new String[0]))) {
            v.setJwksURI(URI.create(stem.getString(this.kk().jwksURI(new String[0]))));
        }
        if (stem.containsKey((Object)this.kk().jwks(new String[0]))) {
            try {
                JSONWebKeys jwks = JSONWebKeyUtil.fromJSON((JSON)stem.getStem(this.kk().jwks(new String[0])).toJSON());
                v.setJWKS(jwks);
            }
            catch (Throwable e) {
                if (DebugUtil.isEnabled()) {
                    e.printStackTrace();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new GeneralException("could not convert to JSON web key.", e);
            }
        }
        if (stem.containsKey((Object)this.kk().allowQDL(new String[0]))) {
            v.setAllowQDL(stem.getBoolean(this.kk().allowQDL(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().allowQDLCodeBlocks(new String[0]))) {
            v.setAllowQDLCodeBlocks(stem.getBoolean(this.kk().allowQDLCodeBlocks(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().listUsers(new String[0]))) {
            v.setListUsers(stem.getBoolean(this.kk().listUsers(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().listUsersInOtherClients(new String[0]))) {
            v.setListUsersInOtherClients(stem.getBoolean(this.kk().listUsersInOtherClients(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().allowCustomIDs(new String[0]))) {
            v.setAllowCustomIDs(stem.getBoolean(this.kk().allowCustomIDs(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().useTimestampsInIds(new String[0]))) {
            v.setUseTimestampInIDs(stem.getBoolean(this.kk().useTimestampsInIds(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().generateIDs(new String[0]))) {
            v.setGenerateIDs(stem.getBoolean(this.kk().generateIDs(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().idHead(new String[0]))) {
            v.setIdHead(URI.create(stem.getString(this.kk().idHead(new String[0]))));
        }
        if (this.isStringKeyOK(stem, this.kk().config(new String[0]))) {
            v.setConfig(JSONObject.fromObject((Object)stem.getString(this.kk().config(new String[0]))));
        }
        if (stem.containsKey((Object)this.kk().config(new String[0]))) {
            v.setConfig(JSONObject.fromObject((Object)stem.getString(this.kk().config(new String[0]))));
        }
        if (this.isStringKeyOK(stem, this.kk().issuer(new String[0]))) {
            v.setIssuer(stem.getString(this.kk().issuer(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().maxClients(new String[0]))) {
            v.setMaxClients(stem.getLong(this.kk().maxClients(new String[0])).intValue());
        }
        if (this.isStringKeyOK(stem, this.kk().vo(new String[0]))) {
            v.setVirtualIssuer(BasicIdentifier.newID((String)stem.getString(this.kk().voURI(new String[0]))));
        }
        if (this.isStringKeyOK(stem, this.kk().voURI(new String[0]))) {
            v.setExternalVIName(stem.getString(this.kk().voURI(new String[0])));
        }
        return v;
    }

    @Override
    public QDLStem toMap(V v, QDLStem stem) {
        stem = super.toMap(v, stem);
        this.setNonNullStemValue(stem, this.kk().creationTS(new String[0]), v.getCreationTS().getTime());
        this.setNonNullStemValue(stem, this.kk().email(new String[0]), v.getEmail());
        StemUtility.put((QDLStem)stem, (Object)this.kk().debugOn(new String[0]), (Object)v.isDebugOn());
        this.setNonNullStemValue(stem, this.kk().lastModifiedTS(new String[0]), v.getLastModifiedTS().getTime());
        this.setNonNullStemValue(stem, this.kk().name(new String[0]), v.getName());
        this.setNonNullStemValue(stem, this.kk().secret(new String[0]), v.getSecret());
        StemUtility.put((QDLStem)stem, (Object)this.kk().allowQDL(new String[0]), (Object)v.isAllowQDL());
        StemUtility.put((QDLStem)stem, (Object)this.kk().initializeFlows(new String[0]), (Object)v.canInitializeFlows());
        StemUtility.put((QDLStem)stem, (Object)this.kk().generateIDs(new String[0]), (Object)v.isGenerateIDs());
        StemUtility.put((QDLStem)stem, (Object)this.kk().useTimestampsInIds(new String[0]), (Object)v.isUseTimestampInIDs());
        StemUtility.put((QDLStem)stem, (Object)this.kk().allowCustomIDs(new String[0]), (Object)v.isAllowCustomIDs());
        if (v.getIdHead() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().idHead(new String[0]), (Object)v.getIdHead().toString());
        }
        StemUtility.put((QDLStem)stem, (Object)this.kk().listUsers(new String[0]), (Object)v.isListUsers());
        StemUtility.put((QDLStem)stem, (Object)this.kk().listUsersInOtherClients(new String[0]), (Object)v.isListUsersInOtherClients());
        if (v.getConfig() != null) {
            this.setNonNullStemValue(stem, this.kk().config(new String[0]), v.getConfig().toString());
        }
        this.setNonNullStemValue(stem, this.kk().issuer(new String[0]), v.getIssuer());
        StemUtility.put((QDLStem)stem, (Object)this.kk().maxClients(new String[0]), (Object)v.getMaxClients());
        this.setNonNullStemValue(stem, this.kk().allowQDLCodeBlocks(new String[0]), v.allowQDLCodeBlocks());
        if (v.getVirtualIssuer() != null) {
            this.setNonNullStemValue(stem, this.kk().voURI(new String[0]), v.getVirtualIssuer().toString());
        }
        if (v.getJwksURI() != null) {
            this.setNonNullStemValue(stem, this.kk().jwksURI(new String[0]), v.getJwksURI().toString());
        }
        if (v.hasJWKS()) {
            QDLStem ss = new QDLStem();
            ss.fromJSON(JSONWebKeyUtil.toJSON((JSONWebKeys)v.getJWKS()));
            this.setNonNullStemValue(stem, this.kk().jwks(new String[0]), ss);
        }
        this.setNonNullStemValue(stem, this.kk().rfc7523Client(new String[0]), v.isServiceClient());
        this.fromList(v.getServiceClientUsers(), stem, this.kk().rfc7523ClientUsers(new String[0]));
        this.setNonNullStemValue(stem, this.kk().vo(new String[0]), v.getExternalVIName());
        return stem;
    }
}

