/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import org.oa4mp.delegation.common.storage.clients.ClientApprovalKeys;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.qdl.storage.StemConverter;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;

public class ApprovalStemMC<V extends ClientApproval>
extends StemConverter<V> {
    public ApprovalStemMC(MapConverter<V> mapConverter) {
        super(mapConverter);
    }

    ClientApprovalKeys kk() {
        return (ClientApprovalKeys)this.keys;
    }

    @Override
    public V fromMap(QDLStem stem, V v) {
        v = (ClientApproval)super.fromMap(stem, v);
        if (stem.containsKey((Object)this.kk().approved(new String[0]))) {
            v.setApproved(stem.getBoolean(this.kk().approved(new String[0])).booleanValue());
        }
        if (this.isTimeOk(stem, this.kk().approvalTS(new String[0]))) {
            v.setApprovalTimestamp(this.toDate(stem, this.kk().approvalTS(new String[0])));
        }
        if (this.isStringKeyOK(stem, this.kk().status(new String[0]))) {
            ClientApproval.Status status1 = ClientApproval.Status.resolveByStatusValue((String)stem.getString(this.kk().status(new String[0])));
            v.setStatus(status1);
        } else {
            v.setStatus(ClientApproval.Status.NONE);
        }
        if (this.isStringKeyOK(stem, this.kk().approver(new String[0]))) {
            v.setApprover(stem.getString(this.kk().approver(new String[0])));
        }
        return v;
    }

    @Override
    public QDLStem toMap(V v, QDLStem stem) {
        stem = super.toMap(v, stem);
        if (v.getStatus() == null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().status(new String[0]), (Object)ClientApproval.Status.NONE.getStatus());
        } else {
            StemUtility.put((QDLStem)stem, (Object)this.kk().status(new String[0]), (Object)v.getStatus().getStatus());
        }
        if (v.getApprovalTimestamp() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().approvalTS(new String[0]), (Object)v.getApprovalTimestamp().getTime());
        }
        if (!StringUtils.isTrivial((String)v.getApprover())) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().approver(new String[0]), (Object)v.getApprover());
        }
        StemUtility.put((QDLStem)stem, (Object)this.kk().approved(new String[0]), (Object)v.isApproved());
        return stem;
    }
}

