/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientConverter;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;
import org.oa4mp.server.qdl.storage.StemConverter;
import org.qdl_lang.variables.QDLList;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StringValue;

public class ClientStemMC<V extends OA2Client>
extends StemConverter<V> {
    public ClientStemMC(MapConverter<V> mapConverter) {
        super(mapConverter);
    }

    @Override
    public V fromMap(QDLStem stem, V v) {
        QDLStem j;
        v = (OA2Client)super.fromMap(stem, v);
        if (this.isTimeOk(stem, this.kk().creationTS(new String[0]))) {
            v.setCreationTS(this.toDate(stem, this.kk().creationTS(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().ersatzInheritIDToken(new String[0]))) {
            v.setErsatzInheritIDToken(stem.getBoolean(this.kk().ersatzInheritIDToken(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().debugOn(new String[0]))) {
            v.setDebugOn(stem.getBoolean(this.kk().debugOn(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().forwardScopesToProxy(new String[0]))) {
            v.setForwardScopesToProxy(stem.getBoolean(this.kk().forwardScopesToProxy(new String[0])).booleanValue());
        }
        if (this.isStringKeyOK(stem, this.kk().email(new String[0]))) {
            v.setEmail(stem.getString(this.kk().email(new String[0])));
        }
        if (this.isStringKeyOK(stem, this.kk().errorURL(new String[0]))) {
            v.setErrorUri(stem.getString(this.kk().errorURL(new String[0])));
        }
        if (this.isStringKeyOK(stem, this.kk().homeURL(new String[0]))) {
            v.setHomeUri(stem.getString(this.kk().homeURL(new String[0])));
        }
        if (this.isTimeOk(stem, this.kk().lastModifiedTS(new String[0]))) {
            v.setLastModifiedTS(this.toDate(stem, this.kk().lastModifiedTS(new String[0])));
        }
        if (this.isStringKeyOK(stem, this.kk().name(new String[0]))) {
            v.setName(stem.getString(this.kk().name(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().proxyLimited(new String[0]))) {
            v.setProxyLimited(stem.getBoolean(this.kk().proxyLimited(new String[0])).booleanValue());
        }
        if (this.isStringKeyOK(stem, this.kk().secret(new String[0]))) {
            v.setSecret(stem.getString(this.kk().secret(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().rfc7523Client(new String[0]))) {
            v.setServiceClient(stem.getBoolean(this.kk().rfc7523Client(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().rfc7523ClientUsers(new String[0]))) {
            v.setServiceClientUsers((Collection)this.toList(stem, this.kk().rfc7523ClientUsers(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().jwksURI(new String[0]))) {
            v.setJwksURI(URI.create(stem.getString(this.kk().proxyClaimsList(new String[0]))));
        }
        if (stem.containsKey((Object)this.kk().jwks(new String[0]))) {
            try {
                JSONWebKeys jwks = JSONWebKeyUtil.fromJSON((JSON)stem.getStem(this.kk().jwks(new String[0])).toJSON());
                v.setJWKS(jwks);
            }
            catch (Throwable e) {
                if (DebugUtil.isEnabled()) {
                    e.printStackTrace();
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new GeneralException("could not convert to JSON web key.", e);
            }
        }
        if (stem.containsKey((Object)this.kk().atLifetime(new String[0]))) {
            v.setAtLifetime(stem.getLong(this.kk().atLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().audience(new String[0]))) {
            v.setAudience((Collection)this.toList(stem, this.kk().audience(new String[0])));
            v.setAudience((Collection)this.toList(stem, this.kk().audience(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().callbackUri(new String[0]))) {
            v.setCallbackURIs((Collection)this.toList(stem, this.kk().callbackUri(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().cfg(new String[0]))) {
            j = stem.get(this.kk().cfg(new String[0])).asStem();
            v.setConfig((JSONObject)j.toJSON());
        }
        if (stem.containsKey((Object)this.kk().dfInterval(new String[0]))) {
            v.setDfInterval(stem.getLong(this.kk().dfInterval(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().rtGracePeriod(new String[0]))) {
            v.setRtGracePeriod(stem.getLong(this.kk().rtGracePeriod(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().dfLifetime(new String[0]))) {
            v.setDfLifetime(stem.getLong(this.kk().dfLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().ersatzClient(new String[0]))) {
            v.setErsatzClient(stem.getBoolean(this.kk().ersatzClient(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().ea(new String[0]))) {
            j = stem.get(this.kk().ea(new String[0])).asStem();
            v.setExtendedAttributes((JSONObject)j.toJSON());
        }
        if (this.isStringKeyOK(stem, this.kk().issuer(new String[0]))) {
            v.setIssuer(stem.getString(this.kk().issuer(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().ldap(new String[0])) && stem.get(this.kk().ldap(new String[0])).isStem()) {
            QDLStem ldap = stem.get(this.kk().ldap(new String[0])).asStem();
            JSONArray array = (JSONArray)ldap.toJSON();
            v.setLdaps(this.getCC().getLdapConfigurationUtil().fromJSON(array));
        }
        if (stem.containsKey((Object)this.kk().extendsProvisioners(new String[0]))) {
            v.setExtendsProvisioners(stem.getBoolean(this.kk().extendsProvisioners(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().prototypes(new String[0]))) {
            ArrayList<Identifier> ids = new ArrayList<Identifier>();
            List list = this.toList(stem, this.kk().prototypes(new String[0]));
            for (Object obj : list) {
                if (!(obj instanceof String)) continue;
                ids.add(BasicIdentifier.newID((String)((String)obj)));
            }
            if (!ids.isEmpty()) {
                v.setPrototypes(ids);
            }
        }
        if (stem.containsKey((Object)this.kk().proxyClaimsList(new String[0]))) {
            v.setProxyClaimsList((Collection)this.toList(stem, this.kk().proxyClaimsList(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().proxyRequestScopes(new String[0]))) {
            v.setProxyRequestScopes((Collection)this.toList(stem, this.kk().proxyRequestScopes(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().publicClient(new String[0]))) {
            v.setPublicClient(stem.getBoolean(this.kk().publicClient(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().resource(new String[0]))) {
            v.setResource(this.toList(stem, this.kk().resource(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().rtLifetime(new String[0]))) {
            v.setRtLifetime(stem.getLong(this.kk().rtLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().idtLifetime(new String[0]))) {
            v.setIdTokenLifetime(stem.getLong(this.kk().idtLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().maxIDTLifetime(new String[0]))) {
            v.setMaxIDTLifetime(stem.getLong(this.kk().maxIDTLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().maxATLifetime(new String[0]))) {
            v.setMaxATLifetime(stem.getLong(this.kk().maxATLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().maxRTLifetime(new String[0]))) {
            v.setMaxRTLifetime(stem.getLong(this.kk().maxRTLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().scopes(new String[0]))) {
            v.setScopes((Collection)this.toList(stem, this.kk().scopes(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().signTokens(new String[0]))) {
            v.setSignTokens(stem.getBoolean(this.kk().signTokens(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().skipServerScripts(new String[0]))) {
            v.setSkipServerScripts(stem.getBoolean(this.kk().skipServerScripts(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().strictScopes(new String[0]))) {
            v.setStrictscopes(stem.getBoolean(this.kk().strictScopes(new String[0])).booleanValue());
        }
        return v;
    }

    protected OA2ClientKeys kk() {
        return (OA2ClientKeys)this.keys;
    }

    @Override
    public QDLStem toMap(V v, QDLStem stem) {
        stem = super.toMap(v, stem);
        this.setNonNullStemValue(stem, this.kk().secret(new String[0]), v.getSecret());
        this.setNonNullStemValue(stem, this.kk().debugOn(new String[0]), v.isDebugOn());
        this.setNonNullStemValue(stem, this.kk().forwardScopesToProxy(new String[0]), v.isForwardScopesToProxy());
        this.setNonNullStemValue(stem, this.kk().email(new String[0]), v.getEmail());
        this.setNonNullStemValue(stem, this.kk().name(new String[0]), v.getName());
        this.setNonNullStemValue(stem, this.kk().creationTS(new String[0]), v.getCreationTS().getTime());
        if (v.getJwksURI() != null) {
            this.setNonNullStemValue(stem, this.kk().jwksURI(new String[0]), v.getJwksURI().toString());
        }
        if (v.hasJWKS()) {
            QDLStem ss = new QDLStem();
            ss.fromJSON(JSONWebKeyUtil.toJSON((JSONWebKeys)v.getJWKS()));
            this.setNonNullStemValue(stem, this.kk().jwks(new String[0]), ss);
        }
        this.setNonNullStemValue(stem, this.kk().lastModifiedTS(new String[0]), v.getLastModifiedTS().getTime());
        this.setNonNullStemValue(stem, this.kk().homeURL(new String[0]), v.getHomeUri());
        this.setNonNullStemValue(stem, this.kk().errorURL(new String[0]), v.getErrorUri());
        this.setNonNullStemValue(stem, this.kk().proxyLimited(new String[0]), v.isProxyLimited());
        this.setNonNullStemValue(stem, this.kk().rfc7523Client(new String[0]), v.isServiceClient());
        this.fromList(v.getServiceClientUsers(), stem, this.kk().rfc7523ClientUsers(new String[0]));
        this.setNonNullStemValue(stem, this.kk().extendsProvisioners(new String[0]), v.isExtendsProvisioners());
        this.setNonNullStemValue(stem, this.kk().atLifetime(new String[0]), v.getAtLifetime());
        this.setNonNullStemValue(stem, this.kk().idtLifetime(new String[0]), v.getIdTokenLifetime());
        if (v.getAudience() != null && !v.getAudience().isEmpty()) {
            this.fromList(v.getAudience(), stem, this.kk().audience(new String[0]));
        }
        if (v.getCallbackURIs() != null && !v.getCallbackURIs().isEmpty()) {
            this.fromList(v.getCallbackURIs(), stem, this.kk().callbackUri(new String[0]));
        }
        if (v.getProxyClaimsList() != null && !v.getProxyClaimsList().isEmpty()) {
            this.fromList(v.getProxyClaimsList(), stem, this.kk().proxyClaimsList(new String[0]));
        }
        if (v.getProxyRequestScopes() != null && !v.getProxyRequestScopes().isEmpty()) {
            this.fromList(v.getProxyRequestScopes(), stem, this.kk().proxyRequestScopes(new String[0]));
        }
        if (v.getConfig() != null && !v.getConfig().isEmpty()) {
            QDLStem cfg = new QDLStem();
            cfg.fromJSON(v.getConfig());
            StemUtility.put((QDLStem)stem, (Object)this.kk().cfg(new String[0]), (Object)cfg);
        }
        StemUtility.put((QDLStem)stem, (Object)this.kk().dfInterval(new String[0]), (Object)v.getDfInterval());
        StemUtility.put((QDLStem)stem, (Object)this.kk().dfLifetime(new String[0]), (Object)v.getDfLifetime());
        if (v.getExtendedAttributes() != null && !v.getExtendedAttributes().isEmpty()) {
            QDLStem ea = new QDLStem();
            ea.fromJSON(v.getExtendedAttributes());
            StemUtility.put((QDLStem)stem, (Object)this.kk().ea(new String[0]), (Object)ea);
        }
        StemUtility.put((QDLStem)stem, (Object)this.kk().maxIDTLifetime(new String[0]), (Object)v.getMaxIDTLifetime());
        StemUtility.put((QDLStem)stem, (Object)this.kk().maxATLifetime(new String[0]), (Object)v.getMaxATLifetime());
        StemUtility.put((QDLStem)stem, (Object)this.kk().maxRTLifetime(new String[0]), (Object)v.getMaxRTLifetime());
        StemUtility.put((QDLStem)stem, (Object)this.kk().rtGracePeriod(new String[0]), (Object)v.getRtGracePeriod());
        StemUtility.put((QDLStem)stem, (Object)this.kk().ersatzClient(new String[0]), (Object)v.isErsatzClient());
        this.setNonNullStemValue(stem, this.kk().ersatzInheritIDToken(new String[0]), v.isErsatzInheritIDToken());
        this.setNonNullStemValue(stem, this.kk().issuer(new String[0]), v.getIssuer());
        if (v.getLdaps() != null && !v.getLdaps().isEmpty()) {
            JSONArray jsonArray = this.getCC().getLdapConfigurationUtil().toJSON(v.getLdaps());
            QDLStem ldap = new QDLStem();
            ldap.fromJSON((JSON)jsonArray);
            StemUtility.put((QDLStem)stem, (Object)this.kk().ldap(new String[0]), (Object)ldap);
        }
        this.setNonNullStemValue(stem, this.kk().publicClient(new String[0]), v.isPublicClient());
        this.setNonNullStemValue(stem, this.kk().rtLifetime(new String[0]), v.getRtLifetime());
        if (v.getResource() != null && !v.getResource().isEmpty()) {
            this.fromList(v.getResource(), stem, this.kk().resource(new String[0]));
        }
        if (v.getScopes() != null && !v.getScopes().isEmpty()) {
            this.fromList(v.getScopes(), stem, this.kk().scopes(new String[0]));
        }
        this.setNonNullStemValue(stem, this.kk().signTokens(new String[0]), v.isSignTokens());
        this.setNonNullStemValue(stem, this.kk().skipServerScripts(new String[0]), v.isSkipServerScripts());
        this.setNonNullStemValue(stem, this.kk().strictScopes(new String[0]), v.useStrictScopes());
        if (v.hasPrototypes()) {
            QDLList list = new QDLList();
            for (Identifier id : v.getPrototypes()) {
                list.add((QDLValue)new StringValue(id.toString()));
            }
            StemUtility.put((QDLStem)stem, (Object)this.kk().prototypes(new String[0]), (Object)list);
        }
        return stem;
    }

    OA2ClientConverter getCC() {
        return (OA2ClientConverter)this.parentMC;
    }
}

