/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.util.ArrayList;
import java.util.List;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionKeys;
import org.oa4mp.server.qdl.storage.StemConverter;
import org.qdl_lang.variables.QDLList;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StringValue;

public class PermissionStemMC<V extends Permission>
extends StemConverter<V> {
    public PermissionStemMC(MapConverter<V> mapConverter) {
        super(mapConverter);
    }

    protected PermissionKeys kk() {
        return (PermissionKeys)this.keys;
    }

    @Override
    public V fromMap(QDLStem stem, V v) {
        v = (Permission)super.fromMap(stem, v);
        if (this.isStringKeyOK(stem, this.kk().adminID(new String[0]))) {
            v.setAdminID(BasicIdentifier.newID((String)stem.getString(this.kk().adminID(new String[0]))));
        }
        if (this.isStringKeyOK(stem, this.kk().clientID(new String[0]))) {
            v.setClientID(BasicIdentifier.newID((String)stem.getString(this.kk().clientID(new String[0]))));
        }
        if (stem.containsKey((Object)this.kk().ersatzID(new String[0]))) {
            ArrayList<Identifier> ids = new ArrayList<Identifier>();
            QDLValue obj = stem.get(this.kk().ersatzID(new String[0]));
            if (obj instanceof QDLStem) {
                QDLList list = ((QDLStem)obj).getQDLList();
                for (Object element : list) {
                    if (!(element instanceof String)) continue;
                    ids.add(BasicIdentifier.newID((String)((String)element)));
                }
            }
            v.setErsatzChain(ids);
        }
        if (stem.containsKey((Object)this.kk().readable(new String[0]))) {
            v.setRead(stem.getBoolean(this.kk().readable(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().writeable(new String[0]))) {
            v.setWrite(stem.getBoolean(this.kk().writeable(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().substitute(new String[0]))) {
            v.setSubstitute(stem.getBoolean(this.kk().substitute(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().canRemove(new String[0]))) {
            v.setDelete(stem.getBoolean(this.kk().canRemove(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().canCreate(new String[0]))) {
            v.setCreate(stem.getBoolean(this.kk().canCreate(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().canApprove(new String[0]))) {
            v.setApprove(stem.getBoolean(this.kk().canApprove(new String[0])).booleanValue());
        }
        return v;
    }

    @Override
    public QDLStem toMap(V v, QDLStem stem) {
        stem = super.toMap(v, stem);
        if (v.getAdminID() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().adminID(new String[0]), (Object)v.getAdminID().toString());
        }
        if (v.getClientID() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().clientID(new String[0]), (Object)v.getClientID().toString());
        }
        if (v.getErsatzChain() != null && !v.getErsatzChain().isEmpty()) {
            List ids = v.getErsatzChain();
            QDLList list = new QDLList();
            for (Identifier id : ids) {
                list.add((QDLValue)new StringValue(id.toString()));
            }
            QDLStem e = new QDLStem();
            e.setQDLList(list);
            StemUtility.put((QDLStem)stem, (Object)this.kk().ersatzID(new String[0]), (Object)list);
        }
        StemUtility.put((QDLStem)stem, (Object)this.kk().substitute(new String[0]), (Object)v.canSubstitute());
        StemUtility.put((QDLStem)stem, (Object)this.kk().canApprove(new String[0]), (Object)v.isApprove());
        StemUtility.put((QDLStem)stem, (Object)this.kk().canCreate(new String[0]), (Object)v.isCreate());
        StemUtility.put((QDLStem)stem, (Object)this.kk().canRemove(new String[0]), (Object)v.isDelete());
        StemUtility.put((QDLStem)stem, (Object)this.kk().readable(new String[0]), (Object)v.isRead());
        StemUtility.put((QDLStem)stem, (Object)this.kk().writeable(new String[0]), (Object)v.isWrite());
        return stem;
    }
}

