/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import java.util.ArrayList;
import java.util.List;
import org.oa4mp.server.qdl.storage.PermissionStemMC;
import org.oa4mp.server.qdl.storage.QDLPermissionStoreAccessor;
import org.oa4mp.server.qdl.storage.QDLStoreAccessor;
import org.oa4mp.server.qdl.storage.StoreFacade;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.QDLValue;

public class PermissionStoreFacade
extends StoreFacade {
    public static String CLIENT_COUNT_NAME = "client_count";
    public static String CLIENTS_NAME = "get_clients";
    public static String ADMINS_NAME = "get_admins";

    protected QDLPermissionStoreAccessor getPS() {
        return (QDLPermissionStoreAccessor)this.getStoreAccessor();
    }

    @Override
    protected QDLStoreAccessor createAccessor(String storeType) throws Exception {
        QDLStoreAccessor a = null;
        a = super.createAccessor(storeType);
        if (a != null) {
            return a;
        }
        switch (storeType) {
            case "permission": {
                a = new QDLPermissionStoreAccessor(storeType, this.getEnvironment().getPermissionStore(), this.getEnvironment().getMyLogger());
                a.setMapConverter(new PermissionStemMC(this.getEnvironment().getPermissionStore().getMapConverter()));
            }
        }
        return a;
    }

    public class GetAdmins
    implements QDLFunction {
        public String getName() {
            return ADMINS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            PermissionStoreFacade.this.checkInit();
            if (objects.length != 1 || !objects[0].isString()) {
                throw new BadArgException(this.getName() + " requires the client id as its argument", 0);
            }
            List<Identifier> ids = PermissionStoreFacade.this.getPS().getAdmins(BasicIdentifier.newID((String)objects[0].asString()));
            QDLStem stem = new QDLStem();
            for (Identifier id : ids) {
                stem.listAdd(QDLValue.asQDLValue((Object)id.toString()));
            }
            return QDLValue.asQDLValue((Object)stem);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(client_id) - return a list of admins associated with this client id");
            doxx.add("See also: " + CLIENTS_NAME);
            return doxx;
        }
    }

    public class GetClients
    implements QDLFunction {
        public String getName() {
            return CLIENTS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            PermissionStoreFacade.this.checkInit();
            if (objects.length != 1 || !objects[0].isString()) {
                throw new BadArgException(this.getName() + " requires the admin id as its argument", 0);
            }
            List<Identifier> ids = PermissionStoreFacade.this.getPS().getClients(BasicIdentifier.newID((String)objects[0].asString()));
            QDLStem stem = new QDLStem();
            for (Identifier id : ids) {
                stem.listAdd(QDLValue.asQDLValue((Object)id.toString()));
            }
            return QDLValue.asQDLValue((Object)stem);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(admin_id) - return a list of clients associated with this admin id");
            doxx.add("See also: " + CLIENT_COUNT_NAME + ", " + ADMINS_NAME);
            return doxx;
        }
    }

    public class ClientCount
    implements QDLFunction {
        public String getName() {
            return CLIENT_COUNT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            PermissionStoreFacade.this.checkInit();
            if (objects.length != 1 || !objects[0].isString()) {
                throw new BadArgException(this.getName() + " requires the admin id as its argument", 0);
            }
            return QDLValue.asQDLValue((Object)PermissionStoreFacade.this.getPS().getClientCount(BasicIdentifier.newID((String)objects[0].asString())));
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(admin_id) - return the number of clients associated with this admin id");
            doxx.add("See also: " + CLIENTS_NAME);
            return doxx;
        }
    }
}

