/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.storage.sql.SQLStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.server.admin.oauth2.base.StoreArchiver;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.qdl.storage.StemConverter;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.QDLKey;
import org.qdl_lang.variables.values.QDLValue;

public class QDLStoreAccessor {
    MyLoggingFacade logger;
    String accessorType = null;
    Store<Identifiable> store;
    StoreArchiver storeArchiver;
    StemConverter mapConverter;

    public QDLStoreAccessor(String accessorType, Store store, MyLoggingFacade myLogger) {
        this.accessorType = accessorType;
        this.store = store;
        this.logger = myLogger;
    }

    public String getAccessorType() {
        return this.accessorType;
    }

    public void setAccessorType(String accessorType) {
        this.accessorType = accessorType;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public StoreArchiver getStoreArchiver() {
        if (this.storeArchiver == null) {
            this.storeArchiver = new StoreArchiver(this.getStore());
        }
        return this.storeArchiver;
    }

    public QDLStem get(Identifier id) {
        return this.toStem((Identifiable)this.getStore().get((Object)id));
    }

    public List<Boolean> saveOrUpdate(QDLStem QDLStem2, boolean doSave) {
        ArrayList<Boolean> out = new ArrayList<Boolean>();
        if (QDLStem2.isList()) {
            for (int i = 0; i < QDLStem2.size(); ++i) {
                QDLValue obj = QDLStem2.get((Object)i);
                if (!(obj instanceof QDLStem)) continue;
                QDLStem QDLStem1 = (QDLStem)obj;
                if (!QDLStem1.isList()) {
                    try {
                        if (doSave) {
                            this.getStore().save(this.fromStem(QDLStem1));
                        } else {
                            this.getStore().update(this.fromStem(QDLStem1));
                        }
                        out.add(Boolean.TRUE);
                    }
                    catch (Throwable t) {
                        String msg = t.getMessage();
                        if (t.getCause() != null) {
                            msg = t.getCause().getMessage();
                        }
                        this.warn("Could not " + (doSave ? "save" : "update") + " object:" + msg);
                        out.add(Boolean.FALSE);
                    }
                    continue;
                }
                out.add(Boolean.FALSE);
            }
        } else {
            this.getStore().save(this.fromStem(QDLStem2));
            out.add(Boolean.TRUE);
        }
        return out;
    }

    public String toXML(QDLStem stem) {
        XMLMap c = new XMLMap();
        this.store.getXMLConverter().toMap(this.fromStem(stem), (Map)c);
        try {
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            c.toXML((OutputStream)fos);
            fos.flush();
            fos.close();
            return new String(fos.toByteArray());
        }
        catch (IOException iOException) {
            throw new GeneralException("Could not convert to XML");
        }
    }

    public QDLStem fromXML(String x) {
        try {
            ByteArrayInputStream fis = new ByteArrayInputStream(x.getBytes());
            XMLMap map = new XMLMap();
            map.fromXML((InputStream)fis);
            fis.close();
            Identifiable newId = this.store.create();
            StemConverter stemConverter = this.getConverter();
            stemConverter.fromMap((ConversionMap<String, Object>)map, newId);
            return this.toStem(newId);
        }
        catch (IOException iOException) {
            throw new GeneralException("Could not convert from XML");
        }
    }

    public boolean shutdown() {
        SQLStore sqlStore;
        if (this.getStore() instanceof SQLStore && (sqlStore = (SQLStore)this.getStore()).getConnectionPool() != null) {
            sqlStore.getConnectionPool().shutdown();
        }
        return true;
    }

    public boolean remove(Identifier id) {
        this.getStore().remove((Object)id);
        return true;
    }

    public void setMapConverter(StemConverter mapConverter) {
        this.mapConverter = mapConverter;
    }

    SerializationKeys getStoreKeys() {
        return this.getConverter().getKeys();
    }

    protected StemConverter getConverter() {
        if (this.mapConverter == null) {
            XMLConverter xmlConverter = this.store.getXMLConverter();
            if (!(xmlConverter instanceof StemConverter)) {
                throw new GeneralException("Internal  XMLConverter not an instance of StemConverter");
            }
            this.mapConverter = (StemConverter)xmlConverter;
        }
        return this.mapConverter;
    }

    public Long size(Boolean includeVersions) {
        int x = this.getStore().size(includeVersions.booleanValue());
        return x;
    }

    protected QDLStem toStem(Identifiable identifiable) {
        QDLStem stem = new QDLStem();
        if (identifiable != null) {
            this.getConverter().toMap(identifiable, stem);
        }
        return stem;
    }

    protected Identifiable fromStem(QDLStem stem) {
        return this.getConverter().fromMap(stem, null);
    }

    public QDLStem create(String id) {
        Identifiable newObject = this.getStore().create();
        if (!StringUtils.isTrivial((String)id)) {
            newObject.setIdentifier(BasicIdentifier.newID((String)id));
            if (newObject instanceof OA2ServiceTransaction) {
                ((OA2ServiceTransaction)newObject).setAuthorizationGrant((AuthorizationGrant)new AuthorizationGrantImpl(URI.create(id)));
            }
        }
        return this.toStem(newObject);
    }

    public QDLStem search(String key, String condition, Boolean isregex) {
        QDLStem output = new QDLStem();
        List result = this.getStore().search(key, condition, isregex.booleanValue());
        ArrayList<QDLStem> stems = new ArrayList<QDLStem>();
        for (Identifiable identifiable : result) {
            if (this.isVersionID(identifiable.getIdentifier())) continue;
            stems.add(this.toStem(identifiable));
        }
        output.addList(stems);
        return output;
    }

    protected boolean isVersionID(Identifier id) {
        return id.getUri().getFragment() == null ? false : id.getUri().getFragment().contains(StoreArchiver.ARCHIVE_VERSION_TAG + StoreArchiver.ARCHIVE_VERSION_SEPARATOR_TAG);
    }

    public QDLStem listKeys() {
        List keys = this.getStoreKeys().allKeys();
        QDLStem QDLStem2 = new QDLStem();
        QDLStem2.addList(keys);
        return QDLStem2;
    }

    protected Identifiable fromXMLMap(XMLMap map) {
        Identifiable identifiable = this.getStore().create();
        this.getConverter().fromMap((ConversionMap<String, Object>)map, identifiable);
        return identifiable;
    }

    public void warn(String x) {
        if (this.logger == null) {
            System.err.println(x);
        } else {
            this.logger.warn(x);
        }
    }

    public void info(String x) {
        if (this.logger == null) {
            System.err.println(x);
        } else {
            this.logger.info(x);
        }
    }

    public QDLStem archive(QDLStem arg) {
        QDLStem output = new QDLStem();
        for (QDLKey key : arg.keySet()) {
            String s = String.valueOf(arg.get(key));
            Identifiable oldVersion = (Identifiable)this.getStore().get((Object)BasicIdentifier.newID((String)s));
            MapConverter mc = (MapConverter)this.getStore().getXMLConverter();
            XMLMap map = new XMLMap();
            Identifiable newVersion = this.getStore().create();
            mc.toMap(oldVersion, (ConversionMap)map);
            Long newIndex = this.getStoreArchiver().create(oldVersion.getIdentifier());
            output.put(key, (Object)newIndex);
        }
        return output;
    }

    public QDLStem getVersion(Identifier id, Long version) throws IOException {
        return this.toStem(this.getStoreArchiver().getVersion(id, version.longValue()));
    }
}

