/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.NotImplementedException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StringValue;

public abstract class StemConverter<V extends Identifiable>
extends MapConverter<V> {
    MapConverter parentMC;

    public StemConverter(MapConverter<V> mapConverter) {
        super(mapConverter.getKeys(), mapConverter.getProvider());
        this.parentMC = mapConverter;
    }

    public StemConverter(SerializationKeys keys, IdentifiableProvider<V> provider) {
        super(keys, provider);
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        return (V)this.getParentMC().fromMap(map, v);
    }

    public MapConverter getParentMC() {
        return this.parentMC;
    }

    public boolean hasParentMapConverter() {
        return this.parentMC != null;
    }

    public V fromMap(QDLStem stem, V v) {
        v = this.createIfNeeded((Identifiable)v);
        v.setIdentifier(BasicIdentifier.newID((String)stem.getString(this.getKeys().identifier(new String[0]))));
        return v;
    }

    public QDLStem toMap(V v, QDLStem stem) {
        if (stem == null) {
            stem = new QDLStem();
        }
        StemUtility.put((QDLStem)stem, (Object)this.getKeys().identifier(new String[0]), (Object)v.getIdentifierString());
        return stem;
    }

    protected boolean isStringKeyOK(QDLStem stem, String key) {
        return stem.containsKey((Object)key) && !StringUtils.isTrivial((String)stem.getString(key));
    }

    protected boolean isTimeOk(QDLStem QDLStem2, String key) {
        return QDLStem2.containsKey((Object)key) && -1L < QDLStem2.getLong(key);
    }

    public V fromMap(Map<String, Object> map, V v) {
        return this.fromMap(this.convertToStem(map), v);
    }

    public QDLStem convertToStem(Map<String, Object> map) {
        QDLStem stem = new QDLStem();
        for (String key : map.keySet()) {
            stem.put(key, QDLValue.asQDLValue((Object)map.get(key)));
        }
        return stem;
    }

    public void toMap(V value, Map<String, Object> data) {
        throw new NotImplementedException(" not implement for non ConversionMap objects");
    }

    protected Date toDate(QDLStem stem, String key) {
        Date date = new Date();
        date.setTime(stem.get(key).asLong());
        return date;
    }

    protected List toList(QDLStem stem, String key) {
        QDLStem target = stem.get(key).asStem();
        return target.getQDLList().toJSON();
    }

    protected void fromList(Collection c, QDLStem stem, String key) {
        QDLStem target = new QDLStem();
        if (c != null) {
            for (Object s : c) {
                if (s == null) continue;
                target.listAdd((QDLValue)new StringValue(s.toString()));
            }
            StemUtility.put((QDLStem)stem, (Object)(key + "."), (Object)target);
        }
    }

    protected void setNonNullStemValue(QDLStem stem, String key, Object value) {
        if (value != null) {
            StemUtility.put((QDLStem)stem, (Object)key, (Object)value);
        }
    }
}

