/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.util.StringUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.oa4mp.server.qdl.storage.StoreFacade;
import org.qdl_lang.expressions.module.Module;
import org.qdl_lang.extensions.JavaModule;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.extensions.QDLVariable;
import org.qdl_lang.state.State;
import org.qdl_lang.xml.XMLMissingCloseTagException;

public class StoreAccessModule
extends JavaModule {
    protected StoreFacade storeFacade;
    public static final String STORE_FACADE_TAG = "store_facade";
    public static final String CFG_FILE_TAG = "cfg_file";
    public static final String CFG_NAME_TAG = "cfg_name";
    public static final String STORE_TYPE_TAG = "store_type";
    List<String> descr = new ArrayList<String>();

    public StoreAccessModule() {
    }

    public StoreAccessModule(URI namespace, String alias) {
        super(namespace, alias);
    }

    public Module newInstance(State state) {
        StoreAccessModule storeAccessModule = new StoreAccessModule(URI.create("oa4mp:/qdl/store"), "store");
        storeAccessModule.storeFacade = this.newStoreFacade();
        this.doIt(storeAccessModule, state);
        if (state != null) {
            storeAccessModule.init(state);
        }
        this.setupModule((Module)storeAccessModule);
        return storeAccessModule;
    }

    protected void doIt(StoreAccessModule sam, State state) {
        if (state != null) {
            sam.storeFacade.setLogger(state.getLogger());
        }
        sam.addFunctions(this.createFList(sam.storeFacade));
        sam.addVariables(this.createVarList(sam.storeFacade));
    }

    protected List<QDLVariable> createVarList(StoreFacade sf) {
        ArrayList<QDLVariable> vars = new ArrayList<QDLVariable>();
        vars.add(new StoreFacade.StoreType(sf));
        return vars;
    }

    protected List<QDLFunction> createFList(StoreFacade sf) {
        ArrayList<QDLFunction> functions = new ArrayList<QDLFunction>();
        functions.add(new StoreFacade.Count(sf));
        functions.add(new StoreFacade.Create(sf));
        functions.add(new StoreFacade.CreateVersion(sf));
        functions.add(new StoreFacade.FromXML(sf));
        functions.add(new StoreFacade.InitMethod(sf));
        functions.add(new StoreFacade.Keys(sf));
        functions.add(new StoreFacade.ReadObject(sf));
        functions.add(new StoreFacade.Remove(sf));
        functions.add(new StoreFacade.SaveObject(sf));
        functions.add(new StoreFacade.Search(sf));
        functions.add(new StoreFacade.Shutdown(sf));
        functions.add(new StoreFacade.ToXML(sf));
        functions.add(new StoreFacade.UpdateObject(sf));
        functions.add(new StoreFacade.VGetVersions(sf));
        functions.add(new StoreFacade.VRestore(sf));
        return functions;
    }

    public StoreFacade newStoreFacade() {
        return new StoreFacade();
    }

    public void writeExtraXMLElements(XMLStreamWriter xsw) throws XMLStreamException {
        super.writeExtraXMLElements(xsw);
        if (this.storeFacade != null) {
            xsw.writeStartElement(STORE_FACADE_TAG);
            if (!StringUtils.isTrivial((String)this.storeFacade.file)) {
                xsw.writeStartElement(CFG_FILE_TAG);
                xsw.writeCData(this.storeFacade.file);
                xsw.writeEndElement();
            }
            if (!StringUtils.isTrivial((String)this.storeFacade.cfgName)) {
                xsw.writeStartElement(CFG_NAME_TAG);
                xsw.writeCData(this.storeFacade.cfgName);
                xsw.writeEndElement();
            }
            if (!StringUtils.isTrivial((String)this.storeFacade.storeType)) {
                xsw.writeStartElement(STORE_TYPE_TAG);
                xsw.writeCData(this.storeFacade.storeType);
                xsw.writeEndElement();
            }
            xsw.writeEndElement();
        }
    }

    protected String processXML(XMLEventReader xer, String tag) throws XMLStreamException {
        XMLEvent xe = xer.peek();
        String value = null;
        while (xer.hasNext()) {
            switch (xe.getEventType()) {
                case 4: {
                    if (xe.asCharacters().isWhiteSpace()) break;
                    value = xe.asCharacters().getData();
                    break;
                }
                case 2: {
                    if (!xe.asEndElement().getName().getLocalPart().equals(tag)) break;
                    return value;
                }
            }
            xe = xer.nextEvent();
        }
        throw new XMLMissingCloseTagException(tag);
    }

    public void readExtraXMLElements(XMLEvent xe, XMLEventReader xer) throws XMLStreamException {
        super.readExtraXMLElements(xe, xer);
        while (xer.hasNext()) {
            switch (xe.getEventType()) {
                case 1: {
                    if (this.storeFacade == null) break;
                    switch (xe.asStartElement().getName().getLocalPart()) {
                        case "cfg_file": {
                            this.storeFacade.file = this.processXML(xer, CFG_FILE_TAG);
                            break;
                        }
                        case "cfg_name": {
                            this.storeFacade.cfgName = this.processXML(xer, CFG_NAME_TAG);
                            break;
                        }
                        case "store_type": {
                            this.storeFacade.storeType = this.processXML(xer, STORE_TYPE_TAG);
                        }
                    }
                    break;
                }
                case 2: {
                    if (!xe.asEndElement().getName().getLocalPart().equals(STORE_FACADE_TAG)) break;
                    try {
                        if (this.storeFacade == null) {
                            this.storeFacade = this.newStoreFacade();
                        }
                        this.storeFacade.doSetup(false);
                    }
                    catch (Throwable t) {
                        System.out.println("Could not re-initialize store facade for alias " + this.getAlias());
                    }
                    return;
                }
            }
            xe = xer.nextEvent();
        }
        throw new XMLMissingCloseTagException(STORE_FACADE_TAG);
    }

    public List<String> getDescription() {
        if (this.descr.isEmpty()) {
            this.descr.add("Module for accessing OA4MP stores (except permissions, which require their");
            this.descr.add("own machinery and hence they have their own module.");
            this.descr.add("The power of this module is that each object is turned into a stem and");
            this.descr.add("may be treated like a QDL object, then saved. There are many utilities too.");
            this.descr.add("All operations are available, such as creating objects and getting");
            this.descr.add("objects or searches. Note that saving the object");
            this.descr.add("is not an update, i.e., if you remove properties, they will be deleted");
            this.descr.add("in the store.");
            this.descr.add("Use. To make a store for clients");
            this.descr.add("1. create the module variable ");
            this.descr.add("\n   clients. := j_load('oa4mp.client.store');\n");
            this.descr.add("2. initialize the store, last argument sets the type");
            this.descr.add("   clients#init('/home/ncsa/dev/csd/config/server-oa2.xml', 'localhost:oa4mp.oa2.mariadb', " + StoreFacade.STORE_TYPES_STEM_NAME + ".'client');");
            this.descr.add("This returns true if the store intialized ok.");
            this.descr.add("3. Issue commands, e.g.");
            this.descr.add("   x. := clients#search('client_id', '.*234.*');\n   size(x.);\n4\n");
            this.descr.add("Indicates that 4 client records were found. The stem contains the");
            this.descr.add("records themselves and may be substantial.");
            if (this.storeFacade != null) {
                this.descr.add("Supported store types are ");
                this.descr.add(this.storeFacade.getStoreTypes().toString());
            }
        }
        return this.descr;
    }
}

