/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.delegation.common.storage.TransactionStore;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.qdl.storage.AdminClientStemMC;
import org.oa4mp.server.qdl.storage.ApprovalStemMC;
import org.oa4mp.server.qdl.storage.ClientStemMC;
import org.oa4mp.server.qdl.storage.PermissionStemMC;
import org.oa4mp.server.qdl.storage.QDLPermissionStoreAccessor;
import org.oa4mp.server.qdl.storage.QDLStoreAccessor;
import org.oa4mp.server.qdl.storage.TXRStemMC;
import org.oa4mp.server.qdl.storage.TransactionStemMC;
import org.qdl_lang.exceptions.BadArgException;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.extensions.QDLVariable;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLList;
import org.qdl_lang.variables.QDLNull;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;
import org.qdl_lang.variables.values.BooleanValue;
import org.qdl_lang.variables.values.LongValue;
import org.qdl_lang.variables.values.QDLKey;
import org.qdl_lang.variables.values.QDLNullValue;
import org.qdl_lang.variables.values.QDLValue;
import org.qdl_lang.variables.values.StringValue;

public class StoreFacade {
    QDLStem types;
    transient MyLoggingFacade logger = null;
    transient ConfigurationNode configurationNode;
    protected transient OA2SE environment = null;
    boolean initCalled = false;
    protected String INIT_NAME = "init";
    public static final String STORE_TYPE_CLIENT = "client";
    public static final String STORE_TYPE_APPROVALS = "client_approval";
    public static final String STORE_TYPE_TRANSACTION = "transaction";
    public static final String STORE_TYPE_TX_STORE = "tx_record";
    public static final String STORE_TYPE_PERMISSION_STORE = "permission";
    public static final String STORE_TYPE_ADMIN_CLIENT_STORE = "admin_client";
    protected String checkInitMessage = "Be sure you have called the " + this.INIT_NAME + " function first or this will fail.";
    String file = null;
    String cfgName = null;
    String storeType = null;
    String FILE_ARG = "file";
    String NAME_ARG = "name";
    String TYPE_ARG = "type";
    String VERBOSE_ON_ARG = "verbose_on";
    public String TO_XML_NAME = "to_xml";
    public String FROM_XML_NAME = "from_xml";
    protected transient QDLStoreAccessor storeAccessor;
    protected String CREATE_NAME = "create";
    protected String READ_NAME = "read";
    protected String UPDATE_NAME = "update";
    protected String SAVE_NAME = "save";
    protected String SEARCH_NAME = "search";
    protected String COUNT_NAME = "count";
    protected String KEYS_NAME = "keys";
    protected String REMOVE_NAME = "remove";
    public static String STORE_TYPES_STEM_NAME = "$$STORE_TYPE.";
    protected String VERSION_CREATE_NAME = "version";
    protected String VERSION_GET_VERSIONS_NAME = "list_versions";
    protected String VERSION_RESTORE_NAME = "restore";
    public static String SHUTDOWN = "shutdown";

    public QDLStem getStoreTypes() {
        if (this.types == null) {
            this.types = new QDLStem();
            StemUtility.put((QDLStem)this.types, (Object)STORE_TYPE_CLIENT, (Object)STORE_TYPE_CLIENT);
            StemUtility.put((QDLStem)this.types, (Object)"approval", (Object)STORE_TYPE_APPROVALS);
            StemUtility.put((QDLStem)this.types, (Object)"admin", (Object)STORE_TYPE_ADMIN_CLIENT_STORE);
            StemUtility.put((QDLStem)this.types, (Object)STORE_TYPE_PERMISSION_STORE, (Object)STORE_TYPE_PERMISSION_STORE);
            StemUtility.put((QDLStem)this.types, (Object)STORE_TYPE_TRANSACTION, (Object)STORE_TYPE_TRANSACTION);
            StemUtility.put((QDLStem)this.types, (Object)"tx", (Object)STORE_TYPE_TX_STORE);
        }
        return this.types;
    }

    public MyLoggingFacade getLogger() {
        return this.logger;
    }

    public void setLogger(MyLoggingFacade logger) {
        this.logger = logger;
    }

    public ConfigurationLoader<? extends AbstractEnvironment> getLoader() {
        return new OA2ConfigurationLoader(this.getConfigurationNode(), this.getLogger());
    }

    public ConfigurationNode getConfigurationNode() {
        return this.configurationNode;
    }

    public void setConfigurationNode(ConfigurationNode configurationNode) {
        this.configurationNode = configurationNode;
    }

    public OA2SE getEnvironment() throws Exception {
        if (this.environment == null) {
            PrintStream out = System.out;
            PrintStream err = System.err;
            System.setOut(new PrintStream(OutputStream.nullOutputStream()));
            System.setErr(new PrintStream(OutputStream.nullOutputStream()));
            this.environment = (OA2SE)this.getLoader().load();
            System.setOut(out);
            System.setErr(err);
        }
        return this.environment;
    }

    protected void checkInit() {
        if (!this.initCalled) {
            throw new IllegalStateException(" You must call init before calling this function");
        }
    }

    protected void init(String configFile, String cfgName) throws Throwable {
        this.setConfigurationNode(XMLConfigUtil.findConfiguration((String)configFile, (String)cfgName, (String)"service"));
        this.initCalled = true;
    }

    protected void doSetup(boolean verboseOn) throws Throwable {
        if (StringUtils.isTrivial((String)this.file) || StringUtils.isTrivial((String)this.cfgName) || StringUtils.isTrivial((String)this.storeType)) {
            return;
        }
        PrintStream out = System.out;
        PrintStream err = System.err;
        if (!verboseOn) {
            System.setOut(new PrintStream(OutputStream.nullOutputStream()));
            System.setErr(new PrintStream(OutputStream.nullOutputStream()));
        }
        this.init(this.file, this.cfgName);
        if (!verboseOn) {
            System.setOut(out);
            System.setErr(err);
        }
        this.setStoreAccessor(this.createAccessor(this.storeType));
        if (this.storeAccessor == null) {
            throw new RuntimeException("unsupported type for store '" + this.storeType + "': config file =" + this.file + ", config name= " + this.cfgName);
        }
    }

    protected QDLStoreAccessor createAccessor(String storeType) throws Exception {
        QDLStoreAccessor storeAccessor = null;
        switch (storeType) {
            case "admin_client": {
                storeAccessor = new QDLStoreAccessor(storeType, (Store)this.getEnvironment().getAdminClientStore(), this.getEnvironment().getMyLogger());
                storeAccessor.setMapConverter(new AdminClientStemMC(this.getEnvironment().getAdminClientStore().getMapConverter()));
                break;
            }
            case "client": {
                storeAccessor = new QDLStoreAccessor(storeType, (Store)this.getEnvironment().getClientStore(), this.getEnvironment().getMyLogger());
                storeAccessor.setMapConverter(new ClientStemMC(this.getEnvironment().getClientStore().getMapConverter()));
                break;
            }
            case "client_approval": {
                storeAccessor = new QDLStoreAccessor(storeType, (Store)this.getEnvironment().getClientApprovalStore(), this.getEnvironment().getMyLogger());
                MapConverter mc = this.getEnvironment().getClientApprovalStore().getMapConverter();
                storeAccessor.setMapConverter(new ApprovalStemMC(mc));
                break;
            }
            case "transaction": {
                storeAccessor = new QDLStoreAccessor(storeType, (Store)this.getEnvironment().getTransactionStore(), this.getEnvironment().getMyLogger());
                storeAccessor.setMapConverter(this.createTransactionStemMC(this.getEnvironment().getTransactionStore(), this.getEnvironment().getClientStore()));
                break;
            }
            case "tx_record": {
                storeAccessor = new QDLStoreAccessor(storeType, (Store)this.getEnvironment().getTxStore(), this.getEnvironment().getMyLogger());
                storeAccessor.setMapConverter(new TXRStemMC(this.getEnvironment().getTxStore().getMapConverter(), this.getEnvironment().getTxStore(), this.getEnvironment().getClientStore()));
                break;
            }
            case "permission": {
                storeAccessor = new QDLPermissionStoreAccessor(storeType, this.getEnvironment().getPermissionStore(), this.getEnvironment().getMyLogger());
                storeAccessor.setMapConverter(new PermissionStemMC(this.getEnvironment().getPermissionStore().getMapConverter()));
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported store '" + storeType + "'");
            }
        }
        return storeAccessor;
    }

    protected TransactionStemMC createTransactionStemMC(TransactionStore transactionStore, ClientStore clientStore) {
        return new TransactionStemMC(transactionStore.getMapConverter(), clientStore);
    }

    public QDLStoreAccessor getStoreAccessor() {
        return this.storeAccessor;
    }

    public void setStoreAccessor(QDLStoreAccessor storeAccessor) {
        this.storeAccessor = storeAccessor;
    }

    private boolean isValueStem(Object value) {
        if (!(value instanceof QDLStem)) {
            return false;
        }
        if (!((QDLStem)value).isList()) {
            return false;
        }
        QDLList ql = ((QDLStem)value).getQDLList();
        return ql.size() == 2 && ql.get(0L).isString() && ql.get(1L).isLong();
    }

    protected QDLStem convertArgsToVersionIDs(QDLValue[] objects, String name) {
        QDLStem out = null;
        if (2 < objects.length) {
            throw new IllegalArgumentException("too many arguments for " + name + ".");
        }
        if (objects.length == 2) {
            out = new QDLStem();
            QDLStem id = new QDLStem();
            if (!objects[0].isString()) {
                throw new BadArgException("dyadic " + name + " requires a string as its first argument", 0);
            }
            id.put((QDLKey)LongValue.Zero, objects[0]);
            if (!objects[1].isLong()) {
                throw new BadArgException("dyadic " + name + " requires an integer as its second argument", 1);
            }
            id.put((QDLKey)LongValue.One, objects[1]);
            out.put((QDLKey)LongValue.Zero, (Object)id);
            return out;
        }
        if (!objects[0].isStem()) {
            throw new BadArgException("monadic " + name + " requires stem as its argument", 0);
        }
        QDLStem temp = objects[0].asStem();
        if (temp.isList() && temp.size() == 2 && temp.get(Long.valueOf(0L)).isString() && temp.get(Long.valueOf(1L)).isLong()) {
            out = new QDLStem();
            out.put((QDLKey)LongValue.Zero, (Object)temp);
        }
        return objects[0].asStem();
    }

    protected VID toVID(QDLStem QDLStem2) {
        if (QDLStem2.size() != 2 || !QDLStem2.isList()) {
            return null;
        }
        QDLValue rawID = QDLStem2.get(Long.valueOf(0L));
        if (!(rawID instanceof String)) {
            return null;
        }
        Identifier id = BasicIdentifier.newID((String)rawID.toString());
        QDLValue v = QDLStem2.get(Long.valueOf(1L));
        if (!(v instanceof Long)) {
            return null;
        }
        return new VID(id, (Long)v);
    }

    protected VID toVID(Object obj) {
        if (!(obj instanceof QDLStem)) {
            return null;
        }
        return this.toVID((QDLStem)obj);
    }

    protected Identifier toIdentifier(Object obj) {
        if (!(obj instanceof String)) {
            return null;
        }
        return BasicIdentifier.newID((URI)URI.create(obj.toString()));
    }

    public class Shutdown
    implements QDLFunction {
        List<String> docs = null;

        public String getName() {
            return SHUTDOWN;
        }

        public int[] getArgCount() {
            return new int[]{0};
        }

        public QDLValue evaluate(QDLValue[] qdlValues, State state) throws Throwable {
            StoreFacade.this.checkInit();
            QDLValue out = QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().shutdown());
            StoreFacade.this.initCalled = false;
            return out;
        }

        public List<String> getDocumentation(int argCount) {
            if (this.docs == null) {
                this.docs = new ArrayList<String>();
                this.docs.add(this.getName() + "() - shutdown the store. ");
                this.docs.add("For most stores this does nothing, but Derby (file) stores can be rendered ");
                this.docs.add("unusable in case of an issue. One important use is catching errors and issuing this");
                this.docs.add("as a final call to cleanup connections");
            }
            return this.docs;
        }
    }

    public class VRestore
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.VERSION_RESTORE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            QDLStem args = StoreFacade.this.convertArgsToVersionIDs(objects, this.getName());
            QDLStem out = new QDLStem();
            for (QDLKey key : args.keySet()) {
                VID vid = StoreFacade.this.toVID(args.get(key));
                if (vid == null) {
                    out.put(key, (QDLValue)BooleanValue.False);
                    continue;
                }
                out.put(key, (Object)StoreFacade.this.getStoreAccessor().getStoreArchiver().restore(vid.id, vid.version));
            }
            return QDLValue.asQDLValue((Object)out);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 1: {
                    doxx.add(this.getName() + "(id. | ids.) - restore the versions for the id. or list of them");
                    break;
                }
                case 2: {
                    doxx.add(this.getName() + "(id, version) - restore the version numbered for the identifier");
                }
            }
            doxx.add("Restores the given version to be to active one.");
            doxx.add("NOTE: This overwrites the currently active object and replaces it!");
            doxx.add("Good practice is to version first whatever you are going to restore.");
            doxx.add("");
            doxx.add("");
            return doxx;
        }
    }

    public class VGetVersions
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.VERSION_GET_VERSIONS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            StoreFacade.this.checkInit();
            QDLStem args = null;
            boolean hasStringArg = false;
            if (objects[0].isString()) {
                args = new QDLStem();
                args.put((QDLKey)LongValue.Zero, objects[0]);
                hasStringArg = true;
            }
            if (objects[0].isStem()) {
                args = objects[0].asStem();
            }
            if (args == null) {
                throw new BadArgException(this.getName() + " requires either an id or stem of them as its argument.", 0);
            }
            QDLStem out = new QDLStem();
            for (QDLKey key : args.keySet()) {
                Identifier id = StoreFacade.this.toIdentifier(args.get(key).asString());
                if (id == null) {
                    out.put(key, (QDLValue)QDLNullValue.getNullValue());
                    continue;
                }
                QDLStem entry = new QDLStem();
                entry.addList(StoreFacade.this.getStoreAccessor().getStoreArchiver().getVersionNumbers(id));
                out.put(key, (Object)entry);
            }
            if (hasStringArg) {
                return out.get(Long.valueOf(0L));
            }
            return QDLValue.asQDLValue((Object)out);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(id | ids.) - get the versions associated with the id or stem of them.");
            doxx.add("This returns a list for each version numbers available for each identifier.");
            doxx.add("If you submit a stem of them, then each returned valus is a stem. If you submit");
            doxx.add("A single ID, then the result is a simple list.");
            doxx.add("E.g.");
            doxx.add("   " + this.getName() + "('uri:/my/object');");
            doxx.add("[0,1,3,7]");
            doxx.add("This is the list of valid version numbers for that object");
            doxx.add("   " + this.getName() + "({'client0':'uri:/my/object0', 'client42':'uri:/my/object42'});");
            doxx.add("{'client0':[1,3],'client42':[0,1,2,3,5]}");
            doxx.add("These are the valid version of each of these.");
            doxx.add(StoreFacade.this.checkInitMessage);
            return doxx;
        }
    }

    public class VID {
        Identifier id;
        Long version;

        public VID(Identifier id, Long version) {
            this.id = id;
            this.version = version;
        }
    }

    public class CreateVersion
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.VERSION_CREATE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            QDLStem arg;
            StoreFacade.this.checkInit();
            boolean isScalar = false;
            switch (objects.length) {
                case 1: {
                    if (objects[0].isStem()) {
                        arg = objects[0].asStem();
                        break;
                    }
                    if (objects[0].isString()) {
                        isScalar = true;
                        arg = new QDLStem();
                        arg.put((QDLKey)LongValue.Zero, objects[0]);
                        break;
                    }
                    throw new BadArgException(this.getName() + " requires stem or string argument", 0);
                }
                case 0: {
                    throw new IllegalArgumentException(this.getName() + " requires an argument");
                }
                default: {
                    throw new IllegalArgumentException(this.getName() + " requires at most a single argument");
                }
            }
            QDLStem out = StoreFacade.this.getStoreAccessor().archive(arg);
            if (isScalar) {
                out.getQDLList().get(0L);
            }
            return QDLValue.asQDLValue((Object)out);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(id | ids.) - create versions the current stored client(s) whose ids are given.");
            doxx.add("Either supply an id for the object or a list of ids.");
            doxx.add(StoreFacade.this.checkInitMessage);
            return doxx;
        }
    }

    public class StoreType
    implements QDLVariable {
        QDLStem storeTypes = null;

        public String getName() {
            return STORE_TYPES_STEM_NAME;
        }

        public Object getValue() {
            return StoreFacade.this.getStoreTypes();
        }
    }

    public class Remove
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.REMOVE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            StoreFacade.this.checkInit();
            if (objects.length == 2) {
                if (!objects[0].isString()) {
                    throw new BadArgException("dyadic " + this.getName() + " requires a string as its first argument.", 0);
                }
                if (!objects[1].isLong()) {
                    throw new BadArgException("dyadic " + this.getName() + " requires a long as its second argument.", 1);
                }
                StoreFacade.this.getStoreAccessor().getStoreArchiver().remove(BasicIdentifier.newID((String)objects[0].asString()), objects[1].asLong().longValue());
                return BooleanValue.True;
            }
            String id = null;
            if (objects[0].isString()) {
                id = objects[0].asString();
                return QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().remove(BasicIdentifier.newID((String)id)));
            }
            if (!objects[0].isStem()) {
                throw new BadArgException("monadic " + this.getName() + " requires a string as its first argument.", 0);
            }
            QDLStem arg = objects[0].asStem();
            QDLStem outStem = new QDLStem();
            for (QDLKey key : arg.keySet()) {
                QDLValue value = arg.get(key);
                if (value.isString()) {
                    outStem.put(key, (Object)StoreFacade.this.getStoreAccessor().remove(BasicIdentifier.newID((String)value.asString())));
                    continue;
                }
                VID vid = StoreFacade.this.toVID(value);
                if (vid == null) continue;
                try {
                    StoreFacade.this.getStoreAccessor().getStoreArchiver().remove(vid.id, vid.version.longValue());
                    outStem.put(key, (Object)Boolean.TRUE);
                }
                catch (Exception e) {
                    outStem.put(key, (Object)Boolean.FALSE);
                }
            }
            return QDLValue.asQDLValue((Object)outStem);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 1: {
                    doxx.add(this.getName() + "(id | ids.) - delete a single object with id, or a stem of them.");
                    doxx.add("The elements of the stem may be simple strings or [id, version] pairs.");
                    break;
                }
                case 2: {
                    doxx.add(this.getName() + "(id, version) - remove the given version from the system.");
                }
            }
            doxx.add("This returns a conformable argument with a true if the object is no longer on the");
            doxx.add("system and a flase otherwise. If an index in the argument is missing, then the argument");
            doxx.add("could not be processed and was skipped.");
            doxx.add(StoreFacade.this.checkInitMessage);
            return doxx;
        }
    }

    public class Keys
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.KEYS_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (objects.length == 1) {
                if (objects[0].isBoolean()) {
                    if (objects[0].asBoolean().booleanValue()) {
                        return QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().getStoreKeys().identifier(new String[0]));
                    }
                } else {
                    throw new BadArgException(this.getName() + " requires a boolean as its argument if present", 0);
                }
            }
            return QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().listKeys());
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doxx.add(this.getName() + "() - list the column names  for the objects in the store.");
                    break;
                }
                case 1: {
                    doxx.add(this.getName() + "(show_primary_key) - list the primary keys this store.");
                    doxx.add("show_primary_key - boolean, if true show the key, if false, show all keys");
                }
            }
            doxx.add(StoreFacade.this.checkInitMessage);
            return doxx;
        }
    }

    public class Count
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.COUNT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            StoreFacade.this.checkInit();
            boolean includeVersions = false;
            if (objects.length == 1) {
                if (objects[0].isBoolean()) {
                    includeVersions = objects[0].asBoolean();
                } else {
                    throw new BadArgException("The first argument of " + StoreFacade.this.COUNT_NAME + ", if present, must be a boolean.", 0);
                }
            }
            return QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().size(includeVersions));
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doxx.add(this.getName() + "() -count the number of entries in the store");
                    break;
                }
                case 1: {
                    doxx.add(this.getName() + "(includeVersions) will count the versions in the store too if true, ");
                    doxx.add("and ignore them if false. The default is false.");
                }
            }
            doxx.add(StoreFacade.this.checkInitMessage);
            return doxx;
        }
    }

    public class Search
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.SEARCH_NAME;
        }

        public int[] getArgCount() {
            return new int[]{2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            StoreFacade.this.checkInit();
            String key = objects[0].asString();
            String regex = objects[1].asString();
            return QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().search(key, regex, true));
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(key, regex) -  search for all clients with the given key whose values satisfy the regex.");
            doxx.add("Note #1: This returns a bunch of stems, one for each object that is found, so it is equivalent to a multi-read");
            doxx.add("Note #2: This may be a huge result if the regex is too general. Do be careful.");
            doxx.add(StoreFacade.this.checkInitMessage);
            return doxx;
        }
    }

    public class SaveObject
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.SAVE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            StoreFacade.this.checkInit();
            if (!objects[0].isStem()) {
                throw new BadArgException(" The argument must be a stem variable", 0);
            }
            QDLStem QDLStem2 = objects[0].asStem();
            List<Boolean> out = StoreFacade.this.getStoreAccessor().saveOrUpdate(QDLStem2, true);
            if (out.size() == 0) {
                return BooleanValue.False;
            }
            if (out.size() == 1) {
                return QDLValue.asQDLValue((Object)out.get(0));
            }
            QDLStem QDLStem1 = new QDLStem();
            QDLStem1.addList(out);
            return QDLValue.asQDLValue((Object)QDLStem1);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(obj.) - save the object to the store. This returns true if the operation succeeds.");
            doxx.add(this.getName() + "This may also be a list of stems and each will be saved if possible. Be sure you send along what you want!");
            doxx.add(StoreFacade.this.checkInitMessage);
            return doxx;
        }
    }

    public class UpdateObject
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.UPDATE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            StoreFacade.this.checkInit();
            if (!objects[0].isStem()) {
                throw new BadArgException(" The argument must be a stem variable", 0);
            }
            QDLStem QDLStem2 = objects[0].asStem();
            List<Boolean> out = StoreFacade.this.getStoreAccessor().saveOrUpdate(QDLStem2, false);
            if (out.size() == 0) {
                return BooleanValue.False;
            }
            if (out.size() == 1) {
                return QDLValue.asQDLValue((Object)out.get(0));
            }
            QDLStem QDLStem1 = new QDLStem();
            QDLStem1.addList(out);
            return QDLValue.asQDLValue((Object)QDLStem1);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + " (stem.) updates and existing object in the store. If the object does not exist, this will fail.");
            doxx.add("See also: " + StoreFacade.this.SAVE_NAME);
            return doxx;
        }
    }

    public class ReadObject
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.READ_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1, 2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            StoreFacade.this.checkInit();
            boolean isScalar = false;
            if (objects.length == 2) {
                if (!objects[0].isString()) {
                    throw new BadArgException("dyadic " + this.getName() + " requires a string as its first argument", 0);
                }
                if (!objects[1].isLong()) {
                    throw new BadArgException("dyadic " + this.getName() + " requires an integer as its seconds argument", 1);
                }
                QDLStem QDLStem2 = StoreFacade.this.getStoreAccessor().getVersion(BasicIdentifier.newID((String)objects[0].asString()), objects[1].asLong());
                if (QDLStem2.isEmpty()) {
                    return QDLNullValue.getNullValue();
                }
                return QDLValue.asQDLValue((Object)QDLStem2);
            }
            if (objects[0].isString()) {
                return QDLValue.asQDLValue((Object)this.getSingleEntry(objects[0]));
            }
            if (!objects[0].isStem()) {
                throw new BadArgException("monadic " + this.getName() + " requires a stem as its first argument", 0);
            }
            QDLStem argStem = objects[0].asStem();
            if (argStem.isList() && StoreFacade.this.isValueStem(argStem)) {
                QDLList ql = argStem.getQDLList();
                QDLStem QDLStem3 = StoreFacade.this.getStoreAccessor().getVersion(BasicIdentifier.newID((String)ql.get(0L).asString()), ql.get(1L).asLong());
                if (QDLStem3.isEmpty()) {
                    return QDLNullValue.getNullValue();
                }
                return QDLValue.asQDLValue((Object)QDLStem3);
            }
            QDLStem outStem = new QDLStem();
            for (QDLKey key : argStem.keySet()) {
                QDLValue value = argStem.get(key);
                Object result = QDLNull.getInstance();
                if (value.isString()) {
                    result = this.getSingleEntry(value);
                }
                if (value.isStem()) {
                    QDLList ql = value.asStem().getQDLList();
                    result = this.getVersionedSingleEntry(ql.get(0L), ql.get(1L));
                }
                outStem.put(key, result);
            }
            return QDLValue.asQDLValue((Object)outStem);
        }

        private Object getSingleEntry(QDLValue object) {
            QDLStem QDLStem2 = StoreFacade.this.getStoreAccessor().get(BasicIdentifier.newID((String)object.asString()));
            if (QDLStem2.isEmpty()) {
                return QDLNullValue.getNullValue();
            }
            return QDLStem2;
        }

        private Object getVersionedSingleEntry(QDLValue object, Object version) throws IOException {
            QDLStem QDLStem2 = StoreFacade.this.getStoreAccessor().getVersion(BasicIdentifier.newID((String)object.asString()), (Long)version);
            if (QDLStem2.isEmpty()) {
                return QDLNull.getInstance();
            }
            return QDLStem2;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 1: {
                    doxx.add(this.getName() + "(id | id.) = get an object or stem of them.");
                    doxx.add("id. may be a stem of simple strings (ids), version entries [id, version],");
                    doxx.add("or a mixture. The result is conformable to the argument.");
                    break;
                }
                case 2: {
                    doxx.add(this.getName() + "(id, version) - get a versioned object");
                }
            }
            doxx.add("If there is no such element for a given id, a null will be returned");
            doxx.add(StoreFacade.this.checkInitMessage);
            return doxx;
        }
    }

    public class Create
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.CREATE_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (objects.length == 1) {
                if (objects[0].isString()) {
                    return QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().create(objects[0].asString()));
                }
                throw new BadArgException(" The argument must be a string identifier.", 0);
            }
            return QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().create(null));
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            if (argCount == 0) {
                doxx.add(this.getName() + "() - Create a new object of this type using system defaults.");
            }
            if (argCount == 1) {
                doxx.add(this.getName() + "(id) - Create a new blank object of this type with the given identifier.");
            }
            doxx.add("You must save this object for it to be in the store.");
            return doxx;
        }
    }

    public class FromXML
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.FROM_XML_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (objects[0].isString()) {
                return QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().fromXML(objects[0].asString()));
            }
            if (!objects[0].isStem()) {
                throw new BadArgException(this.getName() + " requires a string argument or stem of them,.", 0);
            }
            QDLStem arg = objects[0].asStem();
            QDLStem out = new QDLStem();
            for (QDLKey key : arg.keySet()) {
                QDLValue obj = arg.get(key);
                if (obj instanceof String) {
                    out.put(key, (Object)StoreFacade.this.getStoreAccessor().fromXML((String)obj));
                    continue;
                }
                out.put(key, (Object)QDLNull.getInstance());
            }
            return QDLValue.asQDLValue((Object)out);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(xml_doc) - converts a serialized object into a stem.");
            doxx.add("See also: " + StoreFacade.this.TO_XML_NAME);
            return doxx;
        }
    }

    public class ToXML
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.TO_XML_NAME;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) {
            if (!objects[0].isStem()) {
                throw new BadArgException(this.getName() + " requires a stem argument.", 0);
            }
            QDLStem stem = objects[0].asStem();
            if (stem.isEmpty()) {
                return new StringValue();
            }
            if (!stem.isList()) {
                return QDLValue.asQDLValue((Object)StoreFacade.this.getStoreAccessor().toXML(objects[0].asStem()));
            }
            QDLStem out = new QDLStem();
            for (QDLKey key : stem.keySet()) {
                try {
                    out.put(key, (Object)StoreFacade.this.getStoreAccessor().toXML(stem.get(key).asStem()));
                }
                catch (Throwable t) {
                    StoreFacade.this.getLogger().warn("Could not convert object to XML:" + t.getMessage(), t);
                    out.put(key, (QDLValue)QDLNullValue.getNullValue());
                }
            }
            return QDLValue.asQDLValue((Object)out);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            doxx.add(this.getName() + "(stem. | [stem0., stem1.,...]) - converts the object(s)  XML (serialization) format.");
            doxx.add("Serialization format is a good way to store, backup or send configurations.");
            doxx.add("If you supply a single stem for an object, that is processed, or you may supply a list of");
            doxx.add("object. The result is either a string (of XML) or a null if the conversion failed.");
            doxx.add("E.g.");
            doxx.add("   x. := clients#to_xml(clients#search('client_id','.*ligo.*))");
            doxx.add("would search for all client ids that contain 'ligo' and serialize them the XML");
            doxx.add("See also: " + StoreFacade.this.FROM_XML_NAME);
            return doxx;
        }
    }

    public class InitMethod
    implements QDLFunction {
        public String getName() {
            return StoreFacade.this.INIT_NAME;
        }

        public int[] getArgCount() {
            return new int[]{0, 1, 2, 3};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            boolean verboseOn = false;
            switch (objects.length) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!objects[0].isStem()) {
                        throw new BadArgException("monadic " + this.getName() + " requires  a stem.", 0);
                    }
                    QDLStem stem = objects[0].asStem();
                    StoreFacade.this.file = stem.getString(StoreFacade.this.FILE_ARG);
                    StoreFacade.this.cfgName = stem.getString(StoreFacade.this.NAME_ARG);
                    StoreFacade.this.storeType = stem.getString(StoreFacade.this.TYPE_ARG);
                    if (!stem.containsKey((Object)StoreFacade.this.VERBOSE_ON_ARG)) break;
                    verboseOn = stem.getBoolean(StoreFacade.this.VERBOSE_ON_ARG);
                    break;
                }
                case 2: {
                    if (!objects[0].isStem()) {
                        throw new BadArgException("dyadic " + this.getName() + " requires a stem as its first argument", 0);
                    }
                    QDLStem stem2 = objects[0].asStem();
                    if (!objects[1].isString()) {
                        throw new BadArgException("dyadic " + this.getName() + " requires a string, the store type, as its second argument", 1);
                    }
                    StoreFacade.this.file = stem2.getString(StoreFacade.this.FILE_ARG);
                    StoreFacade.this.cfgName = stem2.getString(StoreFacade.this.NAME_ARG);
                    StoreFacade.this.storeType = objects[1].asString();
                    if (!stem2.containsKey((Object)StoreFacade.this.VERBOSE_ON_ARG)) break;
                    verboseOn = stem2.getBoolean(StoreFacade.this.VERBOSE_ON_ARG);
                    break;
                }
                case 3: {
                    for (int j = 0; j < objects.length; ++j) {
                        if (objects[j].isString()) continue;
                        throw new BadArgException(" argument " + j + " must be a string.", j);
                    }
                    StoreFacade.this.file = objects[0].asString();
                    StoreFacade.this.cfgName = objects[1].asString();
                    StoreFacade.this.storeType = objects[2].asString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect argument count");
                }
            }
            StoreFacade.this.doSetup(verboseOn);
            return BooleanValue.True;
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> doxx = new ArrayList<String>();
            switch (argCount) {
                case 0: {
                    doxx.add(this.getName() + "() - Reinitialize this, usually after saving then loading it, since connections to stores must be recreated. ");
                    break;
                }
                case 1: {
                    doxx.add(this.getName() + "(cfg.) - reads the configuration file and then loads the configuration with the given name and store type. ");
                    doxx.add("the stem entries have keys file, name and store_type.");
                    doxx.add("The store_type tells which type of store is to be used.");
                    doxx.add("Store types are in " + STORE_TYPES_STEM_NAME);
                    break;
                }
                case 2: {
                    doxx.add(this.getName() + "(cfg., store_type) - uses the cfg. stem, but allows you to override the store type");
                    doxx.add("if present in the cfg.");
                    break;
                }
                case 3: {
                    doxx.add(this.getName() + "(file, name, store_type) - reads the configuration file and then loads the configuration with the given name and store type. ");
                    break;
                }
                default: {
                    return doxx;
                }
            }
            doxx.add("For a first initialization, you may either supply each argument directly ");
            doxx.add("or simply pass in a stem with the entries of " + StoreFacade.this.FILE_ARG + ", " + StoreFacade.this.NAME_ARG + ", " + StoreFacade.this.TYPE_ARG + " and " + StoreFacade.this.VERBOSE_ON_ARG);
            doxx.add("This must be called before any other function.");
            return doxx;
        }
    }
}

