/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecord;
import org.oa4mp.server.loader.oauth2.storage.tx.TXRecordSerializationKeys;
import org.oa4mp.server.loader.oauth2.storage.tx.TXStore;
import org.oa4mp.server.qdl.storage.StemConverter;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;

public class TXRStemMC<V extends TXRecord>
extends StemConverter<V> {
    ClientStore clientStore;
    TXStore txStore;

    public TXRStemMC(MapConverter<V> mapConverter, TXStore txStore, ClientStore clientStore) {
        super(mapConverter);
        this.clientStore = clientStore;
        this.txStore = txStore;
    }

    protected TXRecordSerializationKeys kk() {
        return (TXRecordSerializationKeys)this.keys;
    }

    @Override
    public V fromMap(QDLStem stem, V v) {
        v = (TXRecord)super.fromMap(stem, v);
        if (stem.containsKey((Object)this.kk().audience(new String[0]))) {
            v.setAudience(this.toList(stem, this.kk().audience(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().expiresAt(new String[0]))) {
            v.setExpiresAt(stem.getLong(this.kk().expiresAt(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().ersatzID(new String[0]))) {
            v.setErsatzClient((OA2Client)this.clientStore.get((Object)BasicIdentifier.newID((String)stem.getString(this.kk().ersatzID(new String[0])))));
        }
        if (stem.containsKey((Object)this.kk().token(new String[0]))) {
            v.setToken((JSONObject)stem.getStem(this.kk().token(new String[0])).toJSON());
        }
        if (stem.containsKey((Object)this.kk().lifetime(new String[0]))) {
            v.setLifetime(stem.getLong(this.kk().lifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().issuedAt(new String[0]))) {
            v.setIssuedAt(stem.getLong(this.kk().issuedAt(new String[0])).longValue());
        }
        if (this.isStringKeyOK(stem, this.kk().issuer(new String[0]))) {
            v.setIssuer(stem.getString(this.kk().issuer(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().isValid(new String[0]))) {
            v.setValid(stem.getBoolean(this.kk().isValid(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().parentID(new String[0]))) {
            v.setParentID(BasicIdentifier.newID((String)stem.getString(this.kk().parentID(new String[0]))));
        }
        if (stem.containsKey((Object)this.kk().resource(new String[0]))) {
            v.setResource(this.toList(stem, this.kk().resource(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().scopes(new String[0]))) {
            v.setScopes(this.toList(stem, this.kk().scopes(new String[0])));
        }
        if (this.isStringKeyOK(stem, this.kk().tokenType(new String[0]))) {
            v.setTokenType(stem.getString(this.kk().tokenType(new String[0])));
        }
        return v;
    }

    @Override
    public QDLStem toMap(V v, QDLStem stem) {
        stem = super.toMap(v, stem);
        this.fromList(v.getAudience(), stem, this.kk().audience(new String[0]));
        StemUtility.put((QDLStem)stem, (Object)this.kk().expiresAt(new String[0]), (Object)v.getExpiresAt());
        StemUtility.put((QDLStem)stem, (Object)this.kk().lifetime(new String[0]), (Object)v.getLifetime());
        StemUtility.put((QDLStem)stem, (Object)this.kk().issuedAt(new String[0]), (Object)v.getIssuedAt());
        if (!StringUtils.isTrivial((String)v.getIssuer())) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().issuer(new String[0]), (Object)v.getIssuer());
        }
        if (v.getErsatzClient() != null) {
            this.setNonNullStemValue(stem, this.kk().ersatzID(new String[0]), v.getErsatzClient().getIdentifierString());
        }
        StemUtility.put((QDLStem)stem, (Object)this.kk().isValid(new String[0]), (Object)v.isValid());
        if (v.getParentID() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().parentID(new String[0]), (Object)v.getParentID().getUri().toString());
        }
        this.fromList(v.getResource(), stem, this.kk().resource(new String[0]));
        this.fromList(v.getScopes(), stem, this.kk().scopes(new String[0]));
        if (!StringUtils.isTrivial((String)v.getTokenType())) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().tokenType(new String[0]), (Object)v.getTokenType());
        }
        return stem;
    }
}

