/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.storage;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.crypto.MyPKCS10CertRequest;
import edu.uiuc.ncsa.security.util.pkcs.MyCertUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Date;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.token.AccessToken;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.MyX509Certificates;
import org.oa4mp.delegation.common.token.ProtectedAsset;
import org.oa4mp.delegation.common.token.RefreshToken;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2ServiceTransaction;
import org.oa4mp.server.loader.oauth2.storage.transactions.OA2TransactionKeys;
import org.oa4mp.server.qdl.storage.StemConverter;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.StemUtility;

public class TransactionStemMC<V extends OA2ServiceTransaction>
extends StemConverter<V> {
    ClientStore clientStore;

    public TransactionStemMC(MapConverter<V> mapConverter, ClientStore clientStore) {
        super(mapConverter);
        this.clientStore = clientStore;
    }

    protected OA2TransactionKeys kk() {
        return (OA2TransactionKeys)this.keys;
    }

    @Override
    public V fromMap(QDLStem stem, V v) {
        v = (OA2ServiceTransaction)super.fromMap(stem, v);
        Identifier id = v.getIdentifier();
        if (stem.containsKey((Object)this.kk().accessToken(new String[0]))) {
            v.setAccessToken((AccessToken)TokenFactory.createAT((String)stem.getString(this.kk().accessToken(new String[0]))));
        }
        if (stem.containsKey((Object)this.kk().authGrant(new String[0]))) {
            v.setAuthorizationGrant((AuthorizationGrant)TokenFactory.createAG((String)stem.getString(this.kk().authGrant(new String[0]))));
        }
        if (stem.containsKey((Object)this.kk().accessTokenValid(new String[0]))) {
            v.setAccessTokenValid(stem.getBoolean(this.kk().accessTokenValid(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().lifetime(new String[0]))) {
            v.setLifetime(stem.getLong(this.kk().lifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().idTokenLifetime(new String[0]))) {
            v.setIDTokenLifetime(stem.getLong(this.kk().idTokenLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().callbackUri(new String[0]))) {
            v.setCallback(URI.create(stem.getString(this.kk().callbackUri(new String[0]))));
        }
        if (this.isStringKeyOK(stem, this.kk().nonce(new String[0]))) {
            v.setNonce(stem.getString(this.kk().nonce(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().tempCredValid(new String[0]))) {
            v.setAuthGrantValid(stem.getBoolean(this.kk().tempCredValid(new String[0])).booleanValue());
        }
        if (this.isStringKeyOK(stem, this.kk().certReq(new String[0]))) {
            v.setCertReq(CertUtil.fromStringToCertReq((String)stem.getString(this.kk().certReq(new String[0]))));
        }
        if (this.isStringKeyOK(stem, this.kk().cert(new String[0]))) {
            try {
                ByteArrayInputStream baos = new ByteArrayInputStream(stem.getString(this.kk().cert(new String[0])).getBytes("UTF-8"));
                MyX509Certificates myCert = new MyX509Certificates(MyCertUtil.fromPEM((InputStream)baos));
                v.setProtectedAsset((ProtectedAsset)myCert);
            }
            catch (CertificateException e) {
                throw new GeneralException("Error decoding certificate", (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (stem.containsKey((Object)this.kk().clientKey(new String[0]))) {
            v.setClient((Client)((OA2Client)this.clientStore.get((Object)BasicIdentifier.newID((String)stem.getString(this.kk().clientKey(new String[0]))))));
        }
        if (this.isStringKeyOK(stem, this.kk().username(new String[0]))) {
            v.setUsername(stem.getString(this.kk().username(new String[0])));
        }
        if (this.isStringKeyOK(stem, this.kk().myproxyUsername(new String[0]))) {
            v.setMyproxyUsername(stem.getString(this.kk().myproxyUsername(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().authTime(new String[0]))) {
            Date date = new Date(stem.getLong(this.kk().authTime(new String[0])));
            v.setAuthTime(date);
        }
        if (stem.containsKey((Object)this.kk().atJWT(new String[0]))) {
            v.setATJWT(stem.getString(this.kk().atJWT(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().authzGrantLifetime(new String[0]))) {
            v.setAuthGrantLifetime(stem.getLong(this.kk().authzGrantLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().consentPageOK(new String[0]))) {
            v.setRFC8628Request(stem.getBoolean(this.kk().consentPageOK(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().expiresIn(new String[0]))) {
            v.setAccessTokenLifetime(stem.getLong(this.kk().expiresIn(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().idTokenIdentifier(new String[0]))) {
            v.setIDTokenIdentifier(stem.getString(this.kk().idTokenIdentifier(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().isRFC8628(new String[0]))) {
            v.setRFC8628Request(stem.getBoolean(this.kk().isRFC8628(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().proxyID(new String[0]))) {
            v.setProxyId(stem.getString(this.kk().proxyID(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().refreshToken(new String[0]))) {
            v.setRefreshToken((RefreshToken)TokenFactory.createRT((String)stem.getString(this.kk().refreshToken(new String[0]))));
        }
        if (stem.containsKey((Object)this.kk().rtJWT(new String[0]))) {
            v.setRTJWT(stem.getString(this.kk().rtJWT(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().refreshTokenLifetime(new String[0]))) {
            v.setRefreshTokenLifetime(stem.getLong(this.kk().refreshTokenLifetime(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().refreshTokenExpiresAt(new String[0]))) {
            v.setRefreshTokenExpiresAt(stem.getLong(this.kk().refreshTokenExpiresAt(new String[0])).longValue());
        }
        if (stem.containsKey((Object)this.kk().refreshTokenValid(new String[0]))) {
            v.setRefreshTokenValid(stem.getBoolean(this.kk().refreshTokenValid(new String[0])).booleanValue());
        }
        if (stem.containsKey((Object)this.kk().reqState(new String[0]))) {
            v.setRequestState(stem.getString(this.kk().reqState(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().scopes(new String[0]))) {
            v.setScopes((Collection)this.toList(stem, this.kk().scopes(new String[0])));
        }
        if (this.isStringKeyOK(stem, this.kk().states(new String[0]))) {
            v.setState(JSONObject.fromObject((Object)stem.getString(this.kk().states(new String[0]))));
        }
        if (stem.containsKey((Object)this.kk().userCode(new String[0]))) {
            v.setUserCode(stem.getString(this.kk().userCode(new String[0])));
        }
        if (stem.containsKey((Object)this.kk().validatedScopes(new String[0]))) {
            v.setValidatedScopes((Collection)this.toList(stem, this.kk().validatedScopes(new String[0])));
        }
        v.setIdentifier(id);
        return v;
    }

    @Override
    public QDLStem toMap(V v, QDLStem stem) {
        MyX509Certificates myCert;
        stem = super.toMap(v, stem);
        if (v.getAccessToken() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().accessToken(new String[0]), (Object)v.getAccessToken().getToken());
        }
        if (v.getAuthorizationGrant() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().authGrant(new String[0]), (Object)v.getAuthorizationGrant().getToken());
        }
        StemUtility.put((QDLStem)stem, (Object)this.kk().accessTokenValid(new String[0]), (Object)v.isAccessTokenValid());
        StemUtility.put((QDLStem)stem, (Object)this.kk().lifetime(new String[0]), (Object)v.getLifetime());
        if (v.getCallback() != null) {
            this.setNonNullStemValue(stem, this.kk().callbackUri(new String[0]), v.getCallback().toString());
        }
        this.setNonNullStemValue(stem, this.kk().nonce(new String[0]), v.getNonce());
        StemUtility.put((QDLStem)stem, (Object)this.kk().tempCredValid(new String[0]), (Object)v.isAuthGrantValid());
        if (v.getCertReq() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().certReq(new String[0]), (Object)CertUtil.fromCertReqToString((MyPKCS10CertRequest)v.getCertReq()));
        }
        if ((myCert = (MyX509Certificates)v.getProtectedAsset()) != null && myCert.getX509Certificates() != null && myCert.getX509Certificates().length != 0) {
            try {
                StemUtility.put((QDLStem)stem, (Object)this.kk().cert(new String[0]), (Object)myCert.getX509CertificatesPEM());
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("could not encode certificate", e);
            }
        }
        if (v.getClient() != null) {
            this.setNonNullStemValue(stem, this.kk().clientKey(new String[0]), v.getClient().getIdentifierString());
        }
        this.setNonNullStemValue(stem, this.kk().username(new String[0]), v.getUsername());
        this.setNonNullStemValue(stem, this.kk().myproxyUsername(new String[0]), v.getMyproxyUsername());
        if (v.getAuthTime() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().authTime(new String[0]), (Object)v.getAuthTime().getTime());
        }
        StemUtility.put((QDLStem)stem, (Object)this.kk().authzGrantLifetime(new String[0]), (Object)v.getAuthzGrantLifetime());
        StemUtility.put((QDLStem)stem, (Object)this.kk().consentPageOK(new String[0]), (Object)v.isConsentPageOK());
        StemUtility.put((QDLStem)stem, (Object)this.kk().expiresIn(new String[0]), (Object)v.getAccessTokenLifetime());
        StemUtility.put((QDLStem)stem, (Object)this.kk().isRFC8628(new String[0]), (Object)v.isRFC8628Request());
        this.setNonNullStemValue(stem, this.kk().idTokenIdentifier(new String[0]), v.getIDTokenIdentifier());
        this.setNonNullStemValue(stem, this.kk().proxyID(new String[0]), v.getProxyId());
        this.setNonNullStemValue(stem, this.kk().atJWT(new String[0]), v.getATJWT());
        this.setNonNullStemValue(stem, this.kk().rtJWT(new String[0]), v.getRTJWT());
        if (v.getRefreshToken() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().refreshToken(new String[0]), (Object)v.getRefreshToken().getToken());
        }
        StemUtility.put((QDLStem)stem, (Object)this.kk().idTokenLifetime(new String[0]), (Object)v.getIDTokenLifetime());
        StemUtility.put((QDLStem)stem, (Object)this.kk().refreshTokenLifetime(new String[0]), (Object)v.getRefreshTokenLifetime());
        StemUtility.put((QDLStem)stem, (Object)this.kk().refreshTokenExpiresAt(new String[0]), (Object)v.getRefreshTokenExpiresAt());
        StemUtility.put((QDLStem)stem, (Object)this.kk().refreshTokenValid(new String[0]), (Object)v.isRefreshTokenValid());
        this.setNonNullStemValue(stem, this.kk().reqState(new String[0]), v.getRequestState());
        this.fromList(v.getScopes(), stem, this.kk().scopes(new String[0]));
        if (v.getState() != null) {
            StemUtility.put((QDLStem)stem, (Object)this.kk().states(new String[0]), (Object)v.getState().toString());
        }
        this.setNonNullStemValue(stem, this.kk().userCode(new String[0]), v.getUserCode());
        if (v.getValidatedScopes() != null && !v.getValidatedScopes().isEmpty()) {
            this.fromList(v.getValidatedScopes(), stem, this.kk().validatedScopes(new String[0]));
        }
        return stem;
    }
}

