/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.testUtils;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.oa4mp.server.qdl.testUtils.TestUtils;
import org.qdl_lang.expressions.module.Module;
import org.qdl_lang.extensions.JavaModule;
import org.qdl_lang.state.State;

public class TestUtilModule
extends JavaModule {
    public TestUtilModule() {
    }

    public TestUtilModule(URI namespace, String alias) {
        super(namespace, alias);
    }

    public Module newInstance(State state) {
        TestUtilModule m = new TestUtilModule(URI.create("oa4mp:/qdl/oidc/test/util"), "test_util");
        TestUtils testUtils = new TestUtils();
        m.setMetaClass(testUtils);
        ArrayList<Object> funcs = new ArrayList<Object>();
        funcs.add(new TestUtils.ComputeIDTLifetime(testUtils));
        funcs.add(new TestUtils.ComputeATLifetime(testUtils));
        funcs.add(new TestUtils.ComputeRTLifetime(testUtils));
        funcs.add(new TestUtils.ComputeGracePeriod(testUtils));
        funcs.add(new TestUtils.TimeToLong(testUtils));
        m.addFunctions(funcs);
        if (state != null) {
            m.init(state);
        }
        return m;
    }

    public List<String> getDescription() {
        ArrayList<String> a = new ArrayList<String>();
        a.add("TestUtils is charged with exposing certain server-side utilities ");
        a.add("such as computing lifetimes of tokens, making them available to QDL scripts that");
        a.add("do testing. The logic for these is often complex and rewriting them");
        a.add("in QDL would just end up being a maintenance headache eventually.");
        return a;
    }
}

