/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.qdl.testUtils;

import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.oa4mp.server.loader.oauth2.servlet.ClientUtils;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;
import org.qdl_lang.extensions.QDLFunction;
import org.qdl_lang.extensions.QDLMetaModule;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.LongValue;
import org.qdl_lang.variables.values.QDLKey;
import org.qdl_lang.variables.values.QDLValue;

public class TestUtils
implements QDLMetaModule {
    OA2ClientKeys oa2ClientKeys = new OA2ClientKeys();
    public static final String COMPUTE_IDT_LIFETIME = "idt_lifetime";
    public static final String COMPUTE_AT_LIFETIME = "at_lifetime";
    public static final String COMPUTE_RT_LIFETIME = "rt_lifetime";
    public static final String COMPUTE_GRACE_PERIOD = "grace_period";
    public static final String TIME_TO_LONG = "time_to_long";

    public JSONObject serializeToJSON() {
        return new JSONObject();
    }

    public void deserializeFromJSON(JSONObject json) {
    }

    protected Long getClientCfgLifetime(QDLStem client, String handlerName) {
        if (!client.containsKey((Object)this.oa2ClientKeys.cfg(new String[0]))) {
            return null;
        }
        QDLStem cfg = client.getStem(this.oa2ClientKeys.cfg(new String[0]));
        if (!cfg.containsKey((Object)"tokens")) {
            return null;
        }
        QDLStem tokens = cfg.getStem("tokens");
        if (!tokens.containsKey((Object)handlerName)) {
            return null;
        }
        QDLStem handler = tokens.getStem(handlerName);
        if (!handler.containsKey((Object)"lifetime")) {
            return null;
        }
        return 1000L * handler.getLong("lifetime");
    }

    protected long checkArgs(QDLValue[] objects, String name) {
        if (!objects[0].isStem()) {
            throw new IllegalArgumentException(name + "(0) must be a stem, got a " + (objects[0] == null ? "null" : objects[0].getClass().getSimpleName()));
        }
        if (!objects[1].isStem()) {
            throw new IllegalArgumentException(name + "(1) must be a stem, got a " + (objects[1] == null ? "null" : objects[1].getClass().getSimpleName()));
        }
        return objects.length == 3 ? objects[2].asLong() : -1L;
    }

    protected List<String> getLifetimeDoc(String name, int argCount) {
        ArrayList<String> d = new ArrayList<String>();
        switch (argCount) {
            case 2: {
                d.add(name + "(server_defaults., client.) = compute the token lifetime using server defaults and client configuration.");
                d.add("");
                break;
            }
            case 3: {
                d.add(name + "(server_defaults., client., requested) = compute the token lifetime using server defaults, client configuration and request lifetime");
                d.add("This applies all policies to the arguments for the server ");
            }
        }
        d.add("Arguments are:");
        d.add("server_defaults. = the server defaults from the Client Management endpoint that lists all token lifetimes, maxes etc.");
        d.add("client. = the configuration for this client from the Client Management endpoint.");
        if (argCount == 3) {
            d.add("requested = the explicit requested lifetime in the request. This overrides server and client configurations but is");
            d.add("            restricted by the maxima allowed.");
        }
        return d;
    }

    public class TimeToLong
    implements QDLFunction {
        Pattern pattern = Pattern.compile("^[0-9]*$");

        public String getName() {
            return TestUtils.TIME_TO_LONG;
        }

        public int[] getArgCount() {
            return new int[]{1};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            return this.convert(objects[0]);
        }

        protected QDLValue convert(QDLValue object) {
            if (object.isString()) {
                return QDLValue.asQDLValue((Object)this.convertSingle(object.asString()));
            }
            if (object.isStem()) {
                QDLStem stem = object.asStem();
                QDLStem outStem = new QDLStem();
                for (QDLKey key : stem.keySet()) {
                    outStem.put(key, this.convert(stem.get(key)));
                }
                return QDLValue.asQDLValue((Object)outStem);
            }
            return object;
        }

        long convertSingle(String x) {
            return XMLConfigUtil.getValueSecsOrMillis((String)x, (!this.pattern.matcher(x).matches() ? 1 : 0) != 0);
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> d = new ArrayList<String>();
            d.add(this.getName() + "(arg | arg.) - convert to milliseconds");
            d.add("This takes a standard OA4MP time like 3 days and converts it to milliseconds.");
            d.add("If there are no units, it is assumed to be in milliseconds.");
            d.add("non-strings are not converted");
            d.add("E.g.");
            d.add(this.getName() + "(3)  returns 3 milliseconds");
            d.add(this.getName() + "(3 sec.)  returns 3000 milliseconds");
            return d;
        }
    }

    public class ComputeGracePeriod
    implements QDLFunction {
        public String getName() {
            return TestUtils.COMPUTE_GRACE_PERIOD;
        }

        public int[] getArgCount() {
            return new int[]{2};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            TestUtils.this.checkArgs(objects, this.getName());
            QDLStem serverDefaults = objects[0].asStem();
            QDLStem client = objects[1].asStem();
            if (serverDefaults.getLong(OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_TAG) == OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_DISABLED) {
                return LongValue.Zero;
            }
            if (client.getLong(TestUtils.this.oa2ClientKeys.rtGracePeriod(new String[0])) == OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_USE_SERVER_DEFAULT) {
                return QDLValue.asQDLValue((Object)serverDefaults.getLong(OA2ConfigurationLoader.REFRESH_TOKEN_GRACE_PERIOD_TAG));
            }
            return QDLValue.asQDLValue((Object)client.getLong(TestUtils.this.oa2ClientKeys.rtGracePeriod(new String[0])));
        }

        public List<String> getDocumentation(int argCount) {
            ArrayList<String> d = new ArrayList<String>();
            d.add(this.getName() + "(server_defaults., client.) = compute the refresh token grace period ");
            return d;
        }
    }

    public class ComputeRTLifetime
    implements QDLFunction {
        public String getName() {
            return TestUtils.COMPUTE_RT_LIFETIME;
        }

        public int[] getArgCount() {
            return new int[]{2, 3};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            long requestedLifetime = TestUtils.this.checkArgs(objects, this.getName());
            QDLStem serverDefaults = objects[0].asStem();
            QDLStem client = objects[1].asStem();
            return QDLValue.asQDLValue((Object)ClientUtils.computeTokenLifetime((long)(1000L * serverDefaults.getLong("max_rt_lifetime")), (long)(1000L * serverDefaults.getLong(TestUtils.COMPUTE_RT_LIFETIME)), (long)(1000L * client.getLong(TestUtils.this.oa2ClientKeys.rtLifetime(new String[0]))), (long)(1000L * client.getLong("max_rt_lifetime")), (Long)TestUtils.this.getClientCfgLifetime(client, "refresh"), (long)requestedLifetime));
        }

        public List<String> getDocumentation(int argCount) {
            return TestUtils.this.getLifetimeDoc(this.getName(), argCount);
        }
    }

    public class ComputeATLifetime
    implements QDLFunction {
        public String getName() {
            return TestUtils.COMPUTE_AT_LIFETIME;
        }

        public int[] getArgCount() {
            return new int[]{2, 3};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            long requestedLifetime = TestUtils.this.checkArgs(objects, this.getName());
            QDLStem serverDefaults = objects[0].asStem();
            QDLStem client = objects[1].asStem();
            return QDLValue.asQDLValue((Object)ClientUtils.computeTokenLifetime((long)(1000L * serverDefaults.getLong("max_at_lifetime")), (long)(1000L * serverDefaults.getLong(TestUtils.COMPUTE_AT_LIFETIME)), (long)(1000L * client.getLong(TestUtils.this.oa2ClientKeys.atLifetime(new String[0]))), (long)(1000L * client.getLong("max_at_lifetime")), (Long)TestUtils.this.getClientCfgLifetime(client, "access"), (long)requestedLifetime));
        }

        public List<String> getDocumentation(int argCount) {
            return TestUtils.this.getLifetimeDoc(this.getName(), argCount);
        }
    }

    public class ComputeIDTLifetime
    implements QDLFunction {
        public String getName() {
            return TestUtils.COMPUTE_IDT_LIFETIME;
        }

        public int[] getArgCount() {
            return new int[]{2, 3};
        }

        public QDLValue evaluate(QDLValue[] objects, State state) throws Throwable {
            long requestedLifetime = TestUtils.this.checkArgs(objects, this.getName());
            QDLStem serverDefaults = objects[0].asStem();
            QDLStem client = objects[1].asStem();
            return QDLValue.asQDLValue((Object)ClientUtils.computeTokenLifetime((long)(1000L * serverDefaults.getLong("max_id_token_lifetime")), (long)(1000L * serverDefaults.getLong("id_token_lifetime")), (long)(1000L * client.getLong("id_token_lifetime")), (long)(1000L * client.getLong("max_id_token_lifetime")), (Long)TestUtils.this.getClientCfgLifetime(client, "identity"), (long)requestedLifetime));
        }

        public List<String> getDocumentation(int argCount) {
            return TestUtils.this.getLifetimeDoc(this.getName(), argCount);
        }
    }
}

