/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.install;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Installer {
    boolean debugOn = false;
    protected static final String UPGRADE_FLAG = "-u";
    protected static final String UPGRADE_OPTION = "upgrade";
    protected static final String HELP_FLAG = "--help";
    protected static final String HELP_OPTION = "help";
    protected static final String DIR_ARG = "-dir";
    protected static final String DEBUG_FLAG = "-debug";
    protected static final String INSTALL_OPTION = "install";
    protected static final String LIST_OPTION = "list";
    protected static final String REMOVE_OPTION = "remove";
    protected static final String OA4MP_FLAG = "-oa4mp";
    protected static final String ALL_FLAG = "-all";
    protected static final String HOST_FLAG = "-host";
    protected static final String PORT_FLAG = "-port";
    static List<String> allOps = Arrays.asList("upgrade", "remove", "help", "install", "list");
    protected String host = "localhost";
    protected int port = 9443;
    Map<String, String> templates;
    File userHome = null;
    public static String SHEBANG = "#!";
    BufferedReader bufferedReader;
    HashMap<String, Object> argMap;
    public String operationKey = "operation";
    public static String NO_PORT = "-1";

    protected void trace(String message) {
        if (this.isDebugOn()) {
            this.say(message);
        }
    }

    public boolean isDebugOn() {
        return this.debugOn;
    }

    public void setDebugOn(boolean debugOn) {
        this.debugOn = debugOn;
    }

    public static void main(String[] args) {
        block2: {
            Installer installer = new Installer();
            try {
                installer.runnit2(args);
            }
            catch (Throwable t) {
                installer.say(t.getMessage());
                if (!installer.isDebugOn()) break block2;
                t.printStackTrace();
            }
        }
    }

    protected void runnit2(String[] args) throws Throwable {
        this.say("OA4MP installer version 6.2.1");
        this.argMap = new HashMap();
        this.setupArgMap(args);
        if (this.isShowHelp()) {
            this.showHelp();
            return;
        }
        if (this.getOperation().startsWith("-")) {
            this.say("unknown operation \"" + this.getOperation() + "\"");
            return;
        }
        this.setDebugOn(this.is(DEBUG_FLAG));
        if (this.isList()) {
            this.doListFiles();
            return;
        }
        if (this.isInstall() && this.isUpgrade()) {
            this.say("sorry, you cannot specify both an upgrade and an install");
            return;
        }
        if ((this.isInstall() || this.isUpgrade()) && this.isRemove()) {
            this.say("sorry, you cannot specify both an removing QDL and an install/upgrade");
            return;
        }
        if (this.isRemove()) {
            this.doRemove();
            return;
        }
        File rootDir = this.checkRootDir(this.getRootDir(), this.isUpgrade());
        if (rootDir == null) {
            return;
        }
        this.setupTemplates();
        if (this.isInstall()) {
            this.doInstall();
        }
        if (this.isUpgrade()) {
            this.doUpgrade();
        }
    }

    protected void doUpgrade() throws Exception {
        File rootDir = this.getRootDir();
        if (this.isOA4MP()) {
            this.upgradeOA4MP(rootDir);
        }
    }

    protected void doInstall() throws Exception {
        File rootDir = this.getRootDir();
        if (this.isOA4MP()) {
            this.installOA4MP(rootDir);
            this.say("Done! You should add");
            this.say("   export OA4MP_HOME=\"" + rootDir.getAbsolutePath() + "\"");
            this.say("to your environment and");
            this.say("   $OA4MP_HOME" + File.separator + "bin\"");
            this.say("to your PATH");
        }
    }

    protected void doRemove() throws IOException {
        if (this.isOA4MP()) {
            this.uninstallOA4MP(this.getRootDir());
        }
    }

    protected void uninstallOA4MP(File rootDir) {
        if (rootDir == null) {
            this.say("you must explicitly specify the directory to be removed. exiting...");
        } else {
            this.nukeDir(rootDir);
            rootDir.delete();
            this.say(String.valueOf(rootDir) + " and all of its subdirectories have been removed.");
        }
    }

    private void showHelp() {
        this.say("=================================================================");
        this.say("java -jar oa4mp-installer.jar install operation arguments* flags*");
        this.say("=================================================================");
        this.say("This will install OA4MP to your system. Options are:");
        this.say("(none) = same as help");
        this.say("install = install");
        this.say("upgrade = upgrade");
        this.say("remove = remove");
        this.say("help = show help and exit. Note you can also use the flag --help");
        this.say("list = list all the files in the distribution. Nothing is done.");
        this.say("--------------");
        this.say("arguments are:");
        this.say("-dir root = install to the given directory. If omitted, you will be prompted.");
        this.say("--------------");
        this.say("Flags are:");
        this.say("-debug = debug mode -- print all messages from the installer as it runs. This is quite verbose.");
        this.say("--help = this help message");
        this.say("-oa4mp = install support for OA4MP");
        this.say("-all = do all components");
        this.say("-host = the host for the service. Default is localhost");
        this.say("-port = the port for the service. Default is 9443. If you set it to -1, no port is used.");
        this.say("");
        this.say("E.g.");
        this.say("A fresh install, specifying the machine and port. This assumes OA4MP_HOME has been set.");
        this.say("The port is set to -1 meaning that no port will be specified for the endpoints. This is used, ");
        this.say("e.g., if this is behind another server (like Apache) that forwards requests.");
        this.say(this.getClass().getSimpleName() + " install -all -dir $OA4MP_HOME -host issuer.bgsu.edu-port -1");
        this.say("\n\nExample of doing an upgrade");
        this.say(this.getClass().getSimpleName() + " upgrade -all -dir $OA4MP_HOME");
        this.say("This upgrades all components, but does not touch any .xml (config) files or scripts.\n");
    }

    protected void setupTemplates() throws IOException {
        this.templates = new HashMap<String, String>();
        this.templates.put("${OA4MP_HOME}", this.getRootDir().getCanonicalPath() + File.separator);
        Object h = this.getHost();
        if (this.hasPort()) {
            h = (String)h + ":" + this.getPort();
        }
        this.templates.put("${OA4MP_HOST}", (String)h);
    }

    protected File getUserHome() {
        if (this.userHome == null) {
            this.userHome = new File(System.getProperty("user.home"));
        }
        return this.userHome;
    }

    protected boolean checkUpgradeDir(File dir) {
        this.trace("checking if dir exists for " + String.valueOf(dir));
        if (!dir.exists() && !dir.mkdir()) {
            this.trace("  nope");
            return false;
        }
        this.trace("  yup");
        return true;
    }

    protected void nukeDir(File dir) {
        File[] contents;
        if (!dir.isDirectory()) {
            return;
        }
        for (File f : contents = dir.listFiles()) {
            this.trace("found " + String.valueOf(f));
            if (f.isFile()) {
                this.trace("   deleting file:" + String.valueOf(f));
                f.delete();
            }
            if (!f.isDirectory()) continue;
            this.trace("   deleting dir:" + String.valueOf(f));
            this.nukeDir(f);
            f.delete();
        }
    }

    protected void doListFiles() throws Exception {
        this.say("files in this distribution");
        this.say("--------------------------");
        InputStream is = this.getClass().getResourceAsStream("/file_list.txt");
        List<String> fileList = this.isToList(is);
        for (String file : fileList) {
            this.say(file);
        }
    }

    protected List<String> isToList(InputStream inputStream) throws IOException {
        String text = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        ArrayList<String> myList = new ArrayList<String>(Arrays.asList(text.split("\\r?\\n")));
        return myList;
    }

    protected void upgradeOA4MP(File rootDir) throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/file_list.txt");
        List<String> fileList = this.isToList(is);
        this.setupDirs(rootDir);
        for (String file : fileList) {
            if (file.startsWith("/bin") || file.startsWith("/etc") && !file.endsWith(".sql")) continue;
            File f = new File(rootDir.getAbsolutePath() + file);
            if (f.exists()) {
                f.delete();
            }
            this.trace("  " + file + " --> " + f.getCanonicalPath());
            this.cp(file, f);
            if (!file.endsWith(".qdl")) continue;
            this.doSetupScript(f);
        }
    }

    private void setupDirs(File rootDir) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/dir_list.txt");
        List<String> dirList = this.isToList(is);
        for (String dir : dirList) {
            File f = new File(rootDir.getAbsolutePath() + dir);
            this.trace("checking dir " + dir + " --> " + f.getCanonicalPath());
            if (f.exists()) continue;
            f.mkdirs();
        }
    }

    protected void cp(String resourceName, File target) throws IOException {
        if (target.isDirectory()) {
            this.trace("Skipping directory " + String.valueOf(target));
            return;
        }
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        Files.copy(is, target.toPath(), new CopyOption[0]);
    }

    protected void installOA4MP(File rootDir) throws Exception {
        InputStream is = this.getClass().getResourceAsStream("/file_list.txt");
        List<String> fileList = this.isToList(is);
        this.trace("starting install...");
        this.setupDirs(rootDir);
        for (String file : fileList) {
            File f = new File(rootDir.getAbsolutePath() + file);
            if (f.exists()) {
                f.delete();
            }
            this.trace("  " + file + " --> " + f.getCanonicalPath());
            this.cp(file, f);
            if (file.startsWith("/bin/")) {
                this.trace("   setting up oa4mp script to be executable:" + file);
                this.doSetupExec(f);
            }
            if (!file.startsWith("/etc/") || !file.endsWith(".xml")) continue;
            this.trace("  setting up basic configuration");
            this.processTemplates(f);
        }
    }

    private void doSetupExec(File f) throws IOException {
        List<String> lines = Files.readAllLines(f.toPath());
        this.trace("      read:" + lines.size() + " lines");
        for (int i = 0; i < lines.size(); ++i) {
            lines.set(i, this.doReplace(lines.get(i)));
            this.trace("  writing: \"" + lines.get(i) + "\"");
        }
        Files.write(f.toPath(), lines, Charset.defaultCharset(), new OpenOption[0]);
        this.trace("setting " + f.getAbsolutePath() + " to executable");
        f.setExecutable(true);
    }

    private void doSetupScript(File f) throws IOException {
        this.trace("setting up script: " + f.getAbsolutePath());
        List<String> lines = Files.readAllLines(f.toPath());
        for (String line : lines) {
            if (line.isBlank()) continue;
            if (line.trim().startsWith(SHEBANG)) {
                f.setExecutable(true);
                this.trace("   >> was set executable!");
            }
            return;
        }
    }

    protected String doReplace(String currentLine) {
        for (String key : this.templates.keySet()) {
            if (!currentLine.contains(key)) continue;
            this.trace("replacing key = " + key);
            this.trace("   with value = " + this.templates.get(key));
            currentLine = currentLine.replace(key, this.templates.get(key));
        }
        return currentLine;
    }

    private void processTemplates(File f) throws IOException {
        List<String> lines = Files.readAllLines(f.toPath());
        for (int i = 0; i < lines.size(); ++i) {
            lines.set(i, this.doReplace(lines.get(i)));
        }
        Files.write(f.toPath(), lines, Charset.defaultCharset(), new OpenOption[0]);
    }

    protected File checkRootDir(File rootDir, boolean upgrade) throws Exception {
        if (rootDir == null) {
            String lineIn = this.readline("Enter the target directory for the QDL installer:");
            rootDir = new File(lineIn);
        }
        if (upgrade) {
            if (!rootDir.exists()) {
                this.say("Sorry, but that directory does not exist so no upgrade can be done. Exiting...");
                return null;
            }
        } else {
            if (rootDir.exists()) {
                if (rootDir.list().length != 0) {
                    this.say("This exists and is not empty. This will only install to an empty/non-existent directory.\nDid you mean upgrade?");
                }
                return null;
            }
            this.trace("creating directories for root path");
            Files.createDirectories(rootDir.toPath(), new FileAttribute[0]);
        }
        return rootDir;
    }

    protected BufferedReader getBufferedReader() {
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.bufferedReader;
    }

    public String readline(String prompt) throws Exception {
        System.out.print(prompt);
        return this.getBufferedReader().readLine();
    }

    protected void say(String x) {
        System.out.println(x);
    }

    protected void setupArgMap(String[] args) {
        this.argMap = new HashMap();
        if (args.length == 0 || args[0].equals(HELP_OPTION) || args[0].equals(HELP_FLAG)) {
            this.argMap.put(HELP_OPTION, true);
            return;
        }
        this.argMap.put(this.operationKey, args[0]);
        block18: for (int i = 1; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "--help": {
                    this.argMap.put(HELP_OPTION, true);
                    return;
                }
                case "-debug": {
                    this.argMap.put(DEBUG_FLAG, true);
                    continue block18;
                }
                case "-dir": {
                    if (i + 1 >= args.length) continue block18;
                    if (args[i + 1].startsWith("-")) {
                        throw new IllegalArgumentException("missing directory");
                    }
                    this.argMap.put(DIR_ARG, new File(args[++i]));
                    continue block18;
                }
                case "-all": {
                    this.argMap.put(ALL_FLAG, true);
                    continue block18;
                }
                case "-oa4mp": {
                    this.argMap.put(OA4MP_FLAG, true);
                    continue block18;
                }
                case "-host": {
                    this.argMap.put(HOST_FLAG, args[i]);
                    continue block18;
                }
                case "-port": {
                    this.argMap.put(PORT_FLAG, args[i]);
                }
            }
        }
        if (!this.isShowHelp() && !allOps.contains(this.getOperation())) {
            throw new IllegalArgumentException("unknown operation \"" + this.getOperation() + "\"");
        }
    }

    protected boolean hasPort() {
        if (!this.argMap.containsKey(PORT_FLAG)) {
            return true;
        }
        return !this.argMap.get(PORT_FLAG).equals(NO_PORT);
    }

    protected String getHost() {
        if (this.argMap.containsKey(HOST_FLAG)) {
            return (String)this.argMap.get(HOST_FLAG);
        }
        return this.host;
    }

    protected int getPort() {
        if (this.argMap.containsKey(PORT_FLAG)) {
            return Integer.parseInt((String)this.argMap.get(PORT_FLAG));
        }
        return this.port;
    }

    public Boolean is(String key) {
        if (!this.argMap.containsKey(key)) {
            return false;
        }
        return (Boolean)this.argMap.get(key);
    }

    public File getRootDir() {
        if (!this.argMap.containsKey(DIR_ARG)) {
            return null;
        }
        return (File)this.argMap.get(DIR_ARG);
    }

    public boolean isInstall() {
        return this.getOperation().equals(INSTALL_OPTION);
    }

    public boolean isRemove() {
        return this.getOperation().equals(REMOVE_OPTION);
    }

    public boolean isUpgrade() {
        return this.getOperation().equals(UPGRADE_OPTION);
    }

    public boolean isShowHelp() {
        return this.is(HELP_OPTION) != false || this.getOperation().equals(HELP_OPTION);
    }

    public boolean isList() {
        return this.getOperation().equals(LIST_OPTION);
    }

    public boolean hasRootDir() {
        return this.getRootDir() != null;
    }

    public String getOperation() {
        return (String)this.argMap.get(this.operationKey);
    }

    public boolean isAll() {
        return this.is(ALL_FLAG);
    }

    public boolean isOA4MP() {
        return this.is(OA4MP_FLAG) != false || this.is(ALL_FLAG) != false;
    }

    protected void download(URL url, File targetFile) throws IOException {
        int bytes;
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        DataInputStream dis = new DataInputStream(connection.getInputStream());
        FileOutputStream fos = new FileOutputStream(targetFile);
        byte[] buffer = new byte[1024];
        int offset = 0;
        while (0 < (bytes = dis.read(buffer, offset, buffer.length))) {
            fos.write(buffer, 0, bytes);
        }
        fos.close();
        dis.close();
    }
}

