/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.install;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ListDistroFiles {
    public static final String FILE_LIST = "file_list.txt";
    public static final String DIR_LIST = "dir_list.txt";
    List<String> fileList;
    List<String> dirList;
    int rootPathLength;

    public static void main(String[] args) throws Throwable {
        File rootDirectory;
        if (args.length != 1) {
            System.err.println("List distribution files requires the directory of the distribution");
            System.exit(1);
        }
        if (!(rootDirectory = new File(args[0])).exists()) {
            System.err.println("\"" + rootDirectory.getAbsolutePath() + "\" does not exist");
            System.exit(1);
        }
        if (!rootDirectory.isDirectory()) {
            System.err.println("\"" + rootDirectory.getAbsolutePath() + "\" is not a directory");
            System.exit(1);
        }
        ListDistroFiles listDistroFiles = new ListDistroFiles();
        listDistroFiles.runnit(rootDirectory);
    }

    protected void runnit(File rootDirectory) throws IOException {
        this.createFileList(rootDirectory);
        this.writeFiles(rootDirectory, this.dirList, DIR_LIST);
        this.writeFiles(rootDirectory, this.fileList, FILE_LIST);
    }

    protected void say(Object x) {
        System.out.println(x.toString());
    }

    protected void createFileList(File rootDirectory) {
        File[] files;
        this.fileList = new ArrayList<String>();
        this.dirList = new ArrayList<String>();
        this.rootPathLength = rootDirectory.getAbsolutePath().toString().length();
        List<String> excludeList = Arrays.asList("installer.mf", "Installer.class", "qdl-installer.jar");
        for (File f : files = rootDirectory.listFiles()) {
            if (excludeList.contains(f.getName())) continue;
            if (f.isDirectory()) {
                this.recurse(f);
                continue;
            }
            this.fileList.add(f.getAbsolutePath().substring(this.rootPathLength));
        }
    }

    protected void recurse(File rootDirectory) {
        File[] files;
        String relativeDirPath = rootDirectory.getAbsolutePath().substring(this.rootPathLength);
        if (relativeDirPath.startsWith("/edu")) {
            return;
        }
        this.dirList.add(rootDirectory.getAbsolutePath().substring(this.rootPathLength));
        for (File f : files = rootDirectory.listFiles()) {
            if (f.isDirectory()) {
                this.recurse(f);
                continue;
            }
            this.fileList.add(f.getAbsolutePath().substring(this.rootPathLength));
        }
    }

    protected void writeFiles(File rootDir, List<String> targetList, String targetFilename) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String dir : targetList) {
            stringBuilder.append(dir + "\n");
        }
        File targetFile = new File(rootDir, targetFilename);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        FileWriter fileWriter = new FileWriter(targetFile);
        fileWriter.write(stringBuilder.toString());
        fileWriter.flush();
        fileWriter.close();
    }
}

