/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.cli.FoundIdentifiables;
import edu.uiuc.ncsa.security.storage.cli.StoreCommands2;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.ExitException;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.cli.Sortable;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeyUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.storage.clients.BaseClientKeys;
import org.oa4mp.delegation.common.storage.clients.ClientApprovalKeys;
import org.oa4mp.delegation.server.storage.BaseClientStore;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.server.admin.oauth2.base.ClientApprovalStoreCommands;
import org.oa4mp.server.admin.oauth2.base.ClientSorter;
import org.oa4mp.server.admin.oauth2.base.OA4MPStoreCommands;

public abstract class BaseClientStoreCommands
extends OA4MPStoreCommands {
    protected ClientApprovalStoreCommands clientApprovalStoreCommands = null;
    ClientApprovalStore clientApprovalStore;
    public static final String APPROVE_FLAG = "-approved";
    public static final String APPROVER_KEY = "-approver";
    public static String RESET_SECRET_SIZE_FLAG = "-size";
    public static String RESET_SECRET_NEW_FLAG = "-new";
    public static int RESET_SECRET_DEFAULT_SIZE = 64;

    public BaseClientStoreCommands(CLIDriver driver, String defaultIndent, Store clientStore, ClientApprovalStoreCommands clientApprovalStoreCommands) throws Throwable {
        super(driver, defaultIndent, clientStore);
        this.clientApprovalStoreCommands = clientApprovalStoreCommands;
        this.setSortable((Sortable)new ClientSorter());
    }

    public BaseClientStoreCommands(CLIDriver driver, Store store) throws Throwable {
        super(driver, store);
    }

    public ClientApprovalStore getClientApprovalStore() {
        return (ClientApprovalStore)this.clientApprovalStoreCommands.getStore();
    }

    protected JSON inputJSON(JSON oldJSON, String componentName) throws IOException {
        return this.inputJSON(oldJSON, componentName, false);
    }

    protected Sortable getSortable() {
        if (this.sortable == null) {
            this.sortable = new ClientSorter();
        }
        return this.sortable;
    }

    public void print_help() throws Exception {
        super.print_help();
        this.say("--Utilities:");
        this.sayi("create_hash = create the hash of a password.");
    }

    protected JSON inputJSON(JSON oldJSON, String componentName, boolean isArray) throws IOException {
        if (oldJSON == null) {
            this.sayi("no current value for " + componentName);
        } else {
            this.sayi("current value for " + componentName + ":");
            this.say(oldJSON.toString(2));
        }
        this.sayi("Enter new JSON value. An empty line terminates input. Entering a line with /exit will terminate input too.\n Hitting /c will clear the contents of this.");
        Object rawJSON = "";
        boolean redo = true;
        while (redo) {
            try {
                String inLine = this.readline();
                while (!this.isEmpty(inLine)) {
                    if (inLine.equals("/c")) {
                        if (isArray) {
                            return new JSONArray();
                        }
                        return new JSONObject();
                    }
                    rawJSON = (String)rawJSON + inLine;
                    inLine = this.readline();
                }
            }
            catch (ExitException x) {
                return null;
            }
            if (((String)rawJSON).isEmpty()) {
                return null;
            }
            try {
                Object json = null;
                json = isArray ? JSONArray.fromObject((Object)rawJSON) : JSONObject.fromObject((Object)rawJSON);
                this.sayi("Success! JSON is valid.");
                return json;
            }
            catch (Throwable t) {
                this.sayi("uh-oh... It seems this was not a valid JSON object. The parser message reads:\"" + t.getMessage() + "\"");
                redo = this.isOk(this.getInput("Try to re-enter this?", "true"));
            }
        }
        return null;
    }

    protected void showCreateHashHelp() {
        this.say("create_hash string | -file path");
        this.say("This will create a hash of the given string which is suitable for storing in the database.");
        this.say("If you specify a file, the entire content will be hashed.");
        this.say("Note that if there are emebedded blanks, you should enclose the entire argument in double quotes");
        this.say("E.g. \n\ncreate_hash my pass word");
        this.say("would just has \"word\", and to get the whole string you should enter");
        this.say("create_hash \"my pass word\"");
    }

    public void create_hash(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.showCreateHashHelp();
            return;
        }
        String secret = null;
        if (inputLine.hasArg("-file")) {
            try {
                int i;
                FileReader fis = new FileReader(inputLine.getArg(1 + inputLine.indexOf("-file")));
                StringBuffer sb = new StringBuffer();
                while ((i = fis.read()) != -1) {
                    sb.append((char)i);
                }
                fis.close();
                secret = sb.toString();
            }
            catch (Throwable t) {
                this.say(" could not read file: " + t.getMessage());
                return;
            }
        } else {
            secret = inputLine.getLastArg();
        }
        this.say("creating hash of \"" + secret + "\"");
        this.say(DigestUtils.sha1Hex((String)secret));
    }

    protected List<Identifiable> listEntries(List<Identifiable> entries, boolean lineList, boolean verboseList) {
        if (entries == null || entries.isEmpty()) {
            this.say("(no entries found)");
            return entries;
        }
        List approvals = this.getClientApprovalStore().getAll();
        HashMap<Identifier, ClientApproval> approvalMap = new HashMap<Identifier, ClientApproval>();
        for (ClientApproval a : approvals) {
            approvalMap.put(a.getIdentifier(), a);
        }
        int i = 0;
        this.getSortable().setState(null);
        entries = this.getSortable().sort(entries);
        for (Identifiable x : entries) {
            ClientApproval tempA = (ClientApproval)approvalMap.get(x.getIdentifier());
            if (tempA == null) {
                tempA = new ClientApproval(x.getIdentifier());
                tempA.setStatus(ClientApproval.Status.NONE);
            }
            if (lineList) {
                if (i != 0) {
                    this.say("-----");
                }
                this.longFormat((BaseClient)x, tempA, false);
                continue;
            }
            if (verboseList) {
                this.longFormat((BaseClient)x, tempA, true);
            } else {
                this.say(i + ". " + this.format((BaseClient)x, tempA));
            }
            ++i;
        }
        return entries;
    }

    protected String format(BaseClient client, ClientApproval ca) {
        Object name;
        String rc = null;
        if (ca == null) {
            rc = "(?) " + String.valueOf(client.getIdentifier()) + " ";
        } else {
            boolean isApproved = ca != null && ca.isApproved();
            rc = "(" + (isApproved ? "Y" : "N") + ") " + String.valueOf(client.getIdentifier()) + " ";
        }
        Object object = name = client.getName() == null ? "no name" : client.getName();
        if (20 < ((String)name).length()) {
            name = ((String)name).substring(0, 20) + "...";
        }
        rc = rc + "(" + (String)name + ")";
        rc = rc + " created on " + Iso8601.date2String((Date)client.getCreationTS());
        return rc;
    }

    protected String archiveFormat(Identifiable identifiable) {
        Long version = this.getStoreArchiver().getVersionNumber(identifiable.getIdentifier());
        int fieldWidth = Math.max(5, version.toString().length());
        BaseClient client = (BaseClient)identifiable;
        String caput = "";
        caput = -1L < version ? StringUtils.RJustify((String)version.toString(), (int)fieldWidth) : StringUtils.RJustify((String)" -- ", (int)fieldWidth);
        return "|" + caput + "|  archived on " + String.valueOf(client.getLastModifiedTS());
    }

    protected String format(Identifiable identifiable) {
        BaseClient client = (BaseClient)identifiable;
        ClientApproval ca = (ClientApproval)this.getClientApprovalStore().get((Object)client.getIdentifier());
        return this.format(client, ca);
    }

    protected int longFormat(Identifiable identifiable, boolean isVerbose) {
        BaseClient client = (BaseClient)identifiable;
        ClientApproval ca = (ClientApproval)this.getClientApprovalStore().get((Object)client.getIdentifier());
        return this.longFormat(client, ca, isVerbose);
    }

    protected int longFormat(BaseClient client, ClientApproval clientApproval, boolean isVerbose) {
        int width = super.longFormat((Identifiable)client, isVerbose);
        if (clientApproval == null) {
            clientApproval = (ClientApproval)this.getClientApprovalStore().create();
            clientApproval.setIdentifier(client.getIdentifier());
            clientApproval.setStatus(ClientApproval.Status.PENDING);
            clientApproval.setApproved(false);
            this.getClientApprovalStore().save((Identifiable)clientApproval);
        }
        if (clientApproval.isApproved() && clientApproval.getStatus() != ClientApproval.Status.APPROVED) {
            clientApproval.setStatus(ClientApproval.Status.APPROVED);
        }
        switch (clientApproval.getStatus()) {
            case APPROVED: {
                String approver = "(unknown)";
                if (clientApproval.getApprover() != null) {
                    approver = clientApproval.getApprover();
                }
                this.say(this.formatLongLine("approved by", approver, width, isVerbose));
                break;
            }
            case NONE: {
                this.say(this.formatLongLine("status", "none", width, isVerbose));
                break;
            }
            case PENDING: {
                this.say(this.formatLongLine("status", "pending", width, isVerbose));
                break;
            }
            case DENIED: {
                this.say(this.formatLongLine("status", "approval denied", width, isVerbose));
                break;
            }
            case REVOKED: {
                this.say(this.formatLongLine("status", "revoked", width, isVerbose));
            }
        }
        return width;
    }

    protected void showApproveHelp() {
        this.clientApprovalStoreCommands.showApproveHelp();
    }

    public void approve(InputLine inputLine) throws Throwable {
        String approver;
        if (this.showHelp(inputLine)) {
            this.showApproveHelp();
            return;
        }
        FoundIdentifiables identifiables = this.findItem(inputLine);
        if (identifiables == null || identifiables.isEmpty()) {
            this.say("no clients found");
            return;
        }
        if (inputLine.getArgCount() == 0 && identifiables.size() == 1) {
            this.old_approve(inputLine, (Identifiable)identifiables.get(0));
            return;
        }
        ApprovalModsConfig approvalModsConfig = this.createApprovalModsConfig(inputLine, null, false);
        if (inputLine.hasArg(APPROVER_KEY)) {
            approver = inputLine.getNextArgFor(APPROVER_KEY);
            inputLine.removeSwitchAndValue(APPROVER_KEY);
        } else {
            approver = this.getInput("Enter the name of the approver:", "");
            if (approver.isEmpty()) {
                this.say("approver required, exiting...");
                return;
            }
        }
        boolean approvalFlag = inputLine.hasArg(APPROVE_FLAG);
        Boolean doApproval = true;
        if (approvalFlag) {
            doApproval = inputLine.getBooleanNextArgFor(new String[]{APPROVE_FLAG});
            if (doApproval == null) {
                this.say("unrecognized value for -approved");
                return;
            }
            inputLine.removeSwitchAndValue(APPROVE_FLAG);
        }
        for (Identifiable identifiable : identifiables) {
            BaseClient client;
            approvalModsConfig.client = client = (BaseClient)identifiable;
            client = this.doApprovalMods(approvalModsConfig);
            ClientApprovalStoreCommands.setupApprovalRecord(this.getClientApprovalStore(), client.getIdentifier(), doApproval, approver);
            this.getStore().update((Identifiable)client);
        }
        this.say(identifiables.size() + " clients " + (doApproval != false ? "approved." : "unapproved."));
    }

    protected abstract ApprovalModsConfig createApprovalModsConfig(InputLine var1, BaseClient var2, boolean var3);

    protected void old_approve(InputLine inputLine, Identifiable identifiable) throws Throwable {
        BaseClient client = (BaseClient)identifiable;
        client = this.doApprovalMods(new ApprovalModsConfig(client, true));
        this.approve(client);
    }

    protected void approve(BaseClient client) throws IOException {
        ClientApproval ca = null;
        if (this.getClientApprovalStore().containsKey((Object)client.getIdentifier())) {
            ca = (ClientApproval)this.getClientApprovalStore().get((Object)client.getIdentifier());
        } else {
            ca = (ClientApproval)this.getClientApprovalStore().create();
            ca.setIdentifier(client.getIdentifier());
        }
        if (this.clientApprovalStoreCommands.approve(ca)) {
            this.getStore().save((Identifiable)client);
        }
    }

    protected BaseClient doApprovalMods(ApprovalModsConfig approvalModsConfig) throws IOException {
        return approvalModsConfig.client;
    }

    protected void rmCleanup(FoundIdentifiables x) {
        this.getClientApprovalStore().remove((List)x);
        this.say(x.size() + " approvals removed");
    }

    public void approver_search(InputLine inputLine) {
        if (this.showHelp(inputLine)) {
            this.sayi("approver_search [ -r] approver [-rs rs_name]  - search for all approvals by a given approver.");
            this.sayi("-rs rs_name - save the result set under then name rs_name");
            this.sayi("-r - if present, treat the approver as a regex in the search.");
            this.sayi("Note that this searched for approvers restricted to current store. If you want");
            this.say("to search the entire set of approvers (and have regexes and dates available)");
            this.sayi("you should use the approvers component and do your searches there.");
            this.sayi("See also: search, status_search, rs");
            return;
        }
        boolean saveRS = inputLine.hasArg("-rs");
        String rsName = null;
        if (saveRS) {
            rsName = inputLine.getNextArgFor("-rs");
            inputLine.removeSwitchAndValue("-rs");
        }
        boolean isRegex = inputLine.hasArg("-regex") || inputLine.hasArg("-r");
        inputLine.removeSwitch("-regex");
        inputLine.removeSwitch("-r");
        if (0 == inputLine.getArgCount()) {
            this.say("missing approver. exiting...");
            return;
        }
        String approver = inputLine.getLastArg();
        ClientApprovalKeys caKeys = (ClientApprovalKeys)this.getClientApprovalStore().getMapConverter().getKeys();
        List approvals = this.getClientApprovalStore().search(caKeys.approver(new String[0]), approver, isRegex);
        boolean i = false;
        ArrayList<String> fields = new ArrayList<String>();
        fields.add(caKeys.identifier(new String[0]));
        fields.add(caKeys.approver(new String[0]));
        if (saveRS) {
            StoreCommands2.RSRecord rsRecord = new StoreCommands2.RSRecord(approvals, caKeys.allKeys());
            this.getResultSets().put(rsName, rsRecord);
            this.say("stored " + approvals.size() + " results.");
        } else {
            this.clientApprovalStoreCommands.printRS(inputLine, approvals, fields, null);
        }
    }

    public void status_search(InputLine inputLine) {
        String rawStatus;
        if (this.showHelp(inputLine)) {
            this.sayi("status_search [-size] [-rs rs_name] status - search for all clients with the given status");
            this.sayi("-rs rs_name - save the result set under the given name");
            this.say("-size = just return the number of clients found in the search.");
            this.sayi("status - the status. Allowed ones are");
            this.sayi(StringUtils.RJustify((String)ClientApproval.Status.APPROVED.getStatus(), (int)10) + " or a = approved");
            this.sayi(StringUtils.RJustify((String)ClientApproval.Status.DENIED.getStatus(), (int)10) + " or d = denied");
            this.sayi(StringUtils.RJustify((String)ClientApproval.Status.NONE.getStatus(), (int)10) + " or n = none");
            this.sayi(StringUtils.RJustify((String)ClientApproval.Status.PENDING.getStatus(), (int)10) + " or p = pending");
            this.sayi(StringUtils.RJustify((String)ClientApproval.Status.REVOKED.getStatus(), (int)10) + " or r = revoked");
            this.say("E.g.");
            this.sayi("status_search -rs my_pending p");
            this.say("would search for all pending approvals and save them in the result set named my_pending");
            this.say("See also: search, approver_search, rs");
            return;
        }
        boolean sizeOnly = inputLine.hasArg("-size");
        inputLine.removeSwitch("-size");
        boolean saveRS = inputLine.hasArg("-rs");
        String rsName = null;
        if (saveRS) {
            rsName = inputLine.getNextArgFor("-rs");
            inputLine.removeSwitchAndValue("-rs");
        }
        switch (rawStatus = inputLine.getLastArg()) {
            case "a": {
                rawStatus = ClientApproval.Status.APPROVED.getStatus();
                break;
            }
            case "d": {
                rawStatus = ClientApproval.Status.DENIED.getStatus();
                break;
            }
            case "n": {
                rawStatus = ClientApproval.Status.NONE.getStatus();
                break;
            }
            case "p": {
                rawStatus = ClientApproval.Status.PENDING.getStatus();
                break;
            }
            case "r": {
                rawStatus = ClientApproval.Status.REVOKED.getStatus();
                break;
            }
            default: {
                this.say("unknown status: " + rawStatus);
                return;
            }
        }
        BaseClientStore clientStore = (BaseClientStore)this.getStore();
        List ids = clientStore.getByStatus(rawStatus, this.getClientApprovalStore());
        if (sizeOnly) {
            this.say("there are " + ids.size() + " clients with the status " + rawStatus);
            return;
        }
        ArrayList<Identifiable> acs = new ArrayList<Identifiable>(ids.size());
        int i = 0;
        BigDecimal bd = new BigDecimal(Math.ceil(Math.log10(ids.size())));
        int numberWidth = bd.intValue() + 1;
        for (Identifier id : ids) {
            acs.add((Identifiable)this.getStore().get((Object)id));
            if (saveRS) continue;
            this.say(StringUtils.RJustify((String)(i++ + "."), (int)numberWidth) + " " + id.toString());
        }
        if (saveRS) {
            if (this.getResultSets().containsKey(rsName)) {
                this.getResultSets().remove(rsName);
                this.say("warning: overwriting existing client result set \"" + rsName + "\"");
            }
            this.say("got " + acs.size() + " results");
            this.getResultSets().put(rsName, new StoreCommands2.RSRecord(acs, this.getMapConverter().getKeys().allKeys()));
            return;
        }
        this.say();
        this.say(acs.size() + " clients with status " + rawStatus);
    }

    protected boolean isCARS(String name) {
        return this.clientApprovalStoreCommands.getResultSets().containsKey(name);
    }

    public void password(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("password [byte_count] - create a new random password and show its hash. ");
            this.say("if 0 < byte_count is given, then that will be the number of bytes in the password");
            this.say("The default is 64 bytes if this is omitted");
            this.say("E.g. from the clients component (results will vary):");
            this.say("  clients>password 32\n  password : dmYJJZo82JUPq4ZhAM3zVWWQHjE2A9rEdqeHxRtT-d4\n      hash : 2f11426429bb7ef99d8162d4e0b3a865c2ef796c");
            return;
        }
        int count = 64;
        SecureRandom random = new SecureRandom();
        switch (inputLine.getArgCount()) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    count = Integer.parseInt(inputLine.getLastArg());
                    break;
                }
                catch (Throwable t) {
                    this.say("Could not parse the argument \"" + inputLine.getLastArg() + "\"");
                    return;
                }
            }
            default: {
                this.say("Sorry, too many arguments");
                return;
            }
        }
        byte[] b = new byte[count];
        random.nextBytes(b);
        String password = Base64.encodeBase64URLSafeString((byte[])b);
        this.say("password : " + password);
        this.say("    hash : " + DigestUtils.sha1Hex((String)password));
    }

    public void reset_secret(InputLine inputLine) throws Throwable {
        FoundIdentifiables identifiables;
        if (this.showHelp(inputLine)) {
            this.say("reset_secret [" + RESET_SECRET_NEW_FLAG + " password] [" + RESET_SECRET_SIZE_FLAG + " byte_count] index");
            this.say("resets the current secret. This creates the hash of the new password.");
            this.say(RESET_SECRET_SIZE_FLAG + " = create a random secret with the given number of bytes.");
            this.say(RESET_SECRET_NEW_FLAG + " = explicitly give the secret and hash it.");
            this.say("If you specify both a secret and a size, the size is ignored.");
            this.say("No parameters mean a random secret of " + RESET_SECRET_DEFAULT_SIZE + " bytes (" + RESET_SECRET_DEFAULT_SIZE * 8 + " bits) is created.");
            this.say("The password and secret are always printed.");
            this.printIndexHelp(true);
            this.say("\nE.g. setting the password, be sure to put it in quotes to get the whole thing:\n");
            this.say("clients>reset_secret " + RESET_SECRET_NEW_FLAG + " \"miarzy doats and dozey doats\"");
            this.say("  password : miarzy doats and dozey doats");
            this.say("      hash : 4d6e44b6ddceeccfe15e2f67f356cc09bbcec411");
            return;
        }
        int size = RESET_SECRET_DEFAULT_SIZE;
        boolean hasSize = inputLine.hasArg(RESET_SECRET_SIZE_FLAG);
        if (hasSize) {
            String x = inputLine.getNextArgFor(RESET_SECRET_SIZE_FLAG);
            inputLine.removeSwitchAndValue(RESET_SECRET_SIZE_FLAG);
            try {
                size = Integer.parseInt(x);
            }
            catch (Throwable t) {
                this.say("sorry, could not interpret a size of \"" + x + "\". aborting...");
                return;
            }
            if (size <= 0) {
                this.say("sorry,  size of \"" + size + "\" must be positive. aborting...");
                return;
            }
        }
        if ((identifiables = this.findItem(inputLine)) == null) {
            this.say("no client found.");
        }
        if (!identifiables.isSingleton()) {
            this.say("only a single object is supported for this operation");
            return;
        }
        Object secret = null;
        boolean hasPassword = inputLine.hasArg(RESET_SECRET_NEW_FLAG);
        if (hasPassword) {
            secret = inputLine.getNextArgFor(RESET_SECRET_NEW_FLAG);
            inputLine.removeSwitchAndValue(RESET_SECRET_NEW_FLAG);
        }
        BaseClient client = (BaseClient)identifiables.get(0);
        if (!hasPassword) {
            byte[] y = new byte[size];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(y);
            secret = Base64.encodeBase64URLSafeString((byte[])y);
        }
        if (StringUtils.isTrivial((String)secret)) {
            this.say("sorry but could not determine a secret for client '" + String.valueOf(client.getIdentifier()) + "'");
            return;
        }
        String hash = DigestUtils.sha1Hex((String)secret);
        client.setSecret(hash);
        this.getStore().save((Identifiable)client);
        if (-1 < ((String)secret).indexOf(" ")) {
            secret = "\"" + (String)secret + "\"";
        }
        this.say("client_id : " + client.getIdentifierString());
        this.say("   secret : " + (String)secret);
        this.say("     hash : " + hash);
    }

    public void create(InputLine inputLine) throws IOException {
        BaseClient client = (BaseClient)this.actualCreate(inputLine, 0);
        if (client == null) {
            return;
        }
        if (this.isOk(this.readline("approve this client [y/n]?"))) {
            this.approve(client);
        }
    }

    @Override
    public void extraUpdates(Identifiable identifiable, int magicNumber) throws IOException {
        String keyOrSecret;
        BaseClient client = (BaseClient)identifiable;
        BaseClientKeys keys = (BaseClientKeys)this.getSerializationKeys();
        client.setName(this.getPropertyHelp(keys.name(new String[0]), "enter name", client.getName()));
        client.setEmail(this.getPropertyHelp(keys.email(new String[0]), "enter email", client.getEmail()));
        switch (keyOrSecret = this.getPropertyHelp(keys.secret(new String[0]), "enter a key, secret or URI (k|s|u) or return to skip", "")) {
            case "k": 
            case "K": {
                this.getPublicKeyFile(client, keys);
                break;
            }
            case "s": 
            case "S": {
                this.getSecret(client, keys);
                break;
            }
            case "u": 
            case "U": {
                String rr = this.getPropertyHelp(keys.jwksURI(new String[0]), "  enter JWKS uri", "");
                if (this.isEmpty(rr)) {
                    this.say("   skipped");
                    break;
                }
                client.setJwksURI(URI.create(rr));
                break;
            }
            case "": {
                break;
            }
            default: {
                this.say("unknown option \"" + keyOrSecret + "\"");
            }
        }
    }

    protected void getSecret(BaseClient client, BaseClientKeys keys) throws IOException {
        String input = this.getPropertyHelp(keys.secret(new String[0]), "  enter a new secret or return to skip.", client.getSecret());
        if (this.isEmpty(input)) {
            return;
        }
        String secret = DigestUtils.sha1Hex((String)input);
        client.setSecret(secret);
    }

    protected void getPublicKeyFile(BaseClient client, BaseClientKeys keys) throws IOException {
        String fileNotFoundMessage = "  ...uh-oh, I can't find that file. Please enter it again";
        Object secret = client.getSecret();
        if (!this.isEmpty((String)secret)) {
            secret = ((String)secret).substring(0, Math.min(25, ((String)secret).length())) + "...";
        }
        boolean askForFile = true;
        while (askForFile) {
            String input = this.getPropertyHelp(keys.jwks(new String[0]), "  enter full path and file name of public key", (String)secret);
            if (this.isEmpty(input)) {
                return;
            }
            if (input.equals(secret)) {
                this.sayi(" public key entry skipped.");
                return;
            }
            if (input == null) continue;
            File f = new File(input);
            if (!f.exists()) {
                this.say(fileNotFoundMessage);
                continue;
            }
            try {
                client.setJWKS(JSONWebKeyUtil.fromJSON((File)f));
                askForFile = false;
            }
            catch (Throwable e) {
                this.say("error reading file \"" + input + "\", try again");
                return;
            }
        }
    }

    public StoreCommands2.ChangeIDRecord doChangeID(Identifiable identifiable, Identifier newID, boolean updatePermissions) {
        StoreCommands2.ChangeIDRecord changeIDRecord = super.doChangeID(identifiable, newID, updatePermissions);
        ClientApproval clientApproval = (ClientApproval)this.getClientApprovalStore().get((Object)changeIDRecord.oldID);
        if (clientApproval == null) {
            clientApproval = (ClientApproval)this.getClientApprovalStore().create();
        } else {
            this.getClientApprovalStore().remove((Object)changeIDRecord.oldID);
        }
        clientApproval.setIdentifier(newID);
        this.getClientApprovalStore().save((Identifiable)clientApproval);
        return changeIDRecord;
    }

    public static class ApprovalModsConfig {
        public BaseClient client;
        public boolean doPrompt = true;

        public ApprovalModsConfig(BaseClient client, boolean doPrompt) {
            this.client = client;
            this.doPrompt = doPrompt;
        }
    }
}

