/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.CommonCommands2;
import edu.uiuc.ncsa.security.util.cli.ComponentManager;
import edu.uiuc.ncsa.security.util.cli.ConfigurableCommandsImpl2;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.oa4mp.server.admin.oauth2.base.ClientApprovalStoreCommands;
import org.oa4mp.server.admin.oauth2.base.ClientStoreCommands;
import org.oa4mp.server.admin.oauth2.base.CopyCommands;
import org.oa4mp.server.admin.oauth2.base.OA4MPStoreCommands;
import org.oa4mp.server.admin.oauth2.tools.TransactionStoreCommands;
import org.oa4mp.server.api.ServiceEnvironment;

public abstract class BaseCommands2
extends ConfigurableCommandsImpl2
implements ComponentManager {
    public static final String CLIENTS = "clients";
    public static final String CLIENT_APPROVALS = "approvals";
    public static final String COPY = "copy";
    public String TRANSACTION_COMMAND = "transactions";
    protected Map<String, CLIDriver> drivers = new HashMap<String, CLIDriver>();
    protected boolean showHeader = true;
    protected boolean showLogo = true;
    protected String logoName = "times";

    public void initialize() {
        try {
            if (this.drivers.isEmpty()) {
                this.drivers.put(CLIENTS, this.createCLIDriver((CommonCommands2)this.getClientCommands()));
                this.drivers.put(CLIENT_APPROVALS, this.createCLIDriver((CommonCommands2)this.getClientApprovalCommands()));
                this.drivers.put(this.TRANSACTION_COMMAND, this.createCLIDriver((CommonCommands2)this.getTransactionCommands()));
            }
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new GeneralException("Unable to initialize CLI components", t);
        }
    }

    public Set<String> listComponents() {
        return this.drivers.keySet();
    }

    public abstract void about();

    public abstract ClientStoreCommands getClientCommands() throws Throwable;

    public abstract CopyCommands getCopyCommands() throws Throwable;

    protected abstract TransactionStoreCommands getTransactionCommands() throws Throwable;

    public BaseCommands2(CLIDriver driver) {
        super(driver);
    }

    public String getComponentName() {
        return "service";
    }

    protected void startup(String[] args) throws Throwable {
        this.bootstrap(new InputLine(args));
    }

    public ServiceEnvironment getServiceEnvironment() throws Exception {
        return (ServiceEnvironment)this.getEnvironment();
    }

    public ClientApprovalStoreCommands getClientApprovalCommands() throws Throwable {
        return new ClientApprovalStoreCommands(this.getDriver(), "  ", (Store)this.getServiceEnvironment().getClientApprovalStore());
    }

    public boolean use(InputLine inputLine) throws Throwable {
        OA4MPStoreCommands commands = null;
        if (inputLine.hasArg(CLIENTS)) {
            commands = this.getClientCommands();
        }
        if (inputLine.hasArg(CLIENT_APPROVALS)) {
            commands = this.getClientApprovalCommands();
        }
        if (inputLine.hasArg(this.TRANSACTION_COMMAND)) {
            commands = this.getTransactionCommands();
        }
        if (commands != null) {
            return this.switchOrRun(inputLine, (CommonCommands2)commands);
        }
        if (super.use(inputLine)) {
            return true;
        }
        this.say("could not find the component named \"" + inputLine.getArg(1) + "\". Type 'use --help' for help");
        return false;
    }

    protected CLIDriver createCLIDriver(CommonCommands2 commands) {
        CLIDriver cli = new CLIDriver();
        cli.setIOInterface(this.getDriver().getIOInterface());
        cli.addCommands(new Commands[]{commands});
        cli.setEnv(this.getDriver().getEnv());
        cli.setComponentManager((ComponentManager)this);
        return cli;
    }

    protected boolean hasComponent(String componentName) {
        return componentName.equals(CLIENTS) || componentName.equals(CLIENT_APPROVALS) || componentName.equals(COPY);
    }

    protected void runComponent(String componentName) throws Throwable {
        Object commonCommands = null;
        if (componentName.equals(CLIENTS)) {
            commonCommands = this.getClientCommands();
        }
        if (componentName.equals(CLIENT_APPROVALS)) {
            commonCommands = this.getClientApprovalCommands();
        }
        if (componentName.equals(COPY)) {
            commonCommands = this.getCopyCommands();
        }
        if (commonCommands != null) {
            CLIDriver cli = new CLIDriver(new Commands[]{commonCommands});
            cli.start();
        }
    }

    public void useHelp() {
        this.say("Choose the component you wish to use.");
        this.say("you specify the component as use + name. Supported components are");
        this.say("clients - edit client records");
        this.say("approvals - edit client approval records\n");
        this.say("copy - copy an entire store.\n");
        this.say("e.g.\n\nuse clients\n\nwill call up the client management component.");
        this.say("Type 'exit' or /q when you wish to exit the component and return to the main menu");
    }
}

