/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.cli.FoundIdentifiables;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.oa4mp.delegation.common.storage.clients.ClientApprovalKeys;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientApprovalStore;
import org.oa4mp.server.admin.oauth2.base.OA4MPStoreCommands;

public class ClientApprovalStoreCommands
extends OA4MPStoreCommands {
    public static final String SHOW_UNAPPROVED_FLAG = "-n";

    public ClientApprovalStoreCommands(CLIDriver driver, String defaultIndent, Store store) throws Throwable {
        super(driver, defaultIndent, store);
    }

    public ClientApprovalStoreCommands(CLIDriver driver, Store store) throws Throwable {
        super(driver, store);
    }

    protected String format(Identifiable identifiable) {
        if (identifiable == null) {
            return "(null)";
        }
        ClientApproval ca = (ClientApproval)identifiable;
        String statusString = "?";
        switch (ca.getStatus()) {
            case APPROVED: {
                statusString = "A";
                break;
            }
            case DENIED: {
                statusString = "D";
                break;
            }
            case REVOKED: {
                statusString = "R";
                break;
            }
        }
        String x = "(" + statusString + ") " + ca.getIdentifierString();
        if (ca.isApproved() || ca.getStatus() == ClientApproval.Status.APPROVED) {
            x = x + " by \"" + ca.getApprover() + "\" on " + String.valueOf(ca.getApprovalTimestamp());
        }
        return x;
    }

    public String getName() {
        return "  approvals";
    }

    public boolean update(Identifiable identifiable) throws IOException {
        ClientApproval clientApproval = (ClientApproval)identifiable;
        ClientApprovalKeys keys = (ClientApprovalKeys)this.getSerializationKeys();
        this.info("Starting update for client approval id=" + identifiable.getIdentifierString());
        this.sayi("Enter the information for the client approval");
        clientApproval.setApprover(this.getPropertyHelp(keys.approver(new String[0]), "name of the approver", clientApproval.getApprover()));
        clientApproval.setApprovalTimestamp(new Date());
        boolean isapproved = this.isOk(this.getPropertyHelp(keys.approved(new String[0]), "set approved?", clientApproval.isApproved() ? "y" : "n"));
        if (isapproved) {
            clientApproval.setApproved(true);
            clientApproval.setStatus(ClientApproval.Status.APPROVED);
        } else {
            clientApproval.setApproved(false);
            switch (clientApproval.getStatus()) {
                case PENDING: 
                case NONE: {
                    clientApproval.setStatus(ClientApproval.Status.DENIED);
                    break;
                }
                case APPROVED: {
                    clientApproval.setStatus(ClientApproval.Status.REVOKED);
                    break;
                }
            }
        }
        this.sayi("save changes [y/n]?");
        if (this.isOk(this.readline())) {
            this.say(clientApproval.toString());
            return true;
        }
        this.sayi("save cancelled");
        this.info("Approval update cancelled for id=" + clientApproval.getIdentifierString());
        return false;
    }

    public void showApproveHelp() {
        this.say("approve index");
        this.say("This is the simple case of approving a client or set of them.");
        this.say("If you need to set the status to something other than 'approved',");
        this.say("use the set_status command.");
        this.say("Some components may prompt you for changes to the client as well.");
        this.say("The approval record will be for that client");
        this.printIndexHelp(false);
        this.say("\nSee also: set_status");
    }

    public void approve(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showApproveHelp();
            return;
        }
        int pass = 0;
        int fail = 0;
        boolean isapproved = this.isOk(this.getInput("set approved?", "y"));
        String approver = this.getInput("approver", "");
        FoundIdentifiables identifiables = this.findItem(inputLine);
        for (Identifiable identifiable : identifiables) {
            if (this.approve((ClientApproval)identifiable, isapproved, approver)) {
                ++pass;
                continue;
            }
            ++fail;
        }
        this.say("Approved " + pass + ", denied " + fail);
    }

    public void set_status(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("set_status [new_status] index - this will set the status for the given/current record(s).");
            this.say("This is more reliable than simply updating the status property manually.");
            this.say("If new_status is given, then it will be set to that and the previous status displayed.");
            this.say("If new_status is missing, you will be prompted. Allowed values for new_status are");
            this.printIndexHelp(false);
            this.say("a | approved");
            this.say("d | denied");
            this.say("n | none");
            this.say("p | pending");
            this.say("r | revoked");
            this.say("\nand any value not on this list is rejected.");
            return;
        }
        FoundIdentifiables item = this.findItem(inputLine);
        if (item == null) {
            this.say("sorry, no record found.");
            return;
        }
        String newStatus = null;
        newStatus = inputLine.getArgCount() == 0 ? this.getInput("enter new status", "a") : inputLine.getLastArg();
        for (Identifiable i : item) {
            ClientApproval approval = (ClientApproval)i;
            if (item.isRS()) {
                approval = (ClientApproval)this.getStore().get((Object)approval.getIdentifierString());
            }
            switch (newStatus) {
                case "a": 
                case "approved": {
                    approval.setStatus(ClientApproval.Status.APPROVED);
                    approval.setApproved(true);
                    break;
                }
                case "d": 
                case "denied": {
                    approval.setStatus(ClientApproval.Status.DENIED);
                    approval.setApproved(false);
                    break;
                }
                case "n": 
                case "none": {
                    approval.setStatus(ClientApproval.Status.NONE);
                    approval.setApproved(false);
                    break;
                }
                case "p": 
                case "pending": {
                    approval.setStatus(ClientApproval.Status.PENDING);
                    approval.setApproved(false);
                    break;
                }
                case "r": 
                case "revoked": {
                    approval.setStatus(ClientApproval.Status.REVOKED);
                    approval.setApproved(false);
                    break;
                }
                default: {
                    this.say("unrecognized status \"" + newStatus + "\".");
                    return;
                }
            }
            this.getStore().save((Identifiable)approval);
        }
        this.say("done!");
    }

    public boolean approve(ClientApproval ca) throws IOException {
        boolean isapproved = this.isOk(this.getInput("set approved?", ca.isApproved() ? "y" : "n"));
        String approver = this.getInput("approver", ca.getApprover());
        return this.approve(ca, isapproved, approver);
    }

    public static ClientApproval setupApprovalRecord(ClientApprovalStore caStore, Identifier identifier, boolean isapproved, String approver) throws IOException {
        ClientApproval ca;
        boolean wasCreated = false;
        if (caStore.containsKey((Object)identifier)) {
            ca = (ClientApproval)caStore.get((Object)identifier);
        } else {
            ca = (ClientApproval)caStore.create();
            ca.setIdentifier(identifier);
            wasCreated = true;
        }
        ClientApprovalStoreCommands.setupApprovalRecord(ca, isapproved, approver);
        if (wasCreated) {
            caStore.save((Identifiable)ca);
        } else {
            caStore.update((Identifiable)ca);
        }
        return ca;
    }

    protected boolean approve(ClientApproval ca, boolean isapproved, String approver) throws IOException {
        ClientApprovalStoreCommands.setupApprovalRecord(ca, isapproved, approver);
        if (this.isOk(this.readline("save this approval record [y/n]?"))) {
            this.getStore().save((Identifiable)ca);
            this.sayi("approval saved");
            this.info("Approval for id = " + ca.getIdentifierString() + " saved");
            return true;
        }
        this.sayi("approval was not saved.");
        this.info("Approval cancelled for id=" + ca.getIdentifierString());
        return false;
    }

    public static void setupApprovalRecord(ClientApproval ca, boolean isapproved, String approver) {
        ca.setApprover(approver);
        if (isapproved) {
            ca.setApproved(true);
            ca.setStatus(ClientApproval.Status.APPROVED);
        } else {
            ca.setApproved(false);
            switch (ca.getStatus()) {
                case PENDING: 
                case NONE: {
                    ca.setStatus(ClientApproval.Status.DENIED);
                    break;
                }
                case APPROVED: {
                    ca.setStatus(ClientApproval.Status.REVOKED);
                    break;
                }
            }
        }
    }

    protected void show(boolean showApproved, String regex) throws Exception {
        this.say("showing " + (showApproved ? "" : "un") + "approved entries");
        List approvals = this.getStore().getAll();
        Pattern p = null;
        if (!StringUtils.isTrivial((String)regex)) {
            p = Pattern.compile(regex);
        }
        int i = 0;
        for (ClientApproval ca : approvals) {
            Matcher m;
            if (p != null && !(m = p.matcher(ca.getIdentifierString())).matches()) continue;
            if (showApproved) {
                if (!ca.isApproved()) continue;
                this.say(this.format((Identifiable)ca));
                ++i;
                continue;
            }
            if (ca.isApproved()) continue;
            this.say(this.format((Identifiable)ca));
            ++i;
        }
        this.say(i + (showApproved ? " " : " un") + "approved entries found");
    }

    public void show(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("show [-n] [-r regex]");
            this.sayi("Show either all the approved or unapproved records");
            this.sayi("-n - show only unapproved records");
            this.sayi("-r - apply the regular expression to the identifier");
            this.say("E.g.");
            this.sayi("show -r qdl.*");
            this.sayi("shows all approved clients whose identifier starts with qdl");
            this.sayi("show -n -r qdl.*");
            this.sayi("shows all UNapproved clients whose identifier starts with qdl");
        }
        boolean showApproved = !inputLine.hasArg(SHOW_UNAPPROVED_FLAG);
        inputLine.removeSwitch(SHOW_UNAPPROVED_FLAG);
        String regex = null;
        if (inputLine.hasArg("-r")) {
            regex = inputLine.getNextArgFor("-r");
            inputLine.removeSwitchAndValue("-r");
        }
        this.show(showApproved, regex);
    }

    protected void initHelp() throws Throwable {
        super.initHelp();
        this.getHelpUtil().load("/help/approver_help.xml");
    }

    public void change_id(InputLine inputLine) throws Throwable {
        this.say("Changing IDs for client approvals is not supported since the client shares the same id. ");
        this.say("Change the id of the client and the approvals will be updated automatically.");
    }

    protected int updateStorePermissions(Identifier newID, Identifier oldID, boolean copy) {
        throw new UnsupportedOperationException("Not supported for approvals.");
    }
}

