/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.util.cli.BasicSorter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import org.oa4mp.delegation.common.storage.clients.BaseClient;

public class ClientSorter
extends BasicSorter {
    public static final String ID_SORT_SWITCH = "i";
    public static final String DATE_SORT_SWITCH = "d";
    protected boolean sortOnIds = false;
    protected boolean sortOnDates = true;

    protected ArrayList<Identifiable> sortByDate(List<Identifiable> arg) {
        TreeMap tm = new TreeMap();
        for (int i = 0; i < arg.size(); ++i) {
            BaseClient client = (BaseClient)arg.get(i);
            String key = Iso8601.date2String((Date)client.getCreationTS());
            if (tm.containsKey(key)) {
                ((ArrayList)tm.get(key)).add(client);
                continue;
            }
            ArrayList<BaseClient> x = new ArrayList<BaseClient>();
            x.add(client);
            tm.put(key, x);
        }
        ArrayList<Identifiable> outList = new ArrayList<Identifiable>();
        for (String key : tm.keySet()) {
            outList.addAll((Collection)tm.get(key));
        }
        return outList;
    }

    protected ArrayList<Identifiable> sortByID(List<Identifiable> arg) {
        TreeMap<String, BaseClient> tm = new TreeMap<String, BaseClient>();
        for (int i = 0; i < arg.size(); ++i) {
            BaseClient client = (BaseClient)arg.get(i);
            tm.put(client.getIdentifierString(), client);
        }
        return new ArrayList<Identifiable>(tm.values());
    }

    public ArrayList<Identifiable> sort(List<Identifiable> arg) {
        if (this.sortOnIds) {
            return this.sortByID(arg);
        }
        if (this.sortOnDates) {
            return this.sortByDate(arg);
        }
        return new ArrayList<Identifiable>();
    }

    public void setState(String args) {
        if (args == null || !args.startsWith("-")) {
            return;
        }
        if (args.contains(ID_SORT_SWITCH)) {
            this.sortOnIds = true;
            this.sortOnDates = false;
            return;
        }
        if (args.contains(DATE_SORT_SWITCH)) {
            this.sortOnIds = false;
            this.sortOnDates = true;
            return;
        }
    }
}

