/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.Sortable;
import java.io.IOException;
import org.oa4mp.delegation.common.storage.clients.Client;
import org.oa4mp.delegation.common.storage.clients.ClientKeys;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.server.admin.oauth2.base.BaseClientStoreCommands;
import org.oa4mp.server.admin.oauth2.base.ClientApprovalStoreCommands;
import org.oa4mp.server.admin.oauth2.base.ClientSorter;

public abstract class ClientStoreCommands
extends BaseClientStoreCommands {
    public ClientStoreCommands(CLIDriver driver, String defaultIndent, Store clientStore, ClientApprovalStoreCommands clientApprovalStoreCommands) throws Throwable {
        super(driver, defaultIndent, clientStore, clientApprovalStoreCommands);
    }

    public ClientStoreCommands(CLIDriver driver, Store store) throws Throwable {
        super(driver, store);
        this.setSortable((Sortable)new ClientSorter());
    }

    public String getName() {
        return "  clients";
    }

    protected int longFormat(Identifiable identifiable) {
        return this.longFormat(identifiable, false);
    }

    public boolean update(Identifiable identifiable) throws IOException {
        Client client = (Client)identifiable;
        ClientKeys keys = (ClientKeys)this.getMapConverter().getKeys();
        String newIdentifier = null;
        this.info("Starting client update for id = " + client.getIdentifierString());
        this.say("Update the values. A return accepts the existing or default value in []'s");
        newIdentifier = this.getPropertyHelp(keys.identifier(new String[0]), "enter the identifier", client.getIdentifierString());
        boolean removeCurrentClient = false;
        Identifier oldID = client.getIdentifier();
        client.setName(this.getPropertyHelp(keys.name(new String[0]), "enter the name", client.getName()));
        client.setEmail(this.getPropertyHelp(keys.email(new String[0]), "enter email", client.getEmail()));
        client.setErrorUri(this.getPropertyHelp(keys.errorURL(new String[0]), "enter error url", client.getErrorUri()));
        client.setHomeUri(this.getPropertyHelp(keys.homeURL(new String[0]), "enter home url", client.getHomeUri()));
        client.setProxyLimited(this.isOk(this.getPropertyHelp(keys.proxyLimited(new String[0]), "does this client require limited proxies?", client.isProxyLimited() ? "y" : "n")));
        this.extraUpdates((Identifiable)client, 0);
        this.sayi("here is the complete client:");
        this.longFormat((Identifiable)client);
        if (!newIdentifier.equals(client.getIdentifierString())) {
            removeCurrentClient = this.isOk(this.readline(" remove client with id=\"" + String.valueOf(client.getIdentifier()) + "\" [y/n]? "));
            client.setIdentifier(BasicIdentifier.newID((String)newIdentifier));
        }
        if (this.isOk(this.readline("save [y/n]?"))) {
            if (removeCurrentClient) {
                this.info("removing client with id = " + String.valueOf(oldID));
                this.getStore().remove((Object)client.getIdentifier());
                this.sayi("client with id " + String.valueOf(oldID) + " removed. Be sure to save any changes.");
            }
            this.sayi("client updated.");
            this.info("Client with id " + client.getIdentifierString() + " saving...");
            return true;
        }
        this.sayi("client not updated, losing changes...");
        this.info("User terminated updates for client with id " + client.getIdentifierString());
        return false;
    }

    private void cloneApproval(Identifier srcID, Identifier targetID) {
        ClientApproval oldCA = (ClientApproval)this.getClientApprovalStore().get((Object)srcID);
        ClientApproval newCA = (ClientApproval)oldCA.clone();
        newCA.setIdentifier(targetID);
        this.getClientApprovalStore().save((Identifiable)newCA);
    }

    protected Identifier doCopy(Identifiable source, Identifier targetId, boolean useRandomID) {
        Identifier id = super.doCopy(source, targetId, useRandomID);
        this.cloneApproval(source.getIdentifier(), id);
        return id;
    }

    @Override
    public void extraUpdates(Identifiable identifiable, int magicNumber) throws IOException {
        super.extraUpdates(identifiable, magicNumber);
        Client client = (Client)identifiable;
        ClientKeys keys = (ClientKeys)this.getMapConverter().getKeys();
        client.setHomeUri(this.getPropertyHelp(keys.homeURL(new String[0]), "enter home url", client.getHomeUri()));
    }
}

