/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.CommonCommands2;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import org.oa4mp.server.admin.oauth2.base.CopyTool;
import org.oa4mp.server.admin.oauth2.base.CopyToolVerifier;

public class CopyCommands
extends CommonCommands2 {
    String configFile;
    public static final String VERIFY_OPTION = "-verify";
    CopyToolVerifier verifier;
    CopyTool copyTool;

    public CopyCommands(CLIDriver driver, CopyTool copyTool, CopyToolVerifier verifier, String configFile) throws Throwable {
        super(driver);
        this.configFile = configFile;
        this.copyTool = copyTool;
        this.verifier = verifier;
    }

    public void about(boolean showBanner, boolean showHeader) {
    }

    public void initialize() throws Throwable {
    }

    public void load(InputLine inputLine) throws Throwable {
    }

    public String getName() {
        return "copy";
    }

    public String getPrompt() {
        return this.getName() + ">";
    }

    protected void showCpHelp() {
        this.sayi("This command copies one store to another. At the end of this operation the");
        this.sayi("target store will be identical to the source, so yes, this will destroy the target");
        this.sayi("store.Syntax is\n");
        this.sayi("cp source target [-verify]\n");
        this.sayi("where source and target are the names of configurations in the currently active configuration file");
        this.sayi("If you supply the verify option, then the target and source content will be checked against each other");
        this.sayi("to ensure they match. Warning:This can be slow, depending on the store involved.");
        this.sayi("If you need more functionality (such as the ability to use this with multiple configuration files)");
        this.sayi("then you should use the dedicated command line tool for this.");
        this.sayi("If you are using an SQL store, just use the built in database tools for that.");
        this.sayi("then you should also use the SQL store tool for that.");
        this.sayi("This is intended for moving e.g. one file store to another, or dumping an in-memory store to disk");
        this.sayi("i.e. moving between stores that do not have such tools.");
    }

    public void cp(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showCpHelp();
            return;
        }
        if (inputLine.size() < 3) {
            this.sayi("Sorry, you don't have enough arguments for me to be sure what you want.");
            this.showCpHelp();
            return;
        }
        String source = inputLine.getArg(1);
        String target = inputLine.getArg(2);
        boolean verify = false;
        if (inputLine.size() == 4) {
            verify = inputLine.getArg(3).equals(VERIFY_OPTION);
        }
        this.sayi("Verification is " + (verify ? "on" : "off"));
        this.info("Copy tool, verifications " + (verify ? "on" : "off"));
        String p = "Are you sure you want to copy  " + source + " to " + target + ", erasing the current contents of " + target + "? [y|n]";
        if (!this.isOk(this.readline(p))) {
            this.sayi("User cancelled. aborting copy with no changes.");
            this.info("User aborted copy.");
            return;
        }
        String[] args = new String[]{"-cfg", this.configFile, "-s", inputLine.getArg(1), "-t", inputLine.getArg(2), "-v"};
        this.getCopyTool().run(args);
        if (verify) {
            this.getVerifier().verifyStores(this.getCopyTool().getSourceEnv(), this.getCopyTool().getTargetEnv());
        }
        this.sayi("done!");
    }

    public CopyToolVerifier getVerifier() {
        if (this.verifier == null) {
            this.verifier = new CopyToolVerifier();
        }
        return this.verifier;
    }

    public CopyTool getCopyTool() {
        if (this.copyTool == null) {
            this.copyTool = new CopyTool();
        }
        return this.copyTool;
    }

    public void setCopyTool(CopyTool copyTool) {
        this.copyTool = copyTool;
    }
}

