/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.util.cli.CLITool2;
import edu.uiuc.ncsa.security.util.configuration.XMLConfigUtil;
import java.util.Map;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.oa4mp.server.admin.oauth2.base.CopyExtension;
import org.oa4mp.server.api.ServiceEnvironmentImpl;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;

public class CopyTool
extends CLITool2 {
    CopyExtension copyExtension;
    public static final String SOURCE_CONFIG_NAME_OPTION = "s";
    public static final String SOURCE_CONFIG_NAME_LONG_OPTION = "sourceConfigName";
    public static final String SOURCE_CONFIG_FILE_OPTION = "cfg";
    public static final String SOURCE_CONFIG_FILE_LONG_OPTION = "configFile";
    public static final String TARGET_CONFIG_FILE_OPTION = "tcfg";
    public static final String TARGET_CONFIG_FILE_LONG_OPTION = "targetConfigFile";
    public static final String TARGET_CONFIG_NAME_OPTION = "t";
    public static final String TARGET_CONFIG_NAME_LONG_OPTION = "targetConfigName";
    ServiceEnvironmentImpl srcEnv;
    ServiceEnvironmentImpl targetEnv;

    public ConfigurationLoader<? extends AbstractEnvironment> getLoader() throws Exception {
        return new OA2ConfigurationLoader(this.getConfigurationNode());
    }

    public CopyTool(ServiceEnvironmentImpl srcEnv, ServiceEnvironmentImpl targetEnv) {
        this.srcEnv = srcEnv;
        this.targetEnv = targetEnv;
    }

    public CopyExtension getCopyExtension() {
        if (this.copyExtension == null) {
            this.copyExtension = new CopyExtension();
        }
        return this.copyExtension;
    }

    public void setCopyExtension(CopyExtension copyExtension) {
        this.copyExtension = copyExtension;
    }

    public CopyTool() {
    }

    public ServiceEnvironmentImpl getSourceEnv() {
        if (this.srcEnv == null) {
            this.srcEnv = this.getEnv(SOURCE_CONFIG_FILE_OPTION, SOURCE_CONFIG_NAME_OPTION);
        }
        return this.srcEnv;
    }

    public ServiceEnvironmentImpl getTargetEnv() {
        if (this.targetEnv == null) {
            this.targetEnv = this.getEnv(TARGET_CONFIG_FILE_OPTION, TARGET_CONFIG_NAME_OPTION);
        }
        return this.targetEnv;
    }

    protected ServiceEnvironmentImpl getEnv(String cfgFileOption, String cfgNameOption) {
        String configName;
        if (this.getInputLine().getNextArgFor(SOURCE_CONFIG_NAME_OPTION).equals(this.getInputLine().getNextArgFor(TARGET_CONFIG_NAME_OPTION))) {
            throw new MyConfigurationException("Error! You have specified that source and target as the same.");
        }
        String fileName = this.getInputLine().getNextArgFor(cfgFileOption);
        if (fileName == null) {
            fileName = this.getInputLine().getNextArgFor(SOURCE_CONFIG_FILE_OPTION);
        }
        this.sayv("loading configuration \"" + ((configName = this.getInputLine().getNextArgFor(cfgNameOption)) == null ? "(none)" : configName) + "\" from file " + fileName);
        ConfigurationNode node = XMLConfigUtil.findConfiguration((String)fileName, (String)this.getInputLine().getNextArgFor(cfgNameOption), (String)"service");
        ConfigurationLoader<? extends AbstractEnvironment> loader = null;
        this.setConfigurationNode(node);
        try {
            loader = this.getLoader();
        }
        catch (Exception e) {
            throw new GeneralException(" Could not get loader", (Throwable)e);
        }
        ServiceEnvironmentImpl env = (ServiceEnvironmentImpl)loader.load();
        return env;
    }

    protected int doItWithState(int totalRecs) {
        return this.getCopyExtension().copy(totalRecs);
    }

    public void setEnvironment(AbstractEnvironment environment) {
        super.setEnvironment(environment);
        this.targetEnv = (ServiceEnvironmentImpl)environment;
        this.srcEnv = (ServiceEnvironmentImpl)environment;
    }

    public void doIt() throws Exception {
        long startTime = System.currentTimeMillis();
        int totalRecs = 0;
        int currentRecCount = this.getSourceEnv().getClientApprovalStore().size();
        totalRecs += currentRecCount;
        this.sayv("Copying " + currentRecCount + " client approvals...");
        this.wipeAndCopy((Store)this.getSourceEnv().getClientApprovalStore(), (Store)this.getTargetEnv().getClientApprovalStore());
        currentRecCount = this.getSourceEnv().getClientStore().size();
        totalRecs += currentRecCount;
        this.sayv("Copying " + currentRecCount + " clients...");
        this.wipeAndCopy((Store)this.getSourceEnv().getClientStore(), (Store)this.getTargetEnv().getClientStore());
        totalRecs = this.doItWithState(totalRecs);
        this.sayv("Done! (" + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " sec., " + totalRecs + " total items.)");
    }

    public String getComponentName() {
        return "service";
    }

    public void help() {
    }

    public void wipeAndCopy(Store source, Store target) {
        target.clear();
        target.putAll((Map)source);
    }

    public void initialize() throws Exception {
    }
}

