/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import org.oa4mp.server.admin.oauth2.base.CopyTool;
import org.oa4mp.server.api.ServiceEnvironmentImpl;

public class CopyToolVerifier {
    protected CopyTool copyTool;

    public CopyTool getCopyTool() {
        if (this.copyTool == null) {
            this.copyTool = new CopyTool();
        }
        return this.copyTool;
    }

    public void doIt(CopyTool adminTool, String[] args) {
        try {
            adminTool.run(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.say("Error! Could not copy store. Verificatiohn aborted.");
            return;
        }
        this.say("Preparing to check stores.");
        try {
            if (this.verifyStores(adminTool.getSourceEnv(), adminTool.getTargetEnv())) {
                this.say("Done! All checks passed.");
            }
        }
        catch (Throwable t) {
            this.say("There was an exception encountered while trying to process this. Check the copy logs for more information");
            adminTool.getMyLogger().error("Error verifying copy!", t);
        }
    }

    public static void main(String[] args) {
        CopyToolVerifier cctv = new CopyToolVerifier();
        if (args == null || args.length == 0) {
            cctv.printHelp();
            return;
        }
        cctv.doIt(cctv.getCopyTool(), args);
    }

    public void printHelp() {
        this.say("OA4MP copy tool verifier.");
        this.say("\njava -jar oa4mp-cp-verifier [args]\n");
        this.say("Where the arguments are identical to what you would supply in the copy tool.");
        this.say("This tool will execute a full copy of the source store to the target store.");
        this.say("It will then check that each copied store is identical to the source.");
        this.say("This is designed to be a complete and low-level check that looks at *every*");
        this.say("single entry in both stores and compares them. It is therefore not designed to be a standard tool");
        this.say("but is useful mostly for debugging the copy tool. You could also use it to ");
        this.say("copy a store to a file store or memory store to check that the copy tool works.");
        this.say("For large stores this is very slow and you should have a good reason for running this tool...");
    }

    public boolean verifyStores(ServiceEnvironmentImpl sEnv, ServiceEnvironmentImpl tEnv) {
        if (!this.verifyStore("clients", (Store<? extends Identifiable>)sEnv.getClientStore(), (Store<? extends Identifiable>)tEnv.getClientStore())) {
            return false;
        }
        return this.verifyStore("client approvals", (Store<? extends Identifiable>)sEnv.getClientApprovalStore(), (Store<? extends Identifiable>)tEnv.getClientApprovalStore());
    }

    public boolean verifyStore(String storeName, Store<? extends Identifiable> source, Store<? extends Identifiable> target) {
        long srcSize = source.size();
        if (srcSize != (long)target.size()) {
            this.say(" Source \"" + String.valueOf(source) + "\"(" + srcSize + ") and target \"" + String.valueOf(target) + "\"(" + target.size() + ") are not the same");
            return false;
        }
        this.saynoCR("Checking store " + storeName + " with " + srcSize + " elements... ");
        for (Identifier identifier : source.keySet()) {
            if (!target.containsKey((Object)identifier)) {
                this.say(" Source store contains key \"" + String.valueOf(identifier) + "\" and target store does not.");
                return false;
            }
            Identifiable src = (Identifiable)source.get((Object)identifier);
            if (src == null) {
                this.say(" Failed getting source object with identifier \"" + String.valueOf(identifier) + "\"");
                return false;
            }
            Identifiable trgt = (Identifiable)target.get((Object)identifier);
            if (trgt == null) {
                this.say(" Failed getting target object with identifier \"" + String.valueOf(identifier) + "\"");
                return false;
            }
            if (src.equals(trgt)) continue;
            this.say(" source and target objects do not match!");
            this.say("Source object:\n\n" + src.toString());
            this.say("\nTarget object:\n\n" + trgt.toString());
            return false;
        }
        this.say("ok!");
        return true;
    }

    public void say(String x) {
        System.out.println(x);
    }

    public void saynoCR(String x) {
        System.out.print(x);
    }
}

