/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.ObjectNotFoundException;
import edu.uiuc.ncsa.security.storage.cli.StoreCommands2;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.io.IOException;
import java.util.List;
import org.oa4mp.delegation.common.token.impl.TokenUtils;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.qdl_lang.parsing.QDLInterpreter;
import org.qdl_lang.state.State;
import org.qdl_lang.variables.QDLList;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.QDLValue;

public abstract class OA4MPStoreCommands
extends StoreCommands2 {
    static final String BASE_32_FLAG = "-32";
    State state = null;

    public OA4MPStoreCommands(CLIDriver driver, String defaultIndent, Store store) throws Throwable {
        super(driver, defaultIndent, store);
    }

    public OA4MPStoreCommands(CLIDriver driver, Store store) throws Throwable {
        super(driver, store);
    }

    public void initialize() throws Throwable {
    }

    public void load(InputLine inputLine) {
    }

    public OA2SE getEnvironment() {
        return (OA2SE)super.getEnvironment();
    }

    public void encode(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("encode [-32] arg");
            this.sayi("encode a string using base 64 or base 32. The default is base 64");
            this.sayi("Note: Enclose your argument in double quotes. You must escape embedded");
            this.sayi("      double quotes with \\\"");
            this.say("E.g.");
            this.sayi("clients>encode \"config \\\" foo \\\"\"\n  Y29uZmlnICIgZm9vICI\n  clients>decode Y29uZmlnICIgZm9vICI\n  config \" foo \"");
            this.say("note the embedded blanks and quotes are preserved.");
            return;
        }
        boolean doBase32 = inputLine.hasArg(BASE_32_FLAG);
        inputLine.removeSwitch(BASE_32_FLAG);
        String originalLine = inputLine.getOriginalLine();
        originalLine = originalLine.substring("encode".length()).trim();
        if (doBase32) {
            originalLine = originalLine.substring(BASE_32_FLAG.length()).trim();
        }
        if (originalLine.length() == 0) {
            this.say("sorry, this needs a single argument.");
            return;
        }
        if (originalLine.startsWith("\"")) {
            originalLine = originalLine.substring(1);
        }
        if (originalLine.endsWith("\"")) {
            originalLine = originalLine.substring(0, originalLine.length() - 1);
        }
        String arg = originalLine.replace("\\\"", "\"");
        if (doBase32) {
            this.say(TokenUtils.b32EncodeToken((String)arg));
        } else {
            this.say(TokenUtils.b64EncodeToken((String)arg));
        }
    }

    public void decode(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("decode [-32] arg");
            this.sayi("decode a string using base 64 or base 32. The default is base 64");
            return;
        }
        boolean doBase32 = inputLine.hasArg(BASE_32_FLAG);
        inputLine.removeSwitch(BASE_32_FLAG);
        if (inputLine.getArgCount() != 1) {
            this.say("sorry, this needs a single argument.");
            return;
        }
        String arg = inputLine.getLastArg();
        if (doBase32) {
            this.say(TokenUtils.b32DecodeToken((String)arg));
        } else {
            this.say(TokenUtils.b64DecodeToken((String)arg));
        }
    }

    public void extraUpdates(Identifiable identifiable, int magicNumber) throws IOException {
    }

    protected List processList(InputLine inputLine, String key) throws Exception {
        if (!inputLine.hasArg(key) || key == null) {
            return null;
        }
        String originalLine = inputLine.getOriginalLine();
        try {
            int index = Integer.parseInt(inputLine.getNextArgFor(key));
            QDLList qdlList = new QDLList();
            qdlList.add(Integer.valueOf(index));
            inputLine.removeSwitchAndValue(key);
            return qdlList;
        }
        catch (Throwable index) {
            String list = this.extractRawList(inputLine, key);
            String varName = "a.";
            String executableLine = varName + " :=" + list + ";";
            State state = this.getState();
            QDLInterpreter interpreter = new QDLInterpreter(null, state);
            try {
                interpreter.execute(executableLine);
                QDLValue o = state.getValue(varName);
                if (o == null) {
                    throw new ObjectNotFoundException("no such value for'" + key + "'");
                }
                QDLStem qdlStem = (QDLStem)o;
                return qdlStem.getQDLList();
            }
            catch (Throwable e) {
                inputLine = new InputLine(originalLine);
                List x = inputLine.getArgList(key);
                if (x != null) {
                    return x;
                }
                throw new GeneralException("Error interpreting list:" + e.getMessage(), e);
            }
        }
    }

    public void run_qdl(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("run_qdl [-file file_path] [statements]");
            this.say("Run either a file using QDL's script_load call or directly interpret");
            this.say(" the rest of the line as parseable QDL. Each store has a separate QDL state and");
            this.say("interpreter. Since E.g. lists are generally processed as QDL, you can set variables");
            this.say("and refer to them, or run other QDL.");
            this.say("This is currently experimental.");
            this.say();
            this.say("E.g.");
            this.say("The rest of the line must be completely valid QDL as all that we do is truncate off the commnd and pass the");
            this.say("rest to the interpreter:");
            this.say("run_qdl script_load('vfs#boot/init.qdl', true, -1);");
            return;
        }
        Object executableLine = null;
        if (inputLine.hasArg("-file")) {
            String file = inputLine.getNextArgFor("-file");
            executableLine = "script_load(" + file + ");";
        } else {
            String commandName = inputLine.getArg(0);
            int len = commandName.length();
            executableLine = inputLine.getOriginalLine().substring(len);
        }
        QDLInterpreter interpreter = new QDLInterpreter(null, this.getState());
        try {
            interpreter.execute(((String)executableLine).trim());
        }
        catch (Throwable t) {
            if (this.isVerbose()) {
                t.printStackTrace();
            }
            this.say("Error interpreting QDL:" + t.getMessage());
        }
    }

    protected void printIndexHelp(boolean singletonsOnly) {
        super.printIndexHelp(singletonsOnly);
        this.say("and for QDL lists, see");
        this.say("/commands qdl_lists");
    }

    public State getState() {
        if (this.state == null) {
            this.state = new State();
            MapConverter mapConverter = (MapConverter)this.getStore().getXMLConverter();
            SerializationKeys serializationKeys = mapConverter.getKeys();
            for (String key : serializationKeys.allKeys()) {
                this.state.setValue(key, QDLValue.asQDLValue((Object)key));
            }
        }
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void about(boolean showBanner, boolean showHeader) {
    }
}

