/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.base;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.XMLConverter;
import edu.uiuc.ncsa.security.core.exceptions.NFWException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DoubleHashMap;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public class StoreArchiver {
    MapConverter mapConverter;
    Store store;
    public static String ARCHIVE_VERSION_TAG = "version";
    public static String ARCHIVE_VERSION_SEPARATOR_TAG = "=";

    public StoreArchiver(Store store) {
        this.store = store;
    }

    public Store getStore() {
        return this.store;
    }

    public MapConverter getMapConverter() {
        if (this.mapConverter == null) {
            XMLConverter xmlConverter = this.getStore().getXMLConverter();
            if (!(xmlConverter instanceof MapConverter)) {
                throw new NFWException("The XML converter for the store is not a MapConverter.");
            }
            this.mapConverter = (MapConverter)xmlConverter;
        }
        return this.mapConverter;
    }

    public long getVersionNumber(Identifier id) {
        URI uri = id.getUri();
        String fragment = uri.getFragment();
        if (StringUtils.isTrivial((String)fragment)) {
            return -1L;
        }
        try {
            return Long.parseLong(fragment.substring(fragment.indexOf(ARCHIVE_VERSION_SEPARATOR_TAG) + 1));
        }
        catch (NumberFormatException nfx) {
            return -1L;
        }
    }

    public Identifier createVersionedID(Identifier id, long version) {
        URI uri = id.getUri();
        Object s = uri.getFragment();
        if (s != null && ((String)s).contains(ARCHIVE_VERSION_TAG + ARCHIVE_VERSION_SEPARATOR_TAG)) {
            throw new IllegalArgumentException(String.valueOf(id) + " already is versioned");
        }
        s = StringUtils.isTrivial((String)s) ? ARCHIVE_VERSION_TAG + ARCHIVE_VERSION_SEPARATOR_TAG + Long.toString(version) : (String)s + "&" + ARCHIVE_VERSION_TAG + ARCHIVE_VERSION_SEPARATOR_TAG + Long.toString(version);
        try {
            uri = new URI(uri.getScheme(), uri.getSchemeSpecificPart(), (String)s);
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalArgumentException("could not create uri for identifier:" + uriSyntaxException.getMessage());
        }
        return BasicIdentifier.newID((URI)uri);
    }

    public static void main(String[] args) {
        StoreArchiver storeArchiver = new StoreArchiver(null);
        Identifier id = storeArchiver.createVersionedID((Identifier)new BasicIdentifier("uri:test/foo"), 1L);
        System.out.println(id);
        System.out.println(storeArchiver.createVersionedID((Identifier)new BasicIdentifier("uri:test/foo?boo=woof#fragment=foo"), 2L));
        System.out.println(storeArchiver.getVersionNumber((Identifier)new BasicIdentifier("uri:new")));
        System.out.println(storeArchiver.getVersionNumber(id));
    }

    protected DoubleHashMap<URI, Long> getVersions(Identifier identifier) {
        MapConverter mc = this.getMapConverter();
        List values = this.getStore().search(mc.getKeys().identifier(new String[0]), identifier.toString() + ".*", true);
        DoubleHashMap versionNumbers = new DoubleHashMap();
        for (Identifiable value : values) {
            URI uri = value.getIdentifier().getUri();
            String fragment = uri.getFragment();
            if (StringUtils.isTrivial((String)fragment)) continue;
            String rawIndex = fragment.substring(1 + fragment.indexOf(ARCHIVE_VERSION_SEPARATOR_TAG));
            try {
                if (StringUtils.isTrivial((String)rawIndex)) continue;
                versionNumbers.put((Object)uri, (Object)Long.parseLong(rawIndex));
            }
            catch (Throwable throwable) {}
        }
        return versionNumbers;
    }

    public TreeMap<Long, Identifiable> getVersionsMap(Identifiable identifiable) {
        MapConverter mc = this.getMapConverter();
        if (identifiable == null) {
            return null;
        }
        List values = this.getStore().search(mc.getKeys().identifier(new String[0]), identifiable.getIdentifierString() + ".*", true);
        TreeMap<Long, Identifiable> sortedMap = new TreeMap<Long, Identifiable>();
        for (Identifiable x : values) {
            long version = this.getVersionNumber(x.getIdentifier());
            if (-1L >= version) continue;
            sortedMap.put(version, x);
        }
        return sortedMap;
    }

    protected Long getLatestVersionNumber(DoubleHashMap<URI, Long> versionNumbers) {
        if (versionNumbers.isEmpty()) {
            return -1L;
        }
        long maxValue = 0L;
        for (URI key : versionNumbers.keySet()) {
            maxValue = Math.max(maxValue, (Long)versionNumbers.get((Object)key));
        }
        return maxValue;
    }

    public Identifiable getVersion(Identifier targetID, long version) throws IOException {
        URI id;
        DoubleHashMap<URI, Long> versionNumbers = this.getVersions(targetID);
        if (version == -1L) {
            version = this.getLatestVersionNumber(versionNumbers);
        }
        if ((id = (URI)versionNumbers.getByValue((Object)version)) == null) {
            return null;
        }
        return (Identifiable)this.getStore().get((Object)BasicIdentifier.newID((URI)id));
    }

    public void remove(Identifier identifier, long version) {
        Identifier versionedID = this.createVersionedID(identifier, version);
        this.getStore().remove((Object)versionedID);
    }

    public Long create(Identifier identifier) {
        Identifiable identifiable = (Identifiable)this.getStore().get((Object)identifier);
        Identifiable newVersion = this.getStore().create();
        XMLMap map = new XMLMap();
        MapConverter mc = this.getMapConverter();
        mc.toMap(identifiable, (ConversionMap)map);
        mc.fromMap((ConversionMap)map, newVersion);
        DoubleHashMap<URI, Long> versions = this.getVersions(identifier);
        long newIndex = 0L;
        if (!versions.isEmpty()) {
            newIndex = this.getLatestVersionNumber(versions) + 1L;
        }
        Identifier newID = this.createVersionedID(identifiable.getIdentifier(), newIndex);
        newVersion.setIdentifier(newID);
        this.getStore().save(newVersion);
        return newIndex;
    }

    public Identifier getBaseID(Identifier overloadedID) {
        String id = overloadedID.toString();
        return BasicIdentifier.newID((String)id.substring(0, id.indexOf(35)));
    }

    public List<Long> getVersionNumbers(Identifier id) {
        DoubleHashMap<URI, Long> versions = this.getVersions(id);
        ArrayList<Long> out = new ArrayList<Long>();
        out.addAll(versions.values());
        Collections.sort(out);
        return out;
    }

    public boolean restore(Identifier id, Long version) {
        try {
            Identifiable identifiable = this.getVersion(id, version);
            identifiable.setIdentifier(id);
            this.getStore().save(identifiable);
            return Boolean.TRUE;
        }
        catch (IOException e) {
            return Boolean.FALSE;
        }
    }
}

