/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.ConfigurableCommandsImpl2;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import org.oa4mp.server.admin.oauth2.tools.ConfigLoaderTool;
import org.oa4mp.server.admin.oauth2.tools.JWKUtilCommands;

public class JWKCLI
extends ConfigurableCommandsImpl2 {
    ConfigurationLoader<? extends AbstractEnvironment> loader = null;
    public static String SHORT_HELP_FLAG = "-help";
    public static String LONG_HELP_FLAG = "--help";
    public static String SHORT_VERBOSE_FLAG = "-v";
    public static String LONG_VERBOSE_FLAG = "--verbose";
    public static String SHORT_NO_OUTPUT_FLAG = "-noOuput";
    public static String LONG_NO_OUTPUT_FLAG = "--noOuput";

    public JWKCLI(CLIDriver driver) {
        super(driver);
    }

    public void about(boolean showBanner, boolean showHeader) {
        int width = 60;
        String stars = StringUtils.repeatString((String)"*", (int)(width + 1));
        this.say(stars);
        this.say(StringUtils.pad2((String)"* JSON Web Token CLI (Command Line Interpreter)", (int)width) + "*");
        this.say(StringUtils.pad2((String)"* Version 6.2.1", (int)width) + "*");
        this.say(StringUtils.pad2((String)"* By Jeff Gaynor  NCSA", (int)width) + "*");
        this.say(StringUtils.pad2((String)"*  (National Center for Supercomputing Applications)", (int)width) + "*");
        this.say(StringUtils.pad2((String)"*", (int)width) + "*");
        this.say(StringUtils.pad2((String)"* type 'help' for a list of commands", (int)width) + "*");
        this.say(StringUtils.pad2((String)"*      'exit' or 'quit' to end this session.", (int)width) + "*");
        this.say(stars);
    }

    public ConfigurationLoader<? extends AbstractEnvironment> getLoader() {
        return this.loader;
    }

    public String getName() {
        return "jwt";
    }

    public String getPrompt() {
        return this.getName() + ">";
    }

    public String getComponentName() {
        return null;
    }

    public void useHelp() {
        this.say("You may use this in both interactive mode and as a command line utility.");
        this.say("Here is a list of commands: An asterisk (X) means it is for interactive mode only");
        this.say("Key commands");
        this.say("------------");
        this.say("create_keys");
        this.say("create_public_keys");
        this.say("*set_keys");
        this.say("list_keys");
        this.say("list_key_ids");
        this.say("*set_default_id");
        this.say("*print_default_id");
        this.say("*print_well_known");
        this.say("Claim Commands");
        this.say("--------------");
        this.say("create_claims");
        this.say("parse_claims");
        this.say("Token Commands");
        this.say("--------------");
        this.say("create_token");
        this.say("generate_token");
        this.say("print_token");
        this.say("validate_token");
        this.say("Other commands");
        this.say("--------------");
        this.say("base64");
        this.say("set_no_output");
        this.say("set_verbose");
        this.say("To get a full explanation of the command and its syntax, type \"command --help \".");
        this.say("Command line options");
        this.say("--------------------");
        this.say("These are flags and arguments to the command line processor.");
        this.say(SHORT_VERBOSE_FLAG + "," + LONG_VERBOSE_FLAG + "= turn verbose mode on. This allows you to see the internal workings of processing");
        this.say("   You can set this in a batch file by invoking set_verbose true|false");
        this.say(SHORT_NO_OUTPUT_FLAG + ", " + LONG_NO_OUTPUT_FLAG + " = turn off all output");
        this.say("   You can set this in a batch file by invoking set_no_ouput true|false");
    }

    public static void main(String[] args) throws Throwable {
        try {
            InputLine inputLine = new InputLine(JWKCLI.class.getSimpleName(), args);
            JWKUtilCommands jwkUtilCommands = new JWKUtilCommands(null);
            CLIDriver cli = new CLIDriver(new Commands[]{jwkUtilCommands});
            inputLine = cli.bootstrap(inputLine);
            jwkUtilCommands.bootstrap(inputLine);
            if (inputLine.hasArg(new String[]{SHORT_HELP_FLAG, LONG_HELP_FLAG})) {
                JWKCLI jwkcli = new JWKCLI(cli);
                jwkcli.useHelp();
                return;
            }
            cli.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void useHelp(InputLine inputLine) {
        this.useHelp();
    }

    public void setLoader(ConfigurationLoader<? extends AbstractEnvironment> loader) {
        this.loader = this.getLoader();
    }

    protected ConfigurationLoader<? extends AbstractEnvironment> figureOutLoader(String fileName, String configName) throws Throwable {
        ConfigLoaderTool configLoaderTool = new ConfigLoaderTool();
        return configLoaderTool.figureOutClientLoader(fileName, configName, this.getComponentName());
    }
}

