/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import com.nimbusds.jose.util.Base64URL;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.FileUtil;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.CommonCommands2;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.crypto.KeyUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKey;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import edu.uiuc.ncsa.security.util.jwk.JWKUtil2;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.delegation.server.JWTUtil;
import org.oa4mp.server.loader.oauth2.OA2SE;
import org.oa4mp.server.loader.qdl.util.SigningCommands;

public class JWKUtilCommands
extends CommonCommands2 {
    JWKUtil2 jwkUtil;
    String FORCE_TO_STD_OUT_FLAG = "-o";
    String CREATE_SINGLE_KEY_FLAG = "-single";
    String CREATE_ELLIPTIC_KEY_FLAG = "-ec";
    String SET_DEFAULT_ID = "-default_id";
    String ALGORITHM_KEY_FLAG = "-alg";
    String ELLIPTIC_CURVE_FLAG = "-curve";
    String RSA_KEY_SIZE_FLAG = "-size";
    JSONWebKeys keys = null;
    String wellKnown = null;
    public static String LOAD_KEY = "-load";
    public static String PEM_KEY = "-pem";
    protected String showAllKeys = "-showAll";
    public String BASE64_FLAG = "-b64";
    String defaultKeyID = null;
    protected String CL_KEY_FILE_FLAG = "-keys";
    protected String CL_KEY_ID_FLAG = "-key_id";
    protected String CL_WELL_KNOWN_FLAG = "-key_id";
    protected String CL_IS_PUBLIC_FLAG = "-public";
    protected String CL_IS_PRIVATE_FLAG = "-private";
    String lastToken = null;
    protected String LIFETIME_FLAG = "-lifetime";
    protected String JTI_FLAG = "-jti";
    protected String PRINT_CLAIMS_FLAG = "-print_claims";
    protected long DEFAULT_LIFETIME = 600L;
    protected int JTI_RADIX = 36;
    String base64Encode = "-encode";
    String base64Dencode = "-decode";
    String base64Bytes = "-binary";

    public JWKUtil2 getJwkUtil() {
        if (this.jwkUtil == null) {
            this.jwkUtil = new JWKUtil2();
        }
        return this.jwkUtil;
    }

    public void setJwkUtil(JWKUtil2 jwkUtil) {
        this.jwkUtil = jwkUtil;
    }

    public JWKUtilCommands(CLIDriver driver) throws Throwable {
        super(driver);
    }

    public void about(boolean showBanner, boolean showHeader) {
    }

    public void initialize() throws Throwable {
    }

    public void load(InputLine inputLine) throws Throwable {
    }

    public String getName() {
        return "jwk";
    }

    public String getPrompt() {
        return this.getName() + ">";
    }

    protected void createKeysHelps() {
        this.say("create_keys [" + this.CL_INPUT_FILE_FLAG + " set_of_keys " + this.CL_IS_PUBLIC_FLAG + "] | [" + this.CL_IS_PRIVATE_FLAG + "] " + this.FORCE_TO_STD_OUT_FLAG + "] " + this.CL_OUTPUT_FILE_FLAG + " file");
        this.sayi(this.CL_INPUT_FILE_FLAG + " - and input file of keys. Implies " + this.CL_IS_PUBLIC_FLAG + " and will extract the public keys.");
        this.sayi(this.CL_IS_PUBLIC_FLAG + " - extract public keys from the file specified by " + this.CL_INPUT_FILE_FLAG);
        this.sayi(this.CL_IS_PRIVATE_FLAG + " - (implied) generate full set of keys. Cannot be specified with  " + this.CL_IS_PUBLIC_FLAG);
        this.sayi(this.FORCE_TO_STD_OUT_FLAG + " - write the keys to standard out.");
        this.sayi(this.SET_DEFAULT_ID + " - specify the id of the default key (only at creation of a full set).");
        this.sayi(this.CL_OUTPUT_FILE_FLAG + " - write the keys to the given file.");
        this.sayi(this.CREATE_SINGLE_KEY_FLAG + " - create only a single RSA 256 key.");
        this.sayi(this.RSA_KEY_SIZE_FLAG + " - specify the key size for the RSA key. Default is 2048 and the value must be multiple of 256");
        this.sayi(this.ELLIPTIC_CURVE_FLAG + " - specify the specific elliptic curve to use. Invoke help with ec to see a list");
        this.sayi(this.ALGORITHM_KEY_FLAG + " - For both RSA and ellitpic functions. Specify the key generation algorithm. Invoke help");
        this.sayi("       with ec or rsa to see a list.");
        this.sayi(this.CREATE_ELLIPTIC_KEY_FLAG + " - if present will create an keys with the default elliptic function");
        this.sayi("Create a set of RSA JSON Web keys and store them in the given file");
        this.sayi("There are several modes of operation. If you do not specify an output file, then the keys are written ");
        this.sayi("to the command line.");
        this.sayi("   E.g.");
        this.sayi("   create_keys " + this.CL_OUTPUT_FILE_FLAG + " keys.jwk");
        this.sayi("       This will create a set of key pairs with random ids and store the result in the file kwys.jwk");
        this.sayi("   create_keys");
        this.sayi("        with no arguments, a full set of keys will be created and printed to the command line.");
        this.sayi("\nE.g.   ");
        this.sayi("   create_keys " + this.CL_IS_PUBLIC_FLAG + " " + this.CL_INPUT_FILE_FLAG + " keys.jwk " + this.CL_OUTPUT_FILE_FLAG + "  pub_keys.jwk");
        this.sayi("        This will take the full set of keys in keys.jwk extract the public keys and place the result in pub_keys.jwk");
        this.sayi("        Note: including the -public flag implies the -in argument is given and an error will result if it is not found");
        this.sayi("If you invoke help with an argument of ec, you will get information on generating elliptic curve keys. ");
        this.sayi("If you supply rsa as the argument, you will et information on generating RSA keys");
        this.sayi("E.g.");
        this.sayi("create_keys --help ec");
        this.say("See also create_public_keys");
    }

    protected SigningCommands createSG(OA2SE oa2SE) throws Exception {
        try {
            SigningCommands sg = new SigningCommands(this.getDriver(), oa2SE);
            return sg;
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new GeneralException("error creating signing commands", t);
        }
    }

    public void add_keys(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.addKeysHelps();
            return;
        }
        boolean hasInputFile = inputLine.hasArg(this.CL_INPUT_FILE_FLAG);
        boolean hasOutputFile = inputLine.hasArg(this.CL_OUTPUT_FILE_FLAG);
        boolean isPublic = inputLine.hasArg(this.CL_IS_PUBLIC_FLAG);
        if (isPublic) {
            this.say("warning: This will create a new set of public and private keys. ");
            if (!"y".equalsIgnoreCase(this.getInput("Do you want to continue?[y/n]"))) {
                this.say("aborted...");
                return;
            }
        }
        JSONWebKeys sourceKeys = this.keys;
        if (hasInputFile) {
            String contents = null;
            try {
                contents = FileUtil.readFileAsString((String)inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG));
            }
            catch (Throwable e) {
                if (this.getDriver().isTraceOn()) {
                    e.printStackTrace();
                }
                this.say("error reading input file: " + e.getMessage());
                return;
            }
            sourceKeys = this.getJwkUtil().fromJSON(contents);
        }
        SigningCommands sg = this.createSG(null);
        JSONWebKeys keys = sg.createJsonWebKeys();
        JSONObject jwks = this.getJwkUtil().toJSON(keys);
        for (String x : keys.keySet()) {
            if (sourceKeys.containsKey((Object)x)) continue;
            sourceKeys.put((JSONWebKey)keys.get((Object)x));
        }
        if (hasOutputFile) {
            this.writeFile(inputLine.getNextArgFor(this.CL_OUTPUT_FILE_FLAG), this.getJwkUtil().toJSON(sourceKeys).toString(2));
        }
        this.say("done!");
    }

    private void addKeysHelps() {
        this.say("add_keys [" + this.CL_INPUT_FILE_FLAG + " in_file " + this.CL_OUTPUT_FILE_FLAG + " out_file]");
        this.sayi("Generates a new set of private keys and adds them to an existing key store.");
        this.sayi("If " + this.CL_INPUT_FILE_FLAG + " is specified, then that is used as the existing set, otherwise ");
        this.sayi("the current set of keys is used. ");
        this.sayi("If " + this.CL_OUTPUT_FILE_FLAG + " is specified, the result is written to that file.");
        this.say("See also, create_keys, set_keys");
    }

    public void create_keys(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            if (inputLine.hasNextArgFor(new String[]{"--help"})) {
                TreeSet<String> algs = new TreeSet<String>();
                switch (inputLine.getNextArgFor("--help")) {
                    case "ec": {
                        TreeSet<String> curves = new TreeSet<String>();
                        curves.addAll(Arrays.asList(JWKUtil2.ALL_EC_CURVES));
                        algs.addAll(Arrays.asList(JWKUtil2.ALL_EC_ALGORITHMS));
                        this.say("Supported curves");
                        this.say("----------------");
                        for (String x : curves) {
                            this.say(x);
                        }
                        this.say("The default is " + JWKUtil2.EC_CURVE_P_256);
                        this.say("\nSupported algorithms");
                        this.say("--------------------");
                        for (String x : algs) {
                            this.say(x);
                        }
                        this.say("The default is ES256");
                        break;
                    }
                    case "rsa": {
                        this.say("Supported algorithms");
                        this.say("--------------------");
                        algs.addAll(Arrays.asList(JWKUtil2.ALL_RSA_ALGORITHMS));
                        for (String x : algs) {
                            this.say(x);
                        }
                        this.say("The default is RS256");
                        break;
                    }
                    default: {
                        this.say("no help for this topic.");
                        break;
                    }
                }
            } else {
                this.createKeysHelps();
            }
            return;
        }
        if (!inputLine.hasArgs() || inputLine.getArgCount() == 1 && inputLine.hasArg(this.CREATE_SINGLE_KEY_FLAG)) {
            SigningCommands sg = this.createSG(null);
            sg.create(inputLine);
            return;
        }
        boolean hasDefaultID = inputLine.hasArg(this.SET_DEFAULT_ID);
        String defaultID = null;
        if (hasDefaultID) {
            defaultID = inputLine.getNextArgFor(this.SET_DEFAULT_ID);
            inputLine.removeSwitchAndValue(this.SET_DEFAULT_ID);
        }
        boolean isCreateElliptic = inputLine.hasArg(this.CREATE_ELLIPTIC_KEY_FLAG);
        inputLine.removeSwitch(this.CREATE_ELLIPTIC_KEY_FLAG);
        boolean createSingleKey = inputLine.hasArg(this.CREATE_SINGLE_KEY_FLAG);
        inputLine.removeSwitch(this.CREATE_SINGLE_KEY_FLAG);
        boolean writeToStdOut = inputLine.hasArg(this.FORCE_TO_STD_OUT_FLAG);
        inputLine.removeSwitch(this.FORCE_TO_STD_OUT_FLAG);
        String algorithm = "RS256";
        if (inputLine.hasArg(this.ALGORITHM_KEY_FLAG)) {
            algorithm = inputLine.getNextArgFor(this.ALGORITHM_KEY_FLAG);
            inputLine.removeSwitchAndValue(this.ALGORITHM_KEY_FLAG);
        } else if (isCreateElliptic) {
            algorithm = "ES256";
        }
        String ellipticCurve = null;
        if (inputLine.hasArg(this.ELLIPTIC_CURVE_FLAG)) {
            ellipticCurve = inputLine.getNextArgFor(this.ELLIPTIC_CURVE_FLAG);
            inputLine.removeSwitchAndValue(this.ELLIPTIC_CURVE_FLAG);
            isCreateElliptic = true;
        } else if (isCreateElliptic && createSingleKey) {
            ellipticCurve = JWKUtil2.EC_CURVE_P_256;
        }
        int keySize = 2048;
        if (inputLine.hasArg(this.RSA_KEY_SIZE_FLAG)) {
            try {
                keySize = inputLine.getNextIntArg(new String[]{this.RSA_KEY_SIZE_FLAG});
            }
            catch (Throwable t) {
                this.say("sorry, but " + inputLine.getNextArgFor(this.RSA_KEY_SIZE_FLAG) + " could not be parsed.");
                return;
            }
            inputLine.removeSwitchAndValue(this.RSA_KEY_SIZE_FLAG);
        }
        if (inputLine.hasArg(this.CL_IS_PUBLIC_FLAG) && !inputLine.hasArg(this.CL_INPUT_FILE_FLAG)) {
            this.say("Error! Request for public keys but no set odf keys supplied.");
            return;
        }
        boolean isPublic = inputLine.hasArg(this.CL_IS_PUBLIC_FLAG);
        inputLine.removeSwitch(this.CL_IS_PUBLIC_FLAG);
        boolean isPrivate = inputLine.hasArg(this.CL_IS_PRIVATE_FLAG);
        inputLine.removeSwitch(this.CL_IS_PRIVATE_FLAG);
        if (isPrivate && isPublic) {
            String err = " cannot specify both private and public keys at the same time";
            this.say(err);
            return;
        }
        boolean hasOutputFile = inputLine.hasArg(this.CL_OUTPUT_FILE_FLAG);
        String outFilename = null;
        if (hasOutputFile) {
            outFilename = inputLine.getNextArgFor(this.CL_OUTPUT_FILE_FLAG);
            inputLine.removeSwitchAndValue(this.CL_OUTPUT_FILE_FLAG);
        }
        boolean hasInputFile = inputLine.hasArg(this.CL_INPUT_FILE_FLAG);
        String inFilename = null;
        if (hasInputFile) {
            inFilename = inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG);
            inputLine.removeSwitchAndValue(this.CL_INPUT_FILE_FLAG);
        }
        if (!isPublic) {
            JSONWebKeys keys;
            SigningCommands sg = this.createSG(null);
            if (createSingleKey) {
                keys = new JSONWebKeys(null);
                if (isCreateElliptic) {
                    keys.put(SigningCommands.createECJWK((String)ellipticCurve, (String)algorithm));
                } else {
                    keys.put(SigningCommands.createRSAJWK((int)keySize, (String)algorithm));
                }
            } else {
                keys = isCreateElliptic ? SigningCommands.createECJsonWebKeys((String)ellipticCurve, (String)defaultID) : SigningCommands.createRSAJsonWebKeys((int)keySize, (String)defaultID);
            }
            this.keys = keys;
            JSONObject jwks = this.getJwkUtil().toJSON(keys);
            if (hasOutputFile) {
                this.writeFile(outFilename, jwks.toString(2));
            }
            if (writeToStdOut) {
                this.say(jwks.toString(2));
            }
            return;
        }
        String contents = null;
        try {
            contents = FileUtil.readFileAsString((String)inFilename);
        }
        catch (Throwable e) {
            if (this.getDriver().isTraceOn()) {
                e.printStackTrace();
            }
            this.say("error reading " + inFilename);
            return;
        }
        JSONWebKeys keys = this.getJwkUtil().fromJSON(contents);
        JSONWebKeys targetKeys = this.getJwkUtil().makePublic(keys);
        JSONObject zzz = this.getJwkUtil().toJSON(targetKeys);
        if (hasOutputFile) {
            this.writeFile(outFilename, zzz.toString(2));
        } else {
            this.say(zzz.toString(2));
        }
    }

    protected void showSymmetricKeyHelp(SigningCommands signingCommands) {
        this.say("create_symmetric_keys [" + signingCommands.SYMMETRIC_KEY_ARG + " len + | " + signingCommands.SYMMETRIC_KEY_COUNT_ARG + " count | " + signingCommands.SYMMETRIC_KEY_FILE_ARG + " fileName] ");
        this.sayi("This will create a key for use as a symmetric key, i.e., this will produce");
        this.sayi("a base 64 encoded sequence of random bytes to be used as a symmetric key for");
        this.sayi("the given length. If no length is included, the default of " + signingCommands.defaultSymmetricKeyLength + " bytes is used.");
        this.sayi("If the " + signingCommands.SYMMETRIC_KEY_COUNT_ARG + " is given, this will produce that many keys");
        this.sayi("If the " + signingCommands.SYMMETRIC_KEY_FILE_ARG + " is given, this will write the keys to the given file, one per line.");
    }

    public void create_password(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.sayi("create_password [length] - create a password with the given length in bytes.");
            this.sayi("No argument implies an 8 byte password. Result is printed to standard out.");
            this.say("E.g.");
            this.say("\njwk>create_password 6");
            this.say("9DbPhjwB");
            this.sayi("\n6 bytes creates a password that is 6*(4/3) = 8 characters long.");
            return;
        }
        SigningCommands signingCommands = this.createSG(null);
        int defaultLength = 8;
        try {
            defaultLength = Integer.parseInt(inputLine.getLastArg());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        InputLine inputLine1 = new InputLine("x " + signingCommands.SYMMETRIC_KEY_ARG + " " + defaultLength + " " + signingCommands.SYMMETRIC_KEY_COUNT_ARG + " 1");
        signingCommands.create_symmetric_keys(inputLine1);
    }

    public void create_symmetric_keys(InputLine inputLine) throws Exception {
        SigningCommands signingCommands = this.createSG(null);
        if (this.showHelp(inputLine)) {
            this.showSymmetricKeyHelp(signingCommands);
            return;
        }
        signingCommands.create_symmetric_keys(inputLine);
    }

    public void print_well_known(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printWellKnownHelp();
            return;
        }
        if (this.wellKnown == null || this.wellKnown.isEmpty()) {
            this.say("(not set)");
            return;
        }
        this.say("well known URL=\"" + this.wellKnown + "\"");
    }

    protected void printWellKnownHelp() {
        this.say("print_well_known: Prints the well-known URL that has been set.");
        this.sayi("Note that you set it in the set_keys call if you supply its URL");
        this.sayi("The well-known URL resides on a server and has the public keys listed");
        this.sayi("While you can validate a signature against it, you cannot create one since");
        this.sayi("the private key is never available through the well-knwon file.");
        this.say("Related: set_keys, validate_token");
    }

    protected void setKeysHelp() {
        this.say("set_keys: [" + this.CL_INPUT_FILE_FLAG + " filename | " + this.CL_WELL_KNOWN_FLAG + " uri]");
        this.sayi("Set the keys used for signing and validation in this session.");
        this.sayi("Either supplied a fully qualified path to the file or a uri. If you pass nothing");
        this.sayi("you will be prompted for a file. You can invoke this at any to change the keys.");
        this.say("See also: create_keys, set_default_id");
    }

    public void set_keys(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.setKeysHelp();
            return;
        }
        File f = null;
        if (inputLine.size() == 1) {
            boolean getFile = this.getBooleanInput("Did you want to enter a file name?");
            if (getFile) {
                String fileName = this.getInput("Enter file name");
                f = new File(fileName);
            } else {
                return;
            }
        }
        if (inputLine.hasArg(this.CL_INPUT_FILE_FLAG) && !(f = new File(inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG))).exists()) {
            this.say("Sorry, the file you specified, \"" + inputLine.getArg(1) + "\" does not exist.");
            return;
        }
        if (f != null) {
            this.keys = this.readKeys(f);
            if (this.defaultKeyID != null && this.keys.containsKey((Object)this.defaultKeyID)) {
                this.keys.setDefaultKeyID(this.defaultKeyID);
            }
        } else {
            this.wellKnown = inputLine.getNextArgFor(this.CL_WELL_KNOWN_FLAG);
            try {
                this.keys = JWTUtil.getJsonWebKeys((ServiceClient)new ServiceClient(URI.create("https://cilogon.org")), (String)this.wellKnown);
            }
            catch (Throwable t) {
                this.sayi("Sorry, could not parse the url: \"" + t.getMessage() + "\"");
            }
        }
    }

    protected JSONWebKeys readKeys(File file) throws Exception {
        return this.getJwkUtil().fromJSON(file);
    }

    public void read_key(InputLine inputLine) throws Exception {
        JSONWebKeys jsonWebKeys;
        if (this.showHelp(inputLine)) {
            this.say("read_key [" + LOAD_KEY + "][" + PEM_KEY + "] file_path - read a single JWK format key.");
            this.say(LOAD_KEY + " = load the key and set as the default");
            this.say(PEM_KEY + " = read the key in PEM (PKCS 1) format.");
            this.say("Not loading the key will simply print it out.");
            return;
        }
        boolean isLoad = inputLine.hasArg(LOAD_KEY);
        boolean isPem = inputLine.hasArg(PEM_KEY);
        inputLine.removeSwitch(LOAD_KEY);
        inputLine.removeSwitch(PEM_KEY);
        if (isPem) {
            KeyPair keyPair = KeyUtil.keyPairFromPKCS1((Reader)new FileReader(inputLine.getLastArg()));
            JSONWebKey jwk = new JSONWebKey();
            jwk.id = "dummy";
            jwk.privateKey = keyPair.getPrivate();
            jwk.publicKey = keyPair.getPublic();
            jwk.type = "RSA";
            jwk.use = "sig";
            jwk.algorithm = "RS256";
            jsonWebKeys = new JSONWebKeys("dummy");
            jsonWebKeys.put(jwk);
        } else {
            jsonWebKeys = this.getJwkUtil().fromJSON(new File(inputLine.getLastArg()));
        }
        if (isLoad) {
            this.keys = jsonWebKeys;
        } else {
            this.say(this.getJwkUtil().toJSON(jsonWebKeys).toString(1));
        }
    }

    protected void listKeysHelp() {
        this.say("list_keys [" + this.showAllKeys + " " + this.CL_INPUT_FILE_FLAG + " file]:This will list all the public keys in the key file in pem format.");
        this.sayi("Each key will be preceeded by its unique ID in the key file.");
        this.sayi("You may invoke this with no argument, in which case the default key file");
        this.sayi("as set in the set_keys command will be used, or you can supply a fully qualified");
        this.sayi("path to a JSON web key file that will be used.");
        this.sayi("If you supply the " + this.showAllKeys + " flag then the private key in PKCS 8 format will be shown");
        this.sayi("too. Note the default is to not show the private key.");
        this.say("  Related: set_keys, create_keys, print_public_keys (prints in JSON format)");
    }

    protected void printPublicKeysHelp() {
        this.say("print_public_keys [file]: This will print the public keys only for a key set.");
        this.sayi("Note that if no file is supplied the current key set is used.");
        this.sayi("The result is JSON formatted. If you need PEM format use list_keys instead.");
    }

    public void print_public_keys(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printPublicKeysHelp();
            return;
        }
        JSONWebKeys localKeys = null;
        if (inputLine.hasArgs()) {
            File publicKeyFile = new File(inputLine.getLastArg());
            localKeys = this.readKeys(publicKeyFile);
        } else {
            localKeys = this.keys;
        }
        JSONWebKeys targetKeys = this.getJwkUtil().makePublic(localKeys);
        JSONObject zzz = this.getJwkUtil().toJSON(targetKeys);
        this.say(zzz.toString(2));
    }

    protected void createPublicKeysHelp() {
        this.say("create_public_keys [" + this.BASE64_FLAG + "] [" + this.CL_INPUT_FILE_FLAG + " in_file] [" + this.CL_OUTPUT_FILE_FLAG + " out_file]");
        this.sayi("Take a set of private keys and extract the public keys.");
        this.sayi("If there is no input file, the current set of keys is used.");
        this.sayi("If the " + this.CL_OUTPUT_FILE_FLAG + " switch is given, the result will be written to the file.");
        this.sayi("If there is no output file specified, then the keys are printed at the console.");
        this.sayi("If the " + this.BASE64_FLAG + " flag is used, then the entire contents is base 64 encoded before");
        this.sayi("being displayed or written to the file.");
        this.say("See also: create_keys, base64");
    }

    public void create_public_keys(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.createPublicKeysHelp();
            return;
        }
        boolean hasInputFile = inputLine.hasArg(this.CL_INPUT_FILE_FLAG);
        boolean hasOutputFile = inputLine.hasArg(this.CL_OUTPUT_FILE_FLAG);
        boolean doB64 = inputLine.hasArg(this.BASE64_FLAG);
        JSONWebKeys localKeys = null;
        if (hasInputFile) {
            File publicKeyFile = new File(inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG));
            localKeys = this.readKeys(publicKeyFile);
        } else {
            if (this.keys == null) {
                this.say("Sorry, there is no set of active keys and no input file was specified. Exiting....");
                return;
            }
            localKeys = this.keys;
        }
        JSONWebKeys targetKeys = this.getJwkUtil().makePublic(localKeys);
        JSONObject zzz = this.getJwkUtil().toJSON(targetKeys);
        String finalOutput = zzz.toString(2);
        if (doB64) {
            finalOutput = Base64.encodeBase64String((byte[])finalOutput.getBytes());
        }
        if (hasOutputFile) {
            try {
                FileUtil.writeStringToFile((String)inputLine.getNextArgFor(this.CL_OUTPUT_FILE_FLAG), (String)finalOutput);
            }
            catch (Throwable iox) {
                this.say("uh-oh... Could not write to the output file:" + iox.getMessage());
            }
        } else {
            this.say(finalOutput);
        }
    }

    protected void writeFile(String filename, String contents) throws Exception {
        File f = new File(filename);
        FileWriter fileWriter = new FileWriter(f);
        fileWriter.write(contents);
        fileWriter.flush();
        fileWriter.close();
    }

    public void list_keys(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.listKeysHelp();
            return;
        }
        boolean showPrivateKeys = inputLine.hasArg(this.showAllKeys);
        boolean hasInputFile = inputLine.hasArg(this.CL_INPUT_FILE_FLAG);
        JSONWebKeys localKeys = null;
        if (showPrivateKeys && !hasInputFile) {
            this.say("warning, there are no private keys to display.");
            showPrivateKeys = false;
        }
        if (hasInputFile) {
            File publicKeyFile = new File(inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG));
            localKeys = this.readKeys(publicKeyFile);
        } else {
            localKeys = this.keys;
        }
        boolean hasDefault = localKeys.hasDefaultKey();
        String defaultKey = null;
        if (hasDefault) {
            defaultKey = localKeys.getDefaultKeyID();
        }
        boolean isFirst = true;
        for (String key : localKeys.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.say("");
            }
            if (hasDefault) {
                if (key.equals(defaultKey)) {
                    this.say("key id=" + key + " (default)");
                } else {
                    this.say("key id=" + key);
                }
            } else {
                this.say("key id=" + key);
            }
            this.say(KeyUtil.toX509PEM((PublicKey)((JSONWebKey)localKeys.get((Object)key)).publicKey));
            if (!showPrivateKeys) continue;
            this.say(KeyUtil.toPKCS8PEM((PrivateKey)((JSONWebKey)localKeys.get((Object)key)).privateKey));
        }
    }

    protected void printCreateClaimsHelp() {
        this.say("create_claims: Prompt the user for key/value pairs and build a claims object. ");
        this.sayi("This will write the object to a file for future use.");
        this.sayi("Note: You may input JSON objects as values as well. There are various");
        this.sayi("places (such as creating a token) that requires a set of claims. This command");
        this.sayi("lets you create one.");
        this.say("See also: create_token, parse_claims");
    }

    public void create_claims(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printCreateClaimsHelp();
            return;
        }
        this.say("Enter a key then a value when prompted. You can enter multiple values separated by commas");
        this.say("Just hit return (no value) to exit");
        boolean isDone = false;
        JSONObject jsonObject = new JSONObject();
        while (!isDone) {
            String key = this.getInput("Enter key or return to exit.");
            if (this.isEmpty(key)) {
                isDone = true;
                continue;
            }
            String value = this.getInput("Enter value. multiple values should be comma separated");
            try {
                JSONObject json = JSONObject.fromObject((Object)value);
                jsonObject.put((Object)key, (Object)json);
            }
            catch (Throwable t) {
                if (0 < value.indexOf(",")) {
                    StringTokenizer st = new StringTokenizer(value, ",");
                    JSONArray array = new JSONArray();
                    while (st.hasMoreTokens()) {
                        array.add((Object)st.nextToken());
                    }
                    jsonObject.put((Object)key, (Object)array);
                    continue;
                }
                jsonObject.put((Object)key, (Object)value);
            }
        }
        this.sayi("Here's what you inputted");
        this.say(jsonObject.toString(2));
        boolean isWrite = this.getBooleanInput("Would you like to write this to a file?[y/n]");
        if (isWrite) {
            String overwrite;
            String fileName = this.getInput("Enter filename");
            File f = new File(fileName);
            if (f.exists() && !Boolean.parseBoolean(overwrite = this.getInput("This file exists. Do you want to overwrite it?", "false"))) {
                return;
            }
            String output = jsonObject.toString(2);
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(output.getBytes());
            fos.flush();
            fos.close();
            this.sayi(String.valueOf(f) + " written!");
        }
    }

    protected boolean getBooleanInput(String prompt) throws IOException {
        String x = this.getInput(prompt, "y");
        return x.equalsIgnoreCase("y") || x.equalsIgnoreCase("yes") || x.equalsIgnoreCase("true");
    }

    protected String getInput(String prompt) throws IOException {
        String inLine = this.readline(prompt + ":");
        if (this.isEmpty(inLine)) {
            return null;
        }
        return inLine;
    }

    protected void printSetDefaultIDHelp() {
        this.say("set_default_id [keyid]: This will set the default key id to be used for all signing and verification.");
        this.sayi("If this is not set, you will be prompted each time for an id.");
        this.sayi("Remember that a set of web keys does not have a default. If you import.");
        this.sayi("a set, you should set one as default.");
        this.say("See also: print_default_id");
    }

    public void set_default_id(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printSetDefaultIDHelp();
            return;
        }
        if (1 < inputLine.size()) {
            this.defaultKeyID = inputLine.getArg(1);
            return;
        }
        String x = this.getInput("Enter the key id");
        if (this.isEmpty(x)) {
            return;
        }
        this.defaultKeyID = x;
    }

    protected void printPrintDefaultIDHelp() {
        this.say("print_default_id: This will print the current default key id that is to be used for all signing and verification.");
        this.say("See also: set_default_id");
    }

    public void print_default_id(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printSetDefaultIDHelp();
            return;
        }
        if (this.defaultKeyID == null || this.defaultKeyID.isEmpty()) {
            this.say("(not set)");
            return;
        }
        this.say("default key id=\"" + this.defaultKeyID + "\"");
    }

    protected void printParseClaimsHelp() {
        this.say("parse_claims [" + this.CL_INPUT_FILE_FLAG + " filename]");
        this.sayi("Read a file and print out if it parses as JSON.");
        this.sayi("If the filename is omitted, you will be prompted for it.");
        this.sayi("Note that this will try to give some limited feedback in syntax errors.");
        this.sayi("The intent is that if you have written a file with claims, this lets you");
        this.sayi("validate the JSON before using it.");
        this.say("See also: create_claims");
    }

    public void parse_claims(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printParseClaimsHelp();
            return;
        }
        boolean hasInputFile = inputLine.hasArg(this.CL_INPUT_FILE_FLAG);
        String filename = null;
        if (hasInputFile) {
            filename = inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG);
        } else {
            filename = this.getInput("Enter full path to the claims file.");
            if (this.isEmpty(filename)) {
                this.say("No claims file. Exiting...");
                return;
            }
        }
        String rawJSON = null;
        try {
            rawJSON = FileUtil.readFileAsString((String)filename);
        }
        catch (Throwable e) {
            if (this.getDriver().isTraceOn()) {
                e.printStackTrace();
            }
            this.say("could not read file: " + filename);
            return;
        }
        if (rawJSON == null) {
            this.say("Could not read the file \"" + filename + "\"");
            return;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.fromObject((Object)rawJSON);
        }
        catch (Throwable t) {
            this.say("Parsing fail with a message of \"" + t.getMessage() + "\"");
            return;
        }
        if (jsonObject != null) {
            this.say("success!");
            this.say(jsonObject.toString(3));
        } else {
            this.say("No JSON object resulted from parsing.");
        }
    }

    protected String getArgValue(InputLine inputLine, String key) {
        return inputLine.getNextArgFor(key);
    }

    protected void createTokenHelp() {
        this.say("create_token " + this.CL_INPUT_FILE_FLAG + " claims [" + this.CL_KEY_FILE_FLAG + " keyfile " + this.CL_KEY_ID_FLAG + " id " + this.CL_OUTPUT_FILE_FLAG + " outputFile]");
        this.sayi("Interactive mode:                                                                     ");
        this.sayi("   This will take the current keys (uses default) and a file containing a JSON");
        this.sayi("   format set of claims. It will then sign the claims with the right headers etc.");
        this.sayi("   and optionally print out the resulting JWT to the console. Any of the arguments omitted ");
        this.sayi("   will cause you to be prompted. NOTE that this only signs the token! If you need to generate");
        this.sayi("   accounting information like the timestamps, please use generate_token instead");
        this.sayi("   If you have already set the key and keyid these will be used.");
        this.sayi("   If the output file is given, the token will be written there instead.");
        this.sayi("");
        this.sayi("   E.g.                                                                                            ");
        this.sayi("   create_token " + this.CL_KEY_FILE_FLAG + " keys.jwk " + this.CL_KEY_ID_FLAG + " ABC123 " + this.CL_INPUT_FILE_FLAG + " my_claims.txt " + this.CL_OUTPUT_FILE_FLAG + " my_token.jwt");
        this.sayi("  Will read the keys in the file keys.jwk, select the one with id ABC123 then                   ");
        this.sayi("  read in the my_claims.txt file (assumed to be a set of claims in JSON format)                 ");
        this.sayi("  and create the header and signature. It will then place the result into the file my_token.jwt ");
        this.sayi("                                                                                                ");
        this.sayi("create_token " + this.CL_WELL_KNOWN_FLAG + " https://fnord.baz/.well-known " + this.CL_KEY_ID_FLAG + " CAFEBEEF " + this.CL_INPUT_FILE_FLAG + " my_claims.txt           ");
        this.sayi("This will read the well-known file, parse it for the keys, load the keys, find the key       ");
        this.sayi("with id CAFEBEEF read in the claims file then print the resulting token to the command line. ");
        this.say("Related: generate_token, set_keys, set_default_id, print_token, verify_token");
    }

    public void create_token(InputLine inputLine) throws Exception {
        String signedToken;
        if (this.showHelp(inputLine)) {
            this.createTokenHelp();
            return;
        }
        File outputFile = null;
        if (inputLine.hasArg(this.CL_OUTPUT_FILE_FLAG)) {
            outputFile = new File(inputLine.getNextArgFor(this.CL_OUTPUT_FILE_FLAG));
        }
        JSONWebKeys localKeys = null;
        if (inputLine.hasArg(this.CL_KEY_FILE_FLAG)) {
            String fileName = this.getArgValue(inputLine, this.CL_KEY_FILE_FLAG);
            File f = new File(fileName);
            if (!f.exists()) {
                this.say("Sorry, that file does not seem to exist");
                return;
            }
            if (!f.isFile()) {
                this.say("Sorry, the thing you specified is not a file.");
                return;
            }
            localKeys = this.readKeys(f);
        }
        if (inputLine.hasArg(this.CL_WELL_KNOWN_FLAG)) {
            localKeys = JWTUtil.getJsonWebKeys((String)inputLine.getNextArgFor(this.CL_WELL_KNOWN_FLAG));
        }
        if (localKeys == null) {
            if (this.keys == null || this.keys.isEmpty()) {
                if (this.getBooleanInput("No keys set. Would you like to specify keys for signing?")) {
                    String x = this.getInput("Enter fully qualified path and file name");
                    if (this.isEmpty(x)) {
                        this.say("no file entered, exiting...");
                        return;
                    }
                    localKeys = this.readKeys(new File(x));
                }
            } else {
                localKeys = this.keys;
            }
        }
        String localDefaultID = null;
        if (inputLine.hasArg(this.CL_KEY_ID_FLAG)) {
            localDefaultID = this.getArgValue(inputLine, this.CL_KEY_ID_FLAG);
        } else if (this.defaultKeyID != null) {
            localDefaultID = this.defaultKeyID;
        } else if (this.getBooleanInput("No key id found. Do you want to enter one?")) {
            localDefaultID = this.getInput("Enter key id:");
        } else {
            return;
        }
        JSONObject claims = null;
        if (inputLine.hasArg(this.CL_INPUT_FILE_FLAG)) {
            try {
                claims = JSONObject.fromObject((Object)FileUtil.readFileAsString((String)this.getArgValue(inputLine, this.CL_INPUT_FILE_FLAG)));
            }
            catch (Throwable e) {
                if (this.getDriver().isTraceOn()) {
                    e.printStackTrace();
                }
                this.say("error reading input file: " + e.getMessage());
                return;
            }
        }
        String x = this.getInput("Enter the name of the file containing the JSON object to use:");
        if (this.isEmpty(x)) {
            this.say("No argument, exiting...");
            return;
        }
        try {
            claims = JSONObject.fromObject((Object)FileUtil.readFileAsString((String)x));
        }
        catch (Throwable e) {
            if (this.getDriver().isTraceOn()) {
                e.printStackTrace();
            }
            this.say("error reading claims file \"" + x + "\":" + e.getMessage());
        }
        this.lastToken = signedToken = JWTUtil.createJWT((JSONObject)claims, (JSONWebKey)((JSONWebKey)localKeys.get((Object)localDefaultID)));
        if (outputFile == null) {
            this.say(signedToken);
        } else {
            FileWriter fileWriter = new FileWriter(outputFile);
            fileWriter.write(signedToken);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    protected void generateTokenHelp() {
        this.say("generate_token " + this.CL_INPUT_FILE_FLAG + "  claims " + this.CL_KEY_FILE_FLAG + " keyFile " + this.CL_KEY_ID_FLAG + " keyId [" + this.JTI_FLAG + " | " + this.PRINT_CLAIMS_FLAG + " | " + this.LIFETIME_FLAG + "  lifetime | " + this.CL_OUTPUT_FILE_FLAG + " outFile]");
        this.sayi("Generate a token from the claims. This includes adding in the current time and using the lifetime (if given)");
        this.sayi("to create the token. A JTI will also be created. ");
        this.sayi("The meaning of the various optional flags is as follows");
        this.sayi(this.CL_INPUT_FILE_FLAG + " (required) The text file of a JSON object that has the claims.");
        this.sayi(this.CL_KEY_FILE_FLAG + " (required) + The JWK format file containing the keys. This must contain a private key.");
        this.sayi(this.CL_KEY_ID_FLAG + " (required) The id in the key file of the key to use.");
        this.sayi(this.JTI_FLAG + " (optional) If specified, generate a unique identifier for this id token. You may also just");
        this.sayi("    put one in the claims file if you need it immutable.");
        this.sayi(this.PRINT_CLAIMS_FLAG + " (optional) If specified, this will print out the generated claims (not token!) to the command line.");
        this.sayi(this.LIFETIME_FLAG + " (optional) Specifies the lifetime in seconds for this token. The default is " + this.DEFAULT_LIFETIME + " seconds.");
        this.sayi("    Note: not specifying an output file will print the resulting token.");
        this.sayi(this.CL_OUTPUT_FILE_FLAG + " (optional) The file to which the resulting token is written. Omitting this dumps it to the command line.");
    }

    public void generate_token(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.generateTokenHelp();
            return;
        }
        if (this.gracefulExit(!inputLine.hasArg(this.CL_INPUT_FILE_FLAG), "Missing claims file.")) {
            return;
        }
        if (this.gracefulExit(!inputLine.hasArg(this.CL_KEY_FILE_FLAG), "Missing keys file.")) {
            return;
        }
        if (this.gracefulExit(!inputLine.hasArg(this.CL_KEY_ID_FLAG), "Missing key id for signature.")) {
            return;
        }
        String localDefaultID = this.getArgValue(inputLine, this.CL_KEY_ID_FLAG);
        JSONWebKeys localKeys = this.readKeys(new File(inputLine.getNextArgFor(this.CL_KEY_FILE_FLAG)));
        if (this.gracefulExit(!localKeys.containsKey((Object)localDefaultID), "The key id is not in the key set. Check the id.")) {
            return;
        }
        long lifetime = this.DEFAULT_LIFETIME;
        if (inputLine.hasArg(this.LIFETIME_FLAG)) {
            lifetime = Long.parseLong(inputLine.getNextArgFor(this.LIFETIME_FLAG));
        }
        long issuedAt = new Date().getTime();
        String x = inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG);
        JSONObject claims = null;
        try {
            claims = this.readJSON(x);
        }
        catch (Throwable e) {
            if (this.getDriver().isTraceOn()) {
                e.printStackTrace();
            }
            this.say("error reading file \"" + x + "\": " + e.getMessage());
            return;
        }
        claims.put((Object)"iat", (Object)(issuedAt / 1000L));
        claims.put((Object)"nbf", (Object)(issuedAt / 1000L));
        claims.put((Object)"exp", (Object)(issuedAt / 1000L + lifetime));
        if (inputLine.hasArg(this.JTI_FLAG)) {
            Object jti = "";
            SecureRandom secureRandom = new SecureRandom();
            byte[] secret = new byte[32];
            secureRandom.nextBytes(secret);
            BigInteger bigInteger = new BigInteger(secret);
            bigInteger = bigInteger.abs();
            jti = "jti://" + bigInteger.toString(this.JTI_RADIX);
            claims.put((Object)"jti", jti);
        }
        if (inputLine.hasArg(this.PRINT_CLAIMS_FLAG)) {
            this.say(claims.toString(2));
        }
        String signedToken = JWTUtil.createJWT((JSONObject)claims, (JSONWebKey)((JSONWebKey)localKeys.get((Object)localDefaultID)));
        if (inputLine.hasArg(this.CL_OUTPUT_FILE_FLAG)) {
            this.writeFile(inputLine.getNextArgFor(this.CL_OUTPUT_FILE_FLAG), signedToken);
        } else {
            this.say(signedToken);
        }
    }

    protected void printTokenHelp() {
        this.say("print_token: [" + this.CL_INPUT_FILE_FLAG + " file | token] Print the given token's header and payload, doing no verification.");
        this.sayi("If you omit the argument, it will print the last token generated by the create_token call.");
        this.sayi("If there is no last token, that will be shown too. ");
        this.say("Related: create_token");
    }

    public void print_token(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printTokenHelp();
            return;
        }
        if (inputLine.isEmpty()) {
            if (this.lastToken == null) {
                this.say("(no token has been created)");
                return;
            }
            this.say(this.lastToken);
            return;
        }
        String rawToken = null;
        if (inputLine.hasArg(this.CL_INPUT_FILE_FLAG)) {
            String x = inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG);
            try {
                rawToken = FileUtil.readFileAsString((String)x);
            }
            catch (Throwable e) {
                if (this.getDriver().isTraceOn()) {
                    e.printStackTrace();
                }
                this.say("error reading file \"" + x + "\"");
                return;
            }
        } else {
            rawToken = inputLine.getLastArg();
        }
        JSONObject[] payloads = JWTUtil.readJWT((String)rawToken);
        this.say("header");
        this.say(payloads[0].toString(2));
        this.say("payload");
        this.say(payloads[1].toString(2));
    }

    protected void printListKeyIDs() {
        this.say("list_key_ids [filename]");
        this.sayi("List the unique key ids in the file");
        this.sayi("If you do not supply an argument, the globally set keys will be used");
        this.sayi("If there is no default set of keys, you will be prompted for a file");
        this.say("See also: set_keys, set_default_id");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void list_key_ids(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.printListKeyIDs();
            return;
        }
        JSONWebKeys jsonWebKeys = null;
        if (1 < inputLine.size()) {
            jsonWebKeys = this.getJwkUtil().fromJSON(new File(inputLine.getArg(1)));
        } else if (this.keys == null) {
            if (!this.getBooleanInput("Do you want to enter a file name?")) return;
            String x = this.getInput("Enter path and name of the key file");
            jsonWebKeys = this.getJwkUtil().fromJSON(new File(x));
        } else {
            jsonWebKeys = this.keys;
        }
        String defaultWebKey = null;
        defaultWebKey = jsonWebKeys.hasDefaultKey() ? jsonWebKeys.getDefaultKeyID() : this.defaultKeyID;
        for (String keyID : jsonWebKeys.keySet()) {
            JSONWebKey webKey = (JSONWebKey)jsonWebKeys.get((Object)keyID);
            boolean isDefault = webKey.id.equals(defaultWebKey);
            this.say("id=" + keyID + ", alg=" + webKey.algorithm + ", type=" + webKey.type + ", use=" + webKey.use + (isDefault ? " (default)" : ""));
        }
    }

    protected void printValidateTokenHelp() {
        this.say("validate_token [" + this.CL_WELL_KNOWN_FLAG + " url | " + this.CL_KEY_FILE_FLAG + " file " + this.CL_INPUT_FILE_FLAG + " filename  | token]");
        this.sayi("This will take a token and check the signature. It will also print out the payload");
        this.sayi("and header information.");
        this.sayi("The validation is against the current set of keys or against a URL specified with the");
        this.sayi("-wellKnown flag. You can also point to a key file (file with JSON web keys in it) with");
        this.sayi("the -keyFile flag.");
        this.sayi("You may supply either the token itself or specify with the -file flag that this is in a file.");
        this.sayi("E.g.s                                                                                                          ");
        this.sayi("validate_token " + this.CL_WELL_KNOWN_FLAG + " https://foo.bar/.well-known " + this.CL_INPUT_FILE_FLAG + " my_token.jwt                                         ");
        this.sayi("   This will read the keys in the well-known file and read the token in the file                                ");
        this.sayi("                                                                                                             ");
        this.sayi("validate_token " + this.CL_WELL_KNOWN_FLAG + " https://foo.bar/.well-known -v " + this.CL_INPUT_FILE_FLAG + " my_token.jwt                                      ");
        this.sayi("   Identical behavior to the first example but note the -v flag: This causes any information about              ");
        this.sayi("   the token to be printed. Normally this is not used except for trying to debug issues.                        ");
        this.sayi("                                    ");
        this.sayi("validate_token " + this.CL_KEY_FILE_FLAG + "  keys.jwk eyJ...........                                                                    ");
        this.sayi("   This will read in the keys from the give file and the assumption is that the last argument is the token itself");
        this.sayi("   Note that in this example the token is truncated so it fits here.                                     ");
        this.say("See also: create_token");
    }

    public void validate_token(InputLine inputLine) throws Exception {
        JSONWebKeys keys;
        String token;
        block13: {
            if (this.showHelp(inputLine)) {
                this.printValidateTokenHelp();
                return;
            }
            token = null;
            if (1 == inputLine.size()) {
                this.say("Sorry, no argument");
                return;
            }
            token = inputLine.hasArg(this.CL_INPUT_FILE_FLAG) ? inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG) : inputLine.getLastArg();
            keys = this.keys;
            if (inputLine.hasArg(this.CL_WELL_KNOWN_FLAG)) {
                String wellKnown = inputLine.getNextArgFor(this.CL_WELL_KNOWN_FLAG);
                try {
                    keys = JWTUtil.getJsonWebKeys((ServiceClient)new ServiceClient(URI.create("https://cilogon.org")), (String)wellKnown);
                }
                catch (Throwable t) {
                    this.sayi("Sorry, could not parse the url: \"" + wellKnown + "\". Message=\"" + t.getMessage() + "\"");
                }
            }
            if (inputLine.hasArg(this.CL_KEY_FILE_FLAG) && !inputLine.hasArg(this.CL_WELL_KNOWN_FLAG)) {
                File f = new File(inputLine.getNextArgFor(this.CL_KEY_FILE_FLAG));
                if (this.gracefulExit(!f.exists(), "Sorry, the file \" + f + \" does not exist")) {
                    return;
                }
                try {
                    keys = this.readKeys(f);
                }
                catch (Throwable t) {
                    if (!this.gracefulExit(true, "Sorry, could not load the file: \"" + inputLine.getNextArgFor("-keyFile") + "\". Message=\"" + t.getMessage() + "\"")) break block13;
                    return;
                }
            }
        }
        if (this.gracefulExit(keys == null, "Sorry, no keys set, please set keys or specify a well-known URL.")) {
            return;
        }
        String[] x = JWTUtil.decat((String)token);
        Base64URL h = new Base64URL(x[0]);
        Base64URL p = new Base64URL(x[1]);
        Base64URL s = null;
        JSONObject fullHeader = JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)x[0])));
        if (x.length == 3) {
            s = new Base64URL(new String(x[2]));
        }
        if (JWTUtil.verify((Base64URL)h, (Base64URL)p, (Base64URL)s, (JSONWebKey)((JSONWebKey)keys.get((Object)fullHeader.getString("kid"))))) {
            this.say("token valid!");
        } else {
            this.say("could not validate token");
        }
    }

    public static void main(String[] args) {
        try {
            String sig = "L2ZN8jp_-SmPmAiEels5DsGKx-nh--EPo3lgGTqp6Kpp5IpwKrgpK0Wc34Cs2iALYtQqyaqvrWVhr1kZxS9_TI4WrE84BIYlpuFc-hSqKl4JVRHhn0ij_Jg7_Y6KuwPdfKeWNq6L9wUxKJPyIMU3WxGV-Nrcl9nAYt9SlrqMBOA7bARuUQfl1maZ05HRZFImL0Ol1PbAOfnbff74P323dbwzGJ1AxqQIvfVmniJXwr_4K88yZxrcYTs81yse8oT1SAsTffiVKJvwoD4DctMxkYas-_mJPaW-WNylBME8GR-R3f0RjTxJ-xO5WlMP8kbVJ2V5rcdzjirqIWqfF9i1Eg";
            byte[] byetArray = Base64.decodeBase64((String)sig);
            String path = "/home/ncsa/temp/rokwire/sig.b";
            File f = new File(path);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(byetArray, 0, byetArray.length);
            FileOutputStream fileOutputStream = new FileOutputStream(f);
            baos.writeTo(fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void base64Help() {
        this.say("base64 " + this.base64Encode + " | " + this.base64Dencode + " " + this.base64Bytes + " " + this.CL_INPUT_FILE_FLAG + " in_file " + this.CL_OUTPUT_FILE_FLAG + " out_file | arg");
        this.sayi("This will encode or decode a base 64 arg. ");
        this.sayi("You may specify which input or output. If none is given, then the assumption is that the input is the arg");
        this.sayi("and the output is to the terminal.");
        this.sayi(this.base64Dencode + ": the input is base64 encoded, output is plain text");
        this.sayi(this.base64Encode + ": the input is plain text, output is base 64 encoded.");
        this.sayi(this.base64Bytes + " treat the output as bytes. Generally this implies you have specified an output file.");
        this.sayi("Note: i the output is binary, you should specify a file as the target since otherwise you get gibbersih.");
    }

    public void base64(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.base64Help();
            return;
        }
        boolean hasInfile = inputLine.hasArg(this.CL_INPUT_FILE_FLAG);
        boolean hasOutfile = inputLine.hasArg(this.CL_OUTPUT_FILE_FLAG);
        boolean isEncode = inputLine.hasArg(this.base64Encode);
        boolean isDecode = inputLine.hasArg(this.base64Dencode);
        boolean isBinary = inputLine.hasArg(this.base64Bytes);
        this.gracefulExit(isDecode && isEncode, "Sorry, you cannot specify both encoding and decoding at the same time");
        String input = "";
        String x = inputLine.getNextArgFor(this.CL_INPUT_FILE_FLAG);
        if (hasInfile) {
            try {
                input = FileUtil.readFileAsString((String)x);
            }
            catch (Throwable e) {
                if (this.getDriver().isTraceOn()) {
                    e.printStackTrace();
                }
                this.say("error reading input file \"" + x + "\":" + e.getMessage());
            }
        } else {
            input = inputLine.getLastArg();
        }
        String output = "";
        if (isEncode) {
            output = Base64.encodeBase64String((byte[])input.getBytes());
            if (hasOutfile) {
                this.writeFile(inputLine.getNextArgFor(this.CL_OUTPUT_FILE_FLAG), output);
            } else {
                this.say(output);
            }
        } else {
            byte[] bytes = Base64.decodeBase64((String)input);
            if (!hasOutfile) {
                this.say(new String(bytes));
                return;
            }
            if (isBinary) {
                File f = new File(inputLine.getNextArgFor(this.CL_OUTPUT_FILE_FLAG));
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(bytes);
                fos.flush();
                fos.close();
            } else {
                this.writeFile(inputLine.getNextArgFor(this.CL_OUTPUT_FILE_FLAG), new String(bytes));
            }
        }
    }
}

