/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.ObjectNotFoundException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.DebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.storage.cli.FoundIdentifiables;
import edu.uiuc.ncsa.security.storage.cli.StoreCommands2;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import net.sf.json.JSONObject;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.server.storage.ClientApproval;
import org.oa4mp.delegation.server.storage.ClientStore;
import org.oa4mp.server.admin.oauth2.base.BaseClientStoreCommands;
import org.oa4mp.server.admin.oauth2.base.ClientApprovalStoreCommands;
import org.oa4mp.server.api.admin.adminClient.AdminClient;
import org.oa4mp.server.api.admin.adminClient.AdminClientKeys;
import org.oa4mp.server.api.admin.permissions.Permission;
import org.oa4mp.server.api.admin.permissions.PermissionKeys;
import org.oa4mp.server.api.admin.permissions.PermissionList;
import org.oa4mp.server.api.admin.permissions.PermissionsStore;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2Client;
import org.oa4mp.server.loader.oauth2.storage.clients.OA2ClientKeys;

public class OA2AdminClientCommands
extends BaseClientStoreCommands {
    ClientStore clientStore;
    PermissionsStore permissionsStore;
    public static String LINK_NEW_CLIENT_FLAG = "-new";
    public static String LINK_RANDOM_CLIENT_ID_ARG = "?";
    public static final String UNLINK_ALL_FLAG = "-all";
    public static final String UNLINK_REMOVE_FLAG = "-rm";
    public static String NO_VERIFY_ALL_FLAG = "-no_verify";
    public static final String APPROVAL_QDL_ENABLE = "-qdl";

    public OA2AdminClientCommands(CLIDriver driver, String defaultIndent, Store adminClientStore, ClientApprovalStoreCommands clientApprovalStoreCommands, PermissionsStore permissionsStore, ClientStore clientStore) throws Throwable {
        super(driver, defaultIndent, adminClientStore, clientApprovalStoreCommands);
        this.clientStore = clientStore;
        this.permissionsStore = permissionsStore;
    }

    @Override
    public void initialize() throws Throwable {
    }

    public String getName() {
        return "  admins";
    }

    @Override
    public void print_help() throws Exception {
        super.print_help();
        this.say("--Admin specific commands:");
        this.sayi("count_clients = How many clients does a given admin manage?");
        this.sayi("list_admins = who administers a client?");
        this.sayi("list_clients = list the clients for a specific admin");
    }

    @Override
    public void extraUpdates(Identifiable identifiable, int magicNumber) throws IOException {
        String vi;
        String viURI;
        AdminClient client = (AdminClient)identifiable;
        AdminClientKeys keys = (AdminClientKeys)this.getSerializationKeys();
        super.extraUpdates((Identifiable)client, magicNumber);
        String issuer = this.getPropertyHelp(keys.issuer(new String[0]), "Give the issuer", client.getIssuer());
        if (!this.isEmpty(issuer)) {
            client.setIssuer(issuer);
        }
        if (!this.isEmpty(viURI = client.getVirtualIssuer() == null ? this.getPropertyHelp(keys.voURI(new String[0]), "Give the VI URI", null) : this.getPropertyHelp(keys.voURI(new String[0]), "Give the VI URI", client.getVirtualIssuer().toString()))) {
            try {
                URI z = URI.create(viURI);
                client.setVirtualIssuer(BasicIdentifier.newID((URI)z));
            }
            catch (Throwable t) {
                if (DebugUtil.isEnabled()) {
                    t.printStackTrace();
                }
                this.say("sorry, but that was not a valid identifier");
            }
        }
        if (client.getExternalVIName() == null) {
            String vvv = client.getVirtualIssuer().toString();
            vi = this.getPropertyHelp(keys.vo(new String[0]), "Give the VI", vvv);
        } else {
            vi = this.getPropertyHelp(keys.vo(new String[0]), "Give the VI", client.getExternalVIName().toString());
        }
        if (!this.isEmpty(vi)) {
            client.setExternalVIName(vi);
        }
        client.setAllowQDL(this.getPropertyHelp(keys.allowQDL(new String[0]), "allow QDL?", "n").equalsIgnoreCase("y"));
        if (client.isAllowQDL()) {
            client.setAllowQDLCodeBlocks(this.getPropertyHelp(keys.allowQDLCodeBlocks(new String[0]), "  allow code blocks containing QDL (y/n)?", "n").equalsIgnoreCase("y"));
        }
        if (this.getInput("configure advanced options (y/n)?", "n").equalsIgnoreCase("y")) {
            JSONObject newConfig = this.inputJSON(client.getConfig(), "client configuration");
            String max = this.getPropertyHelp(keys.maxClients(new String[0]), "Enter new maximum number of clients allowed", Integer.toString(client.getMaxClients()));
            if (!this.isEmpty(max)) {
                client.setMaxClients(Integer.parseInt(max));
            }
            if (newConfig != null) {
                client.setConfig(newConfig);
            }
            if (this.getPropertyHelp(keys.allowCustomIDs(new String[0]), "allow custom ids in client management (y/n)?", "n").equalsIgnoreCase("y")) {
                client.setAllowCustomIDs(true);
                if (this.getPropertyHelp(keys.generateIDs(new String[0]), "  generate ids automatically (y/n)?", "y").equalsIgnoreCase("y")) {
                    client.setGenerateIDs(true);
                } else {
                    client.setGenerateIDs(false);
                    client.setUseTimestampInIDs(this.getPropertyHelp(keys.useTimestampsInIds(new String[0]), "  use timestamps in IDs (y/n)?", "y").equalsIgnoreCase("y"));
                    String head = this.getPropertyHelp(keys.idHead(new String[0]), "  uri to use as start of custom ids (return only for system default)", "");
                    if (!this.isEmpty(head)) {
                        client.setIdHead(URI.create(head));
                    }
                }
            }
        }
    }

    protected void showListClientsHelp() {
        this.say("list_clients index - list all the clients this administrator manages");
        this.say("                        This also lists if the client with the given id has been approved.");
        this.printIndexHelp(true);
    }

    public void list_clients(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showListClientsHelp();
            return;
        }
        AdminClient adminClient = (AdminClient)this.findSingleton(inputLine, "admin client not found");
        List clients = this.permissionsStore.getClients(adminClient.getIdentifier());
        if (clients == null || clients.isEmpty()) {
            this.say("(none)");
        }
        TreeSet sortedClients = new TreeSet();
        sortedClients.addAll(clients);
        for (Identifier identifier : sortedClients) {
            this.say("(" + (this.getClientApprovalStore().isApproved(identifier) ? "Y" : "N") + ") " + String.valueOf(identifier));
        }
        this.say(clients.size() + " total clients");
    }

    protected void showCountClientsHelp() {
        this.say("count_clients index - Count the number of clients this administrator manages");
        this.say("                       For databases, this call is more efficient that getting all the clients and counting them.");
        this.printIndexHelp(false);
    }

    public void count_clients(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showCountClientsHelp();
            return;
        }
        FoundIdentifiables identifiables = this.findItem(inputLine);
        if (identifiables == null) {
            this.say("Sorry, there is no admin client for this identifier.");
            return;
        }
        for (Identifiable identifiable : identifiables) {
            AdminClient adminClient = (AdminClient)identifiable;
            this.say("admin client " + adminClient.getIdentifierString() + " manages " + this.permissionsStore.getClientCount(adminClient.getIdentifier()) + " out of a possible " + adminClient.getMaxClients() + ".");
        }
    }

    protected void showListAdminsHelp() {
        this.say("list_admins client_id - list the administrators associated with the given client id");
        this.say("                 You may specify an result set of clients (not admin clients).");
        this.say("E.g.");
        this.say("admins>list_admins - [1,3,4,5] my_clients");
        this.say("would list the admin clients for entries 1, 3, 4 and 5 in the result set my_clients");
        this.printIndexHelp(false);
    }

    public void list_admins(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showListAdminsHelp();
            return;
        }
        if (inputLine.getArgCount() == 0) {
            this.say("no clients identifier found");
            return;
        }
        Identifier clientID = BasicIdentifier.newID((String)inputLine.getLastArg());
        FoundIdentifiables foundClients = this.findItem((Store)this.getEnvironment().getClientStore(), inputLine, true);
        if (foundClients == null) {
            this.say("client not found.");
            return;
        }
        for (Identifiable identifiable : foundClients) {
            BaseClient baseClient = (BaseClient)identifiable;
            List admins = this.permissionsStore.getAdmins(baseClient.getIdentifier());
            this.say(admins.size() + " admins for " + baseClient.getIdentifierString());
            if (admins == null || admins.isEmpty()) {
                this.say("(none)");
                return;
            }
            for (Identifier id : admins) {
                AdminClient adminClient = (AdminClient)this.getStore().get((Object)id);
                if (adminClient == null) continue;
                this.say(this.format((BaseClient)adminClient, (ClientApproval)this.getClientApprovalStore().get((Object)adminClient.getIdentifier())));
            }
            if (1 >= foundClients.size()) continue;
            this.say(StringUtils.hLine((String)"-", (int)40));
        }
    }

    protected void showDeserializeHelp() {
        super.showDeserializeHelp();
        this.say("NOTE that for clients, the assumption is that you are supplying the hashed secret, not the actual secret.");
        this.say("If you need to create a hash of a secret, invoke the create_hash method on the secret");
    }

    public void link(InputLine inputLine) throws Throwable {
        ArrayList<Identifier> clientIDs;
        if (this.showHelp(inputLine)) {
            this.say("link client_id index - link the client with the given client_id to the admin client");
            this.say("link " + LINK_NEW_CLIENT_FLAG + " (" + LINK_RANDOM_CLIENT_ID_ARG + " | client_id) index- create a new client and link it with the given client_id admin client");
            this.say("   You must supply either a new client id or a \"" + LINK_RANDOM_CLIENT_ID_ARG + "\". If a " + LINK_RANDOM_CLIENT_ID_ARG + " is used, then a random identifier will be created. This merely creates it, you must edit it later.");
            this.printIndexHelp(true);
            this.say("See also: unlink");
            return;
        }
        boolean createNewClient = inputLine.hasArg(LINK_NEW_CLIENT_FLAG);
        Identifier clientID = null;
        boolean isRS = false;
        if (createNewClient) {
            String newID = inputLine.getNextArgFor(LINK_NEW_CLIENT_FLAG);
            OA2Client client = (OA2Client)this.clientStore.create();
            if (newID.equals(LINK_RANDOM_CLIENT_ID_ARG)) {
                clientID = client.getIdentifier();
            } else {
                clientID = BasicIdentifier.newID((String)newID);
                if (this.clientStore.containsKey((Object)clientID)) {
                    this.say("sorry but the client with id \"" + String.valueOf(clientID) + "\" already exists. aborting.");
                    return;
                }
                client.setIdentifier(clientID);
            }
            this.clientStore.save((Identifiable)client);
            this.say("new client with id \"" + client.getIdentifierString() + "\" created. You must edit this separately.");
            inputLine.removeSwitchAndValue(LINK_NEW_CLIENT_FLAG);
            clientIDs = new ArrayList(1);
            clientIDs.add(clientID);
        } else {
            String rawID = inputLine.getArg(1);
            FoundIdentifiables clients = this.findByIDOrRS((Store)this.getEnvironment().getClientStore(), rawID);
            if (clients == null) {
                this.say("sorry. could not find a client or ID");
                return;
            }
            isRS = true;
            clientIDs = new ArrayList<Identifier>(clients.size());
            for (Identifiable client : clients) {
                clientIDs.add(client.getIdentifier());
            }
        }
        AdminClient adminClient = (AdminClient)this.findSingleton(inputLine, "admin client not found");
        int pass = 0;
        int fail = 0;
        for (Identifier client_id : clientIDs) {
            PermissionList permissionList = this.permissionsStore.get(adminClient.getIdentifier(), client_id);
            if (permissionList != null && !permissionList.isEmpty()) {
                this.say("sorry, client \"" + String.valueOf(client_id) + "\" is already managed by this admin.");
                ++fail;
                continue;
            }
            Permission permission = (Permission)this.permissionsStore.create();
            permission.setApprove(true);
            permission.setCreate(true);
            permission.setDelete(true);
            permission.setRead(true);
            permission.setWrite(true);
            permission.setClientID(client_id);
            permission.setAdminID(adminClient.getIdentifier());
            this.permissionsStore.save((Identifiable)permission);
            ++pass;
        }
        if (isRS) {
            this.say("done. " + pass + " clients are now managed by \"" + adminClient.getIdentifierString() + "\"");
            if (0 < fail) {
                this.say(fail + " clients were already managed.");
            }
            return;
        }
        this.say("done. The client with identifier \"" + String.valueOf(clientID) + "\" is now managed by \"" + adminClient.getIdentifierString() + "\"");
    }

    protected void unlinkRS(InputLine inputLine) {
        String rsName = inputLine.getNextArgFor("-rs");
        StoreCommands2.RSRecord rsRecord = null;
        rsRecord = this.isCARS(rsName) ? (StoreCommands2.RSRecord)this.clientApprovalStoreCommands.getResultSets().get(rsName) : (StoreCommands2.RSRecord)this.getResultSets().get(rsName);
        if (rsRecord == null) {
            this.say("sorry, result set \"" + rsName + "\" not found");
            return;
        }
    }

    public void unlink(InputLine inputLine) throws Throwable {
        ArrayList<Identifier> client_ids;
        if (this.showHelp(inputLine)) {
            this.say("unlink -all | (client_id | rs)  + [-rm]  + [" + NO_VERIFY_ALL_FLAG + "] index- unlink the client with the given client_id admin client");
            this.say("-all - (client_id ignored!) unlink all clients, not just the specified one.");
            this.say("-rm - remove clients that are unlinked.");
            this.say("This means that the clients will still exist unless you specifially remove them.");
            this.say(NO_VERIFY_ALL_FLAG + "- if present will suppress asking if you really meant to use the -rm flag.");
            this.say("Scenarios are");
            this.say("1. Removing an admin and all its clients. Run this with the -all, -rm and " + NO_VERIFY_ALL_FLAG);
            this.say("   flags, then remove the admin itself.");
            this.say("2. Removing and admin, but keeping its clients (e.g., to move them to another admin in another virtual issuer.");
            this.say("   Run this with the -all and remove the admin. The clients are still there.");
            this.printIndexHelp(false);
            this.say("See also: link");
            return;
        }
        boolean doAll = inputLine.hasArg(UNLINK_ALL_FLAG);
        boolean removeClient = inputLine.hasArg(UNLINK_REMOVE_FLAG);
        inputLine.removeSwitch(UNLINK_REMOVE_FLAG);
        boolean noVerifyAll = inputLine.hasArg(NO_VERIFY_ALL_FLAG);
        inputLine.removeSwitch(NO_VERIFY_ALL_FLAG);
        AdminClient adminClient = (AdminClient)this.findSingleton(inputLine, "admin client not found");
        if (doAll) {
            inputLine.removeSwitch(UNLINK_ALL_FLAG);
            client_ids = this.permissionsStore.getClients(adminClient.getIdentifier());
            if (client_ids.size() == 0) {
                this.say("no clients found");
                return;
            }
            if (!noVerifyAll && !this.readline("unlink ALL " + client_ids.size() + " of the clients for admin \"" + adminClient.getIdentifierString() + "\"?(Y/n)").equals("Y")) {
                this.say("aborting...");
                return;
            }
        } else {
            String rawID = inputLine.getArg(1);
            inputLine.removeArgAt(1);
            FoundIdentifiables ids = this.findByIDOrRS((Store)this.getEnvironment().getClientStore(), rawID);
            if (ids == null) {
                this.say("no clients found. aborting");
                return;
            }
            client_ids = new ArrayList<Identifier>(ids.size());
            for (Identifiable id : ids) {
                client_ids.add(id.getIdentifier());
            }
        }
        int count = 0;
        int pcount = 0;
        for (Identifier clientIdentifier : client_ids) {
            ++count;
            this.sayv("removing permissions for " + String.valueOf(clientIdentifier));
            PermissionList permissionList = this.permissionsStore.get(adminClient.getIdentifier(), clientIdentifier);
            for (Permission permission : permissionList) {
                ++pcount;
                this.permissionsStore.remove((Object)permission.getIdentifier());
                if (!removeClient) continue;
                this.sayv("removing client and approval: " + String.valueOf(permission.getClientID()));
                this.clientStore.remove((Object)permission.getClientID());
                this.getClientApprovalStore().remove((Object)permission.getClientID());
            }
        }
        this.say("done. Removed " + count + " clients and processed " + pcount + " permissions");
    }

    public void list_provisioners(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("list_provisioners [-rs rs_name] ersatz_id  = list all of the clients that are provisioners for this ersatz client.");
            this.say("If you specify a result set, the result will be a set of clients. to view it, sue the clients component, e.g.");
            this.say("// clients rs show rs_name");
            this.printIndexHelp(true);
            return;
        }
        if (inputLine.getArgCount() == 0) {
            this.say("you must supply the ersatz client id");
            return;
        }
        boolean useResultSet = inputLine.hasArg("-rs");
        String rsName = null;
        StoreCommands2.RSRecord rsRecord = null;
        ArrayList<OA2Client> provisionerList = null;
        if (useResultSet) {
            rsName = inputLine.getNextArgFor("-rs");
            inputLine.removeSwitchAndValue("-rs");
            provisionerList = new ArrayList<OA2Client>();
        }
        PermissionKeys permissionKeys = new PermissionKeys();
        Identifier ersatzID = BasicIdentifier.newID((String)inputLine.getLastArg());
        List provisioners = this.getEnvironment().getPermissionStore().search(permissionKeys.ersatzID(new String[0]), ".*\\Q" + String.valueOf(ersatzID) + "\\E.*", true);
        if (provisioners == null || provisioners.isEmpty()) {
            this.say("(none)");
            return;
        }
        if (useResultSet) {
            provisionerList = new ArrayList(provisioners.size());
        }
        int count = 0;
        for (Permission p : provisioners) {
            OA2Client pClient;
            if (!p.getErsatzChain().contains(ersatzID) || (pClient = (OA2Client)this.getEnvironment().getClientStore().get((Object)p.getClientID())) == null) continue;
            ++count;
            this.say(pClient.getIdentifierString());
            if (!useResultSet) continue;
            provisionerList.add(pClient);
        }
        if (count == 0) {
            this.say("no clients found");
            return;
        }
        if (useResultSet) {
            rsRecord = new StoreCommands2.RSRecord(provisionerList, new OA2ClientKeys().allKeys());
            this.getResultSets().put(rsName, rsRecord);
        }
        this.say(count + " total provisioners for " + String.valueOf(ersatzID));
    }

    public void list_ersatz(InputLine inputLine) throws Throwable {
        AdminClient adminClient;
        if (this.showHelp(inputLine)) {
            this.say("list_ersatz [client_id] [-rs rs_name] + admin_id = list all of the clients granted substitute privilege.");
            this.say("No client id lists all of the ersatz clients known to the admin");
            this.say("Result sets without a client id will contain every such client. To view the result set, use the clients component:");
            this.say("// clients rs show rs_name");
            this.printIndexHelp(true);
            return;
        }
        boolean hasRS = inputLine.hasArg("-rs");
        String rsName = null;
        StoreCommands2.RSRecord rsRecord = null;
        HashSet<Identifier> rsErsatzIDs = null;
        LinkedList<Identifiable> allErsatz = new LinkedList<Identifiable>();
        if (hasRS) {
            rsName = inputLine.getNextArgFor("-rs");
            inputLine.removeSwitchAndValue("-rs");
            rsRecord = new StoreCommands2.RSRecord();
            rsErsatzIDs = new HashSet<Identifier>();
            allErsatz = new LinkedList();
        }
        try {
            adminClient = (AdminClient)this.findSingleton(inputLine, "admin client not found");
        }
        catch (ObjectNotFoundException e) {
            this.say(e.getMessage());
            return;
        }
        if (inputLine.getArgCount() == 0) {
            PermissionKeys permissionKeys = new PermissionKeys();
            List provisioners = this.getEnvironment().getPermissionStore().search(permissionKeys.adminID(new String[0]), adminClient.getIdentifierString(), false);
            HashSet ersatzIds = null;
            HashMap<Identifier, HashSet> idsByProvisioner = new HashMap<Identifier, HashSet>();
            for (Object p : provisioners) {
                if (p.getErsatzChain() == null || p.getErsatzChain().isEmpty()) continue;
                if (idsByProvisioner.containsKey(p.getClientID())) {
                    ersatzIds = (HashSet)idsByProvisioner.get(p.getClientID());
                } else {
                    ersatzIds = new HashSet();
                    idsByProvisioner.put(p.getClientID(), ersatzIds);
                }
                ersatzIds.addAll(p.getErsatzChain());
            }
            if (idsByProvisioner.size() == 0) {
                this.say("no ersatz clients found");
                return;
            }
            int width = 0;
            for (Identifier id : idsByProvisioner.keySet()) {
                width = Math.max(width, id.toString().length());
            }
            int count = 0;
            boolean printHeader = true;
            String hLine = StringUtils.repeatString((String)"-", (int)(width += 2)) + " + " + StringUtils.repeatString((String)"-", (int)width);
            for (Identifier id : idsByProvisioner.keySet()) {
                ersatzIds = (HashSet)idsByProvisioner.get(id);
                boolean firstPass = true;
                if (ersatzIds.isEmpty()) continue;
                for (Identifier eID : ersatzIds) {
                    Identifiable x = (Identifiable)this.getEnvironment().getClientStore().get((Object)eID);
                    if (x == null) continue;
                    ++count;
                    if (hasRS && !rsErsatzIDs.contains(eID)) {
                        rsErsatzIDs.add(eID);
                        allErsatz.add(x);
                    }
                    if (firstPass) {
                        if (printHeader) {
                            this.say(StringUtils.center((String)"client id", (int)width) + " | " + StringUtils.center((String)"ersatz client id", (int)width));
                            printHeader = false;
                        }
                        this.say(hLine);
                        this.say(StringUtils.RJustify((String)id.toString(), (int)width) + " | " + String.valueOf(eID));
                        firstPass = false;
                        continue;
                    }
                    this.say(StringUtils.getBlanks((int)width) + " | " + String.valueOf(eID));
                }
            }
            if (count == 0) {
                this.say("no ersatz clients found");
                return;
            }
            if (hasRS && !rsErsatzIDs.isEmpty()) {
                OA2ClientKeys keys = new OA2ClientKeys();
                rsRecord = new StoreCommands2.RSRecord(allErsatz, keys.allKeys());
                this.getResultSets().put(rsName, rsRecord);
            }
            this.say(count + " total ersatz clients");
            return;
        }
        Identifier clientID = BasicIdentifier.newID((String)inputLine.getArg(1));
        PermissionList ersatzClients = this.permissionsStore.getErsatzChains(adminClient.getIdentifier(), clientID);
        if (ersatzClients == null || ersatzClients.isEmpty()) {
            this.say("(none)");
            return;
        }
        int count = 0;
        for (Permission p : ersatzClients) {
            ++count;
            if (p.getErsatzChain().size() == 1) {
                this.say(((Identifier)p.getErsatzChain().get(0)).toString());
                continue;
            }
            this.say(p.getErsatzChain().toString());
        }
        this.say(count + " total ersatz clients for " + String.valueOf(clientID));
    }

    public void set_ersatz(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.say("set_ersatz client_id ersatz_id index = simple case, that sets permission for a single ersatz_id  for client_id");
            this.say("in token exchanges. Onus is on the user of the CLI not to set something goofy.");
            this.printIndexHelp(true);
            return;
        }
        AdminClient adminClient = (AdminClient)this.findSingleton(inputLine, "admin client not found");
        if (inputLine.getArgCount() < 2) {
            this.say("missing argument. You need both a client id and its ersatz id");
            return;
        }
        Identifier clientID = BasicIdentifier.newID((String)inputLine.getArg(1));
        Identifier ersatzID = BasicIdentifier.newID((String)inputLine.getArg(2));
        Permission permission = (Permission)this.permissionsStore.create();
        permission.setAdminID(adminClient.getIdentifier());
        permission.setClientID(clientID);
        ArrayList<Identifier> eChain = new ArrayList<Identifier>();
        eChain.add(ersatzID);
        permission.setErsatzChain(eChain);
        permission.setSubstitute(true);
        this.permissionsStore.save((Identifiable)permission);
        this.say("done");
    }

    protected void initHelp() throws Throwable {
        super.initHelp();
        this.getHelpUtil().load("/help/admin_help.xml");
    }

    @Override
    protected BaseClientStoreCommands.ApprovalModsConfig createApprovalModsConfig(InputLine inputLine, BaseClient client, boolean doPrompt) {
        boolean enableQDL = false;
        if (inputLine.hasArg(APPROVAL_QDL_ENABLE)) {
            enableQDL = true;
            inputLine.removeSwitch(APPROVAL_QDL_ENABLE);
        }
        return new AdminApprovalModsConfig(client, doPrompt, enableQDL);
    }

    @Override
    protected BaseClient doApprovalMods(BaseClientStoreCommands.ApprovalModsConfig approvalModsConfig) throws IOException {
        AdminClient adminClient = (AdminClient)approvalModsConfig.client;
        if (approvalModsConfig.doPrompt) {
            adminClient.setAllowQDL("y".equals(this.getInput("Allow QDL in scripts?(y/n)", adminClient.isAllowQDL() ? "y" : "n")));
        } else {
            adminClient.setAllowQDL(((AdminApprovalModsConfig)approvalModsConfig).enableQDL);
        }
        return adminClient;
    }

    protected int updateStorePermissions(Identifier newID, Identifier oldID, boolean copy) {
        boolean updateCount = false;
        List permissions = this.getEnvironment().getPermissionStore().getByAdminID(oldID);
        if (!copy) {
            this.getEnvironment().getPermissionStore().remove(permissions);
        }
        for (Permission p : permissions) {
            p.setAdminID(newID);
            this.getEnvironment().getPermissionStore().save((Identifiable)p);
        }
        return permissions.size();
    }

    public static class AdminApprovalModsConfig
    extends BaseClientStoreCommands.ApprovalModsConfig {
        boolean enableQDL = false;

        public AdminApprovalModsConfig(BaseClient client, boolean doPrompt, boolean enableQDL) {
            super(client, doPrompt);
            this.enableQDL = enableQDL;
        }
    }
}

