/*
 * Decompiled with CFR 0.152.
 */
package org.oa4mp.server.admin.oauth2.tools;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.ConnectionException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.MetaDebugUtil;
import edu.uiuc.ncsa.security.core.util.StringUtils;
import edu.uiuc.ncsa.security.servlet.ServiceClient;
import edu.uiuc.ncsa.security.servlet.ServiceClientHTTPException;
import edu.uiuc.ncsa.security.util.cli.CLIDriver;
import edu.uiuc.ncsa.security.util.cli.CommonCommands2;
import edu.uiuc.ncsa.security.util.cli.ConfigurableCommandsImpl;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.crypto.CertUtil;
import edu.uiuc.ncsa.security.util.jwk.JSONWebKeys;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.oa4mp.client.api.AssetResponse;
import org.oa4mp.client.api.ClientEnvironment;
import org.oa4mp.client.api.OA4MPResponse;
import org.oa4mp.client.api.storage.AssetStoreUtil;
import org.oa4mp.client.loader.OA2Asset;
import org.oa4mp.client.loader.OA2ClientEnvironment;
import org.oa4mp.client.loader.OA2MPService;
import org.oa4mp.delegation.client.request.RTResponse;
import org.oa4mp.delegation.common.storage.clients.BaseClient;
import org.oa4mp.delegation.common.token.AuthorizationGrant;
import org.oa4mp.delegation.common.token.Token;
import org.oa4mp.delegation.common.token.impl.AccessTokenImpl;
import org.oa4mp.delegation.common.token.impl.AuthorizationGrantImpl;
import org.oa4mp.delegation.common.token.impl.IDTokenImpl;
import org.oa4mp.delegation.common.token.impl.RefreshTokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenFactory;
import org.oa4mp.delegation.common.token.impl.TokenImpl;
import org.oa4mp.delegation.common.token.impl.TokenUtils;
import org.oa4mp.delegation.server.JWTUtil;
import org.oa4mp.delegation.server.NonceHerder;
import org.oa4mp.delegation.server.OA2TokenForge;
import org.oa4mp.delegation.server.UserInfo;
import org.oa4mp.delegation.server.client.ATResponse2;
import org.oa4mp.delegation.server.client.RFC7523Utils;
import org.oa4mp.delegation.server.jwt.MyOtherJWTUtil2;
import org.oa4mp.server.admin.oauth2.tools.OA2CommandLineClient;
import org.oa4mp.server.loader.oauth2.loader.OA2ConfigurationLoader;
import org.qdl_lang.variables.Constant;
import org.qdl_lang.variables.QDLSet;
import org.qdl_lang.variables.QDLStem;
import org.qdl_lang.variables.values.QDLKey;
import org.qdl_lang.variables.values.QDLValue;

public class OA2CLCCommands
extends CommonCommands2 {
    protected OA2ClientEnvironment ce;
    public static final String IS_RFC_8628_KEY = "is_rfc8628";
    MetaDebugUtil debugUtil;
    protected OA2MPService service;
    String configFile;
    SecureRandom secureRandom;
    String CLIENT_CFG_NAME_KEY;
    OA2CommandLineClient oa2CommandLineClient;
    boolean isDeviceFlow;
    String deviceFlowCallback;
    JSONObject dfResponse;
    String userCode;
    String deviceCode;
    URI currentURI;
    boolean useClipboard;
    static String encoding = "UTF-8";
    AuthorizationGrantImpl grant;
    public static String NO_VERIFY_GRANT_FLAG = "-no_verify";
    public static String CLEAR_PARAMETERS_FLAG = "-all";
    boolean canGetGrant;
    boolean canGetAT;
    boolean canGetCert;
    boolean canGetRT;
    OA2Asset dummyAsset;
    JSONObject introspectResponse;
    Throwable lastException;
    ATResponse2 currentATResponse;
    AssetResponse assetResponse;
    public static final String NO_VERIFY_JWT = "-no_verify";
    public static final String RAW_FLAG = "-raw";
    public static final String CLAIMS_FLAG = "-claims";
    JSONObject exchangeResponse;
    protected String ASSET_KEY;
    protected String AT_RESPONSE_KEY;
    protected String AUTHZ_GRANT_KEY;
    protected String AUTHZ_PARAMETERS_KEY;
    protected String IS_ERSATZ_KEY;
    public String CLAIMS_KEY;
    protected String CONFIG_NAME_KEY;
    protected String CONFIG_FILE_KEY;
    protected String CURRENT_URI_KEY;
    protected String DF_RESPONSE_KEY;
    protected String EXCHANGE_PARAMETERS_KEY;
    protected String INTROSPECT_RESPONSE_KEY;
    protected String PRINT_OUTPUT_ON_KEY;
    protected String REFRESH_PARAMETERS_KEY;
    protected String SYSTEM_MESSAGE_KEY;
    protected String TOKEN_PARAMETERS_KEY;
    protected String USER_MESSAGE_KEY;
    protected String VERBOSE_ON_KEY;
    boolean ersatz;
    public static String PROVISION_ONLY_FLAG = "-provision";
    public static String PROVISION_ONLY_SHORT_FLAG = "-p";
    String MESSAGE_SWITCH;
    String lastUserMessage;
    File saveFile;
    public HashMap<String, Object> requestParameters;
    public HashMap<String, Object> tokenParameters;
    public HashMap<String, Object> refreshParameters;
    public HashMap<String, Object> exchangeParameters;
    public static final String REQ_PARAM_SWITCH = "-authz";
    public static final String SHORT_REQ_PARAM_SWITCH = "-a";
    public static final String TOKEN_PARAM_SWITCH = "-token";
    public static final String SHORT_TOKEN_PARAM_SWITCH = "-t";
    public static final String EXCHANGE_PARAM_SWITCH = "-exchange";
    public static final String SHORT_EXCHANGE_PARAM_SWITCH = "-x";
    public static final String REFRESH_PARAM_SWITCH = "-refresh";
    public static final String SHORT_REFRESH_PARAM_SWITCH = "-r";
    String shortSwitchBlurb;
    public String USERNAME_FLAG;
    public String ALT_USERNAME_FLAG;
    public static final String CCF_RFC7523 = "-rfc7523";
    public static final String CCF_SUB = "-sub";
    JSONObject ccfResponse;

    public String getPrompt() {
        return this.getName() + ">";
    }

    public void about(boolean showBanner, boolean showHeader) {
        try {
            this.say(this.hasClipboard() ? "clipboard is supported." : "no clipboard support available.");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize() throws Throwable {
    }

    public String getName() {
        return "clc";
    }

    public OA2ClientEnvironment getCe() {
        return this.ce;
    }

    public void setCe(OA2ClientEnvironment ce) {
        this.ce = ce;
    }

    public OA2CLCCommands(boolean silentMode, CLIDriver driver, OA2CommandLineClient oa2CommandLineClient) throws Throwable {
        this(driver, oa2CommandLineClient);
        driver.setVerbose(!silentMode);
        driver.setOutputOn(!silentMode);
    }

    public MetaDebugUtil getDebugger() throws Exception {
        if (this.debugUtil == null) {
            this.debugUtil = ((OA2ClientEnvironment)this.oa2CommandLineClient.getEnvironment()).getMetaDebugUtil();
        }
        return this.debugUtil;
    }

    public boolean hasDebugger() {
        return this.debugUtil != null;
    }

    public void setDebugUtil(MetaDebugUtil metaDebugUtil) {
        this.debugUtil = metaDebugUtil;
    }

    public OA2CLCCommands(CLIDriver driver, OA2CommandLineClient oa2CommandLineClient) throws Throwable {
        block4: {
            super(driver);
            this.debugUtil = null;
            this.secureRandom = new SecureRandom();
            this.CLIENT_CFG_NAME_KEY = "-name";
            this.isDeviceFlow = false;
            this.useClipboard = true;
            this.canGetGrant = false;
            this.canGetAT = false;
            this.canGetCert = false;
            this.canGetRT = false;
            this.assetResponse = null;
            this.ASSET_KEY = "asset";
            this.AT_RESPONSE_KEY = "at_response";
            this.AUTHZ_GRANT_KEY = "authz_grant";
            this.AUTHZ_PARAMETERS_KEY = "authz_parameters";
            this.IS_ERSATZ_KEY = "is_ersatz";
            this.CLAIMS_KEY = "claims";
            this.CONFIG_NAME_KEY = "config_name";
            this.CONFIG_FILE_KEY = "config_file";
            this.CURRENT_URI_KEY = "current_uri";
            this.DF_RESPONSE_KEY = "df_response";
            this.EXCHANGE_PARAMETERS_KEY = "exchange_parameters";
            this.INTROSPECT_RESPONSE_KEY = "introspect_response";
            this.PRINT_OUTPUT_ON_KEY = "print_output_on";
            this.REFRESH_PARAMETERS_KEY = "refresh_parameters";
            this.SYSTEM_MESSAGE_KEY = "system_message";
            this.TOKEN_PARAMETERS_KEY = "token_parameters";
            this.USER_MESSAGE_KEY = "user_message";
            this.VERBOSE_ON_KEY = "verbose_on";
            this.ersatz = false;
            this.MESSAGE_SWITCH = "-m";
            this.lastUserMessage = null;
            this.saveFile = null;
            this.requestParameters = new HashMap();
            this.tokenParameters = new HashMap();
            this.refreshParameters = new HashMap();
            this.exchangeParameters = new HashMap();
            this.shortSwitchBlurb = "Short values of switches are allowed: -a | -t | -r | -x";
            this.USERNAME_FLAG = "-user";
            this.ALT_USERNAME_FLAG = CCF_SUB;
            try {
                if (oa2CommandLineClient.getLoader() != null) {
                    this.setCe((OA2ClientEnvironment)oa2CommandLineClient.getEnvironment());
                }
            }
            catch (Throwable t) {
                if (t instanceof ConnectionException) {
                    this.say("unable to connect to OA4MP server. Cannot load configuration.");
                }
                this.error("could not load configuration", t);
                if (!this.getDebugger().isEnabled()) break block4;
                t.printStackTrace();
            }
        }
        this.oa2CommandLineClient = oa2CommandLineClient;
    }

    public OA2MPService getService() {
        if (this.service == null) {
            this.service = new OA2MPService((ClientEnvironment)this.getCe());
        }
        return this.service;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void getURIHelp() {
        this.say("uri");
        this.say("Usage: This will create the correct URL. If possible, it will put it in the clipboard.");
        this.sayi("Create the uri using the  client's configuration");
        this.sayi("This will put this in to the clipboard if possible.");
        this.sayi("This URL should be pasted exactly into the location bar.");
        this.sayi("You must then authenticate. After you authenticate, the");
        this.sayi("service will attempt a call back to a client endpoint which will");
        this.sayi("fail (this is the hook that lets us do this manually).");
        this.sayi("Next Step: You should invoke grant with the callback uri from the server.");
        this.say("See also: set_param");
        this.say("Alias: set_uri");
    }

    protected String getRandomString() {
        long ll = this.secureRandom.nextLong();
        return Long.toHexString(ll);
    }

    public void load(InputLine inputLine) throws Throwable {
        if (!inputLine.hasArgs()) {
            this.say("config file = " + this.oa2CommandLineClient.getConfigFile() + ", config name=" + this.oa2CommandLineClient.getConfigName());
            this.sayi("Usage: load a configuration from a file and make it active.");
            this.sayi("Remember that loading a configuration clears all current state, except parameters.");
            return;
        }
        try {
            this.oa2CommandLineClient.load(inputLine);
        }
        catch (ConfigurableCommandsImpl.ListOnlyNotification listOnlyNotification) {
            return;
        }
        catch (Exception myConfigurationException) {
            if (this.isThrowExceptions()) {
                throw myConfigurationException;
            }
            if (this.isDebugOn()) {
                myConfigurationException.printStackTrace();
            }
            this.say(myConfigurationException.getMessage());
            return;
        }
        if (this.showHelp(inputLine)) {
            return;
        }
        this.clear(inputLine);
        this.setCe((OA2ClientEnvironment)this.oa2CommandLineClient.getEnvironment());
        this.service = null;
    }

    public void df(InputLine inputLine) throws Exception {
        this.clear(inputLine, false);
        try {
            this.df(new HashMap());
            String uriComplete = this.dfResponse.getString("verification_uri_complete");
            this.say("please go to: " + this.deviceFlowCallback);
            if (uriComplete != null) {
                this.say("          or: " + uriComplete);
            }
            this.say("user code: " + this.userCode);
            Date exp = new Date();
            long dfExpiresIn = this.dfResponse.getLong("expires_in");
            exp.setTime(exp.getTime() + dfExpiresIn * 1000L);
            this.say("code valid until " + String.valueOf(exp) + " (" + dfExpiresIn + " sec.)");
            if (uriComplete == null) {
                this.copyToClipboard(this.userCode, "user code copied to clipboard");
            } else {
                this.copyToClipboard(uriComplete, "verification uri copied to clipboard");
            }
        }
        catch (Exception e) {
            if (this.isThrowExceptions()) {
                throw e;
            }
            this.say(e.getMessage());
        }
    }

    public JSONObject df(Map map) throws Exception {
        if (this.getCe() == null) {
            throw new GeneralException("sorry, but you have no loaded a configuration yet.");
        }
        this.dummyAsset = (OA2Asset)this.getCe().getAssetStore().create();
        OA2ClientEnvironment oa2ce = this.getCe();
        String rawResponse = null;
        if (oa2ce.getClient().hasJWKS()) {
            map.put("scope", oa2ce.scopesToString());
            rawResponse = RFC7523Utils.doPost((ServiceClient)this.getService().getRFC8623ServiceClient(), (BaseClient)oa2ce.getClient(), (URI)oa2ce.getDeviceAuthorizationUri(), (String)oa2ce.getKid(), (Map)map);
        } else {
            rawResponse = this.getService().getServiceClient().doGet(this.getRFC8623RequestString(oa2ce, map), map, oa2ce.getClient().getIdentifierString(), oa2ce.getClient().getSecret());
        }
        try {
            this.dfResponse = JSONObject.fromObject((Object)rawResponse);
            this.userCode = this.dfResponse.getString("user_code");
            this.deviceCode = this.dfResponse.getString("device_code");
            this.deviceFlowCallback = this.dfResponse.getString("verification_uri");
            String uriComplete = this.dfResponse.getString("verification_uri_complete");
            if (uriComplete == null) {
                this.copyToClipboard(this.userCode, null);
            } else {
                this.copyToClipboard(uriComplete, null);
            }
            this.isDeviceFlow = true;
            OA2TokenForge tf = new OA2TokenForge(null);
            this.grant = (AuthorizationGrantImpl)tf.getAuthorizationGrant(new String[]{this.dfResponse.getString("device_code")});
            return this.dfResponse;
        }
        catch (Throwable t) {
            throw new GeneralException("sorry but the response from the service was not understood:" + rawResponse, t);
        }
    }

    private String getRFC8623RequestString(OA2ClientEnvironment oa2ce, Map parameters) throws UnsupportedEncodingException {
        Object requestString = oa2ce.getDeviceAuthorizationUri().toString();
        Object scopes = oa2ce.scopesToString();
        Object extraParams = "";
        boolean isFirstPass = true;
        for (String key : this.requestParameters.keySet()) {
            if (key.equals("scope")) {
                scopes = (String)scopes + " " + String.valueOf(this.requestParameters.get(key));
                continue;
            }
            String x = key + "=" + URLEncoder.encode(this.requestParameters.get(key).toString(), "UTF-8");
            if (isFirstPass) {
                isFirstPass = false;
                extraParams = x;
                continue;
            }
            extraParams = (String)extraParams + "&" + x;
        }
        requestString = (String)requestString + "?client_id=" + oa2ce.getClientId();
        if (scopes != null && !((String)scopes).isEmpty()) {
            requestString = (String)requestString + "&scope=" + URLEncoder.encode((String)scopes, "UTF-8");
        }
        for (String key : parameters.keySet()) {
            if (key.equals("__headers")) continue;
            requestString = (String)requestString + "&" + String.valueOf(key) + "=" + URLEncoder.encode(parameters.get(key).toString(), "UTF-8");
        }
        if (!StringUtils.isTrivial((String)extraParams)) {
            requestString = (String)requestString + "&" + (String)extraParams;
        }
        return requestString;
    }

    public long getDfInterval() {
        if (this.dfResponse == null || !this.dfResponse.containsKey((Object)"interval")) {
            return -1L;
        }
        return this.dfResponse.getLong("interval");
    }

    public long getDfExpiresIn() {
        if (this.dfResponse == null || !this.dfResponse.containsKey((Object)"expires_in")) {
            return -1L;
        }
        return this.dfResponse.getLong("expires_in");
    }

    public JSONObject getDfResponse() {
        return this.dfResponse;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public URI getCurrentURI() {
        return this.currentURI;
    }

    public void uri(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getURIHelp();
            return;
        }
        if (this.getCe() == null) {
            this.say("Oops! No configuration has been loaded.");
            return;
        }
        this.clear(inputLine, false);
        Identifier id = AssetStoreUtil.createID();
        HashMap<String, Object> copyOfParams = new HashMap<String, Object>();
        copyOfParams.putAll(this.getRequestParameters());
        this.createScopes(copyOfParams, true);
        OA4MPResponse resp = this.getService().requestCert(id, copyOfParams);
        this.getDebugger().trace((Object)this, "client id = " + this.getCe().getClientId());
        this.currentURI = resp.getRedirect();
        this.dummyAsset = (OA2Asset)this.getCe().getAssetStore().get(id.toString());
        this.copyToClipboard(this.currentURI.toString(), "URL copied to clipboard:");
        this.say(this.currentURI.toString());
    }

    public boolean isUseClipboard() {
        return this.useClipboard;
    }

    public void setUseClipboard(boolean useClipboard) {
        this.useClipboard = useClipboard;
    }

    protected void copyToClipboard(String target, String s) {
        block5: {
            if (!this.isUseClipboard()) {
                return;
            }
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                if (clipboard != null) {
                    StringSelection data = new StringSelection(target);
                    clipboard.setContents(data, data);
                    if (s != null) {
                        this.say(s);
                    }
                }
            }
            catch (Throwable t) {
                if (!this.isThrowExceptions()) break block5;
                throw t;
            }
        }
    }

    public void echo_http_request(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("echo_http_request on|off - echo *all* requests sent to the server to the console.");
            this.say("Do be aware that this is a very low-level development tool which is quite useful");
            this.say("for seeing how the requests are being made. Sensitive information (such as the client");
            this.say("password) will be shown, so you have been warned. Do not use this unless you have a need.");
        }
        this.say("echo request mode set to " + ((ServiceClient.ECHO_REQUEST = inputLine.getLastArg().equalsIgnoreCase("on")) ? "on" : "off"));
    }

    public void echo_http_response(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("echo_http_response on|off - echo the server responses to the console.");
            this.say("Do be aware that this is a very low-level development tool which is quite useful");
            this.say("for seeing how the reponses are being made. These may be very large.");
        }
        this.say("echo response mode set to " + ((ServiceClient.ECHO_RESPONSE = inputLine.getLastArg().equalsIgnoreCase("on")) ? "on" : "off"));
    }

    protected String getFromClipboard(boolean silentMode) throws Throwable {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            return (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (Throwable t) {
            if (this.isThrowExceptions()) {
                throw t;
            }
            return null;
        }
    }

    protected boolean hasClipboard() throws Throwable {
        if (!this.isUseClipboard()) {
            return false;
        }
        PrintStream errStream = System.err;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        System.setErr(new PrintStream(byteArrayOutputStream));
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.getData(DataFlavor.stringFlavor);
            System.setErr(errStream);
            return true;
        }
        catch (Throwable t) {
            if (this.isThrowExceptions()) {
                throw t;
            }
            this.info("Probably benign message from checking clipboard:" + new String(byteArrayOutputStream.toByteArray()));
            System.setErr(errStream);
            return false;
        }
    }

    protected String createURI(String base, HashMap<String, String> args) throws UnsupportedEncodingException {
        Object uri = base;
        boolean firstPass = true;
        for (String key : args.keySet()) {
            String value = args.get(key);
            uri = (String)uri + (firstPass ? "?" : "&") + key + "=" + this.encode(value);
            if (!firstPass) continue;
            firstPass = false;
        }
        this.canGetGrant = true;
        return uri;
    }

    String encode(String x) throws UnsupportedEncodingException {
        if (x == null) {
            return "";
        }
        return URLEncoder.encode(x, encoding);
    }

    String decode(String x) throws UnsupportedEncodingException {
        if (x == null) {
            return "";
        }
        return URLDecoder.decode(x, encoding);
    }

    public AuthorizationGrantImpl getGrant() {
        return this.grant;
    }

    protected void printGrant() {
        if (this.grant == null) {
            this.say("no grant");
            return;
        }
        if (TokenUtils.isBase32((String)this.grant.getToken())) {
            this.say("raw grant = " + this.grant.getToken());
        }
        this.say("    grant = " + String.valueOf(this.grant.getJti()));
    }

    /*
     * Unable to fully structure code
     */
    public void grant(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.setGrantHelp();
            return;
        }
        noCheck = inputLine.hasArg(OA2CLCCommands.NO_VERIFY_GRANT_FLAG);
        inputLine.removeSwitch(OA2CLCCommands.NO_VERIFY_GRANT_FLAG);
        if (this.getCe() == null) {
            this.say("Oops! No configuration has been loaded.");
            return;
        }
        x = null;
        if (inputLine.size() == 1) {
            if (this.grant != null) {
                this.printGrant();
                this.copyToClipboard(this.grant.getJti().toString(), "grant copied to clipboard");
                return;
            }
            if (!this.isUseClipboard()) {
                this.say("Clipboard use disabled");
                return;
            }
            try {
                clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                x = (String)clipboard.getData(DataFlavor.stringFlavor);
            }
            catch (Throwable t) {
                if (this.isThrowExceptions()) {
                    throw t;
                }
                this.say("No clipboard.");
                x = this.getInput("Enter the callback", "");
                if (!StringUtils.isTrivial((String)x)) ** GOTO lbl31
                this.say("aborted");
                return;
            }
        } else {
            x = inputLine.getArg(1);
        }
lbl31:
        // 3 sources

        if (StringUtils.isTrivial((String)x)) {
            this.say("(no grant)");
            return;
        }
        if (!noCheck && !x.startsWith(this.getCe().getCallback().toString())) {
            this.say("The callback in the configuration does not match that in the argument you gave");
            return;
        }
        args = x.substring(x.indexOf("?") + 1);
        st = new StringTokenizer(args, "&");
        gotGrant = false;
        gotError = false;
        errorCode = "";
        errorDescription = "";
        while (st.hasMoreTokens()) {
            current = st.nextToken();
            if (current.startsWith("error=")) {
                gotError = true;
                errorCode = current.substring("error".length() + 1);
            }
            if (current.startsWith("error_description=")) {
                gotError = true;
                errorDescription = current.substring("error_description".length() + 1);
            }
            if (!current.startsWith("code=")) continue;
            raw = this.decode(current.substring(5));
            jti = TokenUtils.isBase32((String)raw) != false ? URI.create(TokenUtils.b32DecodeToken((String)raw)) : URI.create(raw);
            this.grant = new AuthorizationGrantImpl(raw, jti);
            gotGrant = true;
            this.copyToClipboard(jti.toString(), "grant copied to clipboard.");
        }
        if (gotError) {
            if (StringUtils.isTrivial((String)errorCode)) {
                this.say("Error! (no code)");
            } else {
                this.say("Error! The code is: " + errorCode);
            }
            if (!StringUtils.isTrivial((String)errorDescription)) {
                this.say("       description: " + URLDecoder.decode(errorDescription, "UTF-8"));
            }
            return;
        }
        if (gotGrant) {
            this.printGrant();
        } else {
            this.say("No grant found. Check the URL?");
        }
    }

    public OA2Asset getDummyAsset() {
        return this.dummyAsset;
    }

    public void clear(InputLine inputLine, boolean clearParams) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getClearHelp();
            return;
        }
        this.dummyAsset = null;
        this.assetResponse = null;
        this.currentATResponse = null;
        this.currentURI = null;
        this.grant = null;
        this.canGetCert = false;
        this.canGetGrant = false;
        this.canGetRT = false;
        this.canGetAT = false;
        if (clearParams) {
            this.requestParameters = new HashMap();
            this.tokenParameters = new HashMap();
            this.refreshParameters = new HashMap();
            this.exchangeParameters = new HashMap();
        }
        this.isDeviceFlow = false;
        this.userCode = null;
        this.deviceFlowCallback = null;
        this.deviceCode = null;
        this.dfResponse = null;
        this.introspectResponse = null;
    }

    public void clear(InputLine inputLine) throws Exception {
        this.clear(inputLine, inputLine.hasArg(CLEAR_PARAMETERS_FLAG));
    }

    protected void getClearHelp() {
        this.say("clear [" + CLEAR_PARAMETERS_FLAG + "]");
        this.sayi("Usage: Reset all internal state and restart.");
        this.sayi("You should do this rather than just starting over");
        this.sayi("as you may run into old state.");
        this.sayi(CLEAR_PARAMETERS_FLAG + " (optional) if true, will also clear all stored parameters.");
    }

    protected void saveCertHelp() {
        this.say("save_cert filename:");
        this.sayi("Usage: This will save the cert to the filename.");
        this.sayi("Be sure to do a getcert call first so you have one.");
        this.sayi("Note that the filename must be fully qualified.");
        this.sayi("If there is no cert available, no file will be written, but a message will be printed.");
    }

    public void save_cert(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.saveCertHelp();
            return;
        }
        if (this.assetResponse == null) {
            this.say("Sorry, but there is no cert to save. Please do a successful getcert call first.");
            return;
        }
        String cert = CertUtil.toPEM((X509Certificate[])this.assetResponse.getX509Certificates());
        if (!inputLine.hasArgs()) {
            this.say("Sorry. You did not specify a file so the cert cannot be saved.");
            return;
        }
        String fileName = inputLine.getArg(1);
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            this.say("Sorry, you must supply a path.");
            return;
        }
        FileWriter fileWriter = new FileWriter(fileName);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        bufferedWriter.write(cert + "\n");
        bufferedWriter.flush();
        bufferedWriter.close();
        this.say("File \"" + file.getAbsolutePath() + "\" saved successfully.");
    }

    public String getX509CertificateString() {
        return CertUtil.toPEM((X509Certificate[])this.getX509Certificates());
    }

    public X509Certificate[] getX509Certificates() {
        return this.assetResponse.getX509Certificates();
    }

    public boolean hasX509Certificates() {
        if (this.assetResponse == null) {
            return false;
        }
        return this.assetResponse.getX509Certificates() != null;
    }

    protected void showRawTokenHelp() {
        this.sayi("show_raw_id_token:");
        this.sayi("Usage: This will show the raw id token, i.e., the JWT. ");
        this.sayi("If you wish to see the contents of this JWT");
        this.sayi("you should probably invoke show_claims instead.");
        this.sayi("See also: show_claims");
    }

    public void show_raw_id_token(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.showRawTokenHelp();
            return;
        }
        if (this.getIdToken() == null || StringUtils.isTrivial((String)this.getIdToken().getToken())) {
            this.sayi("No id token.");
            return;
        }
        this.sayi(this.getIdToken().getToken());
    }

    public IDTokenImpl getIdToken() {
        return this.dummyAsset.getIdToken();
    }

    public void setIDToken(IDTokenImpl idToken) {
        this.dummyAsset.setIdToken(idToken);
    }

    public RefreshTokenImpl getRefreshToken() {
        return this.dummyAsset.getRefreshToken();
    }

    public void claims(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.showClaimsHelp();
            return;
        }
        if (this.getIdToken() == null || !this.getIdToken().hasPayload()) {
            this.say("(no claims found)");
        } else {
            this.printToken((TokenImpl)this.getIdToken(), true, false);
        }
    }

    protected void showClaimsHelp() {
        this.sayi("showClaims");
        this.sayi("Usage: This will show the most recent set of claims.");
        this.sayi(" You must get an access token before this is set.");
        this.sayi("You may also see the raw version of this (simply the JWT) by calling show_raw_token.");
        this.sayi("See also: get_at, get_rt, exchange");
    }

    protected void showRevokeHelp() {
        this.say("revoke -at | -rt");
        this.sayi("Usage: Revoke either the access token or the refresh token");
    }

    public void revoke(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.showRevokeHelp();
            return;
        }
        boolean revokeRT = inputLine.hasArg("-rt");
        this.getService().revoke(this.getDummyAsset(), revokeRT);
        this.say("revocation on " + (revokeRT ? "refresh" : "access") + " token returned ok");
    }

    protected void showIntrospectHelp() {
        this.say("introspect -at | -rt");
        this.sayi("Usage: Call the introspection endpoint on the server with either the access token or the refresh token");
    }

    public void introspect(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.showIntrospectHelp();
            return;
        }
        boolean checkRT = inputLine.hasArg("-rt");
        this.introspectResponse = this.getService().introspect(this.getDummyAsset(), checkRT);
        this.say("introspection endpoint on " + (checkRT ? "refresh" : "access") + " token returned:");
        this.say(this.introspectResponse.toString(2));
    }

    public JSONObject getIntrospectResponse() {
        return this.introspectResponse;
    }

    public void asset(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("asset");
            this.sayi("Usage: Show the current asset.");
            this.sayi("Asset refers to the internal state of this exchange.");
            this.sayi("Mostly this is used if you are trying to debug exactly what");
            this.sayi("the state of the exchange is. Other calls display parts of the asset.");
            this.sayi("See also: tokens, get_grant, claims");
            return;
        }
        if (this.getDummyAsset() == null) {
            this.say("no asset");
            return;
        }
        this.say(this.getDummyAsset().toJSON().toString(1));
    }

    public void access(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getATHelp();
            return;
        }
        if (this.getCe() == null) {
            this.say("Oops! No configuration has been loaded.");
            return;
        }
        this.getDebugger().trace((Object)this, "Getting AT, grant=" + String.valueOf(this.grant));
        if (!this.isDeviceFlow) {
            this.standard_get_at(inputLine);
        } else {
            this.df_get_at(inputLine);
        }
    }

    public Throwable getLastException() {
        return this.lastException;
    }

    public void setLastException(Throwable lastException) {
        this.lastException = lastException;
    }

    public boolean hadException() {
        return this.lastException != null;
    }

    private void df_get_at(InputLine inputLine) {
        this.lastException = null;
        if (this.isDeviceFlow) {
            HashMap<String, Object> copyOfParams = new HashMap<String, Object>();
            if (this.getTokenParameters().isEmpty() && !this.getRequestParameters().isEmpty()) {
                copyOfParams.putAll(this.getRequestParameters());
            } else {
                copyOfParams.putAll(this.getTokenParameters());
            }
            this.createScopes(copyOfParams, true);
            try {
                this.currentATResponse = this.getService().rfc8628Request(this.dummyAsset, this.deviceCode, copyOfParams);
                this.processATResponse(inputLine);
            }
            catch (Throwable t) {
                this.lastException = t;
                throw t;
            }
        } else {
            this.say("sorry, but there is no device flow active");
        }
    }

    private void standard_get_at(InputLine inputLine) {
        this.currentATResponse = this.getService().getAccessToken(this.getDummyAsset(), (AuthorizationGrant)this.grant, this.tokenParameters);
        this.processATResponse(inputLine);
    }

    private void processATResponse(InputLine inputLine) {
        if (this.getDummyAsset().getAccessToken().isOldVersion() && this.getDummyAsset().getAccessToken().getLifetime() < 0L) {
            this.getDummyAsset().getAccessToken().setLifetime(OA2ConfigurationLoader.ACCESS_TOKEN_LIFETIME_DEFAULT);
        }
        if (this.getDummyAsset().hasRefreshToken() && this.getDummyAsset().getRefreshToken().isOldVersion() && this.getDummyAsset().getRefreshToken().getLifetime() < 0L) {
            this.getDummyAsset().getRefreshToken().setLifetime(OA2ConfigurationLoader.MAX_REFRESH_TOKEN_LIFETIME_DEFAULT);
        }
        if (inputLine.hasArg(CLAIMS_FLAG)) {
            if (this.getIdToken() != null && this.getIdToken().getPayload().isEmpty()) {
                this.say("(no claims found)");
            } else {
                this.printToken((TokenImpl)this.getIdToken(), inputLine.hasArg(NO_VERIFY_JWT), true);
            }
        }
        if (this.isPrintOutput()) {
            this.printTokens(inputLine.hasArg(NO_VERIFY_JWT), true);
        }
    }

    public ATResponse2 getCurrentATResponse() {
        return this.currentATResponse;
    }

    protected boolean isPrintOutput() {
        return this.getDriver().isOutputOn();
    }

    protected void getCertHelp() {
        this.say("get_cert");
        this.sayi("Usage: This will get the requested cert chain from the server.");
    }

    protected void getUIHelp() {
        this.say("user_info");
        this.sayi("Usage: This will get the user info from the server.");
        this.sayi("NOTE: As per the spec., this is the claims, not the expiration etc.");
        this.sayi("      This will not locally update the user metadata, and is therefore not ");
        this.say("       equivalent to regetting the token. Use the token exchange for that.");
        this.sayi("You must have already authenticated and have an access token to use this endpoint");
        this.sayi("Just a list of these it printed.");
        this.sayi("What is returned is dependent upon what the server supports.");
    }

    public void user_info(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getUIHelp();
            return;
        }
        UserInfo userInfo = this.user_info2(inputLine);
        this.say("user info:");
        for (String key : userInfo.getMap().keySet()) {
            this.say("          " + key + " = " + String.valueOf(userInfo.getMap().get(key)));
        }
    }

    public UserInfo user_info2(InputLine inputLine) throws Exception {
        this.lastException = null;
        try {
            return this.getService().getUserInfo(this.dummyAsset.getIdentifier().toString());
        }
        catch (Throwable t) {
            this.lastException = t;
            throw t;
        }
    }

    public void get_cert(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getCertHelp();
            return;
        }
        if (this.getCe() == null) {
            this.say("Oops! No configuration has been loaded.");
            return;
        }
        this.assetResponse = this.getService().getCert(this.dummyAsset, this.currentATResponse);
        if (this.assetResponse.getUsername() != null) {
            this.say("returned username=" + this.assetResponse.getUsername());
        }
        this.say("X509Certs:");
        this.say(CertUtil.toPEM((X509Certificate[])this.assetResponse.getX509Certificates()));
    }

    protected void getRTHelp() {
        this.say("refresh [-claims | -no_verify]:");
        this.sayi("Usage: Get new refresh and access tokens.");
        this.sayi("You must have already called get_at first *and* the server must issue refresh");
        this.sayi("tokens. This will print out a summary of the expiration time.");
        this.sayi("-claims = the id token will be printed");
        this.sayi("-no_verify = do not verify JWTs against server. Default is to verify.");
        this.sayi("Alias: get_rt");
        this.sayi("See also: access, set_param -t");
    }

    public JSONObject resolveFromToken(Token token, boolean noVerify) {
        if (noVerify) {
            try {
                String[] components = JWTUtil.decat((String)token.getToken());
                return JSONObject.fromObject((Object)new String(Base64.decodeBase64((String)components[1])));
            }
            catch (Throwable t) {
                return null;
            }
        }
        JSONWebKeys keys = MyOtherJWTUtil2.getJsonWebKeys((ServiceClient)this.getService().getServiceClient(), (String)((OA2ClientEnvironment)this.getService().getEnvironment()).getWellKnownURI());
        try {
            JSONObject json = JWTUtil.verifyAndReadJWT((String)token.getToken(), (JSONWebKeys)keys);
            return json;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean validateJWT(String rawToken) {
        JSONWebKeys keys = MyOtherJWTUtil2.getJsonWebKeys((ServiceClient)this.getService().getServiceClient(), (String)((OA2ClientEnvironment)this.getService().getEnvironment()).getWellKnownURI());
        try {
            JWTUtil.verifyAndReadJWT((String)rawToken, (JSONWebKeys)keys);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public void authz(InputLine inputLine) throws Exception {
        String rawResponse;
        block8: {
            rawResponse = null;
            try {
                if (inputLine.hasArgs()) {
                    rawResponse = this.getService().getServiceClient().doGet(inputLine.getLastArg(), new HashMap());
                } else {
                    if (this.currentURI == null) {
                        this.say("sorry, you did not specify a URL and no default was found.");
                        return;
                    }
                    rawResponse = this.getService().getServiceClient().doGet(this.currentURI.toString(), new HashMap());
                }
            }
            catch (ServiceClientHTTPException t) {
                if (this.isThrowExceptions()) {
                    throw t;
                }
                if (!t.getMessage().contains("requires HTTP authentication")) break block8;
                this.say("Request ok, but this requires authentication to continue");
                return;
            }
        }
        if (rawResponse == null) {
            this.say("(no response)");
        } else {
            this.say(rawResponse);
        }
    }

    public void tokens(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.showTokensHelp();
            return;
        }
        boolean printRaw = inputLine.hasArg(RAW_FLAG);
        inputLine.removeSwitch(RAW_FLAG);
        this.printTokens(inputLine.hasArg(NO_VERIFY_JWT), printRaw);
    }

    private void showTokensHelp() {
        this.say("tokens [-no_verify]");
        this.sayi("Usage: Print the current list of tokens");
        this.sayi("-no_verify = do not verify JWTs against server. Default is to verify.");
        this.sayi("Note: If the token has expired, then verification will fail and nothing will be");
        this.sayi("displayed.");
    }

    public void printToken(TokenImpl accessToken, boolean noVerify, boolean printRaw) {
        this.NEWprintToken(accessToken, noVerify, printRaw);
    }

    protected void NEWprintToken(TokenImpl tokenImpl, boolean noVerify, boolean printRaw) {
        if (tokenImpl == null) {
            return;
        }
        String tokenType = "unknown";
        if (tokenImpl instanceof AccessTokenImpl) {
            tokenType = "access";
        }
        if (tokenImpl instanceof RefreshTokenImpl) {
            tokenType = "refresh";
        }
        if (tokenImpl instanceof IDTokenImpl) {
            tokenType = "id";
        }
        if (tokenImpl.isJWT()) {
            this.sayi("JWT " + tokenType + " token " + tokenImpl.getPayload().toString(1));
            if (noVerify) {
                this.sayi("token signature validation skipped");
            } else {
                this.sayi("signature is " + (this.validateJWT(tokenImpl.getToken()) ? "" : "NOT") + " valid");
            }
            if (printRaw) {
                this.sayi("raw token=" + tokenImpl.getToken());
            }
            Date d = new Date();
            d.setTime(tokenImpl.getExpiresAt());
            long x = d.getTime() - System.currentTimeMillis();
            if (x <= 0L) {
                this.say("   token expired at " + String.valueOf(d) + "\n");
            } else {
                this.say("   expires in = " + x + " ms.\n");
            }
            return;
        }
        this.say(tokenType + " token = " + tokenImpl.getToken());
        this.say("   decoded token:" + String.valueOf(tokenImpl.getJti()));
        if (tokenImpl.getExpiresAt() < System.currentTimeMillis()) {
            Date d = new Date(tokenImpl.getExpiresAt());
            this.say("   token expired at " + String.valueOf(d) + "\n");
        } else {
            this.say("   expires in = " + tokenImpl.getLifetime() + " ms.");
            this.say("   valid until " + String.valueOf(new Date(tokenImpl.getExpiresAt())) + "\n");
        }
    }

    protected void printTokens(boolean noVerify, boolean printRaw) {
        if (this.isVerbose() && this.currentURI != null) {
            this.say("Current request URI:");
            this.say(this.currentURI.toString());
        }
        this.printToken((TokenImpl)this.getDummyAsset().getAccessToken(), noVerify, printRaw);
        if (this.getDummyAsset().hasRefreshToken()) {
            this.printToken((TokenImpl)this.getDummyAsset().getRefreshToken(), noVerify, printRaw);
        }
    }

    public void refresh(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.getRTHelp();
            return;
        }
        if (this.getCe() == null) {
            this.say("Oops! No configuration has been loaded.");
            return;
        }
        try {
            this.refresh();
        }
        catch (Throwable t) {
            if (this.isThrowExceptions()) {
                throw t;
            }
            this.say(t.getMessage());
            return;
        }
        if (inputLine.hasArg(CLAIMS_FLAG)) {
            if (this.getIdToken().getPayload().isEmpty()) {
                this.say("(no claims found)");
            } else {
                this.say(this.getIdToken().getPayload().toString(2));
            }
        }
        if (this.isPrintOutput()) {
            this.printTokens(inputLine.hasArg(NO_VERIFY_JWT), false);
        }
    }

    public void refresh() throws Exception {
        this.lastException = null;
        try {
            if (this.getCe() == null) {
                throw new IllegalStateException("no configuration has been loaded.");
            }
            if (!this.dummyAsset.hasRefreshToken()) {
                throw new IllegalStateException("no refresh token");
            }
            HashMap<String, Object> copyOfParameters = new HashMap<String, Object>();
            copyOfParameters.putAll(this.getRefreshParameters());
            this.createScopes(copyOfParameters, false);
            RTResponse rtResponse = this.getService().refresh(this.dummyAsset.getIdentifier().toString(), copyOfParameters);
            OA2Asset z = (OA2Asset)this.getCe().getAssetStore().get(this.dummyAsset.getIdentifier().toString());
            if (z != null && this.dummyAsset.getIssuedAt().getTime() < z.getIssuedAt().getTime()) {
                this.dummyAsset = z;
            }
            this.currentATResponse = new ATResponse2(this.dummyAsset.getAccessToken(), this.dummyAsset.getRefreshToken(), this.dummyAsset.getIdToken());
            this.currentATResponse.setParameters(rtResponse.getParameters());
        }
        catch (Throwable t) {
            this.lastException = t;
            throw t;
        }
    }

    protected void getATHelp() {
        this.say("access [-claims | -no_verify]:");
        this.sayi("Usage: Gets the access token and refresh token (if supported on");
        this.sayi("   the server) for a given grant. ");
        this.sayi("You must have already set the grant with the get_grant call.");
        this.sayi("A summary of the refresh token and its expiration is printed, if applicable.");
        this.sayi("-claims =  he id token will be printed");
        this.sayi("-no_verify = do not verify JWTs against server. Default is to verify.");
        this.sayi("Alias: get_at");
    }

    protected void setGrantHelp() {
        this.say("grant [callback]:");
        this.sayi("Usage: Read the callback URL and process it into a grant, etc.");
        this.sayi("callback = the entire callback returned from the service");
        this.sayi("no arg -- either ");
        this.sayi("case A: you already have done this and a grant is set. Show it, paste it in the clipboard.");
        this.sayi("case B: No grant is set. Read the clipboard and set it from that.");
        this.sayi("The assumption is that you use seturi to get the correct authorization uri and have ");
        this.sayi("logged in. Your browser *should* have a callback to your client.");
        this.sayi("Copy that to the clipboard. If you call this with no argument, then the clipboard is read.");
        this.sayi("Otherwise paste the callback directly");
        this.sayi("Alias: get_grant");
        this.sayi("See also: set_uri");
    }

    protected void exchangeHelp() {
        this.sayi("exchange [-at|-rt|-id|-none] [-subject at | rt | id]");
        this.sayi("Usage: This will exchange the current access token (so you need to");
        this.sayi("   have gotten that far first) for a secure token.");
        this.sayi("-at | -rt | -id | -none = explicitly request an access token, refresh token id token or do not specify a ");
        this.sayi("     return token type, taking whatever the system uses for defaults (usually same as -at).");
        this.sayi("-subject at|rt|id = which type of token to use as the subject. Access, Refresh or ID.");
        this.sayi("     NOTE: The default is to use the access token. If that has expired, the request fails.");
        this.sayi("-x = (deprected, use -subject rt) use the refresh token as the subject token in the exchange. Default is to use ");
        this.sayi("     the same type as the requested token. This will fail if requesting an access token");
        this.sayi("     with one that has expired.");
        this.sayi("The response will contain other information that will be displayed.");
        this.sayi("If there is no parameter, the current access token is used for the exchange");
        this.sayi("Otherwise you may specify -at to exchange the access token or -rt to exchange using the refresh token.");
        this.say("E.g.");
        this.sayi("exchange -at -x");
        this.sayi("Note: you can only specify scopes for the access token. They are ignored for refresh tokens");
        this.say("See also: access, refresh, set_param -x to set additional parameters (like specific scopes or the audience");
    }

    public void exchange(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.exchangeHelp();
            return;
        }
        if (this.getCe() == null) {
            this.say("Oops! No configuration has been loaded.");
            return;
        }
        if (this.getDummyAsset() == null) {
            throw new IllegalStateException("No dummy asset has been loaded.");
        }
        this.lastException = null;
        try {
            int requestedTokenType = 0;
            if (0 < inputLine.size()) {
                if (inputLine.hasArg("-at")) {
                    requestedTokenType = 50;
                    inputLine.removeSwitch("-at");
                }
                if (inputLine.hasArg("-rt")) {
                    requestedTokenType = 10;
                    inputLine.removeSwitch("-tt");
                }
                if (inputLine.hasArg("-none")) {
                    requestedTokenType = 0;
                    inputLine.removeSwitch("-none");
                }
                if (inputLine.hasArg("-id")) {
                    requestedTokenType = 100;
                    inputLine.removeSwitch("-id");
                }
            }
            String subjectTokenType = null;
            IDTokenImpl subjectToken = null;
            JSONObject token = null;
            String tt = null;
            if (inputLine.hasArg("-subject")) {
                tt = inputLine.getNextArgFor("-subject");
                inputLine.removeSwitchAndValue("-subject");
            } else if (inputLine.hasArg(SHORT_EXCHANGE_PARAM_SWITCH)) {
                tt = "rt";
            } else {
                switch (requestedTokenType) {
                    default: {
                        tt = "at";
                        break;
                    }
                    case 10: {
                        tt = "rt";
                        break;
                    }
                    case 100: {
                        tt = "id";
                    }
                }
            }
            switch (tt) {
                case "at": {
                    subjectTokenType = "access_token";
                    token = this.resolveFromToken((Token)this.getDummyAsset().getAccessToken(), true);
                    if (token == null) {
                        subjectToken = this.getDummyAsset().getAccessToken();
                        break;
                    }
                    subjectToken = new AccessTokenImpl(this.getDummyAsset().getAccessToken().getToken(), URI.create(token.getString("jti")));
                    break;
                }
                case "rt": {
                    subjectTokenType = "refresh_token";
                    token = this.resolveFromToken((Token)this.getDummyAsset().getRefreshToken(), true);
                    if (token == null) {
                        subjectToken = this.getDummyAsset().getRefreshToken();
                        break;
                    }
                    subjectToken = new RefreshTokenImpl(this.getDummyAsset().getRefreshToken().getToken(), URI.create(token.getString("jti")));
                    break;
                }
                case "id": {
                    subjectTokenType = "id_token";
                    subjectToken = this.getDummyAsset().getIdToken();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown token type \"" + tt + "\"");
                }
            }
            if (subjectToken == null) {
                this.say("missing subject token -- did you get an access token first?");
                return;
            }
            HashMap<String, Object> copyOfParameters = new HashMap<String, Object>();
            copyOfParameters.putAll(this.getExchangeParameters());
            this.createScopes(copyOfParameters, false);
            this.exchangeResponse = this.getService().exchangeRefreshToken(this.getDummyAsset(), (TokenImpl)subjectToken, copyOfParameters, requestedTokenType, subjectTokenType, this.isErsatz());
            if (this.isErsatz()) {
                if (requestedTokenType == 10) {
                    this.printToken((TokenImpl)this.getRefreshToken(), false, true);
                } else {
                    this.printTokens(false, true);
                    this.printToken((TokenImpl)this.getIdToken(), false, true);
                }
                this.setErsatz(false);
            } else {
                switch (requestedTokenType) {
                    case 10: {
                        this.printToken((TokenImpl)this.getDummyAsset().getRefreshToken(), false, true);
                        break;
                    }
                    case 0: 
                    case 50: {
                        this.printToken((TokenImpl)this.getDummyAsset().getAccessToken(), false, true);
                        break;
                    }
                    case 100: {
                        this.printToken((TokenImpl)this.getIdToken(), false, true);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.lastException = t;
            throw t;
        }
    }

    public JSONObject getExchangeResponse() {
        return this.exchangeResponse;
    }

    public void setExchangeResponse(JSONObject exchangeResponse) {
        this.exchangeResponse = exchangeResponse;
    }

    public void fromJSON(JSONObject json) throws Throwable {
        this.fromJSON(json, true);
    }

    protected void fromJSON(JSONObject json, boolean loadStoredConfig) throws Throwable {
        if (loadStoredConfig && json.containsKey((Object)this.CONFIG_FILE_KEY)) {
            Vector<String> v = new Vector<String>();
            v.add("load");
            v.add(json.getString(this.CONFIG_NAME_KEY));
            v.add(json.getString(this.CONFIG_FILE_KEY));
            InputLine loadLine = new InputLine(v);
            this.load(loadLine);
        }
        if (json.containsKey((Object)this.SYSTEM_MESSAGE_KEY)) {
            this.say(json.getString(this.SYSTEM_MESSAGE_KEY));
        }
        if (json.containsKey((Object)"debugger") && this.hasDebugger()) {
            this.getDebugger().fromJSON(json.getJSONObject("debugger"));
        }
        if (json.containsKey((Object)this.PRINT_OUTPUT_ON_KEY)) {
            this.getDriver().setOutputOn(json.getBoolean(this.PRINT_OUTPUT_ON_KEY));
        }
        if (json.containsKey((Object)this.VERBOSE_ON_KEY)) {
            this.getDriver().setVerbose(json.getBoolean(this.VERBOSE_ON_KEY));
        }
        if (json.containsKey((Object)this.USER_MESSAGE_KEY)) {
            this.lastUserMessage = json.getString(this.USER_MESSAGE_KEY);
            this.say(this.lastUserMessage);
        }
        IDTokenImpl idToken = null;
        if (json.containsKey((Object)this.CLAIMS_KEY)) {
            idToken = TokenFactory.createIDT((JSONObject)json.getJSONObject(this.CLAIMS_KEY));
        }
        if (json.containsKey((Object)this.CURRENT_URI_KEY)) {
            this.currentURI = URI.create(json.getString(this.CURRENT_URI_KEY));
        }
        if (json.containsKey((Object)this.AUTHZ_GRANT_KEY)) {
            this.grant = new AuthorizationGrantImpl(URI.create("a"));
            this.grant.fromJSON(json.getJSONObject(this.AUTHZ_GRANT_KEY));
        }
        if (json.containsKey((Object)this.TOKEN_PARAMETERS_KEY)) {
            this.tokenParameters = new HashMap();
            this.tokenParameters.putAll((Map<String, Object>)json.getJSONObject(this.TOKEN_PARAMETERS_KEY));
        }
        if (json.containsKey((Object)this.AUTHZ_PARAMETERS_KEY)) {
            this.requestParameters = new HashMap();
            this.requestParameters.putAll((Map<String, Object>)json.getJSONObject(this.AUTHZ_PARAMETERS_KEY));
        }
        if (json.containsKey((Object)this.IS_ERSATZ_KEY)) {
            this.setErsatz(json.getBoolean(this.IS_ERSATZ_KEY));
        }
        if (json.containsKey((Object)this.REFRESH_PARAMETERS_KEY)) {
            this.refreshParameters = new HashMap();
            this.refreshParameters.putAll((Map<String, Object>)json.getJSONObject(this.REFRESH_PARAMETERS_KEY));
        }
        if (json.containsKey((Object)this.INTROSPECT_RESPONSE_KEY)) {
            this.introspectResponse = json.getJSONObject(this.INTROSPECT_RESPONSE_KEY);
        }
        if (json.containsKey((Object)this.DF_RESPONSE_KEY)) {
            this.dfResponse = json.getJSONObject(this.DF_RESPONSE_KEY);
        }
        if (json.containsKey((Object)this.EXCHANGE_PARAMETERS_KEY)) {
            this.exchangeParameters = new HashMap();
            this.exchangeParameters.putAll((Map<String, Object>)json.getJSONObject(this.EXCHANGE_PARAMETERS_KEY));
        }
        if (json.containsKey((Object)this.AT_RESPONSE_KEY)) {
            JSONObject atr = json.getJSONObject(this.AT_RESPONSE_KEY);
            if (atr.containsKey((Object)"type")) {
                this.currentATResponse = new ATResponse2(null);
                this.currentATResponse.fromJSON(atr);
            } else {
                AccessTokenImpl ati = new AccessTokenImpl(null);
                ati.fromJSON(atr.getJSONObject("access_token"));
                RefreshTokenImpl rti = new RefreshTokenImpl(null);
                rti.fromJSON(atr.getJSONObject("refresh_token"));
                this.currentATResponse = new ATResponse2(ati, rti, idToken);
                if (atr.containsKey((Object)"parameters")) {
                    this.currentATResponse.setParameters((Map)atr.getJSONObject("parameters"));
                }
            }
        }
        this.isDeviceFlow = json.getBoolean(IS_RFC_8628_KEY);
        if (json.containsKey((Object)"user_code")) {
            this.userCode = json.getString("user_code");
        }
        if (json.containsKey((Object)"device_code")) {
            this.deviceCode = json.getString("device_code");
        }
        if (json.containsKey((Object)"verification_uri")) {
            this.deviceFlowCallback = json.getString("verification_uri");
        }
        this.dummyAsset = new OA2Asset(null);
        if (json.containsKey((Object)this.ASSET_KEY)) {
            this.dummyAsset.fromJSON(json.getJSONObject(this.ASSET_KEY));
            if (!this.getCe().getAssetStore().containsKey((Object)this.dummyAsset.getIdentifier())) {
                this.getCe().getAssetStore().save((Identifiable)this.dummyAsset);
            }
            if (!loadStoredConfig) {
                Identifier id = AssetStoreUtil.createID();
                if (this.isVerbose()) {
                    this.say("created new asset with id " + String.valueOf(id));
                }
                this.dummyAsset.setIdentifier(id);
                this.getCe().getAssetStore().save((Identifiable)this.dummyAsset);
            }
        }
    }

    public boolean isErsatz() {
        return this.ersatz;
    }

    public void setErsatz(boolean ersatz) {
        this.ersatz = ersatz;
    }

    public void read(InputLine inputLine) throws Throwable {
        if (this.showHelp(inputLine)) {
            this.showReadHelp();
            return;
        }
        boolean isErsatz = inputLine.hasArg(PROVISION_ONLY_FLAG) || inputLine.hasArg(PROVISION_ONLY_SHORT_FLAG);
        inputLine.removeSwitch(PROVISION_ONLY_FLAG);
        inputLine.removeSwitch(PROVISION_ONLY_SHORT_FLAG);
        if (0 == inputLine.getArgCount()) {
            if (this.saveFile == null) {
                this.say("sorry, but you must specify a file");
                return;
            }
        } else {
            this.saveFile = new File(inputLine.getLastArg());
        }
        if (!this.saveFile.exists()) {
            this.say("sorry, but \"" + this.saveFile.getAbsolutePath() + "\" does not exist");
            return;
        }
        if (this.saveFile.isDirectory()) {
            this.say("sorry, but \"" + this.saveFile.getAbsolutePath() + "\" is a directory");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Path path = Paths.get(this.saveFile.getAbsolutePath(), new String[0]);
        this.say("reading file \"" + this.saveFile.getAbsolutePath() + "\"");
        List<String> contents = Files.readAllLines(path);
        boolean i = false;
        for (String content : contents) {
            stringBuffer.append(content + "\n");
        }
        JSONObject json = JSONObject.fromObject((Object)stringBuffer.toString());
        this.fromJSON(json, !isErsatz);
        this.setErsatz(isErsatz);
        this.say("done!");
    }

    private void showReadHelp() {
        this.say("read  path [" + PROVISION_ONLY_SHORT_FLAG + " | " + PROVISION_ONLY_FLAG + " ]");
        this.sayi("Usage: Reads a saved session from a given file.");
        this.sayi(PROVISION_ONLY_SHORT_FLAG + " | " + PROVISION_ONLY_FLAG + " = for erstaz clients, only provision from the configuration,");
        this.sayi("   do not reload the client configuration there (i.e. keep the current client, load the tokens etc from the stored state)");
        this.sayi("See also: write");
    }

    public JSONObject toJSON() throws Exception {
        JSONObject jj;
        JSONObject jsonObject;
        block23: {
            jsonObject = new JSONObject();
            if (!StringUtils.isTrivial((String)this.lastUserMessage)) {
                jsonObject.put((Object)this.USER_MESSAGE_KEY, (Object)this.lastUserMessage);
            }
            try {
                if (this.getDebugger() != null) {
                    jsonObject.put((Object)"debugger", (Object)this.getDebugger().toJSON());
                }
            }
            catch (Exception e) {
                if (this.isThrowExceptions()) {
                    throw e;
                }
                if (this.isPrintOutput()) {
                    this.say("warn -- could not serialize debugger:" + e.getMessage());
                }
                if (!this.isVerbose()) break block23;
                e.printStackTrace();
            }
        }
        jsonObject.put((Object)this.SYSTEM_MESSAGE_KEY, (Object)("OA4MP command line client state stored on " + String.valueOf(new Date())));
        if (this.grant != null) {
            jsonObject.put((Object)this.AUTHZ_GRANT_KEY, (Object)this.grant.toJSON());
        }
        jsonObject.put((Object)this.PRINT_OUTPUT_ON_KEY, (Object)this.isPrintOutput());
        jsonObject.put((Object)this.VERBOSE_ON_KEY, (Object)this.isVerbose());
        if (this.currentURI != null) {
            jsonObject.put((Object)this.CURRENT_URI_KEY, (Object)this.currentURI.toString());
        }
        if (this.dummyAsset != null) {
            jsonObject.put((Object)this.ASSET_KEY, (Object)this.dummyAsset.toJSON());
        }
        jsonObject.put((Object)this.CONFIG_NAME_KEY, (Object)this.oa2CommandLineClient.getConfigName());
        jsonObject.put((Object)this.CONFIG_FILE_KEY, (Object)this.oa2CommandLineClient.getConfigFile());
        jsonObject.put((Object)this.IS_ERSATZ_KEY, (Object)this.isErsatz());
        if (!this.requestParameters.isEmpty()) {
            jj = new JSONObject();
            jj.putAll(this.requestParameters);
            jsonObject.put((Object)this.AUTHZ_PARAMETERS_KEY, (Object)jj);
        }
        if (!this.tokenParameters.isEmpty()) {
            jj = new JSONObject();
            jj.putAll(this.tokenParameters);
            jsonObject.put((Object)this.AUTHZ_PARAMETERS_KEY, (Object)jj);
        }
        if (!this.refreshParameters.isEmpty()) {
            jj = new JSONObject();
            jj.putAll(this.refreshParameters);
            jsonObject.put((Object)this.REFRESH_PARAMETERS_KEY, (Object)jj);
        }
        if (!this.exchangeParameters.isEmpty()) {
            jj = new JSONObject();
            jj.putAll(this.exchangeParameters);
            jsonObject.put((Object)this.EXCHANGE_PARAMETERS_KEY, (Object)jj);
        }
        if (this.introspectResponse != null && !this.introspectResponse.isEmpty()) {
            jsonObject.put((Object)this.INTROSPECT_RESPONSE_KEY, (Object)this.introspectResponse);
        }
        if (this.dfResponse != null && !this.dfResponse.isEmpty()) {
            jsonObject.put((Object)this.DF_RESPONSE_KEY, (Object)this.dfResponse);
        }
        if (this.currentATResponse != null) {
            JSONObject atr = new JSONObject();
            if (this.currentATResponse.getAccessToken() != null) {
                atr.put((Object)"access_token", (Object)this.currentATResponse.getAccessToken().toJSON());
            }
            if (this.currentATResponse.getRefreshToken() != null) {
                atr.put((Object)"refresh_token", (Object)this.currentATResponse.getRefreshToken().toJSON());
            }
            if (this.currentATResponse.getParameters() != null && !this.currentATResponse.getParameters().isEmpty()) {
                JSONObject atState = new JSONObject();
                atState.putAll(this.currentATResponse.getParameters());
                atr.put((Object)"parameters", (Object)atState);
            }
            if (!atr.isEmpty()) {
                jsonObject.put((Object)this.AT_RESPONSE_KEY, (Object)atr);
            }
        }
        jsonObject.put((Object)IS_RFC_8628_KEY, (Object)this.isDeviceFlow);
        if (!StringUtils.isTrivial((String)this.deviceCode)) {
            jsonObject.put((Object)"device_code", (Object)this.deviceCode);
        }
        if (!StringUtils.isTrivial((String)this.userCode)) {
            jsonObject.put((Object)"user_code", (Object)this.userCode);
        }
        if (!StringUtils.isTrivial((String)this.deviceFlowCallback)) {
            jsonObject.put((Object)"verification_uri", (Object)this.deviceFlowCallback);
        }
        return jsonObject;
    }

    public void write(InputLine inputLine) throws Exception {
        String r;
        if (this.showHelp(inputLine)) {
            this.showWriteHelp();
            return;
        }
        if (inputLine.hasArg(this.MESSAGE_SWITCH)) {
            this.lastUserMessage = inputLine.getNextArgFor(this.MESSAGE_SWITCH);
            inputLine.removeSwitchAndValue(this.MESSAGE_SWITCH);
        }
        if (inputLine.getArgCount() == 0) {
            if (this.saveFile == null) {
                this.say("sorry, no file specified.");
                return;
            }
        } else {
            this.saveFile = new File(inputLine.getLastArg());
        }
        if (this.saveFile.isDirectory()) {
            this.say("sorry, but \"" + this.saveFile.getAbsolutePath() + "\" is a directory");
            return;
        }
        if (!this.saveFile.isAbsolute()) {
            this.say("Sorry, but " + this.saveFile.getName() + " needs the path.");
            return;
        }
        if (this.saveFile.exists() && !(r = this.readline("\"" + this.saveFile.getAbsolutePath() + "\" exists. Overwrite?[y/n]")).equals("y")) {
            this.say("aborted. Returning...");
            return;
        }
        FileWriter fileWriter = new FileWriter(this.saveFile);
        fileWriter.write(this.toJSON().toString(1));
        fileWriter.flush();
        fileWriter.close();
        this.say("done! Saved to \"" + this.saveFile.getAbsolutePath() + "\".");
    }

    private void showWriteHelp() {
        this.say("write [" + this.MESSAGE_SWITCH + " message] path");
        this.sayi("Usage: Write the current session to a file.");
        this.sayi("You may read it and resume your session");
        this.sayi(this.MESSAGE_SWITCH + " - (optional) a message to include about this session.");
        this.sayi("Make sure it is double quote delimited");
        this.sayi("Note that these are serialized to JSON, so you can just go look at one if you like.");
        this.say("E.g.");
        this.sayi("write -m \"testing refresh on poloc\" /opt/cilogon-oa2/var/temp/poloc-test.json");
        this.say("See also: read");
    }

    public HashMap<String, Object> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(HashMap<String, Object> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public HashMap<String, Object> getTokenParameters() {
        return this.tokenParameters;
    }

    public void setTokenParameters(HashMap<String, Object> tokenParameters) {
        this.tokenParameters = tokenParameters;
    }

    public HashMap<String, Object> getRefreshParameters() {
        return this.refreshParameters;
    }

    public void setRefreshParameters(HashMap<String, Object> refreshParameters) {
        this.refreshParameters = refreshParameters;
    }

    public HashMap<String, Object> getExchangeParameters() {
        return this.exchangeParameters;
    }

    public void setExchangeParameters(HashMap<String, Object> exchangeParameters) {
        this.exchangeParameters = exchangeParameters;
    }

    public void set_param(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("set_param -authz | -token | -refresh | -exchange key value");
            this.sayi("Usage: Sets an additional request parameter to be send along with the request.");
            this.sayi("For scopes, these are added to whatever the client is sending. For other parameters, they override");
            this.sayi("what the client sends.");
            this.sayi("-authz = parameters for the initial request to the authorization endpoint.");
            this.sayi("-token = parameters to send in the token request. Note these supercede -a parameters.");
            this.sayi("-refresh = parameters for the refresh request.");
            this.sayi("-exchange = parameters for the token exchange request.");
            this.sayi(this.shortSwitchBlurb);
            this.say("See also: get_param, clear_param");
            return;
        }
        boolean setRP = inputLine.hasArg(new String[]{REQ_PARAM_SWITCH, SHORT_REQ_PARAM_SWITCH});
        boolean setTP = inputLine.hasArg(new String[]{TOKEN_PARAM_SWITCH, SHORT_TOKEN_PARAM_SWITCH});
        boolean setXP = inputLine.hasArg(new String[]{EXCHANGE_PARAM_SWITCH, SHORT_EXCHANGE_PARAM_SWITCH});
        boolean setRFP = inputLine.hasArg(new String[]{REFRESH_PARAM_SWITCH, SHORT_REFRESH_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{REQ_PARAM_SWITCH, SHORT_REQ_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{TOKEN_PARAM_SWITCH, SHORT_TOKEN_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{EXCHANGE_PARAM_SWITCH, SHORT_EXCHANGE_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{REFRESH_PARAM_SWITCH, SHORT_REFRESH_PARAM_SWITCH});
        if (!(setRP || setTP || setXP || setRFP)) {
            this.say("sorry, you must specify the switch for which additional parameters to set");
            return;
        }
        if (inputLine.getArgCount() < 2) {
            this.say("Sorry, missing argument");
            return;
        }
        if (2 < inputLine.getArgCount()) {
            this.say("sorry, too many args -- can't determine which is they key and value. Perhaps use double quotes around arguments?");
            return;
        }
        if (setRP) {
            this.requestParameters.put(inputLine.getArg(1), inputLine.getArg(2));
        }
        if (setTP) {
            this.tokenParameters.put(inputLine.getArg(1), inputLine.getArg(2));
        }
        if (setXP) {
            this.exchangeParameters.put(inputLine.getArg(1), inputLine.getArg(2));
        }
        if (setRFP) {
            this.refreshParameters.put(inputLine.getArg(1), inputLine.getArg(2));
        }
    }

    public void get_param(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("get_param [-authz | -token | -refresh | -exchange] key0 key1 key2 ...");
            this.sayi("Usage: Show what additional parameters have been set.");
            this.sayi("If no switches are given then both token and authorization additional parameters are shown ");
            this.sayi("If keys are specified, only those are shown. If no keys are specified, all the given parameters are shown");
            this.sayi("switches correspond to: ");
            this.sayi("-authz sent in the authorization request, i.e. uri");
            this.sayi("-token sent in the access token requests");
            this.sayi("-refresh sent in the refesh requests");
            this.sayi("-exchange sent in the exchange request");
            this.sayi(this.shortSwitchBlurb);
            this.say("See also: set_param, clear_param, rm_param");
            return;
        }
        boolean getRP = inputLine.hasArg(new String[]{REQ_PARAM_SWITCH, SHORT_REQ_PARAM_SWITCH});
        boolean getTP = inputLine.hasArg(new String[]{TOKEN_PARAM_SWITCH, SHORT_TOKEN_PARAM_SWITCH});
        boolean getXP = inputLine.hasArg(new String[]{EXCHANGE_PARAM_SWITCH, SHORT_EXCHANGE_PARAM_SWITCH});
        boolean getRFP = inputLine.hasArg(new String[]{REFRESH_PARAM_SWITCH, SHORT_REFRESH_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{REQ_PARAM_SWITCH, SHORT_REQ_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{TOKEN_PARAM_SWITCH, SHORT_TOKEN_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{EXCHANGE_PARAM_SWITCH, SHORT_EXCHANGE_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{REFRESH_PARAM_SWITCH, SHORT_REFRESH_PARAM_SWITCH});
        if (!(getRP || getRP || getXP || getRFP)) {
            getTP = true;
            getRP = true;
            getXP = true;
            getRFP = true;
        }
        if (getRP) {
            this.listParams(this.requestParameters, inputLine, "authz");
        }
        if (getTP) {
            this.listParams(this.tokenParameters, inputLine, "tokens");
        }
        if (getRFP) {
            this.listParams(this.refreshParameters, inputLine, "refresh");
        }
        if (getXP) {
            this.listParams(this.exchangeParameters, inputLine, "exchange");
        }
    }

    private void listParams(Map params, InputLine inputLine, String component) {
        if (inputLine.getArgCount() == 0) {
            for (Object k : params.keySet()) {
                this.say(component + ": " + String.valueOf(k) + "=" + String.valueOf(params.get(k)));
            }
        } else {
            for (String k : inputLine.getArgs()) {
                if (!params.containsKey(k)) continue;
                this.say(component + ": " + k + "=" + String.valueOf(params.get(k)));
            }
        }
    }

    public void clear_all_params(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("clear_all_params -authz | -token | -refresh | -exchange | -all");
            this.say("Usage: Clear all of the additional parameters for the switch.");
            this.sayi("-all will clear everything . You must invoke this a switch or nothing will be done.");
            this.sayi(this.shortSwitchBlurb);
            this.say("See also: set_param, get_param, rm_param");
            return;
        }
        boolean getRP = inputLine.hasArg(new String[]{REQ_PARAM_SWITCH, SHORT_REQ_PARAM_SWITCH});
        boolean getTP = inputLine.hasArg(new String[]{TOKEN_PARAM_SWITCH, SHORT_TOKEN_PARAM_SWITCH});
        boolean getXP = inputLine.hasArg(new String[]{EXCHANGE_PARAM_SWITCH, SHORT_EXCHANGE_PARAM_SWITCH});
        boolean getRFP = inputLine.hasArg(new String[]{REFRESH_PARAM_SWITCH, SHORT_REFRESH_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{REQ_PARAM_SWITCH, SHORT_REQ_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{TOKEN_PARAM_SWITCH, SHORT_TOKEN_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{REFRESH_PARAM_SWITCH, SHORT_REFRESH_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{EXCHANGE_PARAM_SWITCH, SHORT_EXCHANGE_PARAM_SWITCH});
        if (inputLine.hasArg("-all")) {
            getRP = true;
            getTP = true;
            getXP = true;
            getRFP = true;
            inputLine.removeSwitch("-all");
        }
        if (!(getTP || getRP || getXP || getRFP)) {
            this.say("Sorry, you must specify which set of additional parameters to clear.");
            return;
        }
        if (getRP) {
            this.requestParameters = new HashMap();
            this.say("additional authorization parameters cleared.");
        }
        if (getTP) {
            this.tokenParameters = new HashMap();
            this.say("additional token parameters cleared.");
        }
        if (getRFP) {
            this.refreshParameters = new HashMap();
            this.say("additional refresh parameters cleared.");
        }
        if (getXP) {
            this.exchangeParameters = new HashMap();
            this.say("additional exchange parameters cleared.");
        }
    }

    public void rm_param(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("rm_param -authz | -token | -refresh | -exchange key0 key1 ...");
            this.sayi("Usage: Remove the given key(s) from the set of additional parameters");
            this.sayi("If none are given, then nothing is done.");
            this.sayi(this.shortSwitchBlurb);
            return;
        }
        boolean getRP = inputLine.hasArg(new String[]{REQ_PARAM_SWITCH, SHORT_REQ_PARAM_SWITCH});
        boolean getTP = inputLine.hasArg(new String[]{TOKEN_PARAM_SWITCH, SHORT_TOKEN_PARAM_SWITCH});
        boolean getXP = inputLine.hasArg(new String[]{EXCHANGE_PARAM_SWITCH, SHORT_EXCHANGE_PARAM_SWITCH});
        boolean getRFP = inputLine.hasArg(new String[]{REFRESH_PARAM_SWITCH, SHORT_REFRESH_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{REQ_PARAM_SWITCH, SHORT_REQ_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{TOKEN_PARAM_SWITCH, SHORT_TOKEN_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{REFRESH_PARAM_SWITCH, SHORT_REFRESH_PARAM_SWITCH});
        inputLine.removeSwitch(new String[]{EXCHANGE_PARAM_SWITCH, SHORT_EXCHANGE_PARAM_SWITCH});
        if (inputLine.getArgCount() == 0) {
            this.say("No keys found.");
            return;
        }
        int tRemoved = 0;
        int rRemoved = 0;
        int xRemoved = 0;
        int rfRemoved = 0;
        for (String k : inputLine.getArgs()) {
            if (getTP) {
                this.tokenParameters.remove(k);
                ++tRemoved;
            }
            if (getRP) {
                this.requestParameters.remove(k);
                ++rRemoved;
            }
            if (getXP) {
                this.exchangeParameters.remove(k);
                ++xRemoved;
            }
            if (!getRFP) continue;
            this.refreshParameters.remove(k);
            ++rfRemoved;
        }
        this.say("removed: " + rRemoved + " authz parameters, " + tRemoved + " token parameters, " + rfRemoved + " refresh parameters, " + xRemoved + " exchange parameters");
    }

    public JSONObject rfc7523(Map p) throws Exception {
        this.clear(new InputLine(new String[0]), false);
        this.dummyAsset = (OA2Asset)this.getCe().getAssetStore().create();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.putAll(p);
        parameters.putAll(this.getRequestParameters());
        this.createScopes(parameters, true);
        if (!parameters.containsKey("redirect_uri") && this.getCe().getCallback() != null) {
            parameters.put("redirect_uri", this.getCe().getCallback().toString());
        }
        if (!parameters.containsKey("nonce")) {
            parameters.put("nonce", NonceHerder.createNonce());
        }
        if (!parameters.containsKey("sub")) {
            parameters.put("sub", this.getCe().getClient().getIdentifierString());
        }
        JSONObject jsonObject = this.getService().rfc7523(this.getDummyAsset(), parameters);
        return jsonObject;
    }

    private void createScopes(Map parameters, boolean addClientScopes) {
        if (parameters != null) {
            if (parameters.containsKey("scope")) {
                Set<String> scopes = this.scopesToSet(parameters.get("scope"));
                if (this.getCe().hasScopes() && addClientScopes) {
                    scopes.addAll(this.getCe().getScopes());
                }
                parameters.put("scope", this.getCe().scopesToString(scopes));
            } else if (this.getCe().hasScopes() && addClientScopes) {
                parameters.put("scope", this.getCe().scopesToString());
            }
        }
    }

    private Set<String> scopesToSet(Object ss) {
        HashSet<String> scopes = new HashSet<String>();
        ArrayList<String> addScopes = new ArrayList<String>();
        switch (Constant.getType((Object)ss)) {
            case 3: {
                StringTokenizer st = new StringTokenizer((String)ss, " ");
                addScopes = new ArrayList();
                while (st.hasMoreTokens()) {
                    addScopes.add(st.nextToken());
                }
                break;
            }
            case 4: {
                QDLStem qdlstem = (QDLStem)ss;
                for (QDLKey key : qdlstem.keySet()) {
                    addScopes.add(qdlstem.get(key).toString());
                }
                break;
            }
            case 10: {
                QDLSet qdlset = (QDLSet)ss;
                for (QDLValue v : qdlset) {
                    addScopes.add(v.toString());
                }
                break;
            }
            case -1: {
                if (ss instanceof List) {
                    addScopes.addAll((List)ss);
                    break;
                }
                throw new IllegalArgumentException("Unknown type for scopes" + String.valueOf(ss));
            }
        }
        scopes.addAll(addScopes);
        return scopes;
    }

    public void rfc7523(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("rfc7523 [" + this.USERNAME_FLAG + "|" + this.ALT_USERNAME_FLAG + " user_name]- make an RFC 7523 request to the service.");
            this.say("This is compliant with section 2.1, and is in effect an authorization grant.");
            this.say("Note that parameters set with the -a flag are passed along.");
            this.say(this.ALT_USERNAME_FLAG + " | " + this.USERNAME_FLAG + " - if present, set the subject of the request (hence the username) to this,");
            this.say("   If missing, the default subject will be the client ID.");
            return;
        }
        if (this.getCe() == null) {
            this.say("Oops! No configuration has been loaded.");
            return;
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String username = null;
        if (inputLine.hasArg(this.USERNAME_FLAG)) {
            username = inputLine.getNextArgFor(this.USERNAME_FLAG);
            inputLine.removeSwitchAndValue(this.USERNAME_FLAG);
            parameters.put("sub", username);
        }
        if (inputLine.hasArg(this.ALT_USERNAME_FLAG)) {
            username = inputLine.getNextArgFor(this.ALT_USERNAME_FLAG);
            inputLine.removeSwitchAndValue(this.ALT_USERNAME_FLAG);
            parameters.put("sub", username);
        }
        for (String x : this.getRequestParameters().keySet()) {
            parameters.put(x, this.getRequestParameters().get(x));
        }
        this.rfc7523(parameters);
        if (this.isPrintOutput()) {
            this.printTokens(inputLine.hasArg(NO_VERIFY_JWT), true);
        }
    }

    public void ccf(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.say("ccf [-sub subject | -rfc7523] - client credential flow with a given subject");
            this.say("-rfc7523 if present forces using that. The default is to use a standard client_id");
            this.say("         and secret. Including this when there are no keys raises an error.");
            this.say("-sub subject - sets the subject for the request. If this is configured to return an ID token");
            this.say("         with the openid scopes, this will be used as the subject of that token");
            return;
        }
        boolean useRFC7523 = inputLine.hasArg(CCF_RFC7523);
        inputLine.removeSwitch(CCF_RFC7523);
        String subject = null;
        if (inputLine.hasArg(CCF_SUB)) {
            subject = inputLine.getNextArgFor(CCF_SUB);
            inputLine.removeSwitchAndValue(CCF_SUB);
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (subject != null) {
            parameters.put("sub", subject);
        }
        this.say(this.getCcfResponse().toString(1));
    }

    public JSONObject ccf(Map parameters, boolean useRFC7523) throws Exception {
        this.dummyAsset = (OA2Asset)this.getCe().getAssetStore().create();
        if (!parameters.containsKey("scope")) {
            JSONArray array = new JSONArray();
            array.addAll(this.getCe().getScopes());
            parameters.put("scope", array);
        }
        if (!parameters.containsKey("nonce")) {
            parameters.put("nonce", NonceHerder.createNonce());
        }
        if (!parameters.containsKey("state")) {
            parameters.put("state", NonceHerder.createNonce());
        }
        if (!parameters.containsKey("sub")) {
            parameters.put("sub", this.getCe().getClient().getIdentifierString());
        }
        parameters.put("grant_type", "client_credentials");
        JSONObject jsonObject = this.getService().rfc6749_4_4(this.getDummyAsset(), parameters, useRFC7523);
        this.setCcfResponse(jsonObject);
        return jsonObject;
    }

    public JSONObject getCcfResponse() {
        return this.ccfResponse;
    }

    public void setCcfResponse(JSONObject ccfResponse) {
        this.ccfResponse = ccfResponse;
    }
}

